// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Inference
{
    /// <summary>
    /// The configuration information for a chat completions request.
    /// Completions support a wide variety of tasks and generate text that continues from or "completes"
    /// provided prompt data.
    /// </summary>
    public partial class ChatCompletionsOptions
    {
        /// <summary> Initializes a new instance of <see cref="ChatCompletionsOptions"/>. </summary>
        /// <param name="messages">
        /// The collection of context messages associated with this chat completions request.
        /// Typical usage begins with a chat message for the System role that provides instructions for
        /// the behavior of the assistant, followed by alternating messages between the User and
        /// Assistant roles.
        /// Please note <see cref="ChatRequestMessage"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ChatRequestAssistantMessage"/>, <see cref="ChatRequestSystemMessage"/>, <see cref="ChatRequestToolMessage"/> and <see cref="ChatRequestUserMessage"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="messages"/> is null. </exception>
        public ChatCompletionsOptions(IEnumerable<ChatRequestMessage> messages)
        {
            Argument.AssertNotNull(messages, nameof(messages));

            Messages = messages.ToList();
            StopSequences = new ChangeTrackingList<string>();
            Tools = new ChangeTrackingList<ChatCompletionsToolDefinition>();
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsOptions"/>. </summary>
        /// <param name="messages">
        /// The collection of context messages associated with this chat completions request.
        /// Typical usage begins with a chat message for the System role that provides instructions for
        /// the behavior of the assistant, followed by alternating messages between the User and
        /// Assistant roles.
        /// Please note <see cref="ChatRequestMessage"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ChatRequestAssistantMessage"/>, <see cref="ChatRequestSystemMessage"/>, <see cref="ChatRequestToolMessage"/> and <see cref="ChatRequestUserMessage"/>.
        /// </param>
        /// <param name="frequencyPenalty">
        /// A value that influences the probability of generated tokens appearing based on their cumulative
        /// frequency in generated text.
        /// Positive values will make tokens less likely to appear as their frequency increases and
        /// decrease the likelihood of the model repeating the same statements verbatim.
        /// Supported range is [-2, 2].
        /// </param>
        /// <param name="internalShouldStreamResponse"> A value indicating whether chat completions should be streamed for this request. </param>
        /// <param name="presencePenalty">
        /// A value that influences the probability of generated tokens appearing based on their existing
        /// presence in generated text.
        /// Positive values will make tokens less likely to appear when they already exist and increase the
        /// model's likelihood to output new topics.
        /// Supported range is [-2, 2].
        /// </param>
        /// <param name="temperature">
        /// The sampling temperature to use that controls the apparent creativity of generated completions.
        /// Higher values will make output more random while lower values will make results more focused
        /// and deterministic.
        /// It is not recommended to modify temperature and top_p for the same completions request as the
        /// interaction of these two settings is difficult to predict.
        /// Supported range is [0, 1].
        /// </param>
        /// <param name="nucleusSamplingFactor">
        /// An alternative to sampling with temperature called nucleus sampling. This value causes the
        /// model to consider the results of tokens with the provided probability mass. As an example, a
        /// value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
        /// considered.
        /// It is not recommended to modify temperature and top_p for the same completions request as the
        /// interaction of these two settings is difficult to predict.
        /// Supported range is [0, 1].
        /// </param>
        /// <param name="maxTokens"> The maximum number of tokens to generate. </param>
        /// <param name="responseFormat">
        /// The format that the model must output. Use this to enable JSON mode instead of the default text mode.
        /// Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
        /// via a system or user message.
        /// Please note <see cref="ChatCompletionsResponseFormat"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ChatCompletionsResponseFormatJSON"/> and <see cref="ChatCompletionsResponseFormatText"/>.
        /// </param>
        /// <param name="stopSequences"> A collection of textual sequences that will end completions generation. </param>
        /// <param name="tools">
        /// A list of tools the model may request to call. Currently, only functions are supported as a tool. The model
        /// may response with a function call request and provide the input arguments in JSON format for that function.
        /// </param>
        /// <param name="internalSuppressedToolChoice"> If specified, the model will configure which of the provided tools it can use for the chat completions response. </param>
        /// <param name="seed">
        /// If specified, the system will make a best effort to sample deterministically such that repeated requests with the
        /// same seed and parameters should return the same result. Determinism is not guaranteed.
        /// </param>
        /// <param name="model"> ID of the specific AI model to use, if more than one model is available on the endpoint. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal ChatCompletionsOptions(IList<ChatRequestMessage> messages, float? frequencyPenalty, bool? internalShouldStreamResponse, float? presencePenalty, float? temperature, float? nucleusSamplingFactor, int? maxTokens, ChatCompletionsResponseFormat responseFormat, IList<string> stopSequences, IList<ChatCompletionsToolDefinition> tools, BinaryData internalSuppressedToolChoice, long? seed, string model, IDictionary<string, BinaryData> additionalProperties)
        {
            Messages = messages;
            FrequencyPenalty = frequencyPenalty;
            InternalShouldStreamResponse = internalShouldStreamResponse;
            PresencePenalty = presencePenalty;
            Temperature = temperature;
            NucleusSamplingFactor = nucleusSamplingFactor;
            MaxTokens = maxTokens;
            ResponseFormat = responseFormat;
            StopSequences = stopSequences;
            Tools = tools;
            InternalSuppressedToolChoice = internalSuppressedToolChoice;
            Seed = seed;
            Model = model;
            AdditionalProperties = additionalProperties;
        }
        /// <summary>
        /// A value that influences the probability of generated tokens appearing based on their cumulative
        /// frequency in generated text.
        /// Positive values will make tokens less likely to appear as their frequency increases and
        /// decrease the likelihood of the model repeating the same statements verbatim.
        /// Supported range is [-2, 2].
        /// </summary>
        public float? FrequencyPenalty { get; set; }
        /// <summary>
        /// A value that influences the probability of generated tokens appearing based on their existing
        /// presence in generated text.
        /// Positive values will make tokens less likely to appear when they already exist and increase the
        /// model's likelihood to output new topics.
        /// Supported range is [-2, 2].
        /// </summary>
        public float? PresencePenalty { get; set; }
        /// <summary>
        /// The sampling temperature to use that controls the apparent creativity of generated completions.
        /// Higher values will make output more random while lower values will make results more focused
        /// and deterministic.
        /// It is not recommended to modify temperature and top_p for the same completions request as the
        /// interaction of these two settings is difficult to predict.
        /// Supported range is [0, 1].
        /// </summary>
        public float? Temperature { get; set; }
        /// <summary>
        /// An alternative to sampling with temperature called nucleus sampling. This value causes the
        /// model to consider the results of tokens with the provided probability mass. As an example, a
        /// value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
        /// considered.
        /// It is not recommended to modify temperature and top_p for the same completions request as the
        /// interaction of these two settings is difficult to predict.
        /// Supported range is [0, 1].
        /// </summary>
        public float? NucleusSamplingFactor { get; set; }
        /// <summary> The maximum number of tokens to generate. </summary>
        public int? MaxTokens { get; set; }
        /// <summary>
        /// The format that the model must output. Use this to enable JSON mode instead of the default text mode.
        /// Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
        /// via a system or user message.
        /// Please note <see cref="ChatCompletionsResponseFormat"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ChatCompletionsResponseFormatJSON"/> and <see cref="ChatCompletionsResponseFormatText"/>.
        /// </summary>
        public ChatCompletionsResponseFormat ResponseFormat { get; set; }
        /// <summary> A collection of textual sequences that will end completions generation. </summary>
        public IList<string> StopSequences { get; }
        /// <summary>
        /// A list of tools the model may request to call. Currently, only functions are supported as a tool. The model
        /// may response with a function call request and provide the input arguments in JSON format for that function.
        /// </summary>
        public IList<ChatCompletionsToolDefinition> Tools { get; }
        /// <summary>
        /// If specified, the system will make a best effort to sample deterministically such that repeated requests with the
        /// same seed and parameters should return the same result. Determinism is not guaranteed.
        /// </summary>
        public long? Seed { get; set; }
        /// <summary> ID of the specific AI model to use, if more than one model is available on the endpoint. </summary>
        public string Model { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
