// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary> The ChatCompletionsNamedToolChoice_type. </summary>
    public readonly partial struct ChatCompletionsNamedToolChoiceType : IEquatable<ChatCompletionsNamedToolChoiceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsNamedToolChoiceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChatCompletionsNamedToolChoiceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FunctionValue = "function";

        /// <summary> function. </summary>
        public static ChatCompletionsNamedToolChoiceType Function { get; } = new ChatCompletionsNamedToolChoiceType(FunctionValue);
        /// <summary> Determines if two <see cref="ChatCompletionsNamedToolChoiceType"/> values are the same. </summary>
        public static bool operator ==(ChatCompletionsNamedToolChoiceType left, ChatCompletionsNamedToolChoiceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChatCompletionsNamedToolChoiceType"/> values are not the same. </summary>
        public static bool operator !=(ChatCompletionsNamedToolChoiceType left, ChatCompletionsNamedToolChoiceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChatCompletionsNamedToolChoiceType"/>. </summary>
        public static implicit operator ChatCompletionsNamedToolChoiceType(string value) => new ChatCompletionsNamedToolChoiceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChatCompletionsNamedToolChoiceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChatCompletionsNamedToolChoiceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
