// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> A tool selection of a specific, named function tool that will limit chat completions to using the named function. </summary>
    public partial class ChatCompletionsNamedToolChoice
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsNamedToolChoice"/>. </summary>
        /// <param name="function"> The function that should be called. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="function"/> is null. </exception>
        public ChatCompletionsNamedToolChoice(ChatCompletionsNamedToolChoiceFunction function)
        {
            Argument.AssertNotNull(function, nameof(function));

            Function = function;
        }

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsNamedToolChoice"/>. </summary>
        /// <param name="type"> The type of the tool. Currently, only `function` is supported. </param>
        /// <param name="function"> The function that should be called. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatCompletionsNamedToolChoice(ChatCompletionsNamedToolChoiceType type, ChatCompletionsNamedToolChoiceFunction function, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            Function = function;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsNamedToolChoice"/> for deserialization. </summary>
        internal ChatCompletionsNamedToolChoice()
        {
        }

        /// <summary> The type of the tool. Currently, only `function` is supported. </summary>
        public ChatCompletionsNamedToolChoiceType Type { get; } = ChatCompletionsNamedToolChoiceType.Function;

        /// <summary> The function that should be called. </summary>
        public ChatCompletionsNamedToolChoiceFunction Function { get; }
    }
}
