// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Inference
{
    /// <summary> Model factory for models. </summary>
    public static partial class AIInferenceModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Inference.ChatRequestSystemMessage"/>. </summary>
        /// <param name="content"> The contents of the system message. </param>
        /// <returns> A new <see cref="Inference.ChatRequestSystemMessage"/> instance for mocking. </returns>
        public static ChatRequestSystemMessage ChatRequestSystemMessage(string content = null)
        {
            return new ChatRequestSystemMessage(ChatRole.System, serializedAdditionalRawData: null, content);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatMessageTextContentItem"/>. </summary>
        /// <param name="text"> The content of the message. </param>
        /// <returns> A new <see cref="Inference.ChatMessageTextContentItem"/> instance for mocking. </returns>
        public static ChatMessageTextContentItem ChatMessageTextContentItem(string text = null)
        {
            return new ChatMessageTextContentItem("text", serializedAdditionalRawData: null, text);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatCompletionsToolCall"/>. </summary>
        /// <param name="id"> The ID of the tool call. </param>
        /// <param name="type"> The type of tool call. Currently, only `function` is supported. </param>
        /// <param name="function"> The details of the function call requested by the AI model. </param>
        /// <returns> A new <see cref="Inference.ChatCompletionsToolCall"/> instance for mocking. </returns>
        public static ChatCompletionsToolCall ChatCompletionsToolCall(string id = null, ChatCompletionsToolCallType type = default, FunctionCall function = null)
        {
            return new ChatCompletionsToolCall(id, type, function, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatRequestToolMessage"/>. </summary>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCallId"> The ID of the tool call resolved by the provided content. </param>
        /// <returns> A new <see cref="Inference.ChatRequestToolMessage"/> instance for mocking. </returns>
        public static ChatRequestToolMessage ChatRequestToolMessage(string content = null, string toolCallId = null)
        {
            return new ChatRequestToolMessage(ChatRole.Tool, serializedAdditionalRawData: null, content, toolCallId);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatCompletionsToolDefinition"/>. </summary>
        /// <param name="type"> The type of the tool. Currently, only `function` is supported. </param>
        /// <param name="function"> The function definition details for the function tool. </param>
        /// <returns> A new <see cref="Inference.ChatCompletionsToolDefinition"/> instance for mocking. </returns>
        public static ChatCompletionsToolDefinition ChatCompletionsToolDefinition(ChatCompletionsToolDefinitionType type = default, FunctionDefinition function = null)
        {
            return new ChatCompletionsToolDefinition(type, function, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatCompletionsNamedToolChoice"/>. </summary>
        /// <param name="type"> The type of the tool. Currently, only `function` is supported. </param>
        /// <param name="function"> The function that should be called. </param>
        /// <returns> A new <see cref="Inference.ChatCompletionsNamedToolChoice"/> instance for mocking. </returns>
        public static ChatCompletionsNamedToolChoice ChatCompletionsNamedToolChoice(ChatCompletionsNamedToolChoiceType type = default, ChatCompletionsNamedToolChoiceFunction function = null)
        {
            return new ChatCompletionsNamedToolChoice(type, function, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.CompletionsUsage"/>. </summary>
        /// <param name="completionTokens"> The number of tokens generated across all completions emissions. </param>
        /// <param name="promptTokens"> The number of tokens in the provided prompts for the completions request. </param>
        /// <param name="totalTokens"> The total number of tokens processed for the completions request and response. </param>
        /// <returns> A new <see cref="Inference.CompletionsUsage"/> instance for mocking. </returns>
        public static CompletionsUsage CompletionsUsage(int completionTokens = default, int promptTokens = default, int totalTokens = default)
        {
            return new CompletionsUsage(completionTokens, promptTokens, totalTokens, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatChoice"/>. </summary>
        /// <param name="index"> The ordered index associated with this chat completions choice. </param>
        /// <param name="finishReason"> The reason that this chat completions choice completed its generated. </param>
        /// <param name="message"> The chat message for a given chat completions prompt. </param>
        /// <returns> A new <see cref="Inference.ChatChoice"/> instance for mocking. </returns>
        public static ChatChoice ChatChoice(int index = default, CompletionsFinishReason? finishReason = null, ChatResponseMessage message = null)
        {
            return new ChatChoice(index, finishReason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ChatResponseMessage"/>. </summary>
        /// <param name="role"> The chat role associated with the message. </param>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCalls">
        /// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
        /// completions request to resolve as configured.
        /// </param>
        /// <returns> A new <see cref="Inference.ChatResponseMessage"/> instance for mocking. </returns>
        public static ChatResponseMessage ChatResponseMessage(ChatRole role = default, string content = null, IEnumerable<ChatCompletionsToolCall> toolCalls = null)
        {
            toolCalls ??= new List<ChatCompletionsToolCall>();

            return new ChatResponseMessage(role, content, toolCalls?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.ModelInfo"/>. </summary>
        /// <param name="modelName"> The name of the AI model. For example: `Phi21`. </param>
        /// <param name="modelType"> The type of the AI model. A Unique identifier for the profile. </param>
        /// <param name="modelProviderName"> The model provider name. For example: `Microsoft Research`. </param>
        /// <returns> A new <see cref="Inference.ModelInfo"/> instance for mocking. </returns>
        public static ModelInfo ModelInfo(string modelName = null, ModelType modelType = default, string modelProviderName = null)
        {
            return new ModelInfo(modelName, modelType, modelProviderName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.EmbeddingsResult"/>. </summary>
        /// <param name="id"> Unique identifier for the embeddings result. </param>
        /// <param name="data"> Embedding values for the prompts submitted in the request. </param>
        /// <param name="usage"> Usage counts for tokens input using the embeddings API. </param>
        /// <param name="model"> The model ID used to generate this result. </param>
        /// <returns> A new <see cref="Inference.EmbeddingsResult"/> instance for mocking. </returns>
        public static EmbeddingsResult EmbeddingsResult(string id = null, IEnumerable<EmbeddingItem> data = null, EmbeddingsUsage usage = null, string model = null)
        {
            data ??= new List<EmbeddingItem>();

            return new EmbeddingsResult(id, data?.ToList(), usage, model, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.EmbeddingItem"/>. </summary>
        /// <param name="embedding">
        /// List of embedding values for the input prompt. These represent a measurement of the
        /// vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
        /// </param>
        /// <param name="index"> Index of the prompt to which the EmbeddingItem corresponds. </param>
        /// <returns> A new <see cref="Inference.EmbeddingItem"/> instance for mocking. </returns>
        public static EmbeddingItem EmbeddingItem(BinaryData embedding = null, int index = default)
        {
            return new EmbeddingItem(embedding, index, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.EmbeddingsUsage"/>. </summary>
        /// <param name="promptTokens"> Number of tokens in the request. </param>
        /// <param name="totalTokens">
        /// Total number of tokens transacted in this request/response. Should equal the
        /// number of tokens in the request.
        /// </param>
        /// <returns> A new <see cref="Inference.EmbeddingsUsage"/> instance for mocking. </returns>
        public static EmbeddingsUsage EmbeddingsUsage(int promptTokens = default, int totalTokens = default)
        {
            return new EmbeddingsUsage(promptTokens, totalTokens, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.StreamingChatCompletionsUpdate"/>. </summary>
        /// <param name="id"> A unique identifier associated with this chat completions response. </param>
        /// <param name="created">
        /// The first timestamp associated with generation activity for this completions response,
        /// represented as seconds since the beginning of the Unix epoch of 00:00 on 1 Jan 1970.
        /// </param>
        /// <param name="model"> The model used for the chat completion. </param>
        /// <param name="usage"> Usage information for tokens processed and generated as part of this completions operation. </param>
        /// <param name="choices">
        /// An update to the collection of completion choices associated with this completions response.
        /// Generally, `n` choices are generated per provided prompt with a default value of 1.
        /// Token limits and other settings may limit the number of choices generated.
        /// </param>
        /// <returns> A new <see cref="Inference.StreamingChatCompletionsUpdate"/> instance for mocking. </returns>
        public static StreamingChatCompletionsUpdate StreamingChatCompletionsUpdate(string id = null, DateTimeOffset created = default, string model = null, CompletionsUsage usage = null, IEnumerable<StreamingChatChoiceUpdate> choices = null)
        {
            choices ??= new List<StreamingChatChoiceUpdate>();

            return new StreamingChatCompletionsUpdate(
                id,
                created,
                model,
                usage,
                choices?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.StreamingChatChoiceUpdate"/>. </summary>
        /// <param name="index"> The ordered index associated with this chat completions choice. </param>
        /// <param name="finishReason"> The reason that this chat completions choice completed its generated. </param>
        /// <param name="delta"> An update to the chat message for a given chat completions prompt. </param>
        /// <returns> A new <see cref="Inference.StreamingChatChoiceUpdate"/> instance for mocking. </returns>
        public static StreamingChatChoiceUpdate StreamingChatChoiceUpdate(int index = default, CompletionsFinishReason? finishReason = null, StreamingChatResponseMessageUpdate delta = null)
        {
            return new StreamingChatChoiceUpdate(index, finishReason, delta, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.StreamingChatResponseMessageUpdate"/>. </summary>
        /// <param name="role"> The chat role associated with the message. If present, should always be 'assistant'. </param>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCalls">
        /// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
        /// completions request to resolve as configured.
        /// </param>
        /// <returns> A new <see cref="Inference.StreamingChatResponseMessageUpdate"/> instance for mocking. </returns>
        public static StreamingChatResponseMessageUpdate StreamingChatResponseMessageUpdate(ChatRole? role = null, string content = null, IEnumerable<StreamingChatResponseToolCallUpdate> toolCalls = null)
        {
            toolCalls ??= new List<StreamingChatResponseToolCallUpdate>();

            return new StreamingChatResponseMessageUpdate(role, content, toolCalls?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Inference.StreamingChatResponseToolCallUpdate"/>. </summary>
        /// <param name="id"> The ID of the tool call. </param>
        /// <param name="function"> Updates to the function call requested by the AI model. </param>
        /// <returns> A new <see cref="Inference.StreamingChatResponseToolCallUpdate"/> instance for mocking. </returns>
        public static StreamingChatResponseToolCallUpdate StreamingChatResponseToolCallUpdate(string id = null, FunctionCall function = null)
        {
            return new StreamingChatResponseToolCallUpdate(id, function, serializedAdditionalRawData: null);
        }
    }
}
