---
page_type: sample
languages:
- csharp
products:
# Including relevant stubs from https://review.docs.microsoft.com/help/contribute/metadata-taxonomies#product
- azure
name: Azure.AI.Inference samples for .NET
description: Samples for the Azure.AI.Inference client library.
---

# Azure.AI.Inference Samples

| Sample | Description |
| ------ | ----------- |
| [Sample1_ChatCompletions](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample1_ChatCompletions.md) | A basic example of chat completions. |
| [Sample2_ChatCompletionsWithAoai](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample2_ChatCompletionsWithAoai.md) | Chat completions targeting Azure OpenAI. |
| [Sample3_ChatCompletionsStreaming](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample3_ChatCompletionsStreaming.md) | Chat completions with streaming responses. |
| [Sample4_ChatCompletionsWithHistory](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample4_ChatCompletionsWithHistory.md) | Chat completions using chat history. |
| [Sample5_ChatCompletionsWithImages](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample5_ChatCompletionsWithImages.md) | Chat completions providing an image url. |
| [Sample6_ChatCompletionsWithAdditionalProperties](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample6_ChatCompletionsWithAdditionalProperties.md) | Chat completions providing additional model specific properties. |
| [Sample7_ChatCompletionsWithTools](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample7_ChatCompletionsWithTools.md) | Chat completions using tools. |
| [Sample8_ChatCompletionsWithOpenTelemetry](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample8_ChatCompletionsWithOpenTelemetry.md) | Chat completions using Open Telemetry for tracing. |
| [Sample9_Embeddings](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample9_Embeddings.md) | Basic text embeddings. |
| [Sample10_EmbeddingsWithAoai](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/ai/Azure.AI.Inference/samples/Sample10_EmbeddingsWithAoai.md) | Text embeddings targetting Azure OpenAi. |
