// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_Sensors
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateOrUpdate("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateOrUpdateAsync("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                sensorDataModelId = "<sensorDataModelId>",
                integrationId = "<integrationId>",
                hardwareId = "<hardwareId>",
                deviceId = "<deviceId>",
                type = "<type>",
                location = new
                {
                    latitude = 123.45,
                    longitude = 123.45,
                },
                port = new
                {
                    name = "<name>",
                    type = "<type>",
                },
                depthInMeters = new object[]
            {
123.45
            },
                status = "<status>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = client.CreateOrUpdate("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("integrationId").ToString());
            Console.WriteLine(result.GetProperty("hardwareId").ToString());
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                sensorDataModelId = "<sensorDataModelId>",
                integrationId = "<integrationId>",
                hardwareId = "<hardwareId>",
                deviceId = "<deviceId>",
                type = "<type>",
                location = new
                {
                    latitude = 123.45,
                    longitude = 123.45,
                },
                port = new
                {
                    name = "<name>",
                    type = "<type>",
                },
                depthInMeters = new object[]
            {
123.45
            },
                status = "<status>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = await client.CreateOrUpdateAsync("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("integrationId").ToString());
            Console.WriteLine(result.GetProperty("hardwareId").ToString());
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensor_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.GetSensor("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensor_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.GetSensorAsync("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensor_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.GetSensor("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("integrationId").ToString());
            Console.WriteLine(result.GetProperty("hardwareId").ToString());
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensor_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.GetSensorAsync("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("integrationId").ToString());
            Console.WriteLine(result.GetProperty("hardwareId").ToString());
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
            Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.Delete("<sensorPartnerId>", "<sensorId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.DeleteAsync("<sensorPartnerId>", "<sensorId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.Delete("<sensorPartnerId>", "<sensorId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.DeleteAsync("<sensorPartnerId>", "<sensorId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConnectionString_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.GetConnectionString("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConnectionString_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.GetConnectionStringAsync("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConnectionString_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = client.GetConnectionString("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("primaryDeviceConnectionString").ToString());
            Console.WriteLine(result.GetProperty("secondaryDeviceConnectionString").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConnectionString_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            Response response = await client.GetConnectionStringAsync("<sensorPartnerId>", "<sensorId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("primaryDeviceConnectionString").ToString());
            Console.WriteLine(result.GetProperty("secondaryDeviceConnectionString").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RenewConnectionString_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                connectionStringType = "Primary",
            });
            Response response = client.RenewConnectionString("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RenewConnectionString_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                connectionStringType = "Primary",
            });
            Response response = await client.RenewConnectionStringAsync("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RenewConnectionString_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                connectionStringType = "Primary",
            });
            Response response = client.RenewConnectionString("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("primaryDeviceConnectionString").ToString());
            Console.WriteLine(result.GetProperty("secondaryDeviceConnectionString").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RenewConnectionString_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            using RequestContent content = RequestContent.Create(new
            {
                connectionStringType = "Primary",
            });
            Response response = await client.RenewConnectionStringAsync("<sensorPartnerId>", "<sensorId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("primaryDeviceConnectionString").ToString());
            Console.WriteLine(result.GetProperty("secondaryDeviceConnectionString").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensors_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            foreach (BinaryData item in client.GetSensors("<sensorPartnerId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensors_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            await foreach (BinaryData item in client.GetSensorsAsync("<sensorPartnerId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensors_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            foreach (BinaryData item in client.GetSensors("<sensorPartnerId>", new string[] { "<sensorDataModelIds>" }, new string[] { "<sensorMappingIds>" }, new string[] { "<deviceIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
                Console.WriteLine(result.GetProperty("integrationId").ToString());
                Console.WriteLine(result.GetProperty("hardwareId").ToString());
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
                Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
                Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
                Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensors_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Sensors client = new FarmBeatsClient(endpoint, credential).GetSensorsClient();

            await foreach (BinaryData item in client.GetSensorsAsync("<sensorPartnerId>", new string[] { "<sensorDataModelIds>" }, new string[] { "<sensorMappingIds>" }, new string[] { "<deviceIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
                Console.WriteLine(result.GetProperty("integrationId").ToString());
                Console.WriteLine(result.GetProperty("hardwareId").ToString());
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("location").GetProperty("latitude").ToString());
                Console.WriteLine(result.GetProperty("location").GetProperty("longitude").ToString());
                Console.WriteLine(result.GetProperty("port").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("port").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("depthInMeters")[0].ToString());
                Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }
    }
}
