// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_SensorEvents
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensorEvents_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            SensorEvents client = new FarmBeatsClient(endpoint, credential).GetSensorEventsClient();

            Response response = client.GetSensorEvents("<sensorId>", "<sensorPartnerId>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensorEvents_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            SensorEvents client = new FarmBeatsClient(endpoint, credential).GetSensorEventsClient();

            Response response = await client.GetSensorEventsAsync("<sensorId>", "<sensorPartnerId>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensorEvents_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            SensorEvents client = new FarmBeatsClient(endpoint, credential).GetSensorEventsClient();

            Response response = client.GetSensorEvents("<sensorId>", "<sensorPartnerId>", DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("sensorId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("eventDateTime").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("ingestionDateTime").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("measures").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("skipToken").ToString());
            Console.WriteLine(result.GetProperty("nextLink").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensorEvents_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            SensorEvents client = new FarmBeatsClient(endpoint, credential).GetSensorEventsClient();

            Response response = await client.GetSensorEventsAsync("<sensorId>", "<sensorPartnerId>", DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("sensorId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("eventDateTime").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("ingestionDateTime").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("measures").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("skipToken").ToString());
            Console.WriteLine(result.GetProperty("nextLink").ToString());
        }
    }
}
