// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_Scenes
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Download_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.Download("<filePath>", null);

            if (response.ContentStream != null)
            {
                using Stream outFileStream = File.OpenWrite("<filepath>");
                response.ContentStream.CopyTo(outFileStream);
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Download_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.DownloadAsync("<filePath>", null);

            if (response.ContentStream != null)
            {
                using Stream outFileStream = File.OpenWrite("<filepath>");
                response.ContentStream.CopyTo(outFileStream);
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Download_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.Download("<filePath>", null);

            if (response.ContentStream != null)
            {
                using Stream outFileStream = File.OpenWrite("<filepath>");
                response.ContentStream.CopyTo(outFileStream);
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Download_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.DownloadAsync("<filePath>", null);

            if (response.ContentStream != null)
            {
                using Stream outFileStream = File.OpenWrite("<filepath>");
                response.ContentStream.CopyTo(outFileStream);
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSatelliteDataIngestionJobDetails_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.GetSatelliteDataIngestionJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSatelliteDataIngestionJobDetails_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.GetSatelliteDataIngestionJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSatelliteDataIngestionJobDetails_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.GetSatelliteDataIngestionJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageNames")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageFormats")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageResolutions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSatelliteDataIngestionJobDetails_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.GetSatelliteDataIngestionJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageNames")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageFormats")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageResolutions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SearchFeatures_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
            });
            Response response = client.SearchFeatures("Sentinel_2_L2A", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SearchFeatures_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
            });
            Response response = await client.SearchFeaturesAsync("Sentinel_2_L2A", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SearchFeatures_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                intersects = new
                {
                    coordinates = new object[]
            {
new object[]
{
new object[]
{
new object[]
{
123.45
}
}
}
            },
                    type = "MultiPolygon",
                },
                bbox = new object[]
            {
123.45
            },
                featureIds = new object[]
            {
"<featureIds>"
            },
            });
            Response response = client.SearchFeatures("Sentinel_2_L2A", content, maxpagesize: 1234, skip: 1234);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacExtensions")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("geometry").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("bbox")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("roles")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("collection").ToString());
            Console.WriteLine(result.GetProperty("nextLink").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SearchFeatures_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                intersects = new
                {
                    coordinates = new object[]
            {
new object[]
{
new object[]
{
new object[]
{
123.45
}
}
}
            },
                    type = "MultiPolygon",
                },
                bbox = new object[]
            {
123.45
            },
                featureIds = new object[]
            {
"<featureIds>"
            },
            });
            Response response = await client.SearchFeaturesAsync("Sentinel_2_L2A", content, maxpagesize: 1234, skip: 1234);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("stacExtensions")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("geometry").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("bbox")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("links")[0].GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("assets").GetProperty("<key>").GetProperty("roles")[0].ToString());
            Console.WriteLine(result.GetProperty("features")[0].GetProperty("collection").ToString());
            Console.WriteLine(result.GetProperty("nextLink").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStacFeature_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.GetStacFeature("Sentinel_2_L2A", "<featureId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStacFeature_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.GetStacFeatureAsync("Sentinel_2_L2A", "<featureId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStacFeature_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = client.GetStacFeature("Sentinel_2_L2A", "<featureId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("stacExtensions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("geometry").ToString());
            Console.WriteLine(result.GetProperty("bbox")[0].ToString());
            Console.WriteLine(result.GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("roles")[0].ToString());
            Console.WriteLine(result.GetProperty("collection").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStacFeature_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            Response response = await client.GetStacFeatureAsync("Sentinel_2_L2A", "<featureId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("stacVersion").ToString());
            Console.WriteLine(result.GetProperty("stacExtensions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("geometry").ToString());
            Console.WriteLine(result.GetProperty("bbox")[0].ToString());
            Console.WriteLine(result.GetProperty("properties").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("rel").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("links")[0].GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("href").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("assets").GetProperty("<key>").GetProperty("roles")[0].ToString());
            Console.WriteLine(result.GetProperty("collection").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetScenes_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            foreach (BinaryData item in client.GetScenes("<provider>", "<partyId>", "<boundaryId>", "<source>", null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetScenes_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            await foreach (BinaryData item in client.GetScenesAsync("<provider>", "<partyId>", "<boundaryId>", "<source>", null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetScenes_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            foreach (BinaryData item in client.GetScenes("<provider>", "<partyId>", "<boundaryId>", "<source>", DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<imageNames>" }, new double[] { 123.45 }, new string[] { "<imageFormats>" }, 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("sceneDateTime").ToString());
                Console.WriteLine(result.GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("fileLink").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("imageFormat").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("resolution").ToString());
                Console.WriteLine(result.GetProperty("imageFormat").ToString());
                Console.WriteLine(result.GetProperty("cloudCoverPercentage").ToString());
                Console.WriteLine(result.GetProperty("darkPixelPercentage").ToString());
                Console.WriteLine(result.GetProperty("ndviMedianValue").ToString());
                Console.WriteLine(result.GetProperty("boundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetScenes_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            await foreach (BinaryData item in client.GetScenesAsync("<provider>", "<partyId>", "<boundaryId>", "<source>", DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<imageNames>" }, new double[] { 123.45 }, new string[] { "<imageFormats>" }, 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("sceneDateTime").ToString());
                Console.WriteLine(result.GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("fileLink").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("imageFormat").ToString());
                Console.WriteLine(result.GetProperty("imageFiles")[0].GetProperty("resolution").ToString());
                Console.WriteLine(result.GetProperty("imageFormat").ToString());
                Console.WriteLine(result.GetProperty("cloudCoverPercentage").ToString());
                Console.WriteLine(result.GetProperty("darkPixelPercentage").ToString());
                Console.WriteLine(result.GetProperty("ndviMedianValue").ToString());
                Console.WriteLine(result.GetProperty("boundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSatelliteDataIngestionJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                source = "Sentinel_2_L2A",
            });
            Operation<BinaryData> operation = client.CreateSatelliteDataIngestionJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSatelliteDataIngestionJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                source = "Sentinel_2_L2A",
            });
            Operation<BinaryData> operation = await client.CreateSatelliteDataIngestionJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSatelliteDataIngestionJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                provider = "Microsoft",
                source = "Sentinel_2_L2A",
                data = new
                {
                    imageNames = new object[]
            {
"<imageNames>"
            },
                    imageFormats = new object[]
            {
"<imageFormats>"
            },
                    imageResolutions = new object[]
            {
123.45
            },
                },
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = client.CreateSatelliteDataIngestionJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageNames")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageFormats")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageResolutions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSatelliteDataIngestionJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            Scenes client = new FarmBeatsClient(endpoint, credential).GetScenesClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                endDateTime = "2022-05-10T18:57:31.2311892Z",
                provider = "Microsoft",
                source = "Sentinel_2_L2A",
                data = new
                {
                    imageNames = new object[]
            {
"<imageNames>"
            },
                    imageFormats = new object[]
            {
"<imageFormats>"
            },
                    imageResolutions = new object[]
            {
123.45
            },
                },
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = await client.CreateSatelliteDataIngestionJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("endDateTime").ToString());
            Console.WriteLine(result.GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageNames")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageFormats")[0].ToString());
            Console.WriteLine(result.GetProperty("data").GetProperty("imageResolutions")[0].ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }
    }
}
