// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_PlantTissueAnalyses
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalysis_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.GetPlantTissueAnalysis("<partyId>", "<plantTissueAnalysisId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalysis_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.GetPlantTissueAnalysisAsync("<partyId>", "<plantTissueAnalysisId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalysis_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.GetPlantTissueAnalysis("<partyId>", "<plantTissueAnalysisId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("fieldId").ToString());
            Console.WriteLine(result.GetProperty("cropId").ToString());
            Console.WriteLine(result.GetProperty("cropProductId").ToString());
            Console.WriteLine(result.GetProperty("seasonId").ToString());
            Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
            Console.WriteLine(result.GetProperty("growthStage").ToString());
            Console.WriteLine(result.GetProperty("plantPart").ToString());
            Console.WriteLine(result.GetProperty("plantPosition").ToString());
            Console.WriteLine(result.GetProperty("plantAppearance").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalysis_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.GetPlantTissueAnalysisAsync("<partyId>", "<plantTissueAnalysisId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("fieldId").ToString());
            Console.WriteLine(result.GetProperty("cropId").ToString());
            Console.WriteLine(result.GetProperty("cropProductId").ToString());
            Console.WriteLine(result.GetProperty("seasonId").ToString());
            Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
            Console.WriteLine(result.GetProperty("growthStage").ToString());
            Console.WriteLine(result.GetProperty("plantPart").ToString());
            Console.WriteLine(result.GetProperty("plantPosition").ToString());
            Console.WriteLine(result.GetProperty("plantAppearance").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateOrUpdate("<partyId>", "<plantTissueAnalysisId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateOrUpdateAsync("<partyId>", "<plantTissueAnalysisId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            using RequestContent content = RequestContent.Create(new
            {
                fieldId = "<fieldId>",
                cropId = "<cropId>",
                cropProductId = "<cropProductId>",
                seasonId = "<seasonId>",
                plantingDateTime = "2022-05-10T18:57:31.2311892Z",
                growthStage = "<growthStage>",
                plantPart = "<plantPart>",
                plantPosition = "<plantPosition>",
                plantAppearance = "<plantAppearance>",
                sampleCollectionCondition = "<sampleCollectionCondition>",
                sampleCollectionDateTime = "2022-05-10T18:57:31.2311892Z",
                sampleReceivedDateTime = "2022-05-10T18:57:31.2311892Z",
                sampleTestResultDateTime = "2022-05-10T18:57:31.2311892Z",
                labDetails = new
                {
                    code = "<code>",
                    name = "<name>",
                    description = "<description>",
                    address = "<address>",
                },
                status = "<status>",
                source = "<source>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = client.CreateOrUpdate("<partyId>", "<plantTissueAnalysisId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("fieldId").ToString());
            Console.WriteLine(result.GetProperty("cropId").ToString());
            Console.WriteLine(result.GetProperty("cropProductId").ToString());
            Console.WriteLine(result.GetProperty("seasonId").ToString());
            Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
            Console.WriteLine(result.GetProperty("growthStage").ToString());
            Console.WriteLine(result.GetProperty("plantPart").ToString());
            Console.WriteLine(result.GetProperty("plantPosition").ToString());
            Console.WriteLine(result.GetProperty("plantAppearance").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            using RequestContent content = RequestContent.Create(new
            {
                fieldId = "<fieldId>",
                cropId = "<cropId>",
                cropProductId = "<cropProductId>",
                seasonId = "<seasonId>",
                plantingDateTime = "2022-05-10T18:57:31.2311892Z",
                growthStage = "<growthStage>",
                plantPart = "<plantPart>",
                plantPosition = "<plantPosition>",
                plantAppearance = "<plantAppearance>",
                sampleCollectionCondition = "<sampleCollectionCondition>",
                sampleCollectionDateTime = "2022-05-10T18:57:31.2311892Z",
                sampleReceivedDateTime = "2022-05-10T18:57:31.2311892Z",
                sampleTestResultDateTime = "2022-05-10T18:57:31.2311892Z",
                labDetails = new
                {
                    code = "<code>",
                    name = "<name>",
                    description = "<description>",
                    address = "<address>",
                },
                status = "<status>",
                source = "<source>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = await client.CreateOrUpdateAsync("<partyId>", "<plantTissueAnalysisId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("fieldId").ToString());
            Console.WriteLine(result.GetProperty("cropId").ToString());
            Console.WriteLine(result.GetProperty("cropProductId").ToString());
            Console.WriteLine(result.GetProperty("seasonId").ToString());
            Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
            Console.WriteLine(result.GetProperty("growthStage").ToString());
            Console.WriteLine(result.GetProperty("plantPart").ToString());
            Console.WriteLine(result.GetProperty("plantPosition").ToString());
            Console.WriteLine(result.GetProperty("plantAppearance").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
            Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
            Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.Delete("<partyId>", "<plantTissueAnalysisId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.DeleteAsync("<partyId>", "<plantTissueAnalysisId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.Delete("<partyId>", "<plantTissueAnalysisId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.DeleteAsync("<partyId>", "<plantTissueAnalysisId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCascadeDeleteJobDetails_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.GetCascadeDeleteJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCascadeDeleteJobDetails_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.GetCascadeDeleteJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCascadeDeleteJobDetails_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = client.GetCascadeDeleteJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCascadeDeleteJobDetails_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Response response = await client.GetCascadeDeleteJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalysesByPartyId_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            foreach (BinaryData item in client.GetPlantTissueAnalysesByPartyId("<partyId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalysesByPartyId_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            await foreach (BinaryData item in client.GetPlantTissueAnalysesByPartyIdAsync("<partyId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalysesByPartyId_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            foreach (BinaryData item in client.GetPlantTissueAnalysesByPartyId("<partyId>", new string[] { "<seasonIds>" }, new string[] { "<cropIds>" }, new string[] { "<cropProductsIds>" }, new string[] { "<fieldIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("fieldId").ToString());
                Console.WriteLine(result.GetProperty("cropId").ToString());
                Console.WriteLine(result.GetProperty("cropProductId").ToString());
                Console.WriteLine(result.GetProperty("seasonId").ToString());
                Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
                Console.WriteLine(result.GetProperty("growthStage").ToString());
                Console.WriteLine(result.GetProperty("plantPart").ToString());
                Console.WriteLine(result.GetProperty("plantPosition").ToString());
                Console.WriteLine(result.GetProperty("plantAppearance").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalysesByPartyId_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            await foreach (BinaryData item in client.GetPlantTissueAnalysesByPartyIdAsync("<partyId>", new string[] { "<seasonIds>" }, new string[] { "<cropIds>" }, new string[] { "<cropProductsIds>" }, new string[] { "<fieldIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("fieldId").ToString());
                Console.WriteLine(result.GetProperty("cropId").ToString());
                Console.WriteLine(result.GetProperty("cropProductId").ToString());
                Console.WriteLine(result.GetProperty("seasonId").ToString());
                Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
                Console.WriteLine(result.GetProperty("growthStage").ToString());
                Console.WriteLine(result.GetProperty("plantPart").ToString());
                Console.WriteLine(result.GetProperty("plantPosition").ToString());
                Console.WriteLine(result.GetProperty("plantAppearance").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalyses_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            foreach (BinaryData item in client.GetPlantTissueAnalyses(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalyses_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            await foreach (BinaryData item in client.GetPlantTissueAnalysesAsync(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPlantTissueAnalyses_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            foreach (BinaryData item in client.GetPlantTissueAnalyses(new string[] { "<seasonIds>" }, new string[] { "<cropIds>" }, new string[] { "<cropProductsIds>" }, new string[] { "<fieldIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("fieldId").ToString());
                Console.WriteLine(result.GetProperty("cropId").ToString());
                Console.WriteLine(result.GetProperty("cropProductId").ToString());
                Console.WriteLine(result.GetProperty("seasonId").ToString());
                Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
                Console.WriteLine(result.GetProperty("growthStage").ToString());
                Console.WriteLine(result.GetProperty("plantPart").ToString());
                Console.WriteLine(result.GetProperty("plantPosition").ToString());
                Console.WriteLine(result.GetProperty("plantAppearance").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPlantTissueAnalyses_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            await foreach (BinaryData item in client.GetPlantTissueAnalysesAsync(new string[] { "<seasonIds>" }, new string[] { "<cropIds>" }, new string[] { "<cropProductsIds>" }, new string[] { "<fieldIds>" }, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("fieldId").ToString());
                Console.WriteLine(result.GetProperty("cropId").ToString());
                Console.WriteLine(result.GetProperty("cropProductId").ToString());
                Console.WriteLine(result.GetProperty("seasonId").ToString());
                Console.WriteLine(result.GetProperty("plantingDateTime").ToString());
                Console.WriteLine(result.GetProperty("growthStage").ToString());
                Console.WriteLine(result.GetProperty("plantPart").ToString());
                Console.WriteLine(result.GetProperty("plantPosition").ToString());
                Console.WriteLine(result.GetProperty("plantAppearance").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionCondition").ToString());
                Console.WriteLine(result.GetProperty("sampleCollectionDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleReceivedDateTime").ToString());
                Console.WriteLine(result.GetProperty("sampleTestResultDateTime").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("labDetails").GetProperty("address").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateCascadeDeleteJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Operation<BinaryData> operation = client.CreateCascadeDeleteJob(WaitUntil.Completed, "<jobId>", "<partyId>", "<plantTissueAnalysisId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateCascadeDeleteJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Operation<BinaryData> operation = await client.CreateCascadeDeleteJobAsync(WaitUntil.Completed, "<jobId>", "<partyId>", "<plantTissueAnalysisId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateCascadeDeleteJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Operation<BinaryData> operation = client.CreateCascadeDeleteJob(WaitUntil.Completed, "<jobId>", "<partyId>", "<plantTissueAnalysisId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateCascadeDeleteJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            PlantTissueAnalyses client = new FarmBeatsClient(endpoint, credential).GetPlantTissueAnalysesClient();

            Operation<BinaryData> operation = await client.CreateCascadeDeleteJobAsync(WaitUntil.Completed, "<jobId>", "<partyId>", "<plantTissueAnalysisId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }
    }
}
