// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_ModelInference
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBiomassModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetBiomassModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBiomassModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetBiomassModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBiomassModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetBiomassModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBiomassModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetBiomassModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensorPlacementModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetSensorPlacementModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensorPlacementModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetSensorPlacementModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSensorPlacementModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetSensorPlacementModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSensorPlacementModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetSensorPlacementModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSoilMoistureModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetSoilMoistureModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSoilMoistureModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetSoilMoistureModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetSoilMoistureModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = client.GetSoilMoistureModelJob("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetSoilMoistureModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            Response response = await client.GetSoilMoistureModelJobAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateBiomassModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                cropName = "Corn",
                plantingStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                weatherExtensionId = "<weatherExtensionId>",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
            });
            Operation<BinaryData> operation = client.CreateBiomassModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateBiomassModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                cropName = "Corn",
                plantingStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                weatherExtensionId = "<weatherExtensionId>",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
            });
            Operation<BinaryData> operation = await client.CreateBiomassModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateBiomassModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                cropName = "Corn",
                plantingStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                weatherExtensionId = "<weatherExtensionId>",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = client.CreateBiomassModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateBiomassModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                cropName = "Corn",
                plantingStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                weatherExtensionId = "<weatherExtensionId>",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = await client.CreateBiomassModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("cropName").ToString());
            Console.WriteLine(result.GetProperty("plantingStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("weatherExtensionId").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSensorPlacementModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                sensorType = "<sensorType>",
                isRanked = true,
            });
            Operation<BinaryData> operation = client.CreateSensorPlacementModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSensorPlacementModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                sensorType = "<sensorType>",
                isRanked = true,
            });
            Operation<BinaryData> operation = await client.CreateSensorPlacementModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSensorPlacementModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                sensorType = "<sensorType>",
                isRanked = true,
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = client.CreateSensorPlacementModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSensorPlacementModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                modelVersion = "<modelVersion>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                sensorType = "<sensorType>",
                isRanked = true,
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = await client.CreateSensorPlacementModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("sensorType").ToString());
            Console.WriteLine(result.GetProperty("isRanked").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSoilMoistureModelJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                sensorDataModelId = "<sensorDataModelId>",
                sensorPartnerId = "<sensorPartnerId>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                modelVersion = "<modelVersion>",
                sensorDefinition = new
                {
                    sensorMeasurement = "<sensorMeasurement>",
                    minProperty = "<minProperty>",
                    maxProperty = "<maxProperty>",
                },
            });
            Operation<BinaryData> operation = client.CreateSoilMoistureModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSoilMoistureModelJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                sensorDataModelId = "<sensorDataModelId>",
                sensorPartnerId = "<sensorPartnerId>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                modelVersion = "<modelVersion>",
                sensorDefinition = new
                {
                    sensorMeasurement = "<sensorMeasurement>",
                    minProperty = "<minProperty>",
                    maxProperty = "<maxProperty>",
                },
            });
            Operation<BinaryData> operation = await client.CreateSoilMoistureModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateSoilMoistureModelJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                sensorDataModelId = "<sensorDataModelId>",
                sensorPartnerId = "<sensorPartnerId>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                modelVersion = "<modelVersion>",
                sensorDefinition = new
                {
                    sensorMeasurement = "<sensorMeasurement>",
                    minProperty = "<minProperty>",
                    maxProperty = "<maxProperty>",
                },
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = client.CreateSoilMoistureModelJob(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateSoilMoistureModelJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            ModelInference client = new FarmBeatsClient(endpoint, credential).GetModelInferenceClient();

            using RequestContent content = RequestContent.Create(new
            {
                partyId = "<partyId>",
                boundaryId = "<boundaryId>",
                sensorDataModelId = "<sensorDataModelId>",
                sensorPartnerId = "<sensorPartnerId>",
                inferenceStartDateTime = "2022-05-10T18:57:31.2311892Z",
                inferenceEndDateTime = "2022-05-10T18:57:31.2311892Z",
                satelliteProvider = "Microsoft",
                satelliteSource = "Sentinel_2_L2A",
                imageResolution = 123.45,
                imageFormat = "TIF",
                modelVersion = "<modelVersion>",
                sensorDefinition = new
                {
                    sensorMeasurement = "<sensorMeasurement>",
                    minProperty = "<minProperty>",
                    maxProperty = "<maxProperty>",
                },
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Operation<BinaryData> operation = await client.CreateSoilMoistureModelJobAsync(WaitUntil.Completed, "<jobId>", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("boundaryId").ToString());
            Console.WriteLine(result.GetProperty("sensorDataModelId").ToString());
            Console.WriteLine(result.GetProperty("sensorPartnerId").ToString());
            Console.WriteLine(result.GetProperty("inferenceStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("inferenceEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("satelliteProvider").ToString());
            Console.WriteLine(result.GetProperty("satelliteSource").ToString());
            Console.WriteLine(result.GetProperty("imageResolution").ToString());
            Console.WriteLine(result.GetProperty("imageFormat").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("sensorMeasurement").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("minProperty").ToString());
            Console.WriteLine(result.GetProperty("sensorDefinition").GetProperty("maxProperty").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }
    }
}
