// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Verticals.AgriFood.Farming.Samples
{
    public partial class Samples_HarvestData
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCascadeDeleteJobDetails_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.GetCascadeDeleteJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCascadeDeleteJobDetails_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.GetCascadeDeleteJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCascadeDeleteJobDetails_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.GetCascadeDeleteJobDetails("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCascadeDeleteJobDetails_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.GetCascadeDeleteJobDetailsAsync("<jobId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetHarvestData_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.GetHarvestData("<partyId>", "<harvestDataId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetHarvestData_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.GetHarvestDataAsync("<partyId>", "<harvestDataId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetHarvestData_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.GetHarvestData("<partyId>", "<harvestDataId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetHarvestData_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.GetHarvestDataAsync("<partyId>", "<harvestDataId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateOrUpdate("<partyId>", "<harvestDataId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateOrUpdateAsync("<partyId>", "<harvestDataId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            using RequestContent content = RequestContent.Create(new
            {
                totalYield = new
                {
                    unit = "<unit>",
                    value = 123.45,
                },
                harvestProductDetails = new object[]
            {
new
{
productName = "<productName>",
}
            },
                operationModifiedDateTime = "2022-05-10T18:57:31.2311892Z",
                operationStartDateTime = "2022-05-10T18:57:31.2311892Z",
                operationEndDateTime = "2022-05-10T18:57:31.2311892Z",
                associatedBoundaryId = "<associatedBoundaryId>",
                status = "<status>",
                source = "<source>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = client.CreateOrUpdate("<partyId>", "<harvestDataId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            using RequestContent content = RequestContent.Create(new
            {
                totalYield = new
                {
                    unit = "<unit>",
                    value = 123.45,
                },
                harvestProductDetails = new object[]
            {
new
{
productName = "<productName>",
}
            },
                operationModifiedDateTime = "2022-05-10T18:57:31.2311892Z",
                operationStartDateTime = "2022-05-10T18:57:31.2311892Z",
                operationEndDateTime = "2022-05-10T18:57:31.2311892Z",
                associatedBoundaryId = "<associatedBoundaryId>",
                status = "<status>",
                source = "<source>",
                name = "<name>",
                description = "<description>",
                properties = new
                {
                    key = new object(),
                },
            });
            Response response = await client.CreateOrUpdateAsync("<partyId>", "<harvestDataId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
            Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
            Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
            Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("eTag").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
            Console.WriteLine(result.GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("modifiedBy").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.Delete("<partyId>", "<harvestDataId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.DeleteAsync("<partyId>", "<harvestDataId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = client.Delete("<partyId>", "<harvestDataId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Response response = await client.DeleteAsync("<partyId>", "<harvestDataId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllHarvestData_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            foreach (BinaryData item in client.GetAllHarvestData(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllHarvestData_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            await foreach (BinaryData item in client.GetAllHarvestDataAsync(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllHarvestData_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            foreach (BinaryData item in client.GetAllHarvestData(123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, new string[] { "<sources>" }, new string[] { "<associatedBoundaryIds>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<harvestDataIds>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllHarvestData_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            await foreach (BinaryData item in client.GetAllHarvestDataAsync(123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, new string[] { "<sources>" }, new string[] { "<associatedBoundaryIds>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<harvestDataIds>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllHarvestDataByPartyId_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            foreach (BinaryData item in client.GetAllHarvestDataByPartyId("<partyId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllHarvestDataByPartyId_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            await foreach (BinaryData item in client.GetAllHarvestDataByPartyIdAsync("<partyId>", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllHarvestDataByPartyId_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            foreach (BinaryData item in client.GetAllHarvestDataByPartyId("<partyId>", 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, new string[] { "<sources>" }, new string[] { "<associatedBoundaryIds>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllHarvestDataByPartyId_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            await foreach (BinaryData item in client.GetAllHarvestDataByPartyIdAsync("<partyId>", 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, new string[] { "<sources>" }, new string[] { "<associatedBoundaryIds>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 123.45, 123.45, new string[] { "<ids>" }, new string[] { "<names>" }, new string[] { "<propertyFilters>" }, new string[] { "<statuses>" }, DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"), 1234, "<skipToken>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("avgSpeed").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("productName").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgYield").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgMoisture").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("totalWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("harvestProductDetails")[0].GetProperty("avgWetMass").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("area").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("operationModifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationStartDateTime").ToString());
                Console.WriteLine(result.GetProperty("operationEndDateTime").ToString());
                Console.WriteLine(result.GetProperty("attachmentsLink").ToString());
                Console.WriteLine(result.GetProperty("associatedBoundaryId").ToString());
                Console.WriteLine(result.GetProperty("partyId").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("eTag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("modifiedDateTime").ToString());
                Console.WriteLine(result.GetProperty("source").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("modifiedBy").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateCascadeDeleteJob_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Operation<BinaryData> operation = client.CreateCascadeDeleteJob(WaitUntil.Completed, "<jobId>", "<partyId>", "<harvestDataId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateCascadeDeleteJob_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Operation<BinaryData> operation = await client.CreateCascadeDeleteJobAsync(WaitUntil.Completed, "<jobId>", "<partyId>", "<harvestDataId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateCascadeDeleteJob_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Operation<BinaryData> operation = client.CreateCascadeDeleteJob(WaitUntil.Completed, "<jobId>", "<partyId>", "<harvestDataId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateCascadeDeleteJob_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            TokenCredential credential = new DefaultAzureCredential();
            HarvestData client = new FarmBeatsClient(endpoint, credential).GetHarvestDataClient();

            Operation<BinaryData> operation = await client.CreateCascadeDeleteJobAsync(WaitUntil.Completed, "<jobId>", "<partyId>", "<harvestDataId>", null);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("partyId").ToString());
            Console.WriteLine(result.GetProperty("resourceId").ToString());
            Console.WriteLine(result.GetProperty("resourceType").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("durationInSeconds").ToString());
            Console.WriteLine(result.GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
        }
    }
}
