// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core.Extensions;
using Azure.Verticals.AgriFood.Farming;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="FarmBeatsClient"/> to client builder. </summary>
    public static partial class VerticalsAgriFoodFarmingClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="FarmBeatsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> server parameter. </param>
        public static IAzureClientBuilder<FarmBeatsClient, FarmBeatsClientOptions> AddFarmBeatsClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<FarmBeatsClient, FarmBeatsClientOptions>((options, cred) => new FarmBeatsClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="FarmBeatsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<FarmBeatsClient, FarmBeatsClientOptions> AddFarmBeatsClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<FarmBeatsClient, FarmBeatsClientOptions>(configuration);
        }
    }
}
