// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Verticals.AgriFood.Farming
{
    // Data plane generated sub-client.
    /// <summary> The SensorEvents sub-client. </summary>
    public partial class SensorEvents
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://farmbeats.azure.net/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of SensorEvents for mocking. </summary>
        protected SensorEvents()
        {
        }

        /// <summary> Initializes a new instance of SensorEvents. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="tokenCredential"> The token credential to copy. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        internal SensorEvents(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, TokenCredential tokenCredential, Uri endpoint, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
            _tokenCredential = tokenCredential;
            _endpoint = endpoint;
            _apiVersion = apiVersion;
        }

        /// <summary>
        /// [Protocol Method] Returns a list of sensor events data. Time span for query is limited to 90 days at a time.
        /// Returns last 90 days events when startDateTime and endDateTime are not provided.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sensorId"> Id of the associated sensor. </param>
        /// <param name="sensorPartnerId"> Id of the associated sensor partner. </param>
        /// <param name="startDateTime">
        /// Search span start time of sensor events (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ.
        /// It is truncated upto seconds if fraction is provided.
        /// </param>
        /// <param name="endDateTime">
        /// Search span end time of sensor events (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ.
        /// It is truncated upto seconds if fraction is provided.
        /// </param>
        /// <param name="excludeDuplicateEvents"> Flag to exclude duplicate events and take the latest ones only (Default: true). </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sensorId"/> or <paramref name="sensorPartnerId"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/SensorEvents.xml" path="doc/members/member[@name='GetSensorEventsAsync(string,string,DateTimeOffset?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetSensorEventsAsync(string sensorId, string sensorPartnerId, DateTimeOffset? startDateTime, DateTimeOffset? endDateTime, bool? excludeDuplicateEvents, RequestContext context)
        {
            Argument.AssertNotNull(sensorId, nameof(sensorId));
            Argument.AssertNotNull(sensorPartnerId, nameof(sensorPartnerId));

            using var scope = ClientDiagnostics.CreateScope("SensorEvents.GetSensorEvents");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetSensorEventsRequest(sensorId, sensorPartnerId, startDateTime, endDateTime, excludeDuplicateEvents, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Returns a list of sensor events data. Time span for query is limited to 90 days at a time.
        /// Returns last 90 days events when startDateTime and endDateTime are not provided.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sensorId"> Id of the associated sensor. </param>
        /// <param name="sensorPartnerId"> Id of the associated sensor partner. </param>
        /// <param name="startDateTime">
        /// Search span start time of sensor events (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ.
        /// It is truncated upto seconds if fraction is provided.
        /// </param>
        /// <param name="endDateTime">
        /// Search span end time of sensor events (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ.
        /// It is truncated upto seconds if fraction is provided.
        /// </param>
        /// <param name="excludeDuplicateEvents"> Flag to exclude duplicate events and take the latest ones only (Default: true). </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sensorId"/> or <paramref name="sensorPartnerId"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/SensorEvents.xml" path="doc/members/member[@name='GetSensorEvents(string,string,DateTimeOffset?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual Response GetSensorEvents(string sensorId, string sensorPartnerId, DateTimeOffset? startDateTime, DateTimeOffset? endDateTime, bool? excludeDuplicateEvents, RequestContext context)
        {
            Argument.AssertNotNull(sensorId, nameof(sensorId));
            Argument.AssertNotNull(sensorPartnerId, nameof(sensorPartnerId));

            using var scope = ClientDiagnostics.CreateScope("SensorEvents.GetSensorEvents");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetSensorEventsRequest(sensorId, sensorPartnerId, startDateTime, endDateTime, excludeDuplicateEvents, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateGetSensorEventsRequest(string sensorId, string sensorPartnerId, DateTimeOffset? startDateTime, DateTimeOffset? endDateTime, bool? excludeDuplicateEvents, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/sensor-events", false);
            uri.AppendQuery("sensorId", sensorId, true);
            uri.AppendQuery("sensorPartnerId", sensorPartnerId, true);
            if (startDateTime != null)
            {
                uri.AppendQuery("startDateTime", startDateTime.Value, "O", true);
            }
            if (endDateTime != null)
            {
                uri.AppendQuery("endDateTime", endDateTime.Value, "O", true);
            }
            if (excludeDuplicateEvents != null)
            {
                uri.AppendQuery("excludeDuplicateEvents", excludeDuplicateEvents.Value, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
