namespace Azure.Verticals.AgriFood.Farming
{
    public partial class ApplicationData
    {
        protected ApplicationData() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string applicationDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string applicationDataId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string applicationDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string applicationDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string applicationDataId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string applicationDataId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllApplicationData(double? minAvgMaterial, double? maxAvgMaterial, double? minTotalMaterial, double? maxTotalMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> applicationIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllApplicationDataAsync(double? minAvgMaterial, double? maxAvgMaterial, double? minTotalMaterial, double? maxTotalMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> applicationIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllApplicationDataByPartyId(string partyId, double? minAvgMaterial, double? maxAvgMaterial, double? minTotalMaterial, double? maxTotalMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllApplicationDataByPartyIdAsync(string partyId, double? minAvgMaterial, double? maxAvgMaterial, double? minTotalMaterial, double? maxTotalMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetApplicationData(string partyId, string applicationDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetApplicationDataAsync(string partyId, string applicationDataId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
    }
    public partial class Attachments
    {
        protected Attachments() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string partyId, string attachmentId, Azure.Core.RequestContent content, string contentType, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string attachmentId, Azure.Core.RequestContent content, string contentType, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string attachmentId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string attachmentId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Download(string partyId, string attachmentId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DownloadAsync(string partyId, string attachmentId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetAttachment(string partyId, string attachmentId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetAttachmentAsync(string partyId, string attachmentId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAttachmentsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> resourceIds, System.Collections.Generic.IEnumerable<string> resourceTypes, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAttachmentsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> resourceIds, System.Collections.Generic.IEnumerable<string> resourceTypes, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Boundaries
    {
        protected Boundaries() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string boundaryId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string boundaryId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string boundaryId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string boundaryId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string boundaryId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string boundaryId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetBoundaries(string parentType, string type, System.Collections.Generic.IEnumerable<string> parentIds, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> boundaryIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetBoundariesAsync(string parentType, string type, System.Collections.Generic.IEnumerable<string> parentIds, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> boundaryIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetBoundariesByPartyId(string partyId, string parentType, string type, System.Collections.Generic.IEnumerable<string> parentIds, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetBoundariesByPartyIdAsync(string partyId, string parentType, string type, System.Collections.Generic.IEnumerable<string> parentIds, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetBoundary(string partyId, string boundaryId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetBoundaryAsync(string partyId, string boundaryId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetOverlap(string partyId, string boundaryId, string otherPartyId, string otherBoundaryId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetOverlapAsync(string partyId, string boundaryId, string otherPartyId, string otherBoundaryId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> Search(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> SearchAsync(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> SearchByPartyId(string partyId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> SearchByPartyIdAsync(string partyId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
    }
    public partial class CropProducts
    {
        protected CropProducts() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string cropProductId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string cropProductId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string cropProductId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string cropProductId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCropProduct(string cropProductId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCropProductAsync(string cropProductId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetCropProducts(System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> brands, System.Collections.Generic.IEnumerable<string> products, System.Collections.Generic.IEnumerable<string> traits, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetCropProductsAsync(System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> brands, System.Collections.Generic.IEnumerable<string> products, System.Collections.Generic.IEnumerable<string> traits, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Crops
    {
        protected Crops() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string cropId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string cropId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string cropId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string cropId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCrop(string cropId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCropAsync(string cropId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetCrops(System.Collections.Generic.IEnumerable<string> phenotypes, System.Collections.Generic.IEnumerable<string> breedingMethods, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetCropsAsync(System.Collections.Generic.IEnumerable<string> phenotypes, System.Collections.Generic.IEnumerable<string> breedingMethods, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class DeviceDataModels
    {
        protected DeviceDataModels() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string sensorPartnerId, string deviceDataModelId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorPartnerId, string deviceDataModelId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorPartnerId, string deviceDataModelId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorPartnerId, string deviceDataModelId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetDeviceDataModel(string sensorPartnerId, string deviceDataModelId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetDeviceDataModelAsync(string sensorPartnerId, string deviceDataModelId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetDeviceDataModels(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetDeviceDataModelsAsync(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Devices
    {
        protected Devices() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string sensorPartnerId, string deviceId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorPartnerId, string deviceId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorPartnerId, string deviceId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorPartnerId, string deviceId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetDevice(string sensorPartnerId, string deviceId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetDeviceAsync(string sensorPartnerId, string deviceId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetDevices(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> parentDeviceIds, System.Collections.Generic.IEnumerable<string> deviceDataModelIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetDevicesAsync(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> parentDeviceIds, System.Collections.Generic.IEnumerable<string> deviceDataModelIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class FarmBeatsClient
    {
        protected FarmBeatsClient() { }
        public FarmBeatsClient(System.Uri endpoint, Azure.Core.TokenCredential credential) { }
        public FarmBeatsClient(System.Uri endpoint, Azure.Core.TokenCredential credential, Azure.Verticals.AgriFood.Farming.FarmBeatsClientOptions options) { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Verticals.AgriFood.Farming.ApplicationData GetApplicationDataClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Attachments GetAttachmentsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Boundaries GetBoundariesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.CropProducts GetCropProductsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Crops GetCropsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.DeviceDataModels GetDeviceDataModelsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Devices GetDevicesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.FarmerOAuthTokens GetFarmerOAuthTokensClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.FarmOperationsDataIngestion GetFarmOperationsDataIngestionClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Farms GetFarmsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Fields GetFieldsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.HarvestData GetHarvestDataClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.ImageProcessing GetImageProcessingClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.InsightAttachments GetInsightAttachmentsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Insights GetInsightsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.ManagementZones GetManagementZonesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.ModelInference GetModelInferenceClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.NutrientAnalyses GetNutrientAnalysesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.OAuthProviders GetOAuthProvidersClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Parties GetPartiesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.PlantingData GetPlantingDataClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.PlantTissueAnalyses GetPlantTissueAnalysesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.PrescriptionMaps GetPrescriptionMapsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Prescriptions GetPrescriptionsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Scenes GetScenesClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SeasonalFields GetSeasonalFieldsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Seasons GetSeasonsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SensorDataModels GetSensorDataModelsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SensorEvents GetSensorEventsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SensorMappings GetSensorMappingsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SensorPartnerIntegrations GetSensorPartnerIntegrationsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Sensors GetSensorsClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.SolutionInference GetSolutionInferenceClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.TillageData GetTillageDataClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Weather GetWeatherClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.WeatherData GetWeatherDataClient() { throw null; }
        public virtual Azure.Verticals.AgriFood.Farming.Zones GetZonesClient() { throw null; }
    }
    public partial class FarmBeatsClientOptions : Azure.Core.ClientOptions
    {
        public FarmBeatsClientOptions(Azure.Verticals.AgriFood.Farming.FarmBeatsClientOptions.ServiceVersion version = Azure.Verticals.AgriFood.Farming.FarmBeatsClientOptions.ServiceVersion.V2022_11_01_Preview) { }
        public enum ServiceVersion
        {
            V2022_11_01_Preview = 1,
        }
    }
    public partial class FarmerOAuthTokens
    {
        protected FarmerOAuthTokens() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAuthenticatedFarmersDetails(System.Collections.Generic.IEnumerable<string> authProviderIds, System.Collections.Generic.IEnumerable<string> partyIds, bool? isValid, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAuthenticatedFarmersDetailsAsync(System.Collections.Generic.IEnumerable<string> authProviderIds, System.Collections.Generic.IEnumerable<string> partyIds, bool? isValid, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetOAuthConnectionLink(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetOAuthConnectionLinkAsync(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
    }
    public partial class FarmOperationsDataIngestion
    {
        protected FarmOperationsDataIngestion() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
    }
    public partial class Farms
    {
        protected Farms() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string farmId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string farmId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string farmId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string farmId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string farmId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string farmId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetFarm(string partyId, string farmId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetFarmAsync(string partyId, string farmId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetFarms(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetFarmsAsync(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetFarmsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetFarmsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Fields
    {
        protected Fields() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string fieldId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string fieldId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string fieldId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string fieldId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string fieldId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string fieldId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetField(string partyId, string fieldId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetFieldAsync(string partyId, string fieldId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetFields(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetFieldsAsync(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetFieldsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetFieldsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class HarvestData
    {
        protected HarvestData() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string harvestDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string harvestDataId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string harvestDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string harvestDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string harvestDataId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string harvestDataId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllHarvestData(double? minTotalYield, double? maxTotalYield, double? minAvgYield, double? maxAvgYield, double? minTotalWetMass, double? maxTotalWetMass, double? minAvgWetMass, double? maxAvgWetMass, double? minAvgMoisture, double? maxAvgMoisture, double? minAvgSpeed, double? maxAvgSpeed, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> harvestDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllHarvestDataAsync(double? minTotalYield, double? maxTotalYield, double? minAvgYield, double? maxAvgYield, double? minTotalWetMass, double? maxTotalWetMass, double? minAvgWetMass, double? maxAvgWetMass, double? minAvgMoisture, double? maxAvgMoisture, double? minAvgSpeed, double? maxAvgSpeed, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> harvestDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllHarvestDataByPartyId(string partyId, double? minTotalYield, double? maxTotalYield, double? minAvgYield, double? maxAvgYield, double? minTotalWetMass, double? maxTotalWetMass, double? minAvgWetMass, double? maxAvgWetMass, double? minAvgMoisture, double? maxAvgMoisture, double? minAvgSpeed, double? maxAvgSpeed, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllHarvestDataByPartyIdAsync(string partyId, double? minTotalYield, double? maxTotalYield, double? minAvgYield, double? maxAvgYield, double? minTotalWetMass, double? maxTotalWetMass, double? minAvgWetMass, double? maxAvgWetMass, double? minAvgMoisture, double? maxAvgMoisture, double? minAvgSpeed, double? maxAvgSpeed, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetHarvestData(string partyId, string harvestDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetHarvestDataAsync(string partyId, string harvestDataId, Azure.RequestContext context) { throw null; }
    }
    public partial class ImageProcessing
    {
        protected ImageProcessing() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateRasterizeJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateRasterizeJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetRasterizeJob(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetRasterizeJobAsync(string jobId, Azure.RequestContext context) { throw null; }
    }
    public partial class InsightAttachments
    {
        protected InsightAttachments() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.Core.RequestContent content, string contentType, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.Core.RequestContent content, string contentType, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Download(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DownloadAsync(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetInsightAttachment(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetInsightAttachmentAsync(string partyId, string modelId, string resourceType, string resourceId, string insightAttachmentId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetInsightAttachmentsByPartyIdModelIdAndResource(string partyId, string modelId, string resourceType, string resourceId, System.Collections.Generic.IEnumerable<string> insightIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetInsightAttachmentsByPartyIdModelIdAndResourceAsync(string partyId, string modelId, string resourceType, string resourceId, System.Collections.Generic.IEnumerable<string> insightIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Insights
    {
        protected Insights() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetInsight(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetInsightAsync(string partyId, string modelId, string resourceType, string resourceId, string insightId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetInsightsByPartyIdModelIdAndResource(string partyId, string modelId, string resourceType, string resourceId, System.DateTimeOffset? minInsightStartDateTime, System.DateTimeOffset? maxInsightStartDateTime, System.DateTimeOffset? minInsightEndDateTime, System.DateTimeOffset? maxInsightEndDateTime, System.Collections.Generic.IEnumerable<string> measurementFilters, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetInsightsByPartyIdModelIdAndResourceAsync(string partyId, string modelId, string resourceType, string resourceId, System.DateTimeOffset? minInsightStartDateTime, System.DateTimeOffset? maxInsightStartDateTime, System.DateTimeOffset? minInsightEndDateTime, System.DateTimeOffset? maxInsightEndDateTime, System.Collections.Generic.IEnumerable<string> measurementFilters, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class ManagementZones
    {
        protected ManagementZones() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string managementZoneId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string managementZoneId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string managementZoneId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string managementZoneId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string managementZoneId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string managementZoneId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetManagementZone(string partyId, string managementZoneId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetManagementZoneAsync(string partyId, string managementZoneId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetManagementZones(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetManagementZonesAsync(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetManagementZonesByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetManagementZonesByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class ModelInference
    {
        protected ModelInference() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateBiomassModelJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateBiomassModelJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Operation<System.BinaryData> CreateSensorPlacementModelJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateSensorPlacementModelJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Operation<System.BinaryData> CreateSoilMoistureModelJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateSoilMoistureModelJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetBiomassModelJob(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetBiomassModelJobAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSensorPlacementModelJob(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorPlacementModelJobAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSoilMoistureModelJob(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSoilMoistureModelJobAsync(string jobId, Azure.RequestContext context) { throw null; }
    }
    public partial class NutrientAnalyses
    {
        protected NutrientAnalyses() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string partyId, string nutrientAnalysisId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string nutrientAnalysisId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string nutrientAnalysisId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string nutrientAnalysisId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetNutrientAnalyses(string parentType, System.Collections.Generic.IEnumerable<string> parentIds, System.Collections.Generic.IEnumerable<string> classifications, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetNutrientAnalysesAsync(string parentType, System.Collections.Generic.IEnumerable<string> parentIds, System.Collections.Generic.IEnumerable<string> classifications, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetNutrientAnalysesByPartyId(string partyId, string parentType, System.Collections.Generic.IEnumerable<string> parentIds, System.Collections.Generic.IEnumerable<string> classifications, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetNutrientAnalysesByPartyIdAsync(string partyId, string parentType, System.Collections.Generic.IEnumerable<string> parentIds, System.Collections.Generic.IEnumerable<string> classifications, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetNutrientAnalysis(string partyId, string nutrientAnalysisId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetNutrientAnalysisAsync(string partyId, string nutrientAnalysisId, Azure.RequestContext context) { throw null; }
    }
    public partial class OAuthProviders
    {
        protected OAuthProviders() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string oauthProviderId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string oauthProviderId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string oauthProviderId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string oauthProviderId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetOAuthProvider(string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetOAuthProviderAsync(string oauthProviderId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetOAuthProviders(System.Collections.Generic.IEnumerable<string> providerIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetOAuthProvidersAsync(System.Collections.Generic.IEnumerable<string> providerIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Parties
    {
        protected Parties() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetParties(System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPartiesAsync(System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetParty(string partyId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetPartyAsync(string partyId, Azure.RequestContext context) { throw null; }
    }
    public partial class PlantingData
    {
        protected PlantingData() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string plantingDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string plantingDataId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string plantingDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string plantingDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string plantingDataId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string plantingDataId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllPlantingData(double? minAvgPlantingRate, double? maxAvgPlantingRate, double? minTotalMaterial, double? maxTotalMaterial, double? minAvgMaterial, double? maxAvgMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> plantingDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllPlantingDataAsync(double? minAvgPlantingRate, double? maxAvgPlantingRate, double? minTotalMaterial, double? maxTotalMaterial, double? minAvgMaterial, double? maxAvgMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> plantingDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllPlantingDataByPartyId(string partyId, double? minAvgPlantingRate, double? maxAvgPlantingRate, double? minTotalMaterial, double? maxTotalMaterial, double? minAvgMaterial, double? maxAvgMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllPlantingDataByPartyIdAsync(string partyId, double? minAvgPlantingRate, double? maxAvgPlantingRate, double? minTotalMaterial, double? maxTotalMaterial, double? minAvgMaterial, double? maxAvgMaterial, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetPlantingData(string partyId, string plantingDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetPlantingDataAsync(string partyId, string plantingDataId, Azure.RequestContext context) { throw null; }
    }
    public partial class PlantTissueAnalyses
    {
        protected PlantTissueAnalyses() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string plantTissueAnalysisId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string plantTissueAnalysisId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string plantTissueAnalysisId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string plantTissueAnalysisId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string plantTissueAnalysisId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string plantTissueAnalysisId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPlantTissueAnalyses(System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> cropProductsIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPlantTissueAnalysesAsync(System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> cropProductsIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPlantTissueAnalysesByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> cropProductsIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPlantTissueAnalysesByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> cropProductsIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetPlantTissueAnalysis(string partyId, string plantTissueAnalysisId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetPlantTissueAnalysisAsync(string partyId, string plantTissueAnalysisId, Azure.RequestContext context) { throw null; }
    }
    public partial class PrescriptionMaps
    {
        protected PrescriptionMaps() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string prescriptionMapId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string prescriptionMapId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string prescriptionMapId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string prescriptionMapId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string prescriptionMapId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string prescriptionMapId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetPrescriptionMap(string partyId, string prescriptionMapId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetPrescriptionMapAsync(string partyId, string prescriptionMapId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPrescriptionMaps(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPrescriptionMapsAsync(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPrescriptionMapsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPrescriptionMapsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Prescriptions
    {
        protected Prescriptions() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string prescriptionId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string prescriptionId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string prescriptionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string prescriptionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string prescriptionId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string prescriptionId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetPrescription(string partyId, string prescriptionId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetPrescriptionAsync(string partyId, string prescriptionId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPrescriptions(System.Collections.Generic.IEnumerable<string> prescriptionMapIds, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> productCodes, System.Collections.Generic.IEnumerable<string> productNames, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPrescriptionsAsync(System.Collections.Generic.IEnumerable<string> prescriptionMapIds, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> productCodes, System.Collections.Generic.IEnumerable<string> productNames, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetPrescriptionsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> prescriptionMapIds, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> productCodes, System.Collections.Generic.IEnumerable<string> productNames, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetPrescriptionsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> prescriptionMapIds, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> productCodes, System.Collections.Generic.IEnumerable<string> productNames, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Scenes
    {
        protected Scenes() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateSatelliteDataIngestionJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateSatelliteDataIngestionJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Download(string filePath, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DownloadAsync(string filePath, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSatelliteDataIngestionJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSatelliteDataIngestionJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetScenes(string provider, string partyId, string boundaryId, string source, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, double? maxCloudCoveragePercentage, double? maxDarkPixelCoveragePercentage, System.Collections.Generic.IEnumerable<string> imageNames, System.Collections.Generic.IEnumerable<double> imageResolutions, System.Collections.Generic.IEnumerable<string> imageFormats, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetScenesAsync(string provider, string partyId, string boundaryId, string source, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, double? maxCloudCoveragePercentage, double? maxDarkPixelCoveragePercentage, System.Collections.Generic.IEnumerable<string> imageNames, System.Collections.Generic.IEnumerable<double> imageResolutions, System.Collections.Generic.IEnumerable<string> imageFormats, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetStacFeature(string collectionId, string featureId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetStacFeatureAsync(string collectionId, string featureId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response SearchFeatures(string collectionId, Azure.Core.RequestContent content, int? maxpagesize = default(int?), int? skip = default(int?), Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> SearchFeaturesAsync(string collectionId, Azure.Core.RequestContent content, int? maxpagesize = default(int?), int? skip = default(int?), Azure.RequestContext context = null) { throw null; }
    }
    public partial class SeasonalFields
    {
        protected SeasonalFields() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string seasonalFieldId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string seasonalFieldId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string seasonalFieldId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string seasonalFieldId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string seasonalFieldId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string seasonalFieldId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSeasonalField(string partyId, string seasonalFieldId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSeasonalFieldAsync(string partyId, string seasonalFieldId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSeasonalFields(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropProductIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonalFieldIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSeasonalFieldsAsync(System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropProductIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> seasonalFieldIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSeasonalFieldsByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropProductIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSeasonalFieldsByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> farmIds, System.Collections.Generic.IEnumerable<string> fieldIds, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> cropProductIds, System.Collections.Generic.IEnumerable<string> cropIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Seasons
    {
        protected Seasons() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string seasonId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string seasonId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string seasonId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string seasonId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetSeason(string seasonId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSeasonAsync(string seasonId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSeasons(System.DateTimeOffset? minStartDateTime, System.DateTimeOffset? maxStartDateTime, System.DateTimeOffset? minEndDateTime, System.DateTimeOffset? maxEndDateTime, System.Collections.Generic.IEnumerable<int> years, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSeasonsAsync(System.DateTimeOffset? minStartDateTime, System.DateTimeOffset? maxStartDateTime, System.DateTimeOffset? minEndDateTime, System.DateTimeOffset? maxEndDateTime, System.Collections.Generic.IEnumerable<int> years, System.Collections.Generic.IEnumerable<string> seasonIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class SensorDataModels
    {
        protected SensorDataModels() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string sensorPartnerId, string sensorDataModelId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorPartnerId, string sensorDataModelId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorPartnerId, string sensorDataModelId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorPartnerId, string sensorDataModelId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetSensorDataModel(string sensorPartnerId, string sensorDataModelId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorDataModelAsync(string sensorPartnerId, string sensorDataModelId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSensorDataModels(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSensorDataModelsAsync(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class SensorEvents
    {
        protected SensorEvents() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response GetSensorEvents(string sensorId, string sensorPartnerId, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, bool? excludeDuplicateEvents, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorEventsAsync(string sensorId, string sensorPartnerId, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, bool? excludeDuplicateEvents, Azure.RequestContext context) { throw null; }
    }
    public partial class SensorMappings
    {
        protected SensorMappings() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string sensorMappingId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorMappingId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorMappingId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorMappingId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetSensorMapping(string sensorMappingId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorMappingAsync(string sensorMappingId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSensorMappings(System.Collections.Generic.IEnumerable<string> sensorIds, System.Collections.Generic.IEnumerable<string> sensorPartnerIds, System.Collections.Generic.IEnumerable<string> partyIds, System.Collections.Generic.IEnumerable<string> boundaryIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSensorMappingsAsync(System.Collections.Generic.IEnumerable<string> sensorIds, System.Collections.Generic.IEnumerable<string> sensorPartnerIds, System.Collections.Generic.IEnumerable<string> partyIds, System.Collections.Generic.IEnumerable<string> boundaryIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class SensorPartnerIntegrations
    {
        protected SensorPartnerIntegrations() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CheckConsent(string sensorPartnerId, string integrationId, string key, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CheckConsentAsync(string sensorPartnerId, string integrationId, string key, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string sensorPartnerId, string integrationId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorPartnerId, string integrationId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorPartnerId, string integrationId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorPartnerId, string integrationId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GenerateConsentLink(string sensorPartnerId, string integrationId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GenerateConsentLinkAsync(string sensorPartnerId, string integrationId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSensorPartnerIntegration(string sensorPartnerId, string integrationId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorPartnerIntegrationAsync(string sensorPartnerId, string integrationId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSensorPartnerIntegrations(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> integrationIds, System.Collections.Generic.IEnumerable<string> partyIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSensorPartnerIntegrationsAsync(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> integrationIds, System.Collections.Generic.IEnumerable<string> partyIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class Sensors
    {
        protected Sensors() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response CreateOrUpdate(string sensorPartnerId, string sensorId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string sensorPartnerId, string sensorId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string sensorPartnerId, string sensorId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string sensorPartnerId, string sensorId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetConnectionString(string sensorPartnerId, string sensorId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetConnectionStringAsync(string sensorPartnerId, string sensorId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetSensor(string sensorPartnerId, string sensorId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetSensorAsync(string sensorPartnerId, string sensorId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetSensors(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> sensorDataModelIds, System.Collections.Generic.IEnumerable<string> sensorMappingIds, System.Collections.Generic.IEnumerable<string> deviceIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetSensorsAsync(string sensorPartnerId, System.Collections.Generic.IEnumerable<string> sensorDataModelIds, System.Collections.Generic.IEnumerable<string> sensorMappingIds, System.Collections.Generic.IEnumerable<string> deviceIds, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response RenewConnectionString(string sensorPartnerId, string sensorId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> RenewConnectionStringAsync(string sensorPartnerId, string sensorId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
    }
    public partial class SolutionInference
    {
        protected SolutionInference() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response Cancel(string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CancelAsync(string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Operation<System.BinaryData> CreateOrUpdate(Azure.WaitUntil waitUntil, string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateOrUpdateAsync(Azure.WaitUntil waitUntil, string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Fetch(string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> FetchAsync(string solutionId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
    }
    public partial class TillageData
    {
        protected TillageData() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string tillageDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string tillageDataId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string tillageDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string tillageDataId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string tillageDataId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string tillageDataId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllTillageData(double? minTillageDepth, double? maxTillageDepth, double? minTillagePressure, double? maxTillagePressure, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> tillageDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllTillageDataAsync(double? minTillageDepth, double? maxTillageDepth, double? minTillagePressure, double? maxTillagePressure, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> tillageDataIds, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetAllTillageDataByPartyId(string partyId, double? minTillageDepth, double? maxTillageDepth, double? minTillagePressure, double? maxTillagePressure, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetAllTillageDataByPartyIdAsync(string partyId, double? minTillageDepth, double? maxTillageDepth, double? minTillagePressure, double? maxTillagePressure, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> associatedBoundaryIds, System.DateTimeOffset? minOperationStartDateTime, System.DateTimeOffset? maxOperationStartDateTime, System.DateTimeOffset? minOperationEndDateTime, System.DateTimeOffset? maxOperationEndDateTime, System.DateTimeOffset? minOperationModifiedDateTime, System.DateTimeOffset? maxOperationModifiedDateTime, double? minArea, double? maxArea, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetTillageData(string partyId, string tillageDataId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetTillageDataAsync(string partyId, string tillageDataId, Azure.RequestContext context) { throw null; }
    }
    public partial class Weather
    {
        protected Weather() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateDataDeleteJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateDataDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Operation<System.BinaryData> CreateDataIngestionJob(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateDataIngestionJobAsync(Azure.WaitUntil waitUntil, string jobId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetDataDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetDataDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetDataIngestionJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetDataIngestionJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetWeathers(string partyId, string boundaryId, string extensionId, string weatherDataType, string granularity, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetWeathersAsync(string partyId, string boundaryId, string extensionId, string weatherDataType, string granularity, System.DateTimeOffset? startDateTime, System.DateTimeOffset? endDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
    public partial class WeatherData
    {
        protected WeatherData() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Response GetWeatherData(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetWeatherDataAsync(Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
    }
    public partial class Zones
    {
        protected Zones() { }
        public virtual Azure.Core.Pipeline.HttpPipeline Pipeline { get { throw null; } }
        public virtual Azure.Operation<System.BinaryData> CreateCascadeDeleteJob(Azure.WaitUntil waitUntil, string jobId, string partyId, string zoneId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Operation<System.BinaryData>> CreateCascadeDeleteJobAsync(Azure.WaitUntil waitUntil, string jobId, string partyId, string zoneId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response CreateOrUpdate(string partyId, string zoneId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> CreateOrUpdateAsync(string partyId, string zoneId, Azure.Core.RequestContent content, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response Delete(string partyId, string zoneId, Azure.RequestContext context = null) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> DeleteAsync(string partyId, string zoneId, Azure.RequestContext context = null) { throw null; }
        public virtual Azure.Response GetCascadeDeleteJobDetails(string jobId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetCascadeDeleteJobDetailsAsync(string jobId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Response GetZone(string partyId, string zoneId, Azure.RequestContext context) { throw null; }
        public virtual System.Threading.Tasks.Task<Azure.Response> GetZoneAsync(string partyId, string zoneId, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetZones(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> managementZoneIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetZonesAsync(System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> managementZoneIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.Pageable<System.BinaryData> GetZonesByPartyId(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> managementZoneIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
        public virtual Azure.AsyncPageable<System.BinaryData> GetZonesByPartyIdAsync(string partyId, System.Collections.Generic.IEnumerable<string> types, System.Collections.Generic.IEnumerable<string> managementZoneIds, System.Collections.Generic.IEnumerable<string> sources, System.Collections.Generic.IEnumerable<string> ids, System.Collections.Generic.IEnumerable<string> names, System.Collections.Generic.IEnumerable<string> propertyFilters, System.Collections.Generic.IEnumerable<string> statuses, System.DateTimeOffset? minCreatedDateTime, System.DateTimeOffset? maxCreatedDateTime, System.DateTimeOffset? minLastModifiedDateTime, System.DateTimeOffset? maxLastModifiedDateTime, int? maxPageSize, string skipToken, Azure.RequestContext context) { throw null; }
    }
}
namespace Microsoft.Extensions.Azure
{
    public static partial class VerticalsAgriFoodFarmingClientBuilderExtensions
    {
        public static Azure.Core.Extensions.IAzureClientBuilder<Azure.Verticals.AgriFood.Farming.FarmBeatsClient, Azure.Verticals.AgriFood.Farming.FarmBeatsClientOptions> AddFarmBeatsClient<TBuilder>(this TBuilder builder, System.Uri endpoint) where TBuilder : Azure.Core.Extensions.IAzureClientFactoryBuilderWithCredential { throw null; }
        public static Azure.Core.Extensions.IAzureClientBuilder<Azure.Verticals.AgriFood.Farming.FarmBeatsClient, Azure.Verticals.AgriFood.Farming.FarmBeatsClientOptions> AddFarmBeatsClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration) where TBuilder : Azure.Core.Extensions.IAzureClientFactoryBuilderWithConfiguration<TConfiguration> { throw null; }
    }
}
