// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AgFoodPlatform.Models
{
    public partial class DetailedInformation : IUtf8JsonSerializable, IJsonModel<DetailedInformation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DetailedInformation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DetailedInformation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DetailedInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DetailedInformation)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ApiName))
            {
                writer.WritePropertyName("apiName"u8);
                writer.WriteStringValue(ApiName);
            }
            if (Optional.IsCollectionDefined(CustomParameters))
            {
                writer.WritePropertyName("customParameters"u8);
                writer.WriteStartArray();
                foreach (var item in CustomParameters)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PlatformParameters))
            {
                writer.WritePropertyName("platformParameters"u8);
                writer.WriteStartArray();
                foreach (var item in PlatformParameters)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(UnitsSupported))
            {
                writer.WritePropertyName("unitsSupported"u8);
                writer.WriteObjectValue(UnitsSupported, options);
            }
            if (Optional.IsCollectionDefined(ApiInputParameters))
            {
                writer.WritePropertyName("apiInputParameters"u8);
                writer.WriteStartArray();
                foreach (var item in ApiInputParameters)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DetailedInformation IJsonModel<DetailedInformation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DetailedInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DetailedInformation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDetailedInformation(document.RootElement, options);
        }

        internal static DetailedInformation DeserializeDetailedInformation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string apiName = default;
            IReadOnlyList<string> customParameters = default;
            IReadOnlyList<string> platformParameters = default;
            UnitSystemsInfo unitsSupported = default;
            IReadOnlyList<string> apiInputParameters = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("apiName"u8))
                {
                    apiName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customParameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    customParameters = array;
                    continue;
                }
                if (property.NameEquals("platformParameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    platformParameters = array;
                    continue;
                }
                if (property.NameEquals("unitsSupported"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unitsSupported = UnitSystemsInfo.DeserializeUnitSystemsInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("apiInputParameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    apiInputParameters = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DetailedInformation(
                apiName,
                customParameters ?? new ChangeTrackingList<string>(),
                platformParameters ?? new ChangeTrackingList<string>(),
                unitsSupported,
                apiInputParameters ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DetailedInformation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DetailedInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DetailedInformation)} does not support writing '{options.Format}' format.");
            }
        }

        DetailedInformation IPersistableModel<DetailedInformation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DetailedInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDetailedInformation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DetailedInformation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DetailedInformation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
