// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AgFoodPlatform.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct AgFoodPlatformPrivateEndpointConnectionProvisioningState : IEquatable<AgFoodPlatformPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgFoodPlatformPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgFoodPlatformPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static AgFoodPlatformPrivateEndpointConnectionProvisioningState Succeeded { get; } = new AgFoodPlatformPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static AgFoodPlatformPrivateEndpointConnectionProvisioningState Creating { get; } = new AgFoodPlatformPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static AgFoodPlatformPrivateEndpointConnectionProvisioningState Deleting { get; } = new AgFoodPlatformPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static AgFoodPlatformPrivateEndpointConnectionProvisioningState Failed { get; } = new AgFoodPlatformPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="AgFoodPlatformPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AgFoodPlatformPrivateEndpointConnectionProvisioningState left, AgFoodPlatformPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgFoodPlatformPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AgFoodPlatformPrivateEndpointConnectionProvisioningState left, AgFoodPlatformPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgFoodPlatformPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator AgFoodPlatformPrivateEndpointConnectionProvisioningState(string value) => new AgFoodPlatformPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgFoodPlatformPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgFoodPlatformPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
