// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.AgFoodPlatform.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AgFoodPlatform
{
    public partial class FarmBeatsExtensionData : IUtf8JsonSerializable, IJsonModel<FarmBeatsExtensionData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FarmBeatsExtensionData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FarmBeatsExtensionData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FarmBeatsExtensionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FarmBeatsExtensionData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(TargetResourceType))
            {
                writer.WritePropertyName("targetResourceType"u8);
                writer.WriteStringValue(TargetResourceType);
            }
            if (options.Format != "W" && Optional.IsDefined(FarmBeatsExtensionId))
            {
                writer.WritePropertyName("farmBeatsExtensionId"u8);
                writer.WriteStringValue(FarmBeatsExtensionId);
            }
            if (options.Format != "W" && Optional.IsDefined(FarmBeatsExtensionName))
            {
                writer.WritePropertyName("farmBeatsExtensionName"u8);
                writer.WriteStringValue(FarmBeatsExtensionName);
            }
            if (options.Format != "W" && Optional.IsDefined(FarmBeatsExtensionVersion))
            {
                writer.WritePropertyName("farmBeatsExtensionVersion"u8);
                writer.WriteStringValue(FarmBeatsExtensionVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(PublisherId))
            {
                writer.WritePropertyName("publisherId"u8);
                writer.WriteStringValue(PublisherId);
            }
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(ExtensionCategory))
            {
                writer.WritePropertyName("extensionCategory"u8);
                writer.WriteStringValue(ExtensionCategory);
            }
            if (options.Format != "W" && Optional.IsDefined(ExtensionAuthLink))
            {
                writer.WritePropertyName("extensionAuthLink"u8);
                writer.WriteStringValue(ExtensionAuthLink);
            }
            if (options.Format != "W" && Optional.IsDefined(ExtensionApiDocsLink))
            {
                writer.WritePropertyName("extensionApiDocsLink"u8);
                writer.WriteStringValue(ExtensionApiDocsLink);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DetailedInformation))
            {
                writer.WritePropertyName("detailedInformation"u8);
                writer.WriteStartArray();
                foreach (var item in DetailedInformation)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        FarmBeatsExtensionData IJsonModel<FarmBeatsExtensionData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FarmBeatsExtensionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FarmBeatsExtensionData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFarmBeatsExtensionData(document.RootElement, options);
        }

        internal static FarmBeatsExtensionData DeserializeFarmBeatsExtensionData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string targetResourceType = default;
            string farmBeatsExtensionId = default;
            string farmBeatsExtensionName = default;
            string farmBeatsExtensionVersion = default;
            string publisherId = default;
            string description = default;
            string extensionCategory = default;
            string extensionAuthLink = default;
            string extensionApiDocsLink = default;
            IReadOnlyList<DetailedInformation> detailedInformation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("targetResourceType"u8))
                        {
                            targetResourceType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("farmBeatsExtensionId"u8))
                        {
                            farmBeatsExtensionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("farmBeatsExtensionName"u8))
                        {
                            farmBeatsExtensionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("farmBeatsExtensionVersion"u8))
                        {
                            farmBeatsExtensionVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherId"u8))
                        {
                            publisherId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("extensionCategory"u8))
                        {
                            extensionCategory = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("extensionAuthLink"u8))
                        {
                            extensionAuthLink = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("extensionApiDocsLink"u8))
                        {
                            extensionApiDocsLink = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("detailedInformation"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DetailedInformation> array = new List<DetailedInformation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(Models.DetailedInformation.DeserializeDetailedInformation(item, options));
                            }
                            detailedInformation = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FarmBeatsExtensionData(
                id,
                name,
                type,
                systemData,
                targetResourceType,
                farmBeatsExtensionId,
                farmBeatsExtensionName,
                farmBeatsExtensionVersion,
                publisherId,
                description,
                extensionCategory,
                extensionAuthLink,
                extensionApiDocsLink,
                detailedInformation ?? new ChangeTrackingList<DetailedInformation>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FarmBeatsExtensionData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FarmBeatsExtensionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FarmBeatsExtensionData)} does not support writing '{options.Format}' format.");
            }
        }

        FarmBeatsExtensionData IPersistableModel<FarmBeatsExtensionData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FarmBeatsExtensionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFarmBeatsExtensionData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FarmBeatsExtensionData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FarmBeatsExtensionData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
