// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.AgFoodPlatform.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AgFoodPlatform
{
    /// <summary>
    /// A class representing the FarmBeat data model.
    /// FarmBeats ARM Resource.
    /// </summary>
    public partial class FarmBeatData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FarmBeatData"/>. </summary>
        /// <param name="location"> The location. </param>
        public FarmBeatData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="FarmBeatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity for the resource. Current supported identity types: SystemAssigned. </param>
        /// <param name="instanceUri"> Uri of the FarmBeats instance. </param>
        /// <param name="provisioningState"> FarmBeats instance provisioning state. </param>
        /// <param name="sensorIntegration"> Sensor integration request model. </param>
        /// <param name="publicNetworkAccess"> Property to allow or block public traffic for an Azure FarmBeats resource. </param>
        /// <param name="privateEndpointConnections"> The Private Endpoint Connection resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FarmBeatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, Uri instanceUri, ProvisioningState? provisioningState, SensorIntegration sensorIntegration, PublicNetworkAccess? publicNetworkAccess, AgFoodPlatformPrivateEndpointConnectionData privateEndpointConnections, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            InstanceUri = instanceUri;
            ProvisioningState = provisioningState;
            SensorIntegration = sensorIntegration;
            PublicNetworkAccess = publicNetworkAccess;
            PrivateEndpointConnections = privateEndpointConnections;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FarmBeatData"/> for deserialization. </summary>
        internal FarmBeatData()
        {
        }

        /// <summary> Identity for the resource. Current supported identity types: SystemAssigned. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Uri of the FarmBeats instance. </summary>
        public Uri InstanceUri { get; }
        /// <summary> FarmBeats instance provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> Sensor integration request model. </summary>
        public SensorIntegration SensorIntegration { get; set; }
        /// <summary> Property to allow or block public traffic for an Azure FarmBeats resource. </summary>
        public PublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> The Private Endpoint Connection resource. </summary>
        public AgFoodPlatformPrivateEndpointConnectionData PrivateEndpointConnections { get; }
    }
}
