// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AgFoodPlatform.Samples
{
    public partial class Sample_ExtensionCollection
    {
        // Extensions_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ExtensionsCreate()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/Extensions_Create.json
            // this example is just showing the usage of "Extensions_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this ExtensionResource
            ExtensionCollection collection = farmBeat.GetExtensions();

            // invoke the operation
            string extensionId = "provider.extension";
            ArmOperation<ExtensionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, extensionId);
            ExtensionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtensionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Extensions_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExtensionsGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/Extensions_Get.json
            // this example is just showing the usage of "Extensions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this ExtensionResource
            ExtensionCollection collection = farmBeat.GetExtensions();

            // invoke the operation
            string extensionId = "provider.extension";
            ExtensionResource result = await collection.GetAsync(extensionId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtensionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Extensions_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ExtensionsGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/Extensions_Get.json
            // this example is just showing the usage of "Extensions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this ExtensionResource
            ExtensionCollection collection = farmBeat.GetExtensions();

            // invoke the operation
            string extensionId = "provider.extension";
            bool result = await collection.ExistsAsync(extensionId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Extensions_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ExtensionsGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/Extensions_Get.json
            // this example is just showing the usage of "Extensions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this ExtensionResource
            ExtensionCollection collection = farmBeat.GetExtensions();

            // invoke the operation
            string extensionId = "provider.extension";
            NullableResponse<ExtensionResource> response = await collection.GetIfExistsAsync(extensionId);
            ExtensionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExtensionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Extensions_ListByFarmBeats
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ExtensionsListByFarmBeats()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/Extensions_ListByFarmBeats.json
            // this example is just showing the usage of "Extensions_ListByFarmBeats" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this ExtensionResource
            ExtensionCollection collection = farmBeat.GetExtensions();

            // invoke the operation and iterate over the result
            await foreach (ExtensionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExtensionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
