// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AgFoodPlatform.Samples
{
    public partial class Sample_AgFoodPlatformPrivateLinkResourceCollection
    {
        // PrivateLinkResources_ListByResource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_PrivateLinkResourcesListByResource()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateLinkResources_ListByResource.json
            // this example is just showing the usage of "PrivateLinkResources_ListByResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this AgFoodPlatformPrivateLinkResource
            AgFoodPlatformPrivateLinkResourceCollection collection = farmBeat.GetAgFoodPlatformPrivateLinkResources();

            // invoke the operation and iterate over the result
            await foreach (AgFoodPlatformPrivateLinkResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AgFoodPlatformPrivateLinkResourceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // PrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateLinkResources_Get.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this AgFoodPlatformPrivateLinkResource
            AgFoodPlatformPrivateLinkResourceCollection collection = farmBeat.GetAgFoodPlatformPrivateLinkResources();

            // invoke the operation
            string subResourceName = "farmbeats";
            AgFoodPlatformPrivateLinkResource result = await collection.GetAsync(subResourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AgFoodPlatformPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_PrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateLinkResources_Get.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this AgFoodPlatformPrivateLinkResource
            AgFoodPlatformPrivateLinkResourceCollection collection = farmBeat.GetAgFoodPlatformPrivateLinkResources();

            // invoke the operation
            string subResourceName = "farmbeats";
            bool result = await collection.ExistsAsync(subResourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // PrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_PrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateLinkResources_Get.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FarmBeatResource created on azure
            // for more information of creating FarmBeatResource, please refer to the document of FarmBeatResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            ResourceIdentifier farmBeatResourceId = FarmBeatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName);
            FarmBeatResource farmBeat = client.GetFarmBeatResource(farmBeatResourceId);

            // get the collection of this AgFoodPlatformPrivateLinkResource
            AgFoodPlatformPrivateLinkResourceCollection collection = farmBeat.GetAgFoodPlatformPrivateLinkResources();

            // invoke the operation
            string subResourceName = "farmbeats";
            NullableResponse<AgFoodPlatformPrivateLinkResource> response = await collection.GetIfExistsAsync(subResourceName);
            AgFoodPlatformPrivateLinkResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AgFoodPlatformPrivateLinkResourceData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
