// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AgFoodPlatform.Samples
{
    public partial class Sample_AgFoodPlatformPrivateLinkResource
    {
        // PrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateLinkResources_Get.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AgFoodPlatformPrivateLinkResource created on azure
            // for more information of creating AgFoodPlatformPrivateLinkResource, please refer to the document of AgFoodPlatformPrivateLinkResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            string subResourceName = "farmbeats";
            ResourceIdentifier agFoodPlatformPrivateLinkResourceId = AgFoodPlatformPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName, subResourceName);
            AgFoodPlatformPrivateLinkResource agFoodPlatformPrivateLinkResource = client.GetAgFoodPlatformPrivateLinkResource(agFoodPlatformPrivateLinkResourceId);

            // invoke the operation
            AgFoodPlatformPrivateLinkResource result = await agFoodPlatformPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AgFoodPlatformPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
