// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AgFoodPlatform.Models;

namespace Azure.ResourceManager.AgFoodPlatform.Samples
{
    public partial class Sample_AgFoodPlatformPrivateEndpointConnectionResource
    {
        // PrivateEndpointConnections_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PrivateEndpointConnectionsCreateOrUpdate()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateEndpointConnections_CreateOrUpdate.json
            // this example is just showing the usage of "PrivateEndpointConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AgFoodPlatformPrivateEndpointConnectionResource created on azure
            // for more information of creating AgFoodPlatformPrivateEndpointConnectionResource, please refer to the document of AgFoodPlatformPrivateEndpointConnectionResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            string privateEndpointConnectionName = "privateEndpointConnectionName";
            ResourceIdentifier agFoodPlatformPrivateEndpointConnectionResourceId = AgFoodPlatformPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName, privateEndpointConnectionName);
            AgFoodPlatformPrivateEndpointConnectionResource agFoodPlatformPrivateEndpointConnection = client.GetAgFoodPlatformPrivateEndpointConnectionResource(agFoodPlatformPrivateEndpointConnectionResourceId);

            // invoke the operation
            AgFoodPlatformPrivateEndpointConnectionData data = new AgFoodPlatformPrivateEndpointConnectionData()
            {
                ConnectionState = new AgFoodPlatformPrivateLinkServiceConnectionState()
                {
                    Status = AgFoodPlatformPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Approved by johndoe@contoso.com",
                },
            };
            ArmOperation<AgFoodPlatformPrivateEndpointConnectionResource> lro = await agFoodPlatformPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            AgFoodPlatformPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AgFoodPlatformPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnections_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateEndpointConnectionsGet()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateEndpointConnections_Get.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AgFoodPlatformPrivateEndpointConnectionResource created on azure
            // for more information of creating AgFoodPlatformPrivateEndpointConnectionResource, please refer to the document of AgFoodPlatformPrivateEndpointConnectionResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            string privateEndpointConnectionName = "privateEndpointConnectionName";
            ResourceIdentifier agFoodPlatformPrivateEndpointConnectionResourceId = AgFoodPlatformPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName, privateEndpointConnectionName);
            AgFoodPlatformPrivateEndpointConnectionResource agFoodPlatformPrivateEndpointConnection = client.GetAgFoodPlatformPrivateEndpointConnectionResource(agFoodPlatformPrivateEndpointConnectionResourceId);

            // invoke the operation
            AgFoodPlatformPrivateEndpointConnectionResource result = await agFoodPlatformPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AgFoodPlatformPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnections_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PrivateEndpointConnectionsDelete()
        {
            // Generated from example definition: specification/agrifood/resource-manager/Microsoft.AgFoodPlatform/preview/2021-09-01-preview/examples/PrivateEndpointConnections_Delete.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AgFoodPlatformPrivateEndpointConnectionResource created on azure
            // for more information of creating AgFoodPlatformPrivateEndpointConnectionResource, please refer to the document of AgFoodPlatformPrivateEndpointConnectionResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "examples-rg";
            string farmBeatsResourceName = "examples-farmbeatsResourceName";
            string privateEndpointConnectionName = "privateEndpointConnectionName";
            ResourceIdentifier agFoodPlatformPrivateEndpointConnectionResourceId = AgFoodPlatformPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, farmBeatsResourceName, privateEndpointConnectionName);
            AgFoodPlatformPrivateEndpointConnectionResource agFoodPlatformPrivateEndpointConnection = client.GetAgFoodPlatformPrivateEndpointConnectionResource(agFoodPlatformPrivateEndpointConnectionResourceId);

            // invoke the operation
            await agFoodPlatformPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
