// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Advisor
{
    /// <summary>
    /// A class representing the SuppressionContract data model.
    /// The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
    /// </summary>
    public partial class SuppressionContractData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SuppressionContractData"/>. </summary>
        public SuppressionContractData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SuppressionContractData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="suppressionId"> The GUID of the suppression. </param>
        /// <param name="ttl"> The duration for which the suppression is valid. </param>
        /// <param name="expirationTimeStamp"> Gets or sets the expiration time stamp. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SuppressionContractData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string suppressionId, string ttl, DateTimeOffset? expirationTimeStamp, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SuppressionId = suppressionId;
            Ttl = ttl;
            ExpirationTimeStamp = expirationTimeStamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the suppression. </summary>
        public string SuppressionId { get; set; }
        /// <summary> The duration for which the suppression is valid. </summary>
        public string Ttl { get; set; }
        /// <summary> Gets or sets the expiration time stamp. </summary>
        public DateTimeOffset? ExpirationTimeStamp { get; }
    }
}
