// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Advisor.Models
{
    /// <summary> The Scenario. </summary>
    public readonly partial struct Scenario : IEquatable<Scenario>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="Scenario"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public Scenario(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertsValue = "Alerts";

        /// <summary> Alerts. </summary>
        public static Scenario Alerts { get; } = new Scenario(AlertsValue);
        /// <summary> Determines if two <see cref="Scenario"/> values are the same. </summary>
        public static bool operator ==(Scenario left, Scenario right) => left.Equals(right);
        /// <summary> Determines if two <see cref="Scenario"/> values are not the same. </summary>
        public static bool operator !=(Scenario left, Scenario right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="Scenario"/>. </summary>
        public static implicit operator Scenario(string value) => new Scenario(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is Scenario other && Equals(other);
        /// <inheritdoc />
        public bool Equals(Scenario other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
