// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Advisor.Models
{
    /// <summary> State of digest configuration. </summary>
    public readonly partial struct DigestConfigState : IEquatable<DigestConfigState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigestConfigState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigestConfigState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string DisabledValue = "Disabled";

        /// <summary> Active. </summary>
        public static DigestConfigState Active { get; } = new DigestConfigState(ActiveValue);
        /// <summary> Disabled. </summary>
        public static DigestConfigState Disabled { get; } = new DigestConfigState(DisabledValue);
        /// <summary> Determines if two <see cref="DigestConfigState"/> values are the same. </summary>
        public static bool operator ==(DigestConfigState left, DigestConfigState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigestConfigState"/> values are not the same. </summary>
        public static bool operator !=(DigestConfigState left, DigestConfigState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigestConfigState"/>. </summary>
        public static implicit operator DigestConfigState(string value) => new DigestConfigState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigestConfigState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigestConfigState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
