// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Advisor
{
    /// <summary>
    /// A Class representing a MetadataEntity along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="MetadataEntityResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetMetadataEntityResource method.
    /// Otherwise you can get one from its parent resource <see cref="TenantResource"/> using the GetMetadataEntity method.
    /// </summary>
    public partial class MetadataEntityResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="MetadataEntityResource"/> instance. </summary>
        /// <param name="name"> The name. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string name)
        {
            var resourceId = $"/providers/Microsoft.Advisor/metadata/{name}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _metadataEntityRecommendationMetadataClientDiagnostics;
        private readonly RecommendationMetadataRestOperations _metadataEntityRecommendationMetadataRestClient;
        private readonly MetadataEntityData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Advisor/metadata";

        /// <summary> Initializes a new instance of the <see cref="MetadataEntityResource"/> class for mocking. </summary>
        protected MetadataEntityResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MetadataEntityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal MetadataEntityResource(ArmClient client, MetadataEntityData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="MetadataEntityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MetadataEntityResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _metadataEntityRecommendationMetadataClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Advisor", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string metadataEntityRecommendationMetadataApiVersion);
            _metadataEntityRecommendationMetadataRestClient = new RecommendationMetadataRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, metadataEntityRecommendationMetadataApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual MetadataEntityData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the metadata entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Advisor/metadata/{name}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecommendationMetadata_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MetadataEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<MetadataEntityResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _metadataEntityRecommendationMetadataClientDiagnostics.CreateScope("MetadataEntityResource.Get");
            scope.Start();
            try
            {
                var response = await _metadataEntityRecommendationMetadataRestClient.GetAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MetadataEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the metadata entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Advisor/metadata/{name}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecommendationMetadata_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MetadataEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<MetadataEntityResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _metadataEntityRecommendationMetadataClientDiagnostics.CreateScope("MetadataEntityResource.Get");
            scope.Start();
            try
            {
                var response = _metadataEntityRecommendationMetadataRestClient.Get(Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MetadataEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
