// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Azure.Core;

namespace BasicTypeSpec
{
    internal partial class ClientUriBuilder : RequestUriBuilder
    {
        private UriBuilder _uriBuilder;
        private StringBuilder _pathBuilder;
        private StringBuilder _queryBuilder;

        public ClientUriBuilder()
        {
        }

        private UriBuilder UriBuilder => _uriBuilder  ??=  new UriBuilder();

        private StringBuilder PathBuilder => _pathBuilder  ??=  new StringBuilder(UriBuilder.Path);

        private StringBuilder QueryBuilder => _queryBuilder  ??=  new StringBuilder(UriBuilder.Query);

        public void AppendQueryDelimited<T>(string name, IEnumerable<T> value, string delimiter, bool escape = true)
        {
            IEnumerable<string> stringValues = value.Select(v => TypeFormatters.ConvertToString(v));
            AppendQuery(name, string.Join(delimiter, stringValues), escape);
        }

        public void AppendQueryDelimited<T>(string name, IEnumerable<T> value, string delimiter, string format, bool escape = true)
        {
            IEnumerable<string> stringValues = value.Select(v => TypeFormatters.ConvertToString(v, format));
            AppendQuery(name, string.Join(delimiter, stringValues), escape);
        }
    }
}
