// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Core.Pipeline;

namespace BasicTypeSpec
{
    internal static partial class ClientPipelineExtensions
    {
        public static async ValueTask<Response> ProcessMessageAsync(this HttpPipeline pipeline, HttpMessage message, RequestContext options)
        {
            await pipeline.SendAsync(message, default).ConfigureAwait(false);

            if (message.Response.IsError && (options?.ErrorOptions & ErrorOptions.NoThrow) != ErrorOptions.NoThrow)
            {
                throw new RequestFailedException(message.Response);
            }

            Response response = message.BufferResponse ? message.Response : ExtractResponseContent(message);
            return response;
        }

        public static Response ProcessMessage(this HttpPipeline pipeline, HttpMessage message, RequestContext options)
        {
            pipeline.Send(message, default);

            if (message.Response.IsError && (options?.ErrorOptions & ErrorOptions.NoThrow) != ErrorOptions.NoThrow)
            {
                throw new RequestFailedException(message.Response);
            }

            Response response = message.BufferResponse ? message.Response : ExtractResponseContent(message);
            return response;
        }

        public static async ValueTask<Response<bool>> ProcessHeadAsBoolMessageAsync(this HttpPipeline pipeline, HttpMessage message, RequestContext options)
        {
            Response response = await pipeline.ProcessMessageAsync(message, options).ConfigureAwait(false);
            switch (response.Status)
            {
                case >= 200 and < 300:
                    return Response.FromValue(true, response);
                case >= 400 and < 500:
                    return Response.FromValue(false, response);
                default:
                    return new ErrorResult<bool>(response, new RequestFailedException(response));
            }
        }

        public static Response<bool> ProcessHeadAsBoolMessage(this HttpPipeline pipeline, HttpMessage message, RequestContext options)
        {
            Response response = pipeline.ProcessMessage(message, options);
            switch (response.Status)
            {
                case >= 200 and < 300:
                    return Response.FromValue(true, response);
                case >= 400 and < 500:
                    return Response.FromValue(false, response);
                default:
                    return new ErrorResult<bool>(response, new RequestFailedException(response));
            }
        }

        private static Response ExtractResponseContent(HttpMessage message)
        {
            message.ExtractResponseContent();
            return message.Response;
        }
    }
}
