// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Core.Pipeline;
using BasicTypeSpec.Models;

namespace BasicTypeSpec
{
    /// <summary></summary>
    public partial class BasicTypeSpecClient
    {
        private readonly Uri _endpoint;
        private const string AuthorizationHeader = "my-api-key";
        /// <summary> A credential used to authenticate to the service. </summary>
        private readonly ApiKeyCredential _keyCredential;

        /// <summary> Initializes a new instance of BasicTypeSpecClient for mocking. </summary>
        protected BasicTypeSpecClient()
        {
        }

        /// <summary> Initializes a new instance of BasicTypeSpecClient. </summary>
        /// <param name="endpoint"> Service endpoint. </param>
        /// <param name="keyCredential"> A credential used to authenticate to the service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="keyCredential"/> is null. </exception>
        public BasicTypeSpecClient(Uri endpoint, ApiKeyCredential keyCredential) : this(endpoint, keyCredential, new BasicTypeSpecClientOptions())
        {
        }

        /// <summary> Initializes a new instance of BasicTypeSpecClient. </summary>
        /// <param name="endpoint"> Service endpoint. </param>
        /// <param name="keyCredential"> A credential used to authenticate to the service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="keyCredential"/> is null. </exception>
        public BasicTypeSpecClient(Uri endpoint, ApiKeyCredential keyCredential, BasicTypeSpecClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(keyCredential, nameof(keyCredential));

            options ??= new BasicTypeSpecClientOptions();

            _endpoint = endpoint;
            _keyCredential = keyCredential;
            Pipeline = HttpPipelineBuilder.Build(options, new HttpPipelinePolicy[] {  });
        }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public HttpPipeline Pipeline { get; }

        /// <summary>
        /// [Protocol Method] Return hi
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="headParameter"></param>
        /// <param name="queryParameter"></param>
        /// <param name="optionalQuery"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="headParameter"/> or <paramref name="queryParameter"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response SayHi(string headParameter, string queryParameter, string optionalQuery, RequestContext context)
        {
            Argument.AssertNotNull(headParameter, nameof(headParameter));
            Argument.AssertNotNull(queryParameter, nameof(queryParameter));

            using HttpMessage message = CreateSayHiRequest(headParameter, queryParameter, optionalQuery, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Return hi
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="headParameter"></param>
        /// <param name="queryParameter"></param>
        /// <param name="optionalQuery"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="headParameter"/> or <paramref name="queryParameter"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> SayHiAsync(string headParameter, string queryParameter, string optionalQuery, RequestContext context)
        {
            Argument.AssertNotNull(headParameter, nameof(headParameter));
            Argument.AssertNotNull(queryParameter, nameof(queryParameter));

            using HttpMessage message = CreateSayHiRequest(headParameter, queryParameter, optionalQuery, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Return hi. </summary>
        /// <param name="headParameter"></param>
        /// <param name="queryParameter"></param>
        /// <param name="optionalQuery"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="headParameter"/> or <paramref name="queryParameter"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> SayHi(string headParameter, string queryParameter, string optionalQuery)
        {
            Argument.AssertNotNull(headParameter, nameof(headParameter));
            Argument.AssertNotNull(queryParameter, nameof(queryParameter));

            Response result = SayHi(headParameter, queryParameter, optionalQuery, null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> Return hi. </summary>
        /// <param name="headParameter"></param>
        /// <param name="queryParameter"></param>
        /// <param name="optionalQuery"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="headParameter"/> or <paramref name="queryParameter"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> SayHiAsync(string headParameter, string queryParameter, string optionalQuery)
        {
            Argument.AssertNotNull(headParameter, nameof(headParameter));
            Argument.AssertNotNull(queryParameter, nameof(queryParameter));

            Response result = await SayHiAsync(headParameter, queryParameter, optionalQuery, null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] Return hi again
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response HelloAgain(string p2, string p1, RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateHelloAgainRequest(p2, p1, content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Return hi again
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> HelloAgainAsync(string p2, string p1, RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateHelloAgainRequest(p2, p1, content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Return hi again. </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="action"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="action"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<RoundTripModel> HelloAgain(string p2, string p1, RoundTripModel action)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(action, nameof(action));

            Response result = HelloAgain(p2, p1, action, null);
            return Response.FromValue((RoundTripModel)result, result);
        }

        /// <summary> Return hi again. </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="action"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="action"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<RoundTripModel>> HelloAgainAsync(string p2, string p1, RoundTripModel action)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(action, nameof(action));

            Response result = await HelloAgainAsync(p2, p1, action, null).ConfigureAwait(false);
            return Response.FromValue((RoundTripModel)result, result);
        }

        /// <summary>
        /// [Protocol Method] Return hi again
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response NoContentType(string p2, string p1, RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateNoContentTypeRequest(p2, p1, content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Return hi again
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="p2"></param>
        /// <param name="p1"></param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="p2"/>, <paramref name="p1"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> NoContentTypeAsync(string p2, string p1, RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(p2, nameof(p2));
            Argument.AssertNotNull(p1, nameof(p1));
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateNoContentTypeRequest(p2, p1, content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary>
        /// [Protocol Method] Return hi in demo2
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response HelloDemo2(RequestContext context)
        {
            using HttpMessage message = CreateHelloDemo2Request(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Return hi in demo2
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> HelloDemo2Async(RequestContext context)
        {
            using HttpMessage message = CreateHelloDemo2Request(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Return hi in demo2. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> HelloDemo2()
        {
            Response result = HelloDemo2(null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> Return hi in demo2. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> HelloDemo2Async()
        {
            Response result = await HelloDemo2Async(null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] Create with literal value
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response CreateLiteral(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateCreateLiteralRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Create with literal value
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> CreateLiteralAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateCreateLiteralRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Create with literal value. </summary>
        /// <param name="body"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> CreateLiteral(Thing body)
        {
            Argument.AssertNotNull(body, nameof(body));

            Response result = CreateLiteral(body, null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> Create with literal value. </summary>
        /// <param name="body"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> CreateLiteralAsync(Thing body)
        {
            Argument.AssertNotNull(body, nameof(body));

            Response result = await CreateLiteralAsync(body, null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] Send literal parameters
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response HelloLiteral(RequestContext context)
        {
            using HttpMessage message = CreateHelloLiteralRequest(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Send literal parameters
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> HelloLiteralAsync(RequestContext context)
        {
            using HttpMessage message = CreateHelloLiteralRequest(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Send literal parameters. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> HelloLiteral()
        {
            Response result = HelloLiteral(null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> Send literal parameters. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> HelloLiteralAsync()
        {
            Response result = await HelloLiteralAsync(null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] top level method
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="action"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response TopAction(DateTimeOffset action, RequestContext context)
        {
            using HttpMessage message = CreateTopActionRequest(action, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] top level method
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="action"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> TopActionAsync(DateTimeOffset action, RequestContext context)
        {
            using HttpMessage message = CreateTopActionRequest(action, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> top level method. </summary>
        /// <param name="action"></param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> TopAction(DateTimeOffset action)
        {
            Response result = TopAction(action, null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> top level method. </summary>
        /// <param name="action"></param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> TopActionAsync(DateTimeOffset action)
        {
            Response result = await TopActionAsync(action, null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] top level method2
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response TopAction2(RequestContext context)
        {
            using HttpMessage message = CreateTopAction2Request(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] top level method2
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> TopAction2Async(RequestContext context)
        {
            using HttpMessage message = CreateTopAction2Request(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary>
        /// [Protocol Method] top level patch
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response PatchAction(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreatePatchActionRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] top level patch
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> PatchActionAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreatePatchActionRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary>
        /// [Protocol Method] body parameter without body decorator
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response AnonymousBody(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateAnonymousBodyRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] body parameter without body decorator
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> AnonymousBodyAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateAnonymousBodyRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> body parameter without body decorator. </summary>
        /// <param name="name"> name of the Thing. </param>
        /// <param name="requiredUnion"> required Union. </param>
        /// <param name="requiredLiteralString"> required literal string. </param>
        /// <param name="requiredLiteralInt"> required literal int. </param>
        /// <param name="requiredLiteralFloat"> required literal float. </param>
        /// <param name="requiredLiteralBool"> required literal bool. </param>
        /// <param name="requiredBadDescription"> description with xml &lt;|endoftext|&gt;. </param>
        /// <param name="requiredNullableList"> required nullable collection. </param>
        /// <param name="optionalLiteralString"> optional literal string. </param>
        /// <param name="optionalLiteralInt"> optional literal int. </param>
        /// <param name="optionalLiteralFloat"> optional literal float. </param>
        /// <param name="optionalLiteralBool"> optional literal bool. </param>
        /// <param name="optionalNullableList"> optional nullable collection. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="requiredUnion"/> or <paramref name="requiredBadDescription"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> AnonymousBody(string name, BinaryData requiredUnion, ThingRequiredLiteralString requiredLiteralString, ThingRequiredLiteralInt requiredLiteralInt, ThingRequiredLiteralFloat requiredLiteralFloat, bool requiredLiteralBool, string requiredBadDescription, IEnumerable<int> requiredNullableList, ThingOptionalLiteralString? optionalLiteralString = default, ThingOptionalLiteralInt? optionalLiteralInt = default, ThingOptionalLiteralFloat? optionalLiteralFloat = default, bool? optionalLiteralBool = default, IEnumerable<int> optionalNullableList = default)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(requiredUnion, nameof(requiredUnion));
            Argument.AssertNotNull(requiredBadDescription, nameof(requiredBadDescription));

            Thing spreadModel = new Thing(
                name,
                requiredUnion,
                requiredLiteralString,
                requiredLiteralInt,
                requiredLiteralFloat,
                requiredLiteralBool,
                optionalLiteralString,
                optionalLiteralInt,
                optionalLiteralFloat,
                optionalLiteralBool,
                requiredBadDescription,
                optionalNullableList?.ToList() as IList<int> ?? new ChangeTrackingList<int>(),
                requiredNullableList?.ToList() as IList<int> ?? new ChangeTrackingList<int>(),
                null);
            Response result = AnonymousBody(spreadModel, null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> body parameter without body decorator. </summary>
        /// <param name="name"> name of the Thing. </param>
        /// <param name="requiredUnion"> required Union. </param>
        /// <param name="requiredLiteralString"> required literal string. </param>
        /// <param name="requiredLiteralInt"> required literal int. </param>
        /// <param name="requiredLiteralFloat"> required literal float. </param>
        /// <param name="requiredLiteralBool"> required literal bool. </param>
        /// <param name="requiredBadDescription"> description with xml &lt;|endoftext|&gt;. </param>
        /// <param name="requiredNullableList"> required nullable collection. </param>
        /// <param name="optionalLiteralString"> optional literal string. </param>
        /// <param name="optionalLiteralInt"> optional literal int. </param>
        /// <param name="optionalLiteralFloat"> optional literal float. </param>
        /// <param name="optionalLiteralBool"> optional literal bool. </param>
        /// <param name="optionalNullableList"> optional nullable collection. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="requiredUnion"/> or <paramref name="requiredBadDescription"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> AnonymousBodyAsync(string name, BinaryData requiredUnion, ThingRequiredLiteralString requiredLiteralString, ThingRequiredLiteralInt requiredLiteralInt, ThingRequiredLiteralFloat requiredLiteralFloat, bool requiredLiteralBool, string requiredBadDescription, IEnumerable<int> requiredNullableList, ThingOptionalLiteralString? optionalLiteralString = default, ThingOptionalLiteralInt? optionalLiteralInt = default, ThingOptionalLiteralFloat? optionalLiteralFloat = default, bool? optionalLiteralBool = default, IEnumerable<int> optionalNullableList = default)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(requiredUnion, nameof(requiredUnion));
            Argument.AssertNotNull(requiredBadDescription, nameof(requiredBadDescription));

            Thing spreadModel = new Thing(
                name,
                requiredUnion,
                requiredLiteralString,
                requiredLiteralInt,
                requiredLiteralFloat,
                requiredLiteralBool,
                optionalLiteralString,
                optionalLiteralInt,
                optionalLiteralFloat,
                optionalLiteralBool,
                requiredBadDescription,
                optionalNullableList?.ToList() as IList<int> ?? new ChangeTrackingList<int>(),
                requiredNullableList?.ToList() as IList<int> ?? new ChangeTrackingList<int>(),
                null);
            Response result = await AnonymousBodyAsync(spreadModel, null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] Model can have its friendly name
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response FriendlyModel(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateFriendlyModelRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Model can have its friendly name
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> FriendlyModelAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateFriendlyModelRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Model can have its friendly name. </summary>
        /// <param name="name"> name of the NotFriend. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Friend> FriendlyModel(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Friend spreadModel = new Friend(name, null);
            Response result = FriendlyModel(spreadModel, null);
            return Response.FromValue((Friend)result, result);
        }

        /// <summary> Model can have its friendly name. </summary>
        /// <param name="name"> name of the NotFriend. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Friend>> FriendlyModelAsync(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Friend spreadModel = new Friend(name, null);
            Response result = await FriendlyModelAsync(spreadModel, null).ConfigureAwait(false);
            return Response.FromValue((Friend)result, result);
        }

        /// <summary>
        /// [Protocol Method] addTimeHeader
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response AddTimeHeader(RequestContext context)
        {
            using HttpMessage message = CreateAddTimeHeaderRequest(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] addTimeHeader
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> AddTimeHeaderAsync(RequestContext context)
        {
            using HttpMessage message = CreateAddTimeHeaderRequest(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> addTimeHeader. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response AddTimeHeader()
        {
            return AddTimeHeader(null);
        }

        /// <summary> addTimeHeader. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response> AddTimeHeaderAsync()
        {
            return await AddTimeHeaderAsync(null).ConfigureAwait(false);
        }

        /// <summary>
        /// [Protocol Method] Model can have its projected name
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response ProjectedNameModel(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateProjectedNameModelRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] Model can have its projected name
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> ProjectedNameModelAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateProjectedNameModelRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> Model can have its projected name. </summary>
        /// <param name="name"> name of the ModelWithProjectedName. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<ProjectedModel> ProjectedNameModel(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ProjectedModel spreadModel = new ProjectedModel(name, null);
            Response result = ProjectedNameModel(spreadModel, null);
            return Response.FromValue((ProjectedModel)result, result);
        }

        /// <summary> Model can have its projected name. </summary>
        /// <param name="name"> name of the ModelWithProjectedName. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<ProjectedModel>> ProjectedNameModelAsync(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ProjectedModel spreadModel = new ProjectedModel(name, null);
            Response result = await ProjectedNameModelAsync(spreadModel, null).ConfigureAwait(false);
            return Response.FromValue((ProjectedModel)result, result);
        }

        /// <summary>
        /// [Protocol Method] return anonymous model
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response ReturnsAnonymousModel(RequestContext context)
        {
            using HttpMessage message = CreateReturnsAnonymousModelRequest(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] return anonymous model
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> ReturnsAnonymousModelAsync(RequestContext context)
        {
            using HttpMessage message = CreateReturnsAnonymousModelRequest(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> return anonymous model. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<ReturnsAnonymousModelResponse> ReturnsAnonymousModel()
        {
            Response result = ReturnsAnonymousModel(null);
            return Response.FromValue((ReturnsAnonymousModelResponse)result, result);
        }

        /// <summary> return anonymous model. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<ReturnsAnonymousModelResponse>> ReturnsAnonymousModelAsync()
        {
            Response result = await ReturnsAnonymousModelAsync(null).ConfigureAwait(false);
            return Response.FromValue((ReturnsAnonymousModelResponse)result, result);
        }

        /// <summary>
        /// [Protocol Method] get extensible enum
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="accept"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="accept"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response GetUnknownValue(string accept, RequestContext context)
        {
            Argument.AssertNotNull(accept, nameof(accept));

            using HttpMessage message = CreateGetUnknownValueRequest(accept, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] get extensible enum
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="accept"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="accept"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> GetUnknownValueAsync(string accept, RequestContext context)
        {
            Argument.AssertNotNull(accept, nameof(accept));

            using HttpMessage message = CreateGetUnknownValueRequest(accept, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> get extensible enum. </summary>
        /// <param name="accept"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="accept"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<string> GetUnknownValue(string accept)
        {
            Argument.AssertNotNull(accept, nameof(accept));

            Response result = GetUnknownValue(accept, null);
            return Response.FromValue(result.Content.ToObjectFromJson<string>(), result);
        }

        /// <summary> get extensible enum. </summary>
        /// <param name="accept"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="accept"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<string>> GetUnknownValueAsync(string accept)
        {
            Argument.AssertNotNull(accept, nameof(accept));

            Response result = await GetUnknownValueAsync(accept, null).ConfigureAwait(false);
            return Response.FromValue(result.Content.ToObjectFromJson<string>(), result);
        }

        /// <summary>
        /// [Protocol Method] When set protocol false and convenient true, then the protocol method should be internal
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response InternalProtocol(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateInternalProtocolRequest(content, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] When set protocol false and convenient true, then the protocol method should be internal
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> InternalProtocolAsync(RequestContent content, RequestContext context)
        {
            Argument.AssertNotNull(content, nameof(content));

            using HttpMessage message = CreateInternalProtocolRequest(content, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> When set protocol false and convenient true, then the protocol method should be internal. </summary>
        /// <param name="body"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response<Thing> InternalProtocol(Thing body)
        {
            Argument.AssertNotNull(body, nameof(body));

            Response result = InternalProtocol(body, null);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary> When set protocol false and convenient true, then the protocol method should be internal. </summary>
        /// <param name="body"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response<Thing>> InternalProtocolAsync(Thing body)
        {
            Argument.AssertNotNull(body, nameof(body));

            Response result = await InternalProtocolAsync(body, null).ConfigureAwait(false);
            return Response.FromValue((Thing)result, result);
        }

        /// <summary>
        /// [Protocol Method] When set protocol false and convenient true, the convenient method should be generated even it has the same signature as protocol one
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response StillConvenient(RequestContext context)
        {
            using HttpMessage message = CreateStillConvenientRequest(context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] When set protocol false and convenient true, the convenient method should be generated even it has the same signature as protocol one
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> StillConvenientAsync(RequestContext context)
        {
            using HttpMessage message = CreateStillConvenientRequest(context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> When set protocol false and convenient true, the convenient method should be generated even it has the same signature as protocol one. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response StillConvenient()
        {
            return StillConvenient(null);
        }

        /// <summary> When set protocol false and convenient true, the convenient method should be generated even it has the same signature as protocol one. </summary>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response> StillConvenientAsync()
        {
            return await StillConvenientAsync(null).ConfigureAwait(false);
        }

        /// <summary>
        /// [Protocol Method] head as boolean.
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="id"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual Response HeadAsBoolean(string id, RequestContext context)
        {
            Argument.AssertNotNull(id, nameof(id));

            using HttpMessage message = CreateHeadAsBooleanRequest(id, context);
            return Pipeline.ProcessMessage(message, context);
        }

        /// <summary>
        /// [Protocol Method] head as boolean.
        /// <list type="bullet">
        /// <item>
        /// <description> This <see href="https://aka.ms/azsdk/net/protocol-methods">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios. </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="id"></param>
        /// <param name="context"> The request options, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        public virtual async Task<Response> HeadAsBooleanAsync(string id, RequestContext context)
        {
            Argument.AssertNotNull(id, nameof(id));

            using HttpMessage message = CreateHeadAsBooleanRequest(id, context);
            return await Pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
        }

        /// <summary> head as boolean. </summary>
        /// <param name="id"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual Response HeadAsBoolean(string id)
        {
            Argument.AssertNotNull(id, nameof(id));

            return HeadAsBoolean(id, null);
        }

        /// <summary> head as boolean. </summary>
        /// <param name="id"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        public virtual async Task<Response> HeadAsBooleanAsync(string id)
        {
            Argument.AssertNotNull(id, nameof(id));

            return await HeadAsBooleanAsync(id, null).ConfigureAwait(false);
        }
    }
}
