// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure;
using Azure.Core;

namespace BasicTypeSpec
{
    /// <summary></summary>
    public partial class BasicTypeSpecClient
    {
        private static ResponseClassifier _pipelineMessageClassifier200;
        private static ResponseClassifier _pipelineMessageClassifier204;
        private static Classifier2xxAnd4xx _pipelineMessageClassifier2xxAnd4xx;

        private static ResponseClassifier PipelineMessageClassifier200 => _pipelineMessageClassifier200 = new StatusCodeClassifier(stackalloc ushort[] { 200 });

        private static ResponseClassifier PipelineMessageClassifier204 => _pipelineMessageClassifier204 = new StatusCodeClassifier(stackalloc ushort[] { 204 });

        private static Classifier2xxAnd4xx PipelineMessageClassifier2xxAnd4xx => _pipelineMessageClassifier2xxAnd4xx ??= new Classifier2xxAnd4xx();

        internal HttpMessage CreateSayHiRequest(string headParameter, string queryParameter, string optionalQuery, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/hello", false);
            uri.AppendQuery("queryParameter", queryParameter, true);
            if (optionalQuery != null)
            {
                uri.AppendQuery("optionalQuery", optionalQuery, true);
            }
            request.Uri = uri;
            request.Headers.Add("head-parameter", headParameter);
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateHelloAgainRequest(string p2, string p1, RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/againHi/", false);
            uri.AppendPath(p2, true);
            request.Uri = uri;
            request.Headers.Add("p1", p1);
            request.Headers.Add("Content-Type", "text/plain");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateNoContentTypeRequest(string p2, string p1, RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/noContentType/", false);
            uri.AppendPath(p2, true);
            request.Uri = uri;
            request.Headers.Add("p1", p1);
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateHelloDemo2Request(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/demoHi", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateCreateLiteralRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/literal", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateHelloLiteralRequest(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/helloLiteral/", false);
            uri.AppendPath(123.ToString(), true);
            uri.AppendQuery("p3", TypeFormatters.ConvertToString(true, null), true);
            request.Uri = uri;
            request.Headers.Add("p1", "test");
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateTopActionRequest(DateTimeOffset action, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/top/", false);
            uri.AppendPath(action.ToString("O"), true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateTopAction2Request(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/top2", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreatePatchActionRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("PATCH");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/patch", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateAnonymousBodyRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/anonymousBody", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateFriendlyModelRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/friendlyName", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateAddTimeHeaderRequest(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier204;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            request.Uri = uri;
            request.Headers.Add("Repeatability-First-Sent", TypeFormatters.ConvertToString(DateTimeOffset.Now, "R"));
            return message;
        }

        internal HttpMessage CreateProjectedNameModelRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/projectedName", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateReturnsAnonymousModelRequest(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/returnsAnonymousModel", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetUnknownValueRequest(string accept, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/unknown-value", false);
            request.Uri = uri;
            request.Headers.Add("Accept", accept);
            return message;
        }

        internal HttpMessage CreateInternalProtocolRequest(RequestContent content, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier200;
            Request request = message.Request;
            request.Method = new RequestMethod("POST");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/internalProtocol", false);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accept", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateStillConvenientRequest(RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier204;
            Request request = message.Request;
            request.Method = new RequestMethod("GET");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/stillConvenient", false);
            request.Uri = uri;
            return message;
        }

        internal HttpMessage CreateHeadAsBooleanRequest(string id, RequestContext context)
        {
            HttpMessage message = Pipeline.CreateMessage();
            message.ResponseClassifier = PipelineMessageClassifier2xxAnd4xx;
            Request request = message.Request;
            request.Method = new RequestMethod("HEAD");
            ClientUriBuilder uri = new ClientUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/headAsBoolean/", false);
            uri.AppendPath(id, true);
            request.Uri = uri;
            return message;
        }

        private class Classifier2xxAnd4xx : ResponseClassifier
        {
        }
    }
}
