# Contoso Real Estate Terms of Service

> This document contains information generated using a language model (Azure OpenAI). The information
> contained in this document is only for demonstration purposes and does not reflect the opinions or
> beliefs of Microsoft. Microsoft makes no representations or warranties of any kind, express or implied,
> about the completeness, accuracy, reliability, suitability or availability with respect to the information
> contained in this document.

> All rights reserved to Microsoft

## Terms of Service

Last Updated: September 15, 2023

Welcome to Contoso Real Estate! These Terms of Service ("Terms") outline the rules and regulations for using our platform to search for, book, or list rental properties. Please read these Terms carefully before using our services. By accessing or using Contoso Real Estate, you agree to abide by these Terms. If you do not agree with any part of these Terms, you should not use our services.

## Table of Contents

1. [Our Mission](#our-mission)
2. [How to Search and Book Rentals](#how-to-search-and-book-rentals)
3. [How to List Rentals](#how-to-list-rentals)
4. [Responsibilities and Assumptions of Risk](#responsibilities-and-assumptions-of-risk)
5. [Cancellations and Refund Policies](#cancellations-and-refund-policies)
6. [Travel Issues](#travel-issues)
   - [Listing Description Discrepancy](#listing-description-discrepancy)
7. [Booking Modifications](#booking-modifications)
8. [Host Responsibilities](#host-responsibilities)
9. [Guest Responsibilities](#guest-responsibilities)
   - [Prohibited Activities](#prohibited-activities)
10. [General Terms](#general-terms)
11. [Local Laws](#local-laws)

---

## 1. Our Mission

At Contoso Real Estate, our mission is to connect travelers with unique and comfortable rental accommodations. We aim to create a trusted community where hosts can share their spaces and guests can enjoy memorable experiences.

## 2. How to Search and Book Rentals

### 2.1 Creating an Account

To search for and book rentals, users must create a Contoso Real Estate account. You must provide accurate and complete information during the registration process. Users are responsible for maintaining the confidentiality of their account credentials.

### 2.2 Browsing and Searching

- Users can browse available rentals without an account.
- Use our search filters to narrow down rental options based on your preferences.
- Click on a rental listing to view details, including pricing, availability, and host information.

### 2.3 Booking a Rental

- To book a rental, click the "Book Now" button on the listing page.
- Review the booking details, including dates and pricing, before confirming the reservation.
- Payment is processed securely through our platform. Guests will receive a booking confirmation email.

### 2.4 Guest Verification

- Guests may be required to complete identity verification steps.
- Failure to complete verification may result in booking cancellation.

## 3. How to List Rentals

### 3.1 Listing Creation

- Hosts can create rental listings by providing accurate property details, pricing, and availability.
- Listings must include high-quality photos and an accurate description of the property.

### 3.2 Listing Guidelines

- Hosts must adhere to our content guidelines, including avoiding misleading information.
- Accurate and up-to-date calendar availability is essential to prevent double bookings.

### 3.3 Host Verification

- Hosts may be required to undergo identity verification to build trust within the community.
- Failure to complete verification may lead to listing removal.

## 4. Responsibilities and Assumptions of Risk

### 4.1 Assumption of Risk

- Users acknowledge that renting or hosting properties carries inherent risks.
- Contoso Real Estate does not guarantee the condition, safety, or legality of listed properties.
- Users assume all responsibility for their actions and interactions on our platform.

### 4.2 User Conduct

- Users must conduct themselves respectfully and in accordance with our community standards.
- Any misuse or violation of these Terms may result in account suspension or removal.

## 5. Cancellations and Refund Policies

### 5.1 Guest Cancellations

- Guests can cancel a booking, but cancellation policies vary by listing.
- Review the cancellation policy on the listing page before booking.
- Refunds, if applicable, are processed based on the chosen cancellation policy.

### 5.2 Host Cancellations

- Hosts should avoid canceling confirmed bookings.
- Host-initiated cancellations may lead to penalties and restrictions on their account.

## 6. Travel Issues

### 6.1 Listing Description Discrepancy

- If a rental does not match the listing description, guests should contact the host immediately.
- Contoso Real Estate may assist in resolving disputes between hosts and guests.
- Document any issues with photos or messages to facilitate resolution.

## 7. Booking Modifications

- Guests and hosts can request booking modifications, such as changes to dates or the number of guests.
- Modifications should be agreed upon by both parties and processed through the platform.
- Additional fees or adjustments may apply to modified bookings.

## 8. Host Responsibilities

### 8.1 Property Maintenance

- Hosts must maintain their properties in good condition and ensure they meet safety standards.
- Promptly address issues reported by guests during their stay.

### 8.2 Communication

- Hosts should respond to guest inquiries and booking requests promptly and professionally.
- Clear and honest communication is essential for building trust.

### 8.3 Compliance with Laws

- Hosts are responsible for complying with local laws and regulations, including taxes and permits.
- Understand and adhere to zoning and rental laws in your area.

## 9. Guest Responsibilities

### 9.1 Prohibited Activities

- Guests must not engage in any prohibited activities, including but not limited to:
  - Unauthorized parties or events
  - Smoking in non-smoking properties
  - Violating community rules
  - Damaging property or belongings

## 10. General Terms

### 10.1 Privacy

- Contoso Real Estate respects user privacy. Review our Privacy Policy for information on data collection and usage.

### 10.2 Intellectual Property

- Users may not use Contoso Real Estate's trademarks, logos, or copyrighted materials without prior written consent.

### 10.3 Termination

- Contoso Real Estate reserves the right to terminate or suspend accounts for violations of these Terms or for any other reason at our discretion.

### 10.4 Dispute Resolution

- Any disputes between users should be resolved amicably.
- If necessary, Contoso Real Estate may provide dispute resolution assistance.

### 10.5 Disclaimer of Liability

- Contoso Real Estate is not liable for any direct, indirect, incidental, special, or consequential damages arising from the use of our platform.

## 11. Local Laws

### 11.1 Compliance

- Users are responsible for understanding and complying with all local laws, including those related to renting and hosting properties.

### 11.2 Taxes

- Hosts may have tax obligations related to their rental income. It is the host's responsibility to report and pay any applicable taxes.

### 11.3 Regulations

- Understand and adhere to zoning, building codes, and other regulations that may apply to your property.

## Conclusion

These Terms of Service constitute a legally binding agreement between you and Contoso Real Estate. By using our platform, you agree to abide by these Terms. Please review our Privacy Policy for information on data handling and user privacy.

Contoso Real Estate reserves the right to update these Terms at any time. Users will be notified of changes, and continued use of our platform after such changes constitutes acceptance of the modified Terms.

If you have any questions or concerns about these Terms, please contact our customer support team for assistance.

Thank you for choosing Contoso Real Estate for your rental accommodation needs. We wish you enjoyable and safe travels!
