// This file is generated by genicons.mjs. Do not modify directly.

export interface Icon {
  viewBox: string,
  contents: string
}

const materialIconsViewBox: string = '0 -960 960 960';
const bootstrapIconsViewBox: string = '0 0 16 16';

export const IconAccountCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M216-259q64-41 127.545-61.5 63.546-20.5 136.5-20.5Q553-341 616.5-320.5 680-300 746-259q43-56 60-109t17-112q0-146-98.5-244.5T480-823q-146 0-244.5 98.5T137-480q0 59 17.5 112T216-259Zm263.854-179Q417-438 374-481.146q-43-43.145-43-106Q331-650 374.146-693q43.145-43 106-43Q543-736 586-692.854q43 43.145 43 106Q629-524 585.854-481q-43.145 43-106 43Zm-.42 374q-84.985 0-161.276-32.974-76.29-32.973-132.724-90Q129-244 96.5-319.341 64-394.681 64-480.5q0-85.819 33.21-161.285 33.211-75.467 89.965-132.078 56.754-56.611 132.13-89.374T480.5-896q85.819 0 161.166 33.24t131.632 89.58q56.286 56.34 89.494 131.839T896-480.266q0 85.734-32.763 161.035-32.763 75.302-89.443 132.056-56.68 56.754-132.447 89.965Q565.58-64 479.434-64Z"/>'
};
export const IconAdd: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M444-444H184v-73h260v-260h73v260h259v73H517v259h-73v-259Z"/>'
};
export const IconAddCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M447-272h73v-167h168v-73H520v-176h-73v176H272v73h175v167Zm32.808 208q-85.916 0-161.522-33.02T186.36-186.36q-56.32-56.32-89.34-132.132Q64-394.303 64-480.5q0-86.09 33.079-161.809 33.079-75.718 89.686-132.31 56.606-56.592 132.056-88.986Q394.271-896 480.057-896q86.148 0 162.172 32.395 76.023 32.394 132.397 89Q831-718 863.5-641.958 896-565.917 896-479.724q0 86.192-32.395 161.297-32.394 75.104-88.986 131.502-56.592 56.399-132.616 89.662Q565.979-64 479.808-64Z"/>'
};
export const IconArrowDropDown: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M480-360 280-559h400L480-360Z"/>'
};
export const IconArrowDropUp: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m280-400 200-201 200 201H280Z"/>'
};
export const IconArrowLeft: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M568-263 352-480l216-217v434Z"/>'
};
export const IconArrowRight: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M393-263v-434l216 217-216 217Z"/>'
};
export const IconBadge: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M140-64q-28.725 0-50.862-22.138Q67-108.275 67-137v-485q0-28.725 22.138-50.862Q111.275-695 140-695h237v-129q0-28.725 22.138-50.862Q421.275-897 450-897h60q28.725 0 50.862 22.138Q583-852.725 583-824v129h237q28.725 0 50.862 22.138Q893-650.725 893-622v485q0 28.725-22.138 50.862Q848.725-64 820-64H140Zm86-174h249v-17q0-19.957-10-34.978Q455-305 440-310q-34-11-52.5-15t-34.5-4q-18 0-40 5t-51 14q-16 6-26 20.522-10 14.521-10 34.478v17Zm343-67h176v-58H569v58Zm-216-58q25 0 41.5-16.5T411-421q0-25-16.5-41.5T353-479q-25 0-41.5 16.5T295-421q0 25 16.5 41.5T353-363Zm216-58h176v-59H569v59ZM450-612h60v-212h-60v212Z"/>'
};
export const IconBranding: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M756-582 582-756l70-70q21-22 51-22t52 22l71 72q21 21 21 51t-21 51l-70 70ZM109-109v-175l182-182L69-687l193-195 223 223 44-44 174 174-44 44 224 222L688-70 467-291 284-109H109Zm233-408 91-91-65-64-48 48-51-51 49-48-55-55-91 91 170 170Zm344 345 90-91-54-55-49 49-50-51 48-48-64-65-91 91 170 170Z"/>'
};
export const IconBroadcast: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path d="M3.05 3.05a7 7 0 0 0 0 9.9.5.5 0 0 1-.707.707 8 8 0 0 1 0-11.314.5.5 0 0 1 .707.707zm2.122 2.122a4 4 0 0 0 0 5.656.5.5 0 1 1-.708.708 5 5 0 0 1 0-7.072.5.5 0 0 1 .708.708zm5.656-.708a.5.5 0 0 1 .708 0 5 5 0 0 1 0 7.072.5.5 0 1 1-.708-.708 4 4 0 0 0 0-5.656.5.5 0 0 1 0-.708zm2.122-2.12a.5.5 0 0 1 .707 0 8 8 0 0 1 0 11.313.5.5 0 0 1-.707-.707 7 7 0 0 0 0-9.9.5.5 0 0 1 0-.707zM10 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0z"/>'
};
export const IconCheck: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M378-235 142-471l52-52 184 184 388-388 52 52-440 440Z"/>'
};
export const IconChevronBarDown: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M3.646 4.146a.5.5 0 0 1 .708 0L8 7.793l3.646-3.647a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 0-.708M1 11.5a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5"/>'
};
export const IconChevronBarUp: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M3.646 11.854a.5.5 0 0 0 .708 0L8 8.207l3.646 3.647a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 0 0 0 .708M2.4 5.2c0 .22.18.4.4.4h10.4a.4.4 0 0 0 0-.8H2.8a.4.4 0 0 0-.4.4"/>'
};
export const IconChevronDoubleDown: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M1.646 6.646a.5.5 0 0 1 .708 0L8 12.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708"/>  <path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" d="M1.646 2.646a.5.5 0 0 1 .708 0L8 8.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708"/>'
};
export const IconChevronDoubleUp: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M7.646 2.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1-.708.708L8 3.707 2.354 9.354a.5.5 0 1 1-.708-.708z"/>  <path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" d="M7.646 6.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1-.708.708L8 7.707l-5.646 5.647a.5.5 0 0 1-.708-.708z"/>'
};
export const IconChevronDown: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708"/>'
};
export const IconChevronLeft: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"/>'
};
export const IconChevronRight: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708"/>'
};
export const IconChevronUp: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M7.646 4.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1-.708.708L8 5.707l-5.646 5.647a.5.5 0 0 1-.708-.708z"/>'
};
export const IconClearAll: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M104-277v-72h567v72H104Zm93-182v-73h567v73H197Zm92-183v-73h567v73H289Z"/>'
};
export const IconClose: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m247-195-51-52 233-233-233-234 51-52 234 234 232-234 51 52-232 234 232 233-51 52-232-234-234 234Z"/>'
};
export const IconCode: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M318-232 68-483l253-253 52 53-200 200 198 198-53 53Zm322 2-52-53 201-201-198-198 51-51 251 250-253 253Z"/>'
};
export const IconContract: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M3.646 14.854a.5.5 0 0 0 .708 0L8 11.207l3.646 3.647a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 0 0 0 .708m0-13.708a.5.5 0 0 1 .708 0L8 4.793l3.646-3.647a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 0-.708M1 8a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 0 1h-13A.5.5 0 0 1 1 8"/>'
};
export const IconCopy: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M305-185q-29.725 0-51.363-22.137Q232-229.275 232-258v-564q0-28.725 21.637-50.862Q275.275-895 305-895h444q28.725 0 50.862 22.138Q822-850.725 822-822v564q0 28.725-22.138 50.863Q777.725-185 749-185H305ZM172-52q-29.725 0-51.363-22.138Q99-96.275 99-125v-637h73v637h517v73H172Z"/>'
};
export const IconDateRange: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M303.807-393Q286-393 273.5-405.693t-12.5-30.5Q261-454 273.693-466.5t30.5-12.5Q322-479 334.5-466.307t12.5 30.5Q347-418 334.307-405.5t-30.5 12.5Zm179 0Q465-393 452.5-405.693t-12.5-30.5Q440-454 452.693-466.5t30.5-12.5Q501-479 513.5-466.307t12.5 30.5Q526-418 513.307-405.5t-30.5 12.5Zm172 0Q637-393 624.5-405.693t-12.5-30.5Q612-454 624.693-466.5t30.5-12.5Q673-479 685.5-466.307t12.5 30.5Q698-418 685.307-405.5t-30.5 12.5ZM177-65q-28.725 0-50.863-22.138Q104-109.275 104-138v-626q0-28.725 22.137-50.862Q148.275-837 177-837h49v-58h78v58h352v-58h78v58h49q28.725 0 50.862 22.138Q856-792.725 856-764v626q0 28.725-22.138 50.862Q811.725-65 783-65H177Zm0-73h606v-442H177v442Z"/>'
};
export const IconDelete: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M259-104q-28.725 0-50.863-22.137Q186-148.275 186-177v-575h-41v-73h202v-34h267v34h202v73h-41v575q0 28.725-22.138 50.863Q730.725-104 702-104H259Zm98-160h73v-403h-73v403Zm175 0h73v-403h-73v403Z"/>'
};
export const IconDesktopWindows: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M321-107v-73h87v-101H138q-28.725 0-50.862-22.138Q65-325.275 65-354v-426q0-28.725 22.138-50.862Q109.275-853 138-853h686q28.725 0 50.862 22.138Q897-808.725 897-780v426q0 28.725-22.138 50.862Q852.725-281 824-281H554v101h87v73H321Z"/>'
};
export const IconDownload: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M249-145q-94 0-160-65.5T23-370q0-81 51-143.5T204-591q22-90 88-150.5T445-812v349l-78-78-52 52 166 167 167-167-52-52-78 78v-349q101 14 170.5 92T763-534v24q74 3 124 54t50 128q0 75-54 129t-129 54H249Z"/>'
};
export const IconEdit: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M180-180h44l443-443-44-44-443 443v44Zm614-486L666-794l42-42q17-17 42-17t42 17l44 44q17 17 17 42t-17 42l-42 42Zm-42 42L248-120H120v-128l504-504 128 128Zm-107-21-22-22 44 44-22-22Z"/>'
};
export const IconError: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M479.807-272Q497-272 507.5-282.307t10.5-27.5Q518-327 507.693-337.5t-27.5-10.5Q463-348 452.5-337.693t-10.5 27.5Q442-293 452.307-282.5t27.5 10.5ZM447-434h73v-256h-73v256Zm32.808 370q-85.916 0-161.522-33.02T186.36-186.36q-56.32-56.32-89.34-132.132Q64-394.303 64-480.5q0-86.09 33.079-161.809 33.079-75.718 89.686-132.31 56.606-56.592 132.056-88.986Q394.271-896 480.057-896q86.148 0 162.172 32.395 76.023 32.394 132.397 89Q831-718 863.5-641.958 896-565.917 896-479.724q0 86.192-32.395 161.297-32.394 75.104-88.986 131.502-56.592 56.399-132.616 89.662Q565.979-64 479.808-64Z"/>'
};
export const IconExitToApp: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M177-104q-28.725 0-50.863-22.137Q104-148.275 104-177v-194h73v194h606v-606H177v193h-73v-193q0-28.725 22.137-50.862Q148.275-856 177-856h606q28.725 0 50.862 22.138Q856-811.725 856-783v606q0 28.725-22.138 50.863Q811.725-104 783-104H177Zm235-166-54-56 118-118H104v-73h372L358-635l54-55 209 209-209 211Z"/>'
};
export const IconExpand: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path fill-rule="evenodd" d="M3.646 9.146a.5.5 0 0 1 .708 0L8 12.793l3.646-3.647a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 0-.708m0-2.292a.5.5 0 0 0 .708 0L8 3.207l3.646 3.647a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 0 0 0 .708"/>'
};
export const IconFastForward: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M78-221v-518l375 259L78-221Zm431 0v-518l375 259-375 259Z"/>'
};
export const IconFastRewind: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M881-221 506-480l375-259v518Zm-426 0L80-480l375-259v518Z"/>'
};
export const IconFile: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M312-242h337v-70H312v70Zm0-175h337v-70H312v70ZM218-64q-28.725 0-50.863-22.138Q145-108.275 145-137v-686q0-28.725 22.137-50.862Q189.275-896 218-896h357l240 239v520q0 28.725-22.138 50.862Q770.725-64 742-64H218Zm321-559h203L539-823v200Z"/>'
};
export const IconFilterList: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M393-221v-73h175v73H393ZM228-444v-73h504v73H228ZM104-667v-73h752v73H104Z"/>'
};
export const IconFolder: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M137-144q-28.725 0-50.862-22.319Q64-188.637 64-217v-526q0-28.362 22.138-50.681Q108.275-816 137-816h271l73 73h342q28.362 0 50.681 22.319T896-670v453q0 28.363-22.319 50.681Q851.362-144 823-144H137Z"/>'
};
export const IconGroups: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M-8-232v-61q0-43.021 43.5-69.01Q79-388 150.376-388q8.165 0 15.395.5 7.229.5 15.229.152-10 20.348-14.5 40.024Q162-327.648 162-305v73H-8Zm240 0v-73q0-34 17.478-62.185Q266.955-395.37 301-416q33.867-21 79.292-31.5 45.425-10.5 99.546-10.5 55.162 0 100.559 10.5Q625.793-437 660-416q33 21 50.5 49t17.5 62v73H232Zm566 0v-73.143q0-22.088-4.5-42.407-4.5-20.32-13.5-39.723 8 .273 15.229-.227 7.228-.5 14.771-.5 71.7 0 114.85 25.639Q968-336.722 968-293v61H798ZM149.611-416Q119-416 97-438.005q-22-22.006-22-52.907Q75-522 97.005-544q22.006-22 52.907-22Q181-566 203-544.075t22 53.464Q225-460 203.075-438q-21.925 22-53.464 22Zm660 0Q779-416 757-438.005q-22-22.006-22-52.907Q735-522 757.005-544q22.006-22 52.907-22Q841-566 863-544.075t22 53.464Q885-460 863.075-438q-21.925 22-53.464 22Zm-329.14-72q-53.138 0-90.804-37.211Q352-562.421 352-615.579 352-669 389.667-706.5q37.666-37.5 90.804-37.5 53.4 0 90.464 37.268Q608-669.465 608-615.765q0 53.432-37.065 90.598Q533.871-488 480.471-488Z"/>'
};
export const IconHeadphones: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M338-105H177q-28.725 0-50.863-22.137Q104-149.275 104-178v-303q0-77.971 29.705-146.067 29.704-68.095 80.5-119.014Q265-797 333.703-826.5t146.5-29.5q77.797 0 146.424 29.39 68.627 29.389 119.5 80.5Q797-695 826.5-626.956 856-558.913 856-481v303q0 28.725-22.138 50.863Q811.725-105 783-105H622v-321h161v-55q0-126-88.679-214t-214.5-88Q354-783 265.5-695T177-481v55h161v321Z"/>'
};
export const IconHelp: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M483.93-236q18.07 0 30.57-12.43 12.5-12.429 12.5-30.5 0-18.07-12.43-30.57-12.429-12.5-30.5-12.5-18.07 0-30.57 12.43-12.5 12.429-12.5 30.5 0 18.07 12.43 30.57 12.429 12.5 30.5 12.5ZM443-389h71q0-28.324 6-51.162Q526-463 563-494q31-25 44.5-50.919 13.5-25.919 13.5-57.987 0-56.51-36.848-89.302Q547.304-725 486.469-725 432-725 392.5-698.5 353-672 336-625l63 24q9-27 30.5-44t53.5-17q32 0 53 17.5t21 45.5q0 22-13.714 41.5Q529.571-538 505-517q-33 28-47.5 54T443-389Zm36.542 325Q394.36-64 318.52-97.02q-75.84-33.02-132.16-89.34-56.32-56.32-89.34-132.291T64-480q0-86.272 33.079-162.149 33.079-75.878 89.686-132.47 56.606-56.592 132.216-88.986Q394.59-896 479.557-896q86.329 0 162.512 32.395 76.183 32.394 132.557 89Q831-718 863.5-641.958q32.5 76.041 32.5 162.5 0 85.458-32.395 160.797-32.394 75.338-88.986 131.921-56.592 56.582-132.616 89.661Q565.979-64 479.542-64Z"/>'
};
export const IconHistory: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M485-104q-157.758 0-267.379-110Q108-324 110-481h74q-2 127 85.498 215.5T484-177q127.164 0 216.082-90.127Q789-357.254 789-484.5q0-125.5-89.582-212T485-783q-71.651 0-134.325 33Q288-717 245-662h110v73H121v-233h73v107q52-67 128.635-104Q399.271-856 485-856q77.921 0 146.471 29.6 68.551 29.6 119.323 80.025 50.773 50.424 80.989 118.602Q862-559.594 862-481.797t-30.217 146.772q-30.216 68.976-80.989 120.4Q700.022-163.2 631.471-133.6 562.921-104 485-104Zm116-203L439-465.565V-691h73v194l141 138-52 52Z"/>'
};
export const IconHome: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M148-107v-499l332-248 332 248v499H565v-293H395v293H148Z"/>'
};
export const IconImage: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M180-107q-28.725 0-50.863-22.137Q107-151.275 107-180v-600q0-28.725 22.137-50.862Q151.275-853 180-853h600q28.725 0 50.862 22.138Q853-808.725 853-780v600q0 28.725-22.138 50.863Q808.725-107 780-107H180Zm47-162h507L579-476 446-303l-94-128-125 162Z"/>'
};
export const IconInfo: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M447-272h73v-248h-73v248Zm32.895-330Q496-602 507-612.587t11-26.238q0-17.625-10.87-28.4Q496.261-678 480.193-678 463-678 452.5-667.4 442-656.801 442-639.675q0 16.275 10.895 26.975 10.894 10.7 27 10.7Zm-.087 538q-85.916 0-161.522-33.02T186.36-186.36q-56.32-56.32-89.34-132.132Q64-394.303 64-480.5q0-86.09 33.079-161.809 33.079-75.718 89.686-132.31 56.606-56.592 132.056-88.986Q394.271-896 480.057-896q86.148 0 162.172 32.395 76.023 32.394 132.397 89Q831-718 863.5-641.958 896-565.917 896-479.724q0 86.192-32.395 161.297-32.394 75.104-88.986 131.502-56.592 56.399-132.616 89.662Q565.979-64 479.808-64Z"/>'
};
export const IconInvertColors: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M478.834-107Q341-107 243.5-202.5T146-434.761q0-66.864 25.5-125.551Q197-619 242.881-664.85L480-899l237.119 234.15Q763-619 788.5-560.312 814-501.625 814-434.761 814-299 715.834-203q-98.165 96-237 96ZM480-180v-616L294-613q-36 37-55.5 81T219-435q0 108 77 181.5T480-180Z"/>'
};
export const IconLibraryMusic: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M490.085-325Q533-325 564.5-355.53 596-386.06 596-430v-251h121v-67H553v236q-12.352-9-29.411-14-17.06-5-34.06-5-42.409 0-70.969 29.542-28.56 29.543-28.56 71.5Q390-387 418.585-356q28.584 31 71.5 31ZM265-185q-29.363 0-51.181-22.137Q192-229.275 192-258v-564q0-28.725 21.819-50.862Q235.637-895 265-895h564q28.725 0 50.862 22.138Q902-850.725 902-822v564q0 28.725-22.138 50.863Q857.725-185 829-185H265ZM132-52q-29.363 0-51.181-22.138Q59-96.275 59-125v-637h73v637h637v73H132Z"/>'
};
export const IconLock: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M220-80q-24.75 0-42.375-17.625T160-140v-434q0-24.75 17.625-42.375T220-634h70v-96q0-78.85 55.606-134.425Q401.212-920 480.106-920T614.5-864.425Q670-808.85 670-730v96h70q24.75 0 42.375 17.625T800-574v434q0 24.75-17.625 42.375T740-80H220Zm0-60h520v-434H220v434Zm260.168-140Q512-280 534.5-302.031T557-355q0-30-22.668-54.5t-54.5-24.5Q448-434 425.5-409.5t-22.5 55q0 30.5 22.668 52.5t54.5 22ZM350-634h260v-96q0-54.167-37.882-92.083-37.883-37.917-92-37.917Q426-860 388-822.083 350-784.167 350-730v96ZM220-140v-434 434Z"/>'
};
export const IconLockOpen: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M220-634h390v-96q0-54.167-37.882-92.083-37.883-37.917-92-37.917Q426-860 388-822.083 350-784.167 350-730h-60q0-79 55.606-134.5t134.5-55.5Q559-920 614.5-864.425T670-730v96h70q24.75 0 42.375 17.625T800-574v434q0 24.75-17.625 42.375T740-80H220q-24.75 0-42.375-17.625T160-140v-434q0-24.75 17.625-42.375T220-634Zm0 494h520v-434H220v434Zm260.168-140Q512-280 534.5-302.031T557-355q0-30-22.668-54.5t-54.5-24.5Q448-434 425.5-409.5t-22.5 55q0 30.5 22.668 52.5t54.5 22ZM220-140v-434 434Z"/>'
};
export const IconLogs: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M177-107q-31 0-52-21t-21-52v-605q0-31 21-52t52-21h193q11-35 41-58t69-23q39 0 69 23t41 58h193q31 0 52 21t21 52v605q0 31-21 52t-52 21H177Zm95-165h288v-73H272v73Zm0-174h416v-73H272v73Zm0-175h416v-73H272v73Zm208-184q14 0 24.5-10.5T515-840q0-14-10.5-24.5T480-875q-14 0-24.5 10.5T445-840q0 14 10.5 24.5T480-805Z"/>'
};
export const IconMail: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M137-145q-28.725 0-50.862-22.137Q64-189.275 64-218v-524q0-28.725 22.138-50.862Q108.275-815 137-815h686q28.725 0 50.862 22.138Q896-770.725 896-742v524q0 28.725-22.138 50.863Q851.725-145 823-145H137Zm343-306 343-222v-69L480-522 137-742v69l343 222Z"/>'
};
export const IconMenu: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M104-231v-73h752v73H104Zm0-213v-73h752v73H104Zm0-213v-73h752v73H104Z"/>'
};
export const IconMenuOpen: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M104-224v-73h545v73H104Zm702-54L604-481l201-202 51 51-149 151 150 151-51 52ZM104-447v-72h421v72H104Zm0-217v-72h545v72H104Z"/>'
};
export const IconMic: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M480.118-413Q432-413 400-447.125 368-481.25 368-530v-252q0-46.25 32.324-78.625Q432.647-893 479.824-893 527-893 559.5-860.625T592-782v252q0 48.75-31.882 82.875-31.883 34.125-80 34.125ZM443-103v-135q-113-12-188.5-95T179-530h73q0 94 66.694 158t161.32 64q94.626 0 161.306-64T708-530h73q0 113.772-76 196.886Q629-250 516-238v135h-73Z"/>'
};
export const IconMoreHoriz: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M189.779-425Q167-425 151-441.221q-16-16.221-16-39T151.221-519q16.221-16 39-16T229-518.779q16 16.221 16 39T228.779-441q-16.221 16-39 16Zm290 0Q457-425 441-441.221q-16-16.221-16-39T441.221-519q16.221-16 39-16T519-518.779q16 16.221 16 39T518.779-441q-16.221 16-39 16Zm290 0Q747-425 731-441.221q-16-16.221-16-39T731.221-519q16.222-16 39-16Q793-535 809-518.779q16 16.221 16 39T808.779-441q-16.222 16-39 16Z"/>'
};
export const IconMove: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M480-68 307-241l54-54 83 84v-233l-232-1 78 79-54 54L68-480l169-169 53 53-79 79h233v-232l-79 78-53-53 168-168 168 168-53 53-78-78v232h232l-78-78 53-53 168 168-168 168-53-54 78-78H517v233l83-83 53 53L480-68Z"/>'
};
export const IconMusicNote: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M392-102q-69 0-116.5-47.5T228-266q0-69 47.5-116.5T392-430q27 0 50 6.5t41 19.5v-454h250v154H556v438q0 69-48 116.5T392-102Z"/>'
};
export const IconOpenInNew: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M177-104q-28.725 0-50.863-22.137Q104-148.275 104-177v-606q0-28.725 22.137-50.862Q148.275-856 177-856h292v73H177v606h606v-292h73v292q0 28.725-22.138 50.863Q811.725-104 783-104H177Zm204-225-51-52 402-402H529v-73h327v327h-73v-202L381-329Z"/>'
};
export const IconPauseCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M359-312h73v-336h-73v336Zm169 0h73v-336h-73v336ZM479.542-64Q394.36-64 318.52-97.02q-75.84-33.02-132.16-89.34-56.32-56.32-89.34-132.291T64-480q0-86.272 33.079-162.149 33.079-75.878 89.686-132.47 56.606-56.592 132.216-88.986Q394.59-896 479.557-896q86.329 0 162.512 32.395 76.183 32.394 132.557 89Q831-718 863.5-641.958q32.5 76.041 32.5 162.5 0 85.458-32.395 160.797-32.394 75.338-88.986 131.921-56.592 56.582-132.616 89.661Q565.979-64 479.542-64Zm.458-73q142.513 0 242.756-100.744Q823-338.487 823-480q0-142.513-100.244-242.756Q622.513-823 480-823q-141.513 0-242.256 100.244Q137-622.513 137-480q0 141.513 100.744 242.256Q338.487-137 480-137Zm0-343Z"/>'
};
export const IconPlay: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M306-184v-598l471 299-471 299Z"/>'
};
export const IconPlayCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m376-297 287-183-287-183v366ZM479.542-64Q394.36-64 318.52-97.02q-75.84-33.02-132.16-89.34-56.32-56.32-89.34-132.291T64-480q0-86.272 33.079-162.149 33.079-75.878 89.686-132.47 56.606-56.592 132.216-88.986Q394.59-896 479.557-896q86.329 0 162.512 32.395 76.183 32.394 132.557 89Q831-718 863.5-641.958q32.5 76.041 32.5 162.5 0 85.458-32.395 160.797-32.394 75.338-88.986 131.921-56.592 56.582-132.616 89.661Q565.979-64 479.542-64Zm.458-73q142.513 0 242.756-100.744Q823-338.487 823-480q0-142.513-100.244-242.756Q622.513-823 480-823q-141.513 0-242.256 100.244Q137-622.513 137-480q0 141.513 100.744 242.256Q338.487-137 480-137Zm0-343Z"/>'
};
export const IconPlaylist: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M644.941-144q-50.608 0-86.774-36.029Q522-216.059 522-267.529 522-319 557-355q35-36 85-36 14.903 0 28.452 3Q684-385 696-379v-357h200v83H768v387q0 50.833-36.517 86.417Q694.966-144 644.941-144ZM104-299v-72h319v72H104Zm0-182v-73h487v73H104Zm0-183v-72h487v72H104Z"/>'
};
export const IconPodcasts: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M444-40v-361.62Q422-412 408-433t-14-47q0-35.888 24.819-61.444Q443.638-567 480-567q36.362 0 61.681 25.556Q567-515.888 567-480q0 25-14 45.5t-36 31.386V-40h-73ZM200-186q-59-55-92.5-130.719T74-479.635q0-84.38 31.543-158.594 31.544-74.214 86.833-129.469 55.289-55.255 129.303-87.278Q395.693-887 479.847-887q84.153 0 158.291 32.132 74.138 32.131 129.395 87.287 55.256 55.155 87.362 129.413Q887-563.911 887-479.481 887-392 853-317t-92 131l-53-52q48.62-45.867 77.31-107.24Q814-406.614 814-480.105 814-619 716.452-716.5q-97.549-97.5-236.5-97.5Q341-814 244-716.587q-97 97.412-97 236.168 0 73.419 27.431 134.858Q201.861-284.122 252-238l-52 52Zm113-113q-37-33-58-80.212t-21-101.056Q234-583 305.441-655t174.5-72Q583-727 655-655.25t72 175.132Q727-426 705.5-379.5 684-333 648-299l-52-52q26-23 42-56.041T654-480q0-72.525-50.761-123.263Q552.478-654 479.92-654q-72.558 0-122.739 50.582Q307-552.837 307-480.531q0 39.531 15.537 73.12Q338.074-373.821 365-351l-52 52Z"/>'
};
export const IconPublic: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M479.86-56Q392-56 314.753-89.477q-77.246-33.477-134.388-90.867-57.141-57.389-90.753-134.663T56-480.14Q56-568 89.477-645.247q33.477-77.246 90.867-134.388 57.389-57.141 134.663-90.753T480.14-904q87.86 0 165.107 33.477 77.246 33.477 134.388 90.867 57.141 57.389 90.753 134.663T904-479.86q0 87.86-33.477 165.107-33.477 77.246-90.867 134.388-57.389 57.141-134.663 90.753T479.86-56ZM436-130v-85q-37 0-61.5-26.262-24.5-26.263-24.5-63.286V-350L138-562q-5 19.5-7 40.5t-2 41.594Q129-346 216.5-245.5T436-130Zm303-112q23.286-24.287 40.12-52.145 16.834-27.857 28.554-58.282 11.719-30.425 17.522-62.824Q831-447.65 831-481.097 831-590 771.407-679.545 711.815-769.091 611-810v17.98q0 37.02-24.263 63.52Q562.475-702 525-702h-89v90q0 18-13.5 29T391-572h-87v91h267.429q16.392 0 27.982 13.569Q611-453.862 611-437.5V-304h44.212q29.788 0 52.628 17.277T739-242Z"/>'
};
export const IconRadio: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M137-59q-28.725 0-50.862-22.138Q64-103.275 64-132v-567l576-232 23 60-351 141h511q28.725 0 50.862 22.138Q896-685.725 896-657v525q0 28.725-22.138 50.862Q851.725-59 823-59H137Zm182.183-135Q360-194 388-222.183q28-28.183 28-69T387.817-360q-28.183-28-69-28T250-359.817q-28 28.183-28 69T250.183-222q28.183 28 69 28ZM137-512h518v-63h73v63h95v-145H137v145Z"/>'
};
export const IconRefresh: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M480-143q-140 0-238-98.5T144-479q0-139 98-238.5T480.379-817Q564-817 629-782.5 694-748 744-690v-127h73v281H536v-73h178q-40-60-98-96t-136-36q-110.75 0-186.875 75.882Q217-589.235 217-479.118 217-368 293.117-292q76.116 76 186.855 76Q563-216 632.5-263.5 702-311 730-391h75q-30 111-120.5 179.5T480-143Z"/>'
};
export const IconRemove: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M184-444v-73h592v73H184Z"/>'
};
export const IconRemoveCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M272-447h416v-73H272v73ZM479.542-64Q394.36-64 318.52-97.02q-75.84-33.02-132.16-89.34-56.32-56.32-89.34-132.291T64-480q0-86.272 33.079-162.149 33.079-75.878 89.686-132.47 56.606-56.592 132.216-88.986Q394.59-896 479.557-896q86.329 0 162.512 32.395 76.183 32.394 132.557 89Q831-718 863.5-641.958q32.5 76.041 32.5 162.5 0 85.458-32.395 160.797-32.394 75.338-88.986 131.921-56.592 56.582-132.616 89.661Q565.979-64 479.542-64Z"/>'
};
export const IconReport: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M177-104q-28.725 0-50.863-22.137Q104-148.275 104-177v-606q0-28.725 22.137-50.862Q148.275-856 177-856h472l207 207v472q0 28.725-22.138 50.863Q811.725-104 783-104H177Zm130.684-167Q322-271 333-282.184q11-11.184 11-25.5T333-333q-11-11-25.316-11-14.316 0-25.5 11T271-307.684q0 14.316 11.184 25.5t25.5 11.184Zm0-173Q322-444 333-454.5q11-10.5 11-25.5t-11-26q-11-11-25.316-11-14.316 0-25.5 11T271-480q0 15 11.184 25.5t25.5 10.5Zm0-172Q322-616 333-627.184q11-11.184 11-25.5T333-678q-11-11-25.316-11-14.316 0-25.5 11T271-652.684q0 14.316 11.184 25.5t25.5 11.184ZM610-610h173L610-783v173Z"/>'
};
export const IconRouter: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M160-84q-28.725 0-50.863-21.637Q87-127.275 87-157v-209q0-28.725 22.137-50.862Q131.275-439 160-439h460v-178h73v178h99q28.725 0 50.862 22.138Q865-394.725 865-366v209q0 29.725-22.138 51.363Q820.725-84 792-84H160Zm142-177.105Q302-280 288.895-293q-13.106-13-32-13Q238-306 225-292.895q-13 13.106-13 32Q212-241 225.105-228.5q13.106 12.5 32 12.5Q276-216 289-228.605q13-12.606 13-32.5Zm150 0Q452-280 438.895-293q-13.106-13-32-13Q387-306 374.5-292.895q-12.5 13.106-12.5 32Q362-241 374.605-228.5q12.606 12.5 32.5 12.5Q426-216 439-228.605q13-12.606 13-32.5ZM556.105-216Q575-216 588-228.605q13-12.606 13-32.5Q601-280 587.895-293q-13.106-13-32-13Q537-306 524-292.895q-13 13.106-13 32Q511-241 524.105-228.5q13.106 12.5 32 12.5ZM566-664l-50-50q28-27 62.989-43.5 34.988-16.5 78.068-16.5 42.08 0 77.012 16.5Q769-741 797-714l-49 50q-17-16-40.409-26.5t-50-10.5Q630-701 606-690.5T566-664ZM466-764l-53-53q39.2-39.638 103.1-68.819Q580-915 657-915q76 0 139.5 29T901-817l-54 53q-31-33-79.5-55.5T657-842q-63 0-111 22.5T466-764Z"/>'
};
export const IconRss: Icon = {
  viewBox: bootstrapIconsViewBox,
  contents: '<path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm1.5 2.5c5.523 0 10 4.477 10 10a1 1 0 1 1-2 0 8 8 0 0 0-8-8 1 1 0 0 1 0-2m0 4a6 6 0 0 1 6 6 1 1 0 1 1-2 0 4 4 0 0 0-4-4 1 1 0 0 1 0-2m.5 7a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3"/>'
};
export const IconSearch: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M801-108 537-372q-31 26-72.959 40t-86.603 14q-114.6 0-192.519-78Q107-474 107-586t78-190q78-78 190-78t190 78q78 78 78 190.15 0 43.85-13.5 84.35Q616-461 588-425l266 264-53 53ZM375.5-391q81.75 0 138.125-56.792Q570-504.583 570-586t-56.287-138.208Q457.426-781 375.588-781q-82.671 0-139.13 56.792Q180-667.417 180-586t56.458 138.208Q292.917-391 375.5-391Z"/>'
};
export const IconSend: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M109-151v-253l314-78-314-81v-250l783 331-783 331Z"/>'
};
export const IconSettings: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m377-64-21-130q-16-6-35.5-17T287-233l-122 55L61-364l109-81q-1-7-1.5-18t-.5-19q0-7 .5-17.5T170-518L61-598l104-185 120 55q14-11 34-22.5t37-17.5l21-129h207l20 129q17 6 37.5 17.5T675-728l121-55 104 185-111 79q1 9 2 20t1 19q0 8-1 18.5t-1 18.5l109 79-104 186-122-55q-14 11-33 22.5T605-194L584-64H377Zm102-273q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102q0 60 42 102t102 42Z"/>'
};
export const IconSkipNext: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M686-221v-518h73v518h-73Zm-485 0v-518l375 259-375 259Z"/>'
};
export const IconSmartphone: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M258-23q-28.725 0-50.863-22.138Q185-67.275 185-96v-768q0-28.725 22.137-50.862Q229.275-937 258-937h444q28.725 0 50.862 22.138Q775-892.725 775-864v768q0 28.725-22.138 50.862Q730.725-23 702-23H258Zm0-171h444v-572H258v572Z"/>'
};
export const IconStop: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M229-229v-502h502v502H229Z"/>'
};
export const IconStopCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M324-324h313v-313H324v313ZM479.808-64q-85.916 0-161.522-33.02T186.36-186.36q-56.32-56.32-89.34-132.132Q64-394.303 64-480.5q0-86.09 33.079-161.809 33.079-75.718 89.686-132.31 56.606-56.592 132.056-88.986Q394.271-896 480.057-896q86.148 0 162.172 32.395 76.023 32.394 132.397 89Q831-718 863.5-641.958 896-565.917 896-479.724q0 86.192-32.395 161.297-32.394 75.104-88.986 131.502-56.592 56.399-132.616 89.662Q565.979-64 479.808-64Zm.692-73q142.013 0 242.256-100.744Q823-338.487 823-480.5T722.944-722.756Q622.888-823 480-823q-141.513 0-242.256 100.056Q137-622.888 137-480q0 141.513 100.744 242.256Q338.487-137 480.5-137Zm-.5-343Z"/>'
};
export const IconSupport: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M480-64q-85.64 0-161.98-32.52-76.34-32.52-132.66-88.84-56.32-56.32-88.84-132.66T64-480q0-85.64 32.52-161.98 32.52-76.34 88.84-132.66 56.32-56.32 132.66-88.84T480-896q85.64 0 161.98 32.52 76.34 32.52 132.66 88.84 56.32 56.32 88.84 132.66T896-480q0 85.64-32.52 161.98-32.52 76.34-88.84 132.66-56.32 56.32-132.66 88.84T480-64Zm-122-93 57-137q-41-15-73-45.5T293-414l-136 54q31.193 71.6 82.597 124.3Q291-183 358-157Zm-66-388q17-45 48.5-76.5T414-667l-54-136q-77 31-129 83.5T157-599l135 54Zm187.882 190Q532-355 568.5-391.382q36.5-36.383 36.5-88.5Q605-532 568.618-568.5q-36.383-36.5-88.5-36.5Q428-605 391.5-568.618q-36.5 36.383-36.5 88.5Q355-428 391.382-391.5q36.383 36.5 88.5 36.5ZM602-157q69-28 121-80t80-121l-137-56q-17 45-48 76t-73 45l57 136Zm65-389 136-56q-28.202-68.994-80.101-121.497T602-803l-55 137q40.901 14.171 71.951 45.086Q650-590 667-546Z"/>'
};
export const IconSwapHorizontalCircle: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m363-221 52-52-80-79h185v-73H336l79-78-52-52-167 167 167 167Zm234-176 167-167-166-167-53 52 80 79H440v73h184l-79 78 52 52ZM479.542-64Q394.36-64 318.52-97.02q-75.84-33.02-132.16-89.34-56.32-56.32-89.34-132.291T64-480q0-86.272 33.079-162.149 33.079-75.878 89.686-132.47 56.606-56.592 132.216-88.986Q394.59-896 479.557-896q86.329 0 162.512 32.395 76.183 32.394 132.557 89Q831-718 863.5-641.958q32.5 76.041 32.5 162.5 0 85.458-32.395 160.797-32.394 75.338-88.986 131.921-56.592 56.582-132.616 89.661Q565.979-64 479.542-64Z"/>'
};
export const IconSync: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M156-149v-73h127l-8-6q-62-55-93-114.5T151-478q0-111 66.5-199.5T392-796v76q-76 28-122 94.5T224-478q0 60 21.5 105t58.5 77l26 17v-117h73v247H156Zm413-14v-77q77-27 122.5-94T737-483q0-44-22.5-92T658-659l-25-22v117h-73v-247h247v73H679l8 8q62 57 92.5 122T810-483q0 112-66.5 200.5T569-163Z"/>'
};
export const IconTrendingDown: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M655-227v-73h119L542-533 373-364 65-670l52-53 255 255 169-169 283 284v-116h72v242H655Z"/>'
};
export const IconTrendingUp: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m117-227-52-53 308-306 169 169 232-233H655v-73h241v242h-72v-116L541-313 372-482 117-227Z"/>'
};
export const IconUpdate: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M476-104q-77.833 0-146.928-29.6-69.094-29.6-119.866-81.025-50.773-51.424-80.489-120.4Q99-404 99-482t29.717-145.975q29.716-67.976 80.489-118.4Q259.978-796.8 329.072-826.4 398.167-856 476-856q84.742 0 161.371 37T767-715v-107h73v233H606v-73h110q-44-55-106.532-88Q546.937-783 476-783q-125.836 0-214.918 86.5Q172-610 172-484.5 172-357 260.5-267T477-177q125.607 0 213.303-88.5Q778-354 777-481h74q1 157-108.5 267T476-104Zm125-203L439-466v-225h73v194l141 138-52 52Z"/>'
};
export const IconUpload: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M444-145H249q-93.795 0-159.898-65.369Q23-275.739 23-370.495 23-451 74-513.5T204-591q24-99 101.551-161T482-814q114 0 194.5 81.5T763-534v24q74 3 124 54t50 128q0 75.167-53.917 129.083Q829.167-145 754-145H517v-317l78 77 52-52-167-166-166 166 52 52 78-77v317Z"/>'
};
export const IconVolumeDown: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M187-350v-260h167l214-215v690L354-350H187Zm441 44v-348q57 18 91.5 66T754-480q0 60-34.5 107.5T628-306Z"/>'
};
export const IconVolumeOff: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M821-37 697-160q-34 23-72.5 40T543-94v-75q27-7 52.5-17t48.5-27L463-395v260L249-350H82v-260h165L27-831l52-52L873-90l-52 53Zm-14-247-54-54q18-33 26-69t8-75q0-112-67.5-200.5T543-793v-75q139 28 228 136.5T860-482q0 53-13.5 103T807-284ZM644-447 543-548v-99q49 23 77.5 68t28.5 99q0 9-1 17t-4 16ZM463-628l-98-99 98-98v197Z"/>'
};
export const IconVolumeUp: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M552-94v-75q108-28 176-115t68-198q0-110-68-196.5T552-793v-75q139 28 228 136.5T869-482q0 143-88.5 252T552-94ZM91-350v-260h167l214-215v690L258-350H91Zm441 44v-348q57 18 91.5 66T658-480q0 60-34.5 108T532-306Z"/>'
};
export const IconVpnKey: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="M280-240q-100 0-170-70T40-480q0-100 70-170t170-70q78 0 131.5 37.5T491-583h429v206H814v137H628v-137H491q-26 62-79.5 99.5T280-240Zm0-60q71 0 116.5-47t53.5-90h242v137h62v-137h106v-86H450q-8-43-53.5-90T280-660q-75 0-127.5 52.5T100-480q0 75 52.5 127.5T280-300Zm0-112q29 0 48.5-19.5T348-480q0-29-19.5-48.5T280-548q-29 0-48.5 19.5T212-480q0 29 19.5 48.5T280-412Zm0-68Z"/>'
};
export const IconWarning: Icon = {
  viewBox: materialIconsViewBox,
  contents: '<path d="m14-99 466-804L946-99H14Zm470.86-125q15.14 0 25.64-10.658t10.5-25.5Q521-275 510.325-286q-10.676-11-25.816-11-15.141 0-25.825 10.95Q448-275.099 448-259.825q0 14.85 10.86 25.337Q469.719-224 484.86-224ZM448-346h73v-226h-73v226Z"/>'
};