#pragma once

#include "Runtime/Graphics/CTexture.hpp"

#include <zeus/CAABox.hpp>
#include <zeus/CTransform.hpp>
#include <zeus/CVector3f.hpp>

namespace metaforce {
class CStateManager;
class CModelData;
class CProjectedShadow {
  CTexture x0_texture;
  zeus::CAABox x68_ = zeus::CAABox();
  bool x80_;
  bool x81_persistent;
  float x84_ = 1.f;
  zeus::CVector3f x88_ = zeus::skZero3f;
  float x94_zDistanceAdjust = 0.f;
  float x98_ = 1.f;

public:
  CProjectedShadow(u32, u32, bool);

  zeus::CAABox CalculateRenderBounds();
  void Render(const CStateManager& mgr);
  void RenderShadowBuffer(const CStateManager&, const CModelData&, const zeus::CTransform&, s32, const zeus::CVector3f&,
                          float, float);

  void Unset_X80() { x80_ = false; }
  void Set_x98(float f) { x98_ = f; }
};
} // namespace metaforce
