/********************************************************************************
 * Copyright (c) 2012, Matthew Shepard
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the software nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY SCOTT FERGUSON ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL SCOTT FERGUSON BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

package com.ferg.awfulapp.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

import com.ferg.awfulapp.preferences.AwfulPreferences;

import java.io.FileNotFoundException;
import java.io.IOException;

public class AwfulWebProvider extends ContentProvider {

	private static final String TAG = "AwfulWebProvider";
	
	private AwfulPreferences mPrefs;

	//Using this to serve fonts to webview, but eventually will use this to cache pictures on SD card (heh, maybe).
	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
		Log.e(TAG,"delete STUB");
		return 0;
	}

	@Override
	public String getType(Uri uri) {
		Log.e(TAG,"getType STUB");
		return null;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		Log.e(TAG,"update STUB");
		return null;
	}

	@Override
	public boolean onCreate() {
		mPrefs = AwfulPreferences.getInstance(getContext());
		return true;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection,
			String[] selectionArgs, String sortOrder) {
		Log.e(TAG,"query STUB");
		return null;
	}

	@Override
	public int update(Uri uri, ContentValues values, String selection,
			String[] selectionArgs) {
		Log.e(TAG,"update STUB");
		return 0;
	}

	@Override
	public AssetFileDescriptor openAssetFile(Uri uri, String mode)
			throws FileNotFoundException {
		try {
			return getContext().getAssets().openFd(mPrefs.preferredFont);//.mp3 as a shitty workaround for compressed asset issue
		} catch (IOException e) {
			e.printStackTrace();
			throw new FileNotFoundException();
		}
	}
}
