import { nanoid } from 'nanoid';

export default [
  {
    id: nanoid(),
    name: 'Twitter Trends to Google Sheets',
    icon: 'https://upload.wikimedia.org/wikipedia/commons/4/4f/Twitter-logo.svg',
    table: [
      { id: '6QbkU', name: 'text', type: 'string' },
      { id: 'Q-zII', name: 'tweets_count', type: 'integer' },
    ],
    drawflow: {
      nodes: [
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'F_uKdk2VrnKslRle78d-C-output-1',
                position: 'right',
                x: 196,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 96, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            description: '',
            type: 'manual',
            interval: 60,
            delay: 5,
            date: '',
            time: '00:00',
            url: '',
            shortcut: '',
            activeInInput: false,
            isUrlRegex: false,
            days: [],
            contextMenuName: '',
            contextTypes: [],
            parameters: [],
            preferParamsInTab: false,
            observeElement: {
              selector: '',
              baseSelector: '',
              matchPattern: '',
              targetOptions: {
                subtree: false,
                childList: true,
                attributes: false,
                attributeFilter: [],
                characterData: false,
              },
              baseElOptions: {
                subtree: false,
                childList: true,
                attributes: false,
                attributeFilter: [],
                characterData: false,
              },
            },
          },
          events: {},
          position: { x: 96, y: 75.5 },
          id: 'F_uKdk2VrnKslRle78d-C',
          label: 'trigger',
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '369o3ob-output-1',
                position: 'right',
                x: 196,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '369o3ob-input-1',
                position: 'left',
                x: -20,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 388, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            description: '',
            url: 'https://twitter.com/i/trends',
            userAgent: '',
            active: true,
            inGroup: false,
            waitTabLoaded: false,
            updatePrevTab: false,
            customUserAgent: false,
          },
          events: {},
          position: { x: 388, y: 75.5 },
          label: 'new-tab',
          id: '369o3ob',
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'f0ky2jr-output-1',
                position: 'right',
                x: 196,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'f0ky2jr-input-1',
                position: 'left',
                x: -20,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 680, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            loopId: 'items',
            selector: '[data-testid="trend"]',
            maxLoop: '0',
            description: '',
            reverseLoop: false,
            actionElSelector: '',
            findBy: 'cssSelector',
            actionElMaxWaitTime: 5,
            actionPageMaxWaitTime: 10,
            loadMoreAction: 'scroll',
            scrollToBottom: true,
            waitForSelector: true,
            waitSelectorTimeout: 5000,
          },
          events: {},
          id: 'f0ky2jr',
          label: 'loop-elements',
          position: { x: 680, y: 75.5 },
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'tpiq3ux-output-1',
                position: 'right',
                x: 196,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'tpiq3ux-input-1',
                position: 'left',
                x: -20,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 972, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            description: 'Trending text',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '{{loopData.items}} > div > div[dir="ltr"]:nth-child(2)',
            markEl: false,
            multiple: false,
            regex: '',
            prefixText: '',
            suffixText: '',
            regexExp: [],
            dataColumn: '6QbkU',
            saveData: true,
            includeTags: false,
            addExtraRow: false,
            assignVariable: false,
            useTextContent: false,
            variableName: '',
            extraRowValue: '',
            extraRowDataColumn: '',
          },
          events: {},
          position: { x: 972, y: 75.5 },
          label: 'get-text',
          id: 'tpiq3ux',
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'zel6am7-output-1',
                position: 'right',
                x: 196,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'zel6am7-input-1',
                position: 'left',
                x: -20,
                y: 28,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1264, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            description: 'Trending tweets count',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '{{loopData.items}} > div > div[dir="ltr"]:nth-child(3)',
            markEl: false,
            multiple: false,
            regex: '',
            prefixText: '',
            suffixText: '',
            regexExp: [],
            dataColumn: 'Q-zII',
            saveData: true,
            includeTags: false,
            addExtraRow: false,
            assignVariable: false,
            useTextContent: false,
            variableName: '',
            extraRowValue: '',
            extraRowDataColumn: '',
          },
          events: {},
          label: 'get-text',
          id: 'zel6am7',
          position: { x: 1264, y: 75.5 },
        },
        {
          type: 'BlockLoopBreakpoint',
          dimensions: { width: 192, height: 151 },
          handleBounds: {
            source: [
              {
                id: 'mfzs3rz-output-1',
                position: 'right',
                x: 196,
                y: 67.6875,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'mfzs3rz-input-1',
                position: 'left',
                x: -20,
                y: 67.6875,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1556, y: 75.5, z: 0 },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: { disableBlock: false, loopId: 'items', clearLoop: false },
          events: {},
          position: { x: 1556, y: 75.5 },
          label: 'loop-breakpoint',
          id: 'mfzs3rz',
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '8tor34x-output-1',
                position: 'right',
                x: 196.00022007042253,
                y: 27.999996538337534,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '8tor34x-input-1',
                position: 'left',
                x: -19.99993470685429,
                y: 27.999996538337534,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: {
            x: 1839.6148017621147,
            y: 112.0740088105727,
            z: 0,
          },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            range: '',
            refKey: '',
            type: 'update',
            customData: '',
            description: '',
            spreadsheetId: '',
            dataColumn: '',
            saveData: true,
            assignVariable: false,
            variableName: '',
            firstRowAsKey: false,
            keysAsFirstRow: true,
            valueInputOption: 'RAW',
            InsertDataOption: 'INSERT_ROWS',
            dataFrom: 'data-columns',
          },
          events: {},
          position: { x: 1839.6148017621147, y: 112.0740088105727 },
          label: 'google-sheets',
          id: '8tor34x',
        },
        {
          type: 'BlockNote',
          dimensions: { width: 312, height: 251 },
          handleBounds: {},
          computedPosition: {
            x: 322.1510553694428,
            y: 207.59283268768826,
            z: 0,
          },
          selected: false,
          dragging: false,
          resizing: false,
          initialized: true,
          data: {
            disableBlock: false,
            note: 'Read the documentation about the Google Sheets block before running this workflow',
            drawing: false,
            width: 280,
            height: 168,
            color: 'indigo',
            fontSize: 'regular',
          },
          events: {},
          position: { x: 322.1510553694428, y: 207.59283268768826 },
          label: 'note',
          id: '7rznotf',
        },
      ],
      edges: [
        {
          id: 'vueflow__edge-F_uKdk2VrnKslRle78d-CF_uKdk2VrnKslRle78d-C-output-1-369o3ob369o3ob-input-1',
          target: '369o3ob',
          source: 'F_uKdk2VrnKslRle78d-C',
          targetHandle: '369o3ob-input-1',
          sourceHandle: 'F_uKdk2VrnKslRle78d-C-output-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
        {
          id: 'edge-tczf2qq',
          source: '369o3ob',
          target: 'f0ky2jr',
          sourceHandle: '369o3ob-output-1',
          targetHandle: 'f0ky2jr-input-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
        {
          id: 'vueflow__edge-f0ky2jrf0ky2jr-output-1-tpiq3uxtpiq3ux-input-1',
          target: 'tpiq3ux',
          source: 'f0ky2jr',
          targetHandle: 'tpiq3ux-input-1',
          sourceHandle: 'f0ky2jr-output-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
        {
          id: 'vueflow__edge-tpiq3uxtpiq3ux-output-1-zel6am7zel6am7-input-1',
          target: 'zel6am7',
          source: 'tpiq3ux',
          targetHandle: 'zel6am7-input-1',
          sourceHandle: 'tpiq3ux-output-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
        {
          id: 'vueflow__edge-zel6am7zel6am7-output-1-mfzs3rzmfzs3rz-input-1',
          target: 'mfzs3rz',
          source: 'zel6am7',
          targetHandle: 'mfzs3rz-input-1',
          sourceHandle: 'zel6am7-output-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
        {
          id: 'vueflow__edge-mfzs3rzmfzs3rz-output-1-8tor34x8tor34x-input-1',
          target: '8tor34x',
          source: 'mfzs3rz',
          targetHandle: '8tor34x-input-1',
          sourceHandle: 'mfzs3rz-output-1',
          type: 'custom',
          updatable: true,
          selectable: true,
          markerEnd: 'arrowclosed',
          data: {},
          events: {},
        },
      ],
      position: [-169.83007474880947, 65.03712768543713],
      zoom: 0.9365333557481814,
    },
    settings: {
      publicId: '',
      blockDelay: 0,
      saveLog: true,
      debugMode: false,
      restartTimes: 3,
      notification: true,
      execContext: 'popup',
      reuseLastState: false,
      inputAutocomplete: true,
      onError: 'stop-workflow',
      executedBlockOnWeb: false,
      insertDefaultColumn: false,
      defaultColumnName: 'column',
    },
    globalData: '{\n\t"key": "value"\n}',
    description: 'Import current twitter trends to Google Sheets',
  },
  {
    id: nanoid(),
    name: 'Google search',
    createdAt: Date.now(),
    drawflow: {
      nodes: [
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'd634ff22-5dfe-44dc-83d2-842412bd9fbf-output-1',
                position: 'right',
                x: 196.00000657196182,
                y: 28.000021560199762,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 50, y: 300, z: 0 },
          id: 'd634ff22-5dfe-44dc-83d2-842412bd9fbf',
          label: 'trigger',
          position: { x: 50, y: 300 },
          data: { type: 'manual', interval: 10 },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'b9e7e0d4-e86a-4635-a352-31c63723fef4-output-1',
                position: 'right',
                x: 196.00006103515628,
                y: 27.999992370605472,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'b9e7e0d4-e86a-4635-a352-31c63723fef4-input-1',
                position: 'left',
                x: -20,
                y: 27.999992370605472,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 353, y: 298, z: 0 },
          id: 'b9e7e0d4-e86a-4635-a352-31c63723fef4',
          label: 'new-tab',
          position: { x: 353, y: 298 },
          data: {
            disableBlock: false,
            description: '',
            url: 'https://google.com',
            userAgent: '',
            active: true,
            inGroup: false,
            waitTabLoaded: false,
            updatePrevTab: false,
            customUserAgent: false,
            onError: {},
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '09f3a14c-0514-4287-93b0-aa92b0064fba-output-1',
                position: 'right',
                x: 195.99997405489208,
                y: 28.00001941411291,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '09f3a14c-0514-4287-93b0-aa92b0064fba-input-1',
                position: 'left',
                x: -20.000021574075806,
                y: 28.00001941411291,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 641, y: 290, z: 0 },
          id: '09f3a14c-0514-4287-93b0-aa92b0064fba',
          label: 'forms',
          position: { x: 641, y: 290 },
          data: {
            description: 'Type query',
            selector: "[name='q']",
            markEl: false,
            multiple: false,
            selected: true,
            type: 'text-field',
            value: 'Automa Extension',
            delay: '120',
            events: [],
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '5f76370d-aa3d-4258-8319-230fcfc49a3a-output-1',
                position: 'right',
                x: 196.00006103515628,
                y: 27.999992370605472,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '5f76370d-aa3d-4258-8319-230fcfc49a3a-input-1',
                position: 'left',
                x: -20,
                y: 27.999992370605472,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 929, y: 293, z: 0 },
          id: '5f76370d-aa3d-4258-8319-230fcfc49a3a',
          label: 'event-click',
          position: { x: 929, y: 293 },
          data: {
            description: 'Click search',
            selector: 'center:nth-child(1) > .gNO89b',
            markEl: false,
            multiple: false,
          },
          selected: false,
        },
      ],
      edges: [
        {
          id: 'edge-0',
          sourceHandle: 'd634ff22-5dfe-44dc-83d2-842412bd9fbf-output-1',
          targetHandle: 'b9e7e0d4-e86a-4635-a352-31c63723fef4-input-1',
          source: 'd634ff22-5dfe-44dc-83d2-842412bd9fbf',
          target: 'b9e7e0d4-e86a-4635-a352-31c63723fef4',
          class:
            'source-d634ff22-5dfe-44dc-83d2-842412bd9fbf-output-1 target-b9e7e0d4-e86a-4635-a352-31c63723fef4-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-1',
          sourceHandle: 'b9e7e0d4-e86a-4635-a352-31c63723fef4-output-1',
          targetHandle: '09f3a14c-0514-4287-93b0-aa92b0064fba-input-1',
          source: 'b9e7e0d4-e86a-4635-a352-31c63723fef4',
          target: '09f3a14c-0514-4287-93b0-aa92b0064fba',
          class:
            'source-b9e7e0d4-e86a-4635-a352-31c63723fef4-output-1 target-09f3a14c-0514-4287-93b0-aa92b0064fba-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
          animated: false,
        },
        {
          id: 'edge-2',
          sourceHandle: '09f3a14c-0514-4287-93b0-aa92b0064fba-output-1',
          targetHandle: '5f76370d-aa3d-4258-8319-230fcfc49a3a-input-1',
          source: '09f3a14c-0514-4287-93b0-aa92b0064fba',
          target: '5f76370d-aa3d-4258-8319-230fcfc49a3a',
          class:
            'source-09f3a14c-0514-4287-93b0-aa92b0064fba-output-1 target-5f76370d-aa3d-4258-8319-230fcfc49a3a-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
      ],
      position: [-1.538468549623417, 35.22407674532957],
      zoom: 0.7999999999999999,
    },
  },
  {
    id: nanoid(),
    name: 'Generate lorem ipsum',
    createdAt: Date.now(),
    drawflow: {
      nodes: [
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: 'c5774692-0be4-457f-82be-d5e4b3344ad7-output-1',
                position: 'right',
                x: 195.99998474121094,
                y: 27.99999237060547,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 50, y: 300, z: 0 },
          id: 'c5774692-0be4-457f-82be-d5e4b3344ad7',
          label: 'trigger',
          position: { x: 50, y: 300 },
          data: {
            disableBlock: false,
            description: '',
            type: 'manual',
            interval: 60,
            delay: 5,
            date: '',
            time: '00:00',
            url: '',
            shortcut: '',
            activeInInput: false,
            isUrlRegex: false,
            days: [],
          },
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '10a0429e-b8c4-4c04-9ea3-df169cea78e4-output-1',
                position: 'right',
                x: 195.9999744943092,
                y: 28.000021560199755,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '10a0429e-b8c4-4c04-9ea3-df169cea78e4-input-1',
                position: 'left',
                x: -19.999903128358724,
                y: 28.000021560199755,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 315, y: 297, z: 0 },
          id: '10a0429e-b8c4-4c04-9ea3-df169cea78e4',
          label: 'new-tab',
          position: { x: 315, y: 297 },
          data: {
            disableBlock: false,
            description: '',
            url: 'http://lipsum.com',
            userAgent: '',
            active: true,
            inGroup: false,
            waitTabLoaded: false,
            updatePrevTab: true,
            customUserAgent: false,
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '24bdec44-1e80-4cee-9139-00545b8d33d9-output-1',
                position: 'right',
                x: 195.99997198037403,
                y: 28.000015439189703,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '24bdec44-1e80-4cee-9139-00545b8d33d9-input-1',
                position: 'left',
                x: -20.000004547328174,
                y: 28.000015439189703,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 596, y: 302, z: 0 },
          id: '24bdec44-1e80-4cee-9139-00545b8d33d9',
          label: 'element-scroll',
          position: { x: 596, y: 302 },
          data: {
            disableBlock: false,
            description: '',
            findBy: 'cssSelector',
            waitForSelector: true,
            waitSelectorTimeout: 5000,
            selector: '#amount',
            markEl: false,
            multiple: false,
            scrollY: 0,
            scrollX: 0,
            incX: false,
            incY: false,
            smooth: true,
            scrollIntoView: true,
          },
          selected: false,
        },
        {
          type: 'BlockDelay',
          dimensions: { width: 192, height: 117 },
          handleBounds: {
            source: [
              {
                id: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae-output-1',
                position: 'right',
                x: 196.00015343897923,
                y: 50.687512658751125,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae-input-1',
                position: 'left',
                x: -19.999913818025576,
                y: 50.687512658751125,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 878, y: 282, z: 0 },
          id: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae',
          label: 'delay',
          position: { x: 878, y: 282 },
          data: { time: '1000' },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '2d93c1de-42ca-4f39-8e61-e3e55529fbba-output-1',
                position: 'right',
                x: 195.99997198037403,
                y: 28.000015439189703,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '2d93c1de-42ca-4f39-8e61-e3e55529fbba-input-1',
                position: 'left',
                x: -20.000004547328174,
                y: 28.000015439189703,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1148, y: 297, z: 0 },
          id: '2d93c1de-42ca-4f39-8e61-e3e55529fbba',
          label: 'forms',
          position: { x: 1148, y: 297 },
          data: {
            disableBlock: false,
            description: 'Lipsum length',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '#amount',
            markEl: false,
            multiple: false,
            selected: true,
            clearValue: true,
            getValue: false,
            saveData: false,
            dataColumn: '',
            assignVariable: false,
            variableName: '',
            type: 'text-field',
            value: '3',
            delay: 0,
            events: [],
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-output-1',
                position: 'right',
                x: 195.99997198037403,
                y: 27.999992756864053,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-input-1',
                position: 'left',
                x: -20.00009527663077,
                y: 27.999992756864053,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1414, y: 299, z: 0 },
          id: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb',
          label: 'event-click',
          position: { x: 1414, y: 299 },
          data: {
            disableBlock: false,
            description: 'Generate button',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '#generate',
            markEl: false,
            multiple: false,
          },
          selected: false,
        },
        {
          type: 'BlockDelay',
          dimensions: { width: 192, height: 117 },
          handleBounds: {
            source: [
              {
                id: 'fb9be12f-8995-4876-8bfe-79323769474b-output-1',
                position: 'right',
                x: 195,
                y: 50.68748474121094,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'fb9be12f-8995-4876-8bfe-79323769474b-input-1',
                position: 'left',
                x: -20,
                y: 50.68748474121094,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1686, y: 280, z: 0 },
          id: 'fb9be12f-8995-4876-8bfe-79323769474b',
          label: 'delay',
          position: { x: 1686, y: 280 },
          data: { disableBlock: false, time: 2000 },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '7205fcf2-deda-445e-9690-4e36adb52585-output-1',
                position: 'right',
                x: 195.99997449430924,
                y: 28.00000552137348,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '7205fcf2-deda-445e-9690-4e36adb52585-input-1',
                position: 'left',
                x: -20.000031438968968,
                y: 28.00000552137348,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1973, y: 307, z: 0 },
          id: '7205fcf2-deda-445e-9690-4e36adb52585',
          label: 'get-text',
          position: { x: 1973, y: 307 },
          data: {
            disableBlock: false,
            description: 'Get text result',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '#lipsum',
            markEl: false,
            multiple: false,
            regex: '',
            prefixText: '',
            suffixText: '',
            regexExp: ['g', 'g'],
            dataColumn: '',
            saveData: true,
            includeTags: false,
            addExtraRow: false,
            assignVariable: false,
            variableName: '',
            extraRowValue: '',
            extraRowDataColumn: '',
          },
          selected: false,
        },
        {
          type: 'BlockRepeatTask',
          dimensions: { width: 193, height: 149 },
          handleBounds: {
            source: [
              {
                id: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-1',
                position: 'right',
                x: 197.2124006448874,
                y: 66.6874815732158,
                width: 16,
                height: 16,
              },
              {
                id: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-2',
                position: 'right',
                x: 197.2124006448874,
                y: 113.3875114484557,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-input-1',
                position: 'left',
                x: -20.000129470007995,
                y: 66.6874815732158,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 2253, y: 263.5, z: 0 },
          id: '3d3e8fac-97fa-4c3d-84bc-a3db18740184',
          label: 'repeat-task',
          position: { x: 2253, y: 263.5 },
          data: { disableBlock: false, repeatFor: 2 },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 72 },
          handleBounds: {
            source: [
              {
                id: '4d39ecd5-f33f-4e57-b11d-2f26b1076334-output-1',
                position: 'right',
                x: 195.9998661589599,
                y: 27.999992440129862,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '4d39ecd5-f33f-4e57-b11d-2f26b1076334-input-1',
                position: 'left',
                x: -20.00023736594018,
                y: 27.999992440129862,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 2529.75, y: 304, z: 0 },
          id: '4d39ecd5-f33f-4e57-b11d-2f26b1076334',
          label: 'export-data',
          position: { x: 2529.75, y: 304 },
          data: {
            disableBlock: false,
            name: 'Lipsum',
            refKey: '',
            type: 'plain-text',
            description: '',
            variableName: '',
            addBOMHeader: false,
            onConflict: 'uniquify',
            dataToExport: 'data-columns',
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: { width: 192, height: 96 },
          handleBounds: {
            source: [
              {
                id: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-1',
                position: 'right',
                x: 196.00006103515625,
                y: 40.000038146972656,
                width: 16,
                height: 16,
              },
              {
                id: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-fallback',
                position: 'right',
                x: 196.00006103515625,
                y: 62.00000762939453,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-input-1',
                position: 'left',
                x: -20,
                y: 40.000038146972656,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: { x: 1135.5, y: 628, z: 0 },
          id: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c',
          label: 'go-back',
          position: { x: 1135.5, y: 628 },
          data: {
            disableBlock: false,
            onError: {
              retry: false,
              enable: true,
              retryTimes: 1,
              retryInterval: 2,
              toDo: 'fallback',
            },
          },
        },
      ],
      edges: [
        {
          id: 'edge-0',
          sourceHandle: 'c5774692-0be4-457f-82be-d5e4b3344ad7-output-1',
          targetHandle: '10a0429e-b8c4-4c04-9ea3-df169cea78e4-input-1',
          source: 'c5774692-0be4-457f-82be-d5e4b3344ad7',
          target: '10a0429e-b8c4-4c04-9ea3-df169cea78e4',
          class:
            'source-c5774692-0be4-457f-82be-d5e4b3344ad7-output-1 target-10a0429e-b8c4-4c04-9ea3-df169cea78e4-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-1',
          sourceHandle: '10a0429e-b8c4-4c04-9ea3-df169cea78e4-output-1',
          targetHandle: '24bdec44-1e80-4cee-9139-00545b8d33d9-input-1',
          source: '10a0429e-b8c4-4c04-9ea3-df169cea78e4',
          target: '24bdec44-1e80-4cee-9139-00545b8d33d9',
          class:
            'source-10a0429e-b8c4-4c04-9ea3-df169cea78e4-output-1 target-24bdec44-1e80-4cee-9139-00545b8d33d9-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-2',
          sourceHandle: '24bdec44-1e80-4cee-9139-00545b8d33d9-output-1',
          targetHandle: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae-input-1',
          source: '24bdec44-1e80-4cee-9139-00545b8d33d9',
          target: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae',
          class:
            'source-24bdec44-1e80-4cee-9139-00545b8d33d9-output-1 target-df24edcc-4c29-49f5-8a29-0e572a4bc6ae-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-3',
          sourceHandle: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae-output-1',
          targetHandle: '2d93c1de-42ca-4f39-8e61-e3e55529fbba-input-1',
          source: 'df24edcc-4c29-49f5-8a29-0e572a4bc6ae',
          target: '2d93c1de-42ca-4f39-8e61-e3e55529fbba',
          class:
            'source-df24edcc-4c29-49f5-8a29-0e572a4bc6ae-output-1 target-2d93c1de-42ca-4f39-8e61-e3e55529fbba-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-4',
          sourceHandle: '2d93c1de-42ca-4f39-8e61-e3e55529fbba-output-1',
          targetHandle: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-input-1',
          source: '2d93c1de-42ca-4f39-8e61-e3e55529fbba',
          target: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb',
          class:
            'source-2d93c1de-42ca-4f39-8e61-e3e55529fbba-output-1 target-0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-5',
          sourceHandle: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-output-1',
          targetHandle: 'fb9be12f-8995-4876-8bfe-79323769474b-input-1',
          source: '0f3e2baa-8d6d-4323-8ac7-362f1be39ecb',
          target: 'fb9be12f-8995-4876-8bfe-79323769474b',
          class:
            'source-0f3e2baa-8d6d-4323-8ac7-362f1be39ecb-output-1 target-fb9be12f-8995-4876-8bfe-79323769474b-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-6',
          sourceHandle: 'fb9be12f-8995-4876-8bfe-79323769474b-output-1',
          targetHandle: '7205fcf2-deda-445e-9690-4e36adb52585-input-1',
          source: 'fb9be12f-8995-4876-8bfe-79323769474b',
          target: '7205fcf2-deda-445e-9690-4e36adb52585',
          class:
            'source-fb9be12f-8995-4876-8bfe-79323769474b-output-1 target-7205fcf2-deda-445e-9690-4e36adb52585-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-7',
          sourceHandle: '7205fcf2-deda-445e-9690-4e36adb52585-output-1',
          targetHandle: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-input-1',
          source: '7205fcf2-deda-445e-9690-4e36adb52585',
          target: '3d3e8fac-97fa-4c3d-84bc-a3db18740184',
          class:
            'source-7205fcf2-deda-445e-9690-4e36adb52585-output-1 target-3d3e8fac-97fa-4c3d-84bc-a3db18740184-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-8',
          sourceHandle: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-1',
          targetHandle: '4d39ecd5-f33f-4e57-b11d-2f26b1076334-input-1',
          source: '3d3e8fac-97fa-4c3d-84bc-a3db18740184',
          target: '4d39ecd5-f33f-4e57-b11d-2f26b1076334',
          class:
            'source-3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-1 target-4d39ecd5-f33f-4e57-b11d-2f26b1076334-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-9',
          sourceHandle: '3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-2',
          targetHandle: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-input-1',
          source: '3d3e8fac-97fa-4c3d-84bc-a3db18740184',
          target: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c',
          class:
            'source-3d3e8fac-97fa-4c3d-84bc-a3db18740184-output-2 target-2f5fec61-a318-4e2b-b7d3-bc7328bd282c-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-10',
          sourceHandle: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-1',
          targetHandle: '24bdec44-1e80-4cee-9139-00545b8d33d9-input-1',
          source: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c',
          target: '24bdec44-1e80-4cee-9139-00545b8d33d9',
          class:
            'source-2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-1 target-24bdec44-1e80-4cee-9139-00545b8d33d9-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
        {
          id: 'edge-11',
          sourceHandle: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-fallback',
          targetHandle: '10a0429e-b8c4-4c04-9ea3-df169cea78e4-input-1',
          source: '2f5fec61-a318-4e2b-b7d3-bc7328bd282c',
          target: '10a0429e-b8c4-4c04-9ea3-df169cea78e4',
          class:
            'source-2f5fec61-a318-4e2b-b7d3-bc7328bd282c-output-fallback target-10a0429e-b8c4-4c04-9ea3-df169cea78e4-input-1',
          type: 'default',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
          markerEnd: 'arrowclosed',
        },
      ],
      position: [29, 97],
      zoom: 0.5,
    },
  },
  {
    id: nanoid(),
    name: 'Search in ProductHunt',
    createdAt: Date.now(),
    icon: 'https://res.cloudinary.com/chat-story/image/upload/v1648549611/61f54ef11c566274507d4070_Product_Hunt_j4hpfe.svg',
    drawflow: {
      nodes: [
        {
          type: 'BlockBasic',
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'MeMnYgI8DFrfORUfmREmq-output-1',
                position: 'right',
                x: 196.00003756009605,
                y: 28.000018780048062,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: {
            x: 96,
            y: 36,
            z: 0,
          },
          position: {
            x: 96,
            y: 36,
          },
          id: 'MeMnYgI8DFrfORUfmREmq',
          label: 'trigger',
          data: {
            disableBlock: false,
            description: '',
            type: 'context-menu',
            interval: 60,
            delay: 5,
            date: '',
            time: '00:00',
            url: '',
            shortcut: '',
            activeInInput: false,
            isUrlRegex: false,
            days: [],
            contextMenuName: 'Search in ProductHunt',
            contextTypes: ['selection'],
            parameters: [],
            observeElement: {
              selector: '',
              baseSelector: '',
              matchPattern: '',
              targetOptions: {
                subtree: false,
                childList: true,
                attributes: false,
                attributeFilter: [],
                characterData: false,
              },
              baseElOptions: {
                subtree: false,
                childList: true,
                attributes: false,
                attributeFilter: [],
                characterData: false,
              },
            },
          },
          selected: false,
        },
        {
          type: 'BlockBasic',
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'pdeg5g8-output-1',
                position: 'right',
                x: 196.00003756009605,
                y: 28.000018780048062,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'pdeg5g8-input-1',
                position: 'left',
                x: -19.99999999999999,
                y: 28.000018780048062,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: {
            x: 388,
            y: 36,
            z: 0,
          },
          position: {
            x: 388,
            y: 36,
          },
          label: 'new-tab',
          data: {
            disableBlock: false,
            description: '',
            url: 'https://www.producthunt.com/search?q={{variables@$ctxTextSelection}}',
            userAgent: '',
            active: true,
            inGroup: false,
            waitTabLoaded: false,
            updatePrevTab: false,
            customUserAgent: false,
          },
          id: 'pdeg5g8',
          selected: false,
        },
      ],
      edges: [
        {
          id: 'vueflow__edge-MeMnYgI8DFrfORUfmREmqMeMnYgI8DFrfORUfmREmq-output-1-pdeg5g8pdeg5g8-input-1',
          source: 'MeMnYgI8DFrfORUfmREmq',
          target: 'pdeg5g8',
          sourceHandle: 'MeMnYgI8DFrfORUfmREmq-output-1',
          targetHandle: 'pdeg5g8-input-1',
          updatable: true,
          selectable: true,
          type: 'default',
          markerEnd: '',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
        },
      ],
      position: [136.59999999999997, 279.20001831054685],
      zoom: 1.3,
    },
  },
  {
    id: nanoid(),
    createdAt: Date.now(),
    name: 'Google Keyword Research',
    icon: 'https://upload.wikimedia.org/wikipedia/commons/5/53/Google_%22G%22_Logo.svg',
    table: [
      {
        id: '25D2q',
        name: 'keyword',
        type: 'string',
      },
      {
        id: '38NQr',
        name: 'related',
        type: 'string',
      },
    ],
    drawflow: {
      nodes: [
        {
          computedPosition: {
            x: 96,
            y: 36,
            z: 0,
          },
          data: {
            activeInInput: false,
            contextMenuName: '',
            contextTypes: [],
            date: '',
            days: [],
            delay: 5,
            description: '',
            disableBlock: false,
            interval: 60,
            isUrlRegex: false,
            observeElement: {
              baseElOptions: {
                attributeFilter: [],
                attributes: false,
                characterData: false,
                childList: true,
                subtree: false,
              },
              baseSelector: '',
              matchPattern: '',
              selector: '',
              targetOptions: {
                attributeFilter: [],
                attributes: false,
                characterData: false,
                childList: true,
                subtree: false,
              },
            },
            parameters: [
              {
                defaultValue: '',
                name: 'keywords',
                placeholder: 'keyword 1,keyword 2',
                type: 'string',
              },
            ],
            shortcut: '',
            time: '00:00',
            type: 'manual',
            url: '',
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: '2VtN_ZVBleyrXpIe6hHqm-output-1',
                position: 'right',
                x: 196.000030930837,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: '2VtN_ZVBleyrXpIe6hHqm',
          label: 'trigger',
          position: {
            x: 96,
            y: 36,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 388,
            y: 36,
            z: 0,
          },
          data: {
            active: true,
            customUserAgent: false,
            description: '',
            disableBlock: false,
            inGroup: false,
            updatePrevTab: false,
            url: 'https://www.google.com/',
            userAgent: '',
            waitTabLoaded: false,
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'q2ayq0p-output-1',
                position: 'right',
                x: 195.99998279147678,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'q2ayq0p-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'q2ayq0p',
          label: 'new-tab',
          position: {
            x: 388,
            y: 36,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 680,
            y: 36,
            z: 0,
          },
          data: {
            code: "const keywords = automaRefData('variables', 'keywords');\nautomaSetVariable(\n  'keywords', \n  keywords.split(',').map((keyword) => keyword.trim())\n)",
            description: '',
            disableBlock: false,
            everyNewTab: false,
            preloadScripts: [],
            runBeforeLoad: false,
            timeout: 20000,
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'ls02uyr-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'ls02uyr-input-1',
                position: 'left',
                x: -19.999882316589357,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'ls02uyr',
          label: 'javascript-code',
          position: {
            x: 680,
            y: 36,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 972,
            y: 36,
            z: 0,
          },
          data: {
            description: '',
            disableBlock: false,
            elementSelector: '',
            fromNumber: 1,
            loopData: '[]',
            loopId: 'keywords',
            loopThrough: 'variable',
            maxLoop: 0,
            referenceKey: '',
            resumeLastWorkflow: false,
            startIndex: 0,
            toNumber: 10,
            variableName: 'keywords',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'xk53h8i-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'xk53h8i-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'xk53h8i',
          label: 'loop-data',
          position: {
            x: 972,
            y: 36,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 680,
            y: 158,
            z: 0,
          },
          data: {
            dataList: [
              {
                name: '25D2q',
                type: 'table',
                value: '{{loopData@keywords}}',
              },
            ],
            description: '',
            disableBlock: false,
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'f1fo1xh-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'f1fo1xh-input-1',
                position: 'left',
                x: -19.999882316589357,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'f1fo1xh',
          label: 'insert-data',
          position: {
            x: 680,
            y: 158,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 103.18645833333312,
            y: 284.19444444444446,
            z: 0,
          },
          data: {
            disableBlock: false,
            loopId: 'keywords',
          },
          dimensions: {
            width: 192,
            height: 117,
          },
          handleBounds: {
            source: [
              {
                id: 'xcsy0gj-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 50.68752097023858,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'xcsy0gj-input-1',
                position: 'left',
                x: -20.000026734670005,
                y: 50.68752097023858,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'xcsy0gj',
          label: 'loop-breakpoint',
          position: {
            x: 103.18645833333312,
            y: 284.19444444444446,
          },
          selected: false,
          type: 'BlockLoopBreakpoint',
        },
        {
          computedPosition: {
            x: 96,
            y: 158,
            z: 0,
          },
          data: {
            assignVariable: false,
            clearValue: true,
            dataColumn: '',
            delay: 70,
            description: '',
            disableBlock: false,
            events: [],
            findBy: 'cssSelector',
            getValue: false,
            markEl: false,
            multiple: false,
            optionPosition: '1',
            saveData: false,
            selectOptionBy: 'value',
            selected: true,
            selector: 'input[name="q"]',
            type: 'text-field',
            value: '{{loopData@keywords}}',
            variableName: '',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'uoxxd4x-output-1',
                position: 'right',
                x: 196.000030930837,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'uoxxd4x-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'uoxxd4x',
          label: 'forms',
          position: {
            x: 96,
            y: 158,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 388,
            y: 158,
            z: 0,
          },
          data: {
            disableBlock: false,
            loopId: 'options',
            maxLoop: 0,
            toNumber: 10,
            fromNumber: 1,
            startIndex: 0,
            loopData: '[]',
            description: '',
            variableName: '',
            referenceKey: '',
            elementSelector: '[role="listbox"] [role="option"]',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            resumeLastWorkflow: false,
            loopThrough: 'elements',
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'kz3rbur-output-1',
                position: 'right',
                x: 195.99998279147678,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'kz3rbur-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'kz3rbur',
          label: 'loop-data',
          position: {
            x: 388,
            y: 158,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 972,
            y: 158,
            z: 0,
          },
          data: {
            disableBlock: false,
            description: '',
            findBy: 'cssSelector',
            waitForSelector: false,
            waitSelectorTimeout: 5000,
            selector: '{{loopData@options}}',
            markEl: false,
            multiple: false,
            regex: '',
            prefixText: '',
            suffixText: '',
            regexExp: ['g', 'g', 'g'],
            dataColumn: '38NQr',
            saveData: true,
            includeTags: false,
            addExtraRow: false,
            assignVariable: false,
            useTextContent: false,
            variableName: '',
            extraRowValue: '',
            extraRowDataColumn: '',
          },
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: '5odnjn3-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: '5odnjn3-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          id: '5odnjn3',
          label: 'get-text',
          position: {
            x: 972,
            y: 158,
          },
          selected: false,
          type: 'BlockBasic',
        },
        {
          computedPosition: {
            x: 1227.7190972222222,
            y: 134.33854166666666,
            z: 1000,
          },
          data: {
            disableBlock: false,
            loopId: 'options',
          },
          dimensions: {
            width: 192,
            height: 117,
          },
          handleBounds: {
            source: [
              {
                id: 'th64xxb-output-1',
                position: 'right',
                x: 195.99998279147678,
                y: 50.68747283087836,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'th64xxb-input-1',
                position: 'left',
                x: -19.999978595309788,
                y: 50.68747283087836,
                width: 16,
                height: 16,
              },
            ],
          },
          id: 'th64xxb',
          label: 'loop-breakpoint',
          position: {
            x: 1227.7190972222222,
            y: 134.33854166666666,
          },
          selected: true,
          type: 'BlockLoopBreakpoint',
        },
        {
          type: 'BlockBasic',
          dimensions: {
            width: 192,
            height: 72,
          },
          handleBounds: {
            source: [
              {
                id: 'tts9dbc-output-1',
                position: 'right',
                x: 196.00007907019722,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
            target: [
              {
                id: 'tts9dbc-input-1',
                position: 'left',
                x: -19.999882316589357,
                y: 28.00001817279392,
                width: 16,
                height: 16,
              },
            ],
          },
          computedPosition: {
            x: 376.2090277777778,
            y: 307.24879056082835,
            z: 0,
          },
          position: {
            x: 376.2090277777778,
            y: 307.24879056082835,
          },
          label: 'export-data',
          data: {
            disableBlock: false,
            name: 'google-keywords',
            refKey: '',
            type: 'csv',
            description: '',
            variableName: '',
            csvDelimiter: ',',
            addBOMHeader: true,
            onConflict: 'uniquify',
            dataToExport: 'data-columns',
          },
          id: 'tts9dbc',
          selected: false,
        },
      ],
      edges: [
        {
          id: 'vueflow__edge-2VtN_ZVBleyrXpIe6hHqm2VtN_ZVBleyrXpIe6hHqm-output-1-q2ayq0pq2ayq0p-input-1',
          class: 'source-2VtN_ZVBleyrXpIe6hHqm-output-1 target-q2ayq0p-input-1',
          markerEnd: '',
          selectable: true,
          source: '2VtN_ZVBleyrXpIe6hHqm',
          sourceHandle: '2VtN_ZVBleyrXpIe6hHqm-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'q2ayq0p',
          targetHandle: 'q2ayq0p-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-q2ayq0pq2ayq0p-output-1-ls02uyrls02uyr-input-1',
          markerEnd: '',
          selectable: true,
          selected: false,
          source: 'q2ayq0p',
          sourceHandle: 'q2ayq0p-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'ls02uyr',
          targetHandle: 'ls02uyr-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-ls02uyrls02uyr-output-1-xk53h8ixk53h8i-input-1',
          markerEnd: '',
          selectable: true,
          source: 'ls02uyr',
          sourceHandle: 'ls02uyr-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'xk53h8i',
          targetHandle: 'xk53h8i-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'edge-6k9nnc2',
          class: 'source-uoxxd4x-output-1 target-kz3rbur-input-1',
          markerEnd: '',
          selectable: true,
          selected: false,
          source: 'uoxxd4x',
          sourceHandle: 'uoxxd4x-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'kz3rbur',
          targetHandle: 'kz3rbur-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-kz3rburkz3rbur-output-1-f1fo1xhf1fo1xh-input-1',
          class: 'source-kz3rbur-output-1 target-f1fo1xh-input-1',
          markerEnd: '',
          selectable: true,
          selected: false,
          source: 'kz3rbur',
          sourceHandle: 'kz3rbur-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'f1fo1xh',
          targetHandle: 'f1fo1xh-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-f1fo1xhf1fo1xh-output-1-5odnjn35odnjn3-input-1',
          class: 'source-f1fo1xh-output-1 target-5odnjn3-input-1',
          markerEnd: '',
          selectable: true,
          selected: false,
          source: 'f1fo1xh',
          sourceHandle: 'f1fo1xh-output-1',
          sourceX: 0,
          sourceY: 0,
          target: '5odnjn3',
          targetHandle: '5odnjn3-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-5odnjn35odnjn3-output-1-th64xxbth64xxb-input-1',
          class: 'source-5odnjn3-output-1 target-th64xxb-input-1',
          markerEnd: '',
          selectable: true,
          source: '5odnjn3',
          sourceHandle: '5odnjn3-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'th64xxb',
          targetHandle: 'th64xxb-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-th64xxbth64xxb-output-1-xcsy0gjxcsy0gj-input-1',
          class: 'source-th64xxb-output-1 target-xcsy0gj-input-1',
          markerEnd: '',
          selectable: true,
          source: 'th64xxb',
          sourceHandle: 'th64xxb-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'xcsy0gj',
          targetHandle: 'xcsy0gj-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-xk53h8ixk53h8i-output-1-uoxxd4xuoxxd4x-input-1',
          class: 'source-xk53h8i-output-1 target-uoxxd4x-input-1',
          markerEnd: '',
          selectable: true,
          source: 'xk53h8i',
          sourceHandle: 'xk53h8i-output-1',
          sourceX: 0,
          sourceY: 0,
          target: 'uoxxd4x',
          targetHandle: 'uoxxd4x-input-1',
          targetX: 0,
          targetY: 0,
          type: 'default',
          updatable: true,
          z: 0,
        },
        {
          id: 'vueflow__edge-xcsy0gjxcsy0gj-output-1-tts9dbctts9dbc-input-1',
          source: 'xcsy0gj',
          target: 'tts9dbc',
          sourceHandle: 'xcsy0gj-output-1',
          targetHandle: 'tts9dbc-input-1',
          updatable: true,
          selectable: true,
          type: 'default',
          markerEnd: '',
          z: 0,
          sourceX: 0,
          sourceY: 0,
          targetX: 0,
          targetY: 0,
        },
      ],
      position: [-7.494827206691525, 274.2219861731927],
      zoom: 0.6339423288575831,
    },
  },
];
