
# Windows Auto Dark Mode
![App Logo](https://raw.githubusercontent.com/AutoDarkMode/Windows-Auto-Night-Mode/master/Readme/msstore_award_banner.png)

Switches between the dark and light theme of Windows at scheduled times.

[Overview](#overview) • [Features](#features) • [Download](#download) • [Release Notes](https://github.com/Armin2208/Windows-Auto-Night-Mode/releases) • [Wiki](https://github.com/Armin2208/Windows-Auto-Night-Mode/wiki) • [Telegram Group](https://t.me/autodarkmode)

<a href="https://hosted.weblate.org/engage/auto-dark-mode/">
<img src="https://hosted.weblate.org/widgets/auto-dark-mode/-/svg-badge.svg" alt="Translation status" />
</a>

## Overview
![Screenshot showing Time-Page](https://github.com/Armin2208/Windows-Auto-Night-Mode/blob/master/Readme/screenshot1.png)
Tired of looking at dark content while the sun is shining brightly? But at night everything is suddenly too bright? Auto Dark Mode is the solution for you!

Android, iOS and MacOS already offer the possibility of changing the system design based on the time of the day. We're bringing this feature to Windows on a larger scale.

Auto Dark Mode helps you to be more productive. Because you shouldn't care about changing Windows settings several times a day. As soon as the sun goes down, we'll take care of your eyes.

Because a simple design change would be too boring, Auto Dark Mode is packed with useful functions. For example, we can also change your desktop wallpaper or run custom scripts.

## Features
![Screenshot showing Apps-Page](https://github.com/AutoDarkMode/Windows-Auto-Night-Mode/blob/master/Readme/screenshot4.png)
- Compatible with Windows 10* and Windows 11.
- Theme switch based on sunrise and sunset.
- Desktop wallpaper switch.
- Mouse cursor switch.
- Accent color switch.
- Office theme switch.
- Windows .theme file switch.
- Keyboard shortcuts.
- Support for turning on/off accent color on the Taskbar and title bars.
- Auto Dark Mode can enable the grayscale color filter of Windows.
- Suitable for gamers: Doesn't switch while playing games to avoid stuttering.
- Run custom scripts.
- Postpone or delay the next switch as you like.
- Automatic updates.
- Lightweight with clean uninstall. No admin rights needed.

<sup>*Windows 10 versions 21H1 and older are considered legacy, not all features may work</sup>

## Download

#### Download from Microsoft Store

<a href="https://apps.microsoft.com/store/detail/auto-dark-mode/XP8JK4HZBVF435">
  <img src="https://github.com/AutoDarkMode/Windows-Auto-Night-Mode/blob/master/Readme/GetItFromMicrosoftBadge.png?raw=true" alt="Click here to download Auto Dark Mode from the Microsoft Store" width="200"/>
</a>


#### Download from GitHub
[Click here to download the newest version of Auto Dark Mode!](https://github.com/Armin2208/Windows-Auto-Night-Mode/releases/latest)


#### Even more download options
<details>
  <summary>Click to expand</summary>

#### Via WinGet
Download Auto Dark Mode from [WinGet](https://github.com/microsoft/winget-cli/releases).
```powershell
winget install --id Armin2208.WindowsAutoNightMode
```

#### Via Chocolatey
Download Auto Dark Mode from [Chocolatey](https://chocolatey.org/packages/auto-dark-mode) (unofficial entry).
```powershell
choco install auto-dark-mode
```

#### Via Scoop
Download Auto Dark Mode from [Scoop](https://scoop.sh) (unofficial entry).
- Via portable
```powershell
scoop bucket add dorado https://github.com/chawyehsu/dorado
scoop install autodarkmode
```
- Via non-portable
```powershell
scoop bucket add nonportable
scoop install auto-dark-mode-np
```

</details>


#### Installation
Installation is pretty easy, as you only need to run the setup file provided as .exe. If you want to deploy Auto Dark Mode on multiple machines, you can use the argument _/allusers /verysilent_ to skip the installer window.
<br> <br>
Sometimes Windows or web browsers will show a security notice while downloading Auto Dark Mode. This is due to our lack of a developer license. You can ignore these messages.

## Translations

We use Weblate's cool [free Libre plan](https://hosted.weblate.org/hosting/) that supports open source software projects!
You can find our project here: https://hosted.weblate.org/projects/auto-dark-mode/app/
<p align="left">

<a href="https://hosted.weblate.org/engage/auto-dark-mode/">
<img src="https://hosted.weblate.org/widgets/auto-dark-mode/-/app/multi-auto.svg" alt="Translation status" />
</a>
</p>

Alternatively, you can manually edit the translation files in `AutoDarkModeLib/Properties/Resources`.


## More information
You still have open questions? [Check out our wiki!](https://github.com/Armin2208/Windows-Auto-Night-Mode/wiki)
