/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

export interface InferenceToken {
  token: string
  completed: boolean
}
export const enum InferenceResultType {
  Error = 'Error',
  Data = 'Data',
  End = 'End'
}
export interface InferenceResult {
  type: InferenceResultType
  data?: InferenceToken
  message?: string
}
export interface LogitBias {
  token: number
  bias: number
}
export interface Generate {
  nThreads: number
  nTokPredict: number
  /**
   * logit bias for specific tokens
   * Default: None
   */
  logitBias?: Array<LogitBias>
  /**
   * top k tokens to sample from
   * Range: <= 0 to use vocab size
   * Default: 40
   */
  topK?: number
  /**
   * top p tokens to sample from
   * Default: 0.95
   * 1.0 = disabled
   */
  topP?: number
  /**
   * tail free sampling
   * Default: 1.0
   * 1.0 = disabled
   */
  tfsZ?: number
  /**
   * temperature
   * Default: 0.80
   * 1.0 = disabled
   */
  temp?: number
  /**
   * locally typical sampling
   * Default: 1.0
   * 1.0 = disabled
   */
  typicalP?: number
  /**
   * repeat penalty
   * Default: 1.10
   * 1.0 = disabled
   */
  repeatPenalty?: number
  /**
   * last n tokens to penalize
   * Default: 64
   * 0 = disable penalty, -1 = context size
   */
  repeatLastN?: number
  /**
   * frequency penalty
   * Default: 0.00
   * 1.0 = disabled
   */
  frequencyPenalty?: number
  /**
   * presence penalty
   * Default: 0.00
   * 1.0 = disabled
   */
  presencePenalty?: number
  /**
   * Mirostat 1.0 algorithm described in the paper https://arxiv.org/abs/2007.14966. Uses tokens instead of words.
   * Mirostat: A Neural Text Decoding Algorithm that Directly Controls Perplexity
   * Default: 0
   * 0 = disabled
   * 1 = mirostat 1.0
   * 2 = mirostat 2.0
   */
  mirostat?: number
  /**
   * The target cross-entropy (or surprise) value you want to achieve for the generated text. A higher value corresponds to more surprising or less predictable text, while a lower value corresponds to less surprising or more predictable text.
   * Default: 5.0
   */
  mirostatTau?: number
  /**
   * The learning rate used to update `mu` based on the error between the target and observed surprisal of the sampled word. A larger learning rate will cause `mu` to be updated more quickly, while a smaller learning rate will result in slower updates.
   * Default: 0.1
   */
  mirostatEta?: number
  /**
   * stop sequence
   * Default: None
   */
  stopSequence?: string
  /**
   * consider newlines as a repeatable token
   * Default: true
   */
  penalizeNl?: boolean
  /** prompt */
  prompt: string
}
export interface ModelLoad {
  modelPath: string
  nCtx: number
  nGpuLayers: number
  seed: number
  f16Kv: boolean
  logitsAll: boolean
  vocabOnly: boolean
  useMlock: boolean
  embedding: boolean
  useMmap: boolean
  lora?: LlamaLoraAdaptor
}
export interface LlamaLoraAdaptor {
  loraAdapter: string
  loraBase?: string
  nThreads: number
}
export class LLama {
  static load(params: Partial<ModelLoad>, enableLogger: boolean): Promise<LLama>
  getWordEmbedding(params: Generate): Promise<Array<number>>
  tokenize(params: string): Promise<Array<number>>
  inference(params: Generate, callback: (result: InferenceResult) => void): () => void
}
