---
lang-ref: ch.15-2
lang: zh
lecturer: Alfredo Canziani
title: 训练隐藏变量基础模型（EBM）
authors:  Anu-Ujin Gerelt-Od, Sunidhi Gupta, Bichen Kou, Binfeng Xu
date: 31 Oct 2020
translator: Yang Zhou
translation-date: 05 Feb 2021

---

## [自由能](https://www.youtube.com/watch?v=XLSb1Cs1Jao&t=11s)

<!--Free energy:-->
自由能：

$$F_\infty (\vect{y})=\min_z E(\vect{y},z) = E(\vect{y},\check z)$$

<!--Here, $F_\infty$ is the zero temperature limit free energy, $\vect{y}$ is a 2D vector. This free energy is the quadratic euclidean distance from the model manifold, and all points that are within the model manifold have zero energy. As you move away, it’s going to increase up quadratically.-->

在这里，$F_\infty$ 是零温度极限自由能，$\vect{y}$ 是2D向量。该自由能为距离模型流形的二次欧几里得距离，且模型流形内的所有点的能量均为零。当您将点远离流形时，它将以平方增长。


<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure1.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 1:</b> 冷暖色图
</center>
<!--Cold: $F_\infty = 0$, warm: $F_\infty = 0.5$, hot: $F_\infty \geq 1$-->

冷：$F_\infty = 0$， 暖：$F_\infty = 0.5$， 热：$F_\infty \geq 1$

<!--All the regions around the ellipse that is with the manifold ellipse is going to have zero energy but at the centre, there is an infinite zero temperature limit free energy. In order to avoid this, we need to relax the free energy to one without local minima so that it becomes more smooth.-->

椭圆周围在流形椭圆是的所有区域都将具有零能量，但是在中心处存在无限的零温度极限自由能。为了避免这种情况，我们需要将自由能放宽到没有局部最小值的状态，以使其变得更加平滑。

<!--Let's take a closer look at $y_1=0$, with the following cold-warm map:-->

让我们用接下来的冷热图仔细看看在 $y_1=0$ 处的情况：

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure2.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 2</b>
</center>
<!--If we take $y_2=0.4$, then $F_\beta(\vect{y})=0$ and as we move linearly away from the point towards the right-hand side, the free energy increases quadratically. Similarly, if we move towards 0, you will end up climbing towards the parabola, creating a peak in the centre.-->

如果我们取 $y_2=0.4$， 那么 $F_\beta(\vect{y})=0$ 。当我们从该点向右侧线性移动时，自由能呈二次方增加。同样，如果我们向 $0$ 移动，你最终将沿着抛物线攀升，从而在中心形成一个峰值。

<!--Relaxed version of free energy-->

## 松弛版本的自由能

<!--In order to smooth the peak that we previously observed, we need to relax the free energy function such that:-->为了平滑我们先前观察到的峰值，我们需要放宽自由能函数：

$$F_\beta(\vect{y})\dot{=}-\frac{1}{\beta} \log \frac{1}{\vert\mathcal{Z}\vert}{\int}_\mathcal{Z} \exp[{-\beta}E(\vect{y},z)]\mathrm{d}z$$

<!--where $\beta=(k_B T)^{-1}$ is the inverse temperature, consisting of the Boltzmann constant multiplied by the temperature. If the temperature is very high, $\beta$ is going to be extremely small and if the temperature is cold, then $\beta\rightarrow \infty$.-->

其中 $\beta=(k_B T)^{-1}$ 是逆温度，由玻尔兹曼常数乘以温度组成。如果温度很高 $\beta$ 将会非常小，如果温度很冷，那么 $\beta\rightarrow \infty$。

<!--**Simple discrete approximation:**-->

**简单离散近似：**

$$\tilde{F}_\beta(\vect{y})=-\frac{1}{\beta} \log \frac{1}{\vert\mathcal{Z}\vert}\underset{z\in\mathcal{Z}}{\sum} \exp[{-\beta}E(y,z)]\Delta z$$

<!--Here, we define $-\frac{1}{\beta} \log \frac{1}{\vert\mathcal{Z}\vert}\underset{z\in\mathcal{Z}}{\sum} \exp[{-\beta}E(\vect{y},z)]$ to be the $\smash{\underset{z}{\text{softmin}}}_\beta[E(\vect{y},z)]$, such that the relaxation of the zero temperature limit free energy becomes the *actual*-softmin.-->

在这里，我们定义 $-\frac{1}{\beta} \log \frac{1}{\vert\mathcal{Z}\vert}\underset{z\in\mathcal{Z}}{\sum} \exp[{-\beta}E(\vect{y},z)]$  为 $\smash{\underset{z}{\text{softmin}}}_\beta[E(\vect{y},z)]$， 从而使松弛版本的零温度极限自由能成为*真正的* softmin。

<!--Example-->

**例子:**

<!--We will now revisit examples from the previous practicum and see the effects from applying the relaxed version.-->

现在，我们将回顾以前练习中的示例，并观察采用了松弛版本的效果。

情况 1: $\vect{y}'=Y[23]$

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure3.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 3</b>
</center>
<!--Points that are closer to the point $\vect{y}'$ will have smaller energy, and therefore the exponential will be larger, but for those that are further away the exponential will be zero.-->

靠近点 $\vect{y}'$ 的点具有更小的能量，因此指数将较大，但对于距离较远的那些，指数将为零。

情况 2: $\vect{y}'=Y[10]$

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 4</b>
</center>
<!--Notice how the colour-bar range changed from the previous example. The upper value here is derived from $\exp[-\beta E(\vect{y},z)]$.-->

请注意颜色栏范围与上一个示例之间的变化。这里的上限值是从 $\exp[-\beta E(\vect{y},z)]$  推导而来的。

情况 3: $\vect{y}'=(0,0)$

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 5</b>
</center>
<!--If we choose $\vect{y}'$ to be the origin, then all the points will contribute and the free energy will change symmetrically.-->

如果我们选择 $\vect{y}'$ 作为原点，那么所有的点都会起作用，自由能也会对称地变化。 

<!--Now, let's go back to how we can smooth the peak that formed due to the cold energy. If we choose the warmer free energy, we will get the following depiction:-->

现在，让我们回到如何平滑因冷能而形成的峰的问题上。如果我们选择了更暖一些的自由能，我们会得到如下描述。

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 6</b>
</center>
<!--As we increase the temperature by reducing $\beta$, the result is a parabola with a single global minima. As $\beta$ approaches 0, you will end up with the average and recover the MSE.-->

当我们通过降低温度 $\beta$ 来提高温度时，其结果为抛物线只有一个全局最小值。如 $\beta$ 接近0，你最终将得到平均值并恢复MSE。

<!--Nomenclature and PyTorch-->

## 命名方法和 PyTorch

<!--Formally, we define the <u>actual</u>-softmax as:-->

正式地，我们将<u>实际的</u> softmax 定义如下：

$$\smash{\underset{z}{\text{softmax}}}_\beta[E(y,z)] \doteq \frac{1}{\beta} \log \underset{z\in\mathcal{Z}}{\sum} \exp[{\beta}E(\vect{y},z)] - \frac{1}{\beta} \log{N_z}$$

其中 $N_z = \vert\mathcal{Z}\vert / \Delta z$.
<!--To implement the above function in PyTorch, use `torch.logsumexp` as below:-->

要在 PyTorch 中实现以上函数，可以如下所示使用 `torch.logsumexp`：

$$\smash{\underset{z}{\text{softmax}}}_\beta[E(y,z)] \doteq \frac{1}{\beta} \texttt{torch.logsumexp}({\beta}E(\vect{y},z),\texttt{dim=}z) - \frac{1}{\beta} \log{N_z}$$

<u>实际的</u> softmin:

$$\smash{\underset{z}{\text{softmin}}}_\beta[E(y,z)] \doteq -\frac{1}{\beta}\log\frac{1}{N_z}\underset{z\in\mathcal{Z}}{\sum}\exp[-{\beta}E(\vect{y},z)]$$

<!--Softmin can be implemented using softmax with 2 negative signs as follows:-->

可以使用带有2个负号的 softmax 来实现 softmin，如下所示：

$$\smash{\underset{z}{\text{softmin}}}_\beta[E(y,z)] = -\smash{\underset{z}{\text{softmax}}}_\beta[-E(y,z)]$$

$$\texttt{torch.softmax}(l(j),\texttt{dim=j}) = \smash{\underset{j}{\text{softargmax}_{\beta=1}}}[l(j)]$$

<!--In technical terms, if free energy is-->

从技术的角度看待，如果自由能是

- <!--hot, it refers to the average.--> 热的，它指平均值。
- <!--warm, it refers to the marginalization of the latent.--> 温的，它指隐变量的边缘化。
- <!--cold, it refers to the minimum value.--> 冷的，它指最小值。

## [训练 EBMs](https://www.youtube.com/watch?v=XLSb1Cs1Jao&t=1631s)

<!--Objective -  Finding a well behaved energy function-->

目标——寻找良好表现的能量函数

<!--A loss functional, minimized during learning, is used to measure the quality of the available energy functions. In simple terms, loss functional is a scalar function that tells us how good our energy function is. A distinction should be made between the energy function, which is minimized by the inference process, and the loss functional (introduced in Section 2), which is minimized by the learning process.-->

在学习过程中最小化的损失函数被用于测量可用的能量函数的质量。简单来说，损失函数是一个标量函数，它告诉我们能量函数有多好。我们应当区分能量函数和损失函数（在第2节中介绍的），能量函数通过推理过程最小化，而损失函数通过学习过程最小化。

$$\mathcal{L}(F(\cdot),Y) = \frac{1}{N} \sum_{n=1}^{N} l(F(\cdot),\vect{y}^{(n)}) \in \R$$

<!--$\mathcal{L}$ is the loss function of the whole dataset that can be expressed as the average of these per sample loss function functionals.-->

$\mathcal{L}$ 是整个数据集的损失函数，它可以被表示为每个样本的损失函数功能的平均值。

$$l_{\text{energy}}(F(\cdot),\check{\vect{y}}) = F(\check{\vect{y}})$$

<!--where $l_\text{energy}$ is the energy loss functional evaluated in $\vect{y}$ and $\vect{y}$ is the data point on the dataset. $\check{\vect{y}}$ indicates the data points that are to be pushed down. This means the loss functionals should be minimized while training.-->

其中 $l_\text{energy}$ 是能量损失函数在数据集上的数据点  $\vect{y}$ 的值。$\check{\vect{y}}$ 标明了下一个要被往下推的数据点。这意味着在训练过程中损失函数会被最小化。

<!--The Energy function should be small for data that comes from training distribution but large elsewhere.-->

对于来自训练数据分布的数据，能量函数应该较小，而在其他地方则较大。

$$l_{\text{hinge}}(F(\cdot),\check{\vect{y}},\hat{\vect{y}}) = \big(m - [F(\hat{\vect{y}})-F(\check{\vect{y}})]\big)^{+}$$

<!--where $m$ is the margin and $F(\check{\vect{y}})$ and $F(\hat{\vect{y}})$ are the free energies for "cold" (for correct labels) and "hot" energies (for incorrect labels) respectively.-->

其中 $m$ 是边界，$F(\check{\vect{y}})$ 和 $F(\hat{\vect{y}})$ 是”冷“能量（对于正确标签）和”热“能量（对于错误标签）的自由能。

<!--The model tries to make the difference between two energies to be larger than the margin $m$.-->

该模型试图使得两种能量的差值尽量大于边界 $m$。

<!--Understand that there is a `ReLU` function $[\cdot]^{+}$ used on the output of $m - [F(\hat{\vect{y}}) - F(\check{\vect{y}})]$, which means the value of this hinge loss function will always be non-negative. This implies if there are any negative values, they would become $0$ due to this function.-->

我们注意到在`ReLU` function $[\cdot]^{+}$ 被应用于输出 $m - [F(\hat{\vect{y}}) - F(\check{\vect{y}})]$上。这意味着，Hingle 损失函数值将始终保持非负。这表明了，如果存在任何的负值，它们都会因为这个函数而变成 $0$。

<!--Training will make $F(\hat{\vect{y}})-F(\check{\vect{y}})$ equal or grater than $m$. If the difference becomes greater than $m$, the overall value of $[m - [F(\hat{\vect{y}}) - F(\check{\vect{y}})]]$ becomes negative, the hinge loss becomes $0$. We can also say that we push the energies as long as the difference is less than $m$. However, if the difference becomes greater than the margin $m$, we stop pushing. Hinge Loss Function does not have a smooth margin.-->

训练将使得 $F(\hat{\vect{y}})-F(\check{\vect{y}})$ 等于或大于 $m$。如果差值变得大于 $m$，那么 $[m - [F(\hat{\vect{y}}) - F(\check{\vect{y}})]]$ 的最终结果将变负，Hinge 损失将变 $0$。我们也可以说，只要差值小于 $m$，我们就可以一直推动能量。然而，如果差值变得大于边界 $m$，我们需要停止推动能量。Hinge 损失函数并没有一个光滑的边界。

<!--Log loss functional has smooth margin as shown below:-->

Log 损失函数有光滑的边界，如下所示。

$$l_{\log}(F(\cdot),\check{\vect{y}},\hat{\vect{y}}) = \log(1+\exp[F(\check{\vect{y}})-F(\hat{\vect{y}})]) $$

<!--Since, we have an exponential function, this loss has a smoother margin. In other words, it seems like a “soft” version of the hinge loss with an infinite margin.-->

由于我们有指数函数，这种损失有更平滑的边界。换句话说，它们看起来像是具有无限边界的”柔软“版本的 Hinge 损失。

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure7.png" style="zoom: 80%; background-color:#DCDCDC;" /><br>
<b>图 7</b>
</center>
<!--The left hand side is the untrained version where for every training point, there is a corresponding x which is the location on the model manifold closest to the training point as seen in the picture. During training at ZTL (Zero Temperature Limit), the gradient makes the data point on the manifold that is closest to the training point be pushed towards the training point.-->
<!--We can see that after one epoch on the right hand side image, the trained version of the model shows the x points to arrive at the desired location and the energy goes to zero corresponding to the training points (blue points in the figure).-->

左侧是未经训练的版本，其中每个训练数据点都有一个对应的 $x$，如图中所示，它是模型流形上最靠近训练数据点的位置。在以ZTL（零温度极限）进行训练期间，梯度会使最接近训练数据点的流形上的数据点被推向训练数据点。

我们可以看到，在右侧图像上经过一次迭代之后，训练后的模型版本显示 $x$ 个点到达了所需位置，并且能量变为与训练点相对应的零（图中的蓝色点）。

<!--Let's talk about marginalization now. When the model is trained at ZTL and the temperature is increased, the points were picked individually to be pushed towards the training point. However, in case of marginalization, if we pick one point $\vect{y}$ (the green cross point on the left bottom image), the gradient is just the average of all the arrows pointing towards this particular point $\vect{y}$). This makes all the points that get pulled towards $\vect{y}$, making sure that it does not overfit the training data. Notice how the trained version does not fit over all of the training points.-->

现在让我们谈谈边缘化。当在ZTL训练模型并温度被提高时，数据点被分别推向训练数据点。但是，在边缘化的情况下，如果我们选择一个点 $\vect{y}$  （左下方图像上的绿色十字点），梯度只是指向该特定点的所有箭头的平均值 $\vect{y}$。这使得所有要点都趋向于 $\vect{y}$，以确保它不会过拟合训练数据。请注意受训版本有多不适合所有的训练数据点。

<!--Let us now see the cross-section of the trained version in this following plot. For the ZTL (${\beta = {\infty}}$), we can see that the free energy has a high peak. As we decrease ${\beta}$, the spike keeps on reducing and we reduce it till we get this smooth parabolic plot in blue, which is the plot in case of marginalization.-->

现在让我们在以下图表中查看训练版本的横截面。对于ZTL（${\beta = {\infty}}$），我们可以看到自由能具有很高的峰值。随着我们减少 ${\beta}$，尖峰会不断减小，我们持续减少它，直到我们获得蓝色的平滑抛物线图（这是边缘化情况下的图）。

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure8.png" style="zoom: 80%; background-color:#DCDCDC;" /><br>
<b>图 8</b> 自由能量
</center>



$$F_{\beta}(\vect{y}) \dot{=} -\frac{1}{\beta}\log\frac{1}{\vert\mathcal{Z}\vert}\int_\mathcal{Z}\exp[-{\beta}E(\vect{y},z)]\mathrm{d}z$$

<!--Now let us move on to Self-Supervised Learning (Conditional case).-->

现在让我们继续进入下一环节：自监督学习（有条件的情况）。

## [自监督学习](https://www.youtube.com/watch?v=XLSb1Cs1Jao&t=2577s)

<!--A revisit of the training data:-->

回顾训练数据：

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure9.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 9</b>
</center>
<!--During training, we are trying to learn the shape of the "horn".-->

在训练过程中，我们尝试学到”号角“的形状。

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 10</b> 未训练的模型流形
</center>


$$z = [0:\frac{\pi}{24}: 2\pi[\quad\text{(exclusive of }2\pi)$$

<!--$z$ takes values linearly, and is fed into the decoder to obtain $\tilde{\vect{y}}$, which will go around the ellipse.--> 

$z$ 线性取值，并被送入解码器得到 $\tilde{\vect{y}}$，得到的 $\tilde{\vect{y}}$ 会环绕椭圆。

$$x = [0:\frac{1}{50} :1]$$

<!--The predictor takes the observed x, and  feeds the result into the decoder.-->

预测器获得观测到的 $x$， 并将结果送入解码器。

<!--We perform zero temperature free energy training, which gives a result:-->

我们执行温度自由能训练，其结果为：

<center>
<img src="{{site.baseurl}}/images/week15/15-2/Figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>图 10</b> 未训练的模型流形
</center>

<!--Given the "horn", we take one point $\vect{y}$, find the closest point on the manifold and pull it towards $\vect{y}$.-->

对于给定的”号角“，我们选择一个数据点 $\vect{y}$， 找到流形上离它最近的点，并将其拉向 $\vect{y}$。

<!--In this case, the energy function is defined as-->

在这种情况下，能量函数被定义为

$$E(x,\vect{y},z) = [\vect{y}_{1} - f_{1}(x)g_{1}(z)]^{2} + [\vect{y}_{2} -f_{2}(x)g_{2}(z)]^{2}$$

其中

$$f,g:\mathbb{R} \rightarrow \mathbb{R}^{2}$$

$$
\begin{array}{l}
x \stackrel{f}{\mapsto} x \stackrel{\mathrm{L}^{+}}{\rightarrow} 8 \stackrel{\mathrm{L}^{+}}{\rightarrow} 8 \stackrel{\mathrm{L}}{\rightarrow} 2 \\
z \stackrel{g}{\mapsto}[\cos (z) \quad \sin (z)]^{\top}
\end{array}
$$

<!--The component of $g$ will be scaled by output of $f$.-->

$g$ 的部分被 $f$ 的输出缩放。

<!--The example data takes no time to train, but how do we move forward to generalize it?-->

示例数据不需要花费时间训练。但我们应该如何推广它呢？
$$
\begin{array}{l}
f: \mathbb{R} \rightarrow \mathbb{R}^{\operatorname{dim}(f)} \\
g: \mathbb{R}^{\operatorname{dim}(f)} \times \mathbb{R} \rightarrow \mathbb{R}^{2}
\end{array} \\
E(x, \vect{y}, z)=\left[\vect{y}_{1}-g_{1}(f(x), z)\right]^{2}+\left[\vect{y}_{2}-g_{2}(f(x), z)\right]^{2}
$$

<!--In this case the $g$ function takes $f$ and $z$, and $g$ can be a neural net. This time, the model has to learn that $\vect{y}$ moves around in circle, which is the $\sin$ and $\cos$ part we take for granted before.-->

在这个例子中，$g$ 函数获得 $f$ 和 $z$，而且 $g$ 可以使一个神经网络。这次，该模型需要学习 $\vect{y}$ 绕圈移动，也就是我们之前认为理所当然的 $\sin$ 和 $\cos$ 部分。

<!--Another issue is to determine the dimension of latent variable $z$.-->

另一个问题是需要确定隐变量 $z$ 的维度。
$$
\begin{array}{l}
f: \mathbb{R} \rightarrow \mathbb{R}^{\operatorname{dim}(f)} \\
g: \mathbb{R}^{\operatorname{dim}(f)} \times \mathbb{R}^{\operatorname{dim}(z)} \rightarrow \mathbb{R}^{2}
\end{array}\\
E(x, \vect{y}, z)=\left[\vect{y}_{1}-g_{1}(f(x), z)\right]^{2}+\left[\vect{y}_{2}-g_{2}(f(x), z)\right]^{2}
$$

<!--Since a high dimension latent will lead to overfitting. We need to regularize $z$. Otherwise, the model will memorize all the points, causing the energy to be zero across the space.-->

因为高维隐变量倾向于过拟合。我们需要正则化 $z$。否则，模型将会记住所有数据点，从而导致整个空间的能量为零。