---
lang-ref: ch.14-3
lang: zh
title: 过拟合与正则化
lecturer: Alfredo Canziani
authors: Karl Otness, Xiaoyi Zhang, Shreyas Chandrakaladharan, Chady Raach
date: 5 May 2020
translator: Yang Zhou
translation-date: 03 Feb 2021

---

## [过拟合（Overfitting）](https://www.youtube.com/watch?v=DL7iew823c0&t=101s)

<!--Consider a regression problem. A model could underfit, right-fit, or overfit.-->
当我们考虑一个回归问题时，一个模型可以欠拟合，正好拟合，或者过拟合。

<!--If the model is insufficiently expressive for the data it will underfit. If the model is more expressive than the data (as is the case with deep neural networks), it runs the risk of overfitting.-->
如果一个模型无法充分表达数据，那么它将会欠拟合。如果一个模型过度表达了数据（比如使用深度神经网络），那么它将会承受过拟合的风险。

<!--In this case, the model is powerful enough to fit both the original data *and* the noise, producing a poor solution for the task at hand.-->
在这种情况下，一个模型会强大到可以同时拟合原始训练数据*以及* 训练数据中的噪声，最后在真实任务中表现较差。

<!--Ideally we would like our model to fit the underlying data and not the noise, producing a good fit for our data. We would especially like to do this without needing to reduce the power of our models. Deep learning models are very powerful, often much more than is strictly necessary in order to learn the data. We would like to keep that power (to make training easier), but still fight overfitting.-->
在理想情况下，我们希望我们的模型拟合数据而非噪声，从而得到一个良好的拟合结果。我们还特别希望可以达到这个目标而不损失模型的表达能力。深度学习模型十分强大，而它常常会比学习数据所实际需要的模型强大很多。我们希望可以保持这种表达能力（而能更容易训练），但也希望网络能够对抗过拟合。

### 通过过拟合检查错误

<!--Overfitting can be useful in some cases, such as during debugging. One can test a network on a small subset of training data (even a single batch or a set of random noise tensors) and make sure that the network is able to overfit to this data. If it fails to learn, it is a sign that there may be a bug.-->
过拟合在有些情况下十分有用，比如在查错的过程中。我们可以在一小部分训练数据上（即使只是一个批次或者一些随机噪音张量）训练一个网络，从而确认这个网络可以过拟合这些数据。如果网络无法学习到这些数据的特点，那么这就是一个网络中可能存在错误的信号。

## 正则化 （Regularization）

<!--We can try to fight overfitting by introducing regularization. The amount of regularization will affect the model's validation performance. Too little regularization will fail to resolve the overfitting problem. Too much regularization will make the model much less effective.-->
我们尝试通过引入正则化来对抗过拟合。正则化的程度会影响到模型在验证数据集上的表现。过小的正则化会无法解决过拟合的问题，而过大的正则化会导致模型没有那么有效。

<!--*Regularization* adds prior knowledge to a model; a prior distribution is specified for the parameters. It acts as a restriction on the set of possible learnable functions.-->
*正则化* 给模型添加了先验知识，一个对于参数的先验分布。它可以限制可能学到的表达函数。

<!--Another definition of regularization from Ian Goodfellow:-->
另一个来自Ian Goodfellow的正则化的定义：

> <!--Regularization is any modification we make to a learning algorithm that is intended to reduce its generalization error but not its training error.--> 正则化是一项可以使我们减少泛化误差而非训练误差的修正。

### [初始化方法](https://www.youtube.com/watch?v=DL7iew823c0&t=1091s)

<!--We can select a prior for our network parameters by initializing the weights according to a particular distribution. One option: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).-->
我们可以通过根据特定分布初始化网络权重，从为我们的网络参数选择一个先验。其中以一种选项： [Xavier 优化](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_)

### 权重衰减正则化 （Weight Decay Regularization）

<!--Weight decay is our first regularisation technique. Weight decay is in widespread use in machine learning, but less so with neural networks.  In PyTorch, weight decay is provided as a parameter to the optimizer (see for example the `weight_decay` parameter for [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).-->
权重衰减是我们的第一种正则化技术。权重衰减在机器学习领域广泛应用，但在神经网络中的应用相对较少。在PyTorch中，权重修改是优化器的一个参数。（比如[SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)中的`weight_decay`参数）。

<!--This is also called:-->
这又被成为：

- L2
- Ridge
- <!--Gaussian prior--> 高斯先验

<!--We can consider an objective which acts on the parameters:-->
我们可以考虑带参数的目标函数

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

<!--then we have updates:-->

然后我们更新参数

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

<!--For weight decay we add a penalty term:-->

我们添加了一个惩罚项以实现权重衰减：

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

<!--which produces an update-->

它也产生了一个更新量

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

<!--This new term in the update drives the parameters $\theta$ slightly toward zero, adding some "decay" in the weights with each update.-->

新添加的项通过在每次更新中引入一些权重的“衰减”使得参数 $\theta$ 略微更趋近 $0$。

### L1 正则化

<!-- Available as an option for PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html). -->

在PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html) 中，这是一个可用的选项。

<!--Also called:-->

也可以被称作：

- <!--LASSO: Least Absolute Shrinkage Selector Operator--> LASSO： 最小绝对值收敛和选择算子
- <!--Laplacian prior--> Laplacian先验
- <!--Sparsity prior--> 稀疏先验

<!--Viewing this as a Laplace distribution prior, this regularization puts more probability mass near zero than does a Gaussian distribution.-->

我们可以把看作一个Laplace分布先验，这种正则化比高斯分布能使更多的概率质量分布于 $0$ 附近。

<!--Starting with the same update as above we can view this as adding another penalty:-->

我们可以从上述（权重衰减正则化）的更新步骤开始，并将这个步骤视为添加另一个惩罚项。

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

<!--which produces an update-->

它会产生一个更新量。

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

<!--Unlike $L_2$ weight decay, the $L_1$ regularization will "kill" components that are close to an axis in the parameter space, rather than evenly reducing the length of the parameter vector.-->

不同于 $L_2$ 权重衰减，$L_1$ 正则化会“清除”靠近参数空间的轴的部分， 而非只是减少参数向量的长度。

### Dropout

<!--Dropout involves setting a certain number of neurons to zero randomly during training. This prevents the network from learning a singular path from input to output. Similarly, due to the large parametrisation of neural networks, it is possible for the neural network to effectively memorize the input. However, with dropout, this is a lot more difficult since the input is being put into a different network each time since dropout effectively trains a infinite number of networks that are different each time. Hence, dropout can be a powerful way of controlling overfitting and being more robust against small variations in the input.-->

Dropout会在训练过程中随机置零一部分神经元，这样可以防止网络只学习到一条从输入到输出的路径。相似的，由于神经网络的庞大参数两，神经网络有可能会有效地“记住”输入。然后，Dropout使得“记住”输入变得更难，因为Dropout使每次训练的网络都不一样。因此，Dropout可以有效地控制过拟合，并且对于输入中的微小扰动更加鲁棒。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
图 1: 不采用Dropout的网络
</center>



<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
图 2: 采用Dropout的网络
</center>




<!--In PyTorch, we can set a random dropout rate of neuron.-->

在PyTorch中，我们可以为神经元设置一个随机Dropout率。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
图 3: Dropout 代码
</center>




<!--After training, during inference, dropout is not used any more. In order to create the final network for inference, we average over all of the individual networks created during dropout and use that for inference. We can similarly multiply all of the weights by $1/1-p$ where $p$ is the dropout rate.-->

在训练之后，Dropout不会在推理阶段使用。为了获得一个完整的可推理的网络，我们对所有采用了Dropout的网络取平均。我们可以简单地对所有权重乘以 $1/1-p$ ， 其中 $p$ 是Dropout率。

### 早停法

<!--During training, if the validation loss starts increasing, we can stop training and use the best weights found so far. This prevents the weights from growing too much which will start hurting validation performance at some point. In practise, it is common to calculate the validation performance at certain intervals and stop after a certain number of validation error calculations stop decreasing.-->

在训练过程中，如果验证损失开始增加，我们可以停止训练并且使用已经发现的最好的权重。这样可以防止权重过多增长以至于在某一时刻开始影响验证结果。在实践中，一般根据特定的间隔时间来计算验证结果，并在一定迭代次数内验证误差都停止继续下降的情况下终止训练。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
图 4: 早停法（Early stopping）
</center>



# 间接防止过拟合

<!--There are techniques that have the side-effect of regularizing parameters but are not regularisers themselves.-->

还存在一些其他非正则化的技术可以间接起到对参数正则化的作用。

## 批量归一化

<!--Q. How does batch norm make training more efficient?
A. We can use higher learning rate when applying batch norm.-->

提问：批量归一化是如何使训练更有效的？

回答：当采用批量归一化时，我们可以使用更高的学习率。

<!--Batch normalization is used to prevent the internal covariate shift of a neural network but there is a lot debate if it actually does this and what the true benefit actually is.-->

批量归一化被用于防止神经网络的内部协变量漂移，但学界也存在很多关于它是否真的达成了这点以及它的真正好处是什么的争辩。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
图 5: 批量归一化（Batch normalization）
</center>



<!--Batch normalisation essentially extends the logic of normalizing the input of the neural network to normalizing the input of each hidden layer in the network. The basic idea is to have a fixed distribution feed each subsequent layer of a neural network since learning occurs best when we have a fixed distribution. To do this, we compute the mean and variance of each batch before each hidden layer and normalize the incoming values by these batch specific statistics, which reduces the amount by which the values will ultimately shift around during training.-->

批量归一化将归一化网络输入的理念扩展到了归一化网络中每一隐藏层的输入。这背后基本的想法是：因为固定的概率分布可以有更好的学习效果，所以我们希望网络的每一层输入都有固定的概率分布。为了达到这个目标，我们在遇到每一隐藏层前都计算当前数据流的平均值和方差，并根据这一批次特定的统计数据归一化这一批次的输入数据。这样就可以在训练阶段减少数据最终的漂移量。

<!--Regarding the regularizing effect, due to each batch being different, each sample will be normalized by slightly different statistics based upon the batch it is in.  Hence, the network will see various slightly altered versions of a single input which helps the network learn to be more robust against slight variations in the input and prevent overfitting.-->

关于正则化的效果，由于每一批次的数据都不同，每一个样本都会根据它所在的批次被略微不同的统计数据归一化。因此，网络最终会遇到同一个输入的略微不同的多个版本。这样的操作帮助网络对于输入的轻微改变更加鲁邦，并且可以防止过拟合。

<!--Another benefit of batch normalisation is that training is a lot faster.-->

批量归一化的另一个好处是可以使训练快很多。

### 更多数据

<!--Gathering more data is a easy way to prevent overfitting but can be expensive or not feasible.--->

获得更多的数据是一种简单的防止过拟合的方法，但是这种方法过于昂贵或是不太可行。

### 数据增强

<!--Transformations using Torchvision can have a regularizing effect by teaching the network to learn how to be insensitive to perturbations.-->

使用Torchvision对输入数据进行变换可以通过教网络学到如何对扰动不敏感，从而起到正则化的作用。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
图 6: 使用Torchvision进行数据增强
</center>




### 迁移学习 (TF) 微调 (FT)

<!--Transfer learning (TF) refers to just training a final classifier on top of a pre-trained network (used in cases of little data generally).-->

迁移学习指只训练预训练网络最顶层的分类器。（一般用于只有较少数据的情况下）

<!--Fine tuning (FT) refers to training partial/full portions of the pre-trained network as well (used in cases where we have a lot of data generally).-->

迁移学习也指只训练预训练网络的部分或全部结构。（一般用于拥有很多数据的情况下）

<!--Q. Generally, when should we freeze the layers of a pre-trained model?
A. If we have little training data.-->

提问：一般来说，我们什么时候应该冻结预训练网络的网络层？

回答：如果我们只有很少的训练数据。

<!--4 general cases:
1) If we have little data with similar distributions, we can just do transfer learning.
2) If we have a lot of data with similar distributions we can do fine-tuning in order to improve the performance of the feature extractor as well.
3) If we have a little data and a different distribution we should remove a few of the final trained layers in the feature extractor since they are too specialized.
4) If we have a lot of data and they are from different distributions, we can just train all portions.-->

四种一般情况：

1）如果我们有很少的数据，它们具有相似的分布，我们可以只进行迁移学习。

2）如果我们有很多的数据，它们具有相似的分布，我们可以进行微调从而也提升特征提取模块的性能。

3）如果我们有很少的数据，它们具有不同的分布，我们应该从特征提取模块删除最后一些已训练的网络层，因为它们都过于针对预训练数据了。

4）如果我们有很多的数据，它们具有不同的分布，我们可以直接训练全部的网络。

<!--Note, we can also use different learning rates for different layers in order to improve performance.-->

注意，对于不同的网络层我们应该采用不同的学习率以提升性能。

<!--To further our discussion about overfitting and regularisation, let us look at the visualisations below. These visualisations were generated with the code from [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb).-->

让我们来看看下图的可视化结果以延伸我们关于过拟合和正则化的讨论。这些可视化由[Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb)中的代码生成。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>图 7:</b> 不采用Dropout的损失函数曲线
</center>



<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>图 8:</b> 采用Dropout的损失函数曲线
</center>



<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>图 9:</b> 正则化对权重的效果
</center>



<!--From Figure 7 and Figure 8, we can understand the dramatic effect that dropout has on generalisation error *i.e.* the difference between the training loss and validation loss. In Figure 7, without dropout there is clear overfitting as the training loss is much lower than the validation loss. However, in Figure 8, with dropout the training loss and validation loss almost continuously overlap indicating that the model is generalising well to the validation set, which serves as our proxy for out-of-sample set. Of course, we can measure the actual out-of-sample performance using a separate holdout test set.-->

从图7和图8， 我们可以裂解Dropout对于泛化误差的巨大影戏，其中泛化误差指的是训练损失函数和验证损失函数之间的差别。在图7中，在没有Dropout的情况下存在很明显的过拟合，训练损失函数远低于验证损失函数。然后，在图8中，在有Dropout的情况下，训练损失函数和验证损失函数几乎持续地保持重合。这代表着模型在代表着不包含训练数据的集合的验证集上泛化良好。

<!--In Figure 9, we observe the effect that regularisation (L1 & L2) have on the weights of the network.-->

在图9中，我们对（L1和L2）正则化对于网络模型权重的影响进行观察。

- <!--When we apply L1 regularisation, from the red peak at zero, we can understand that most of the weights are zero. Small red dots closer to zero are the non-zero weights of the model.-->当我们采用L1正则化时，从零位置的红色峰，我们可以发现大多数权重为零 。在靠近零处的一些小红点是模型的非零权重。

- <!--Contrastingly, in L2 regularisation, from the lavender peak near zero we can see that most of the weights are close to zero but non-zero.-->相反的，在L2正则化中，从靠近零处的紫峰我们可以看出大多数的权重靠近零而非零。

- <!--When there is no regularisation (blue) the weights are much more flexible and spread out around zero resembling a normal distribution.-->当未采用正则化（蓝）时，权重分布更加灵活，并且在零位置附近散布形成正态分布。

## [贝叶斯神经网络：估计预测值的不确定度](https://www.youtube.com/watch?v=DL7iew823c0&t=2970s)

<!--We care about uncertainty in neural networks because a network needs to know how certain/confident on its prediction.-->

我们关心神经网络中的不确定性，因为网络需要知道它对于预测结果的确信度。

<!--Ex: If you build a neural networks to predict steering control, you need to know how confident the network's predictions.-->

例子：如果你搭建了一个神经网络以预测汽车的转向控制量，你需要知道网络的预测有多可靠。

<!--We can use a neural network with dropout to get a confidence interval around our predictions. Let us train a network with dropout, $r$ being the dropout ratio.-->

我们可以训练一个带有Dropout的神经网络来获得我们的预测值附近的置信范围。让我们来训练一个带有Dropout的网络，$r$ 是Dropout率。

<!--Usually during inference, we set the network to validation mode and use all neurons to get the final prediction. While doing the prediction, we scale the weights $\delta$ by $\dfrac{1}{1-r}$ to account for dropping neurons during training.-->

通常，在推理过程中，我们会将网络设置为验证模式并使用所有的神经元来得到最终的预测结果。在预测的过程中，我们将权重 $\delta$ 乘上 $\dfrac{1}{1-r}$ 以抵消训练过程中丢弃神经元带来的影响。

<!--This method gives us a single prediction for each input. However, to get a confidence interval around our prediction, we need multiple predictions for the same input. So instead of setting the network to validation mode during inference, we retain it in training mode *i.e.* still drop neurons randomly and get a prediction. When we predict multiple times using this dropout network, for the same input we will get different predictions depending on the neurons being dropped. We use these predictions to estimate the average final prediction and a confidence interval around it.-->

这种方法可以对于每一个输入给予我们一个单独的预测值。然而，为了获得预测值附近的置信度，我们需要对同一输入进行多次预测。相比较于在推理过程中将网络设置为验证模式，我们将其保持为训练模式，意味着我们随机丢弃一些神经元并得到一个测试结果。当我们使用这个Dropout网络进行多次预测时，对于相同的输入，我们会根据神经元被丢弃的情况获得不同的预测结果。我们使用这些预测结果来估计一个平均的最终输出，以及一个置信区间。

<!--In the below images, we have estimated confidence intervals around the predictions of networks. These visualisations were generated with the code from [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). The red line represents the predictions. The purple shaded region around the predictions represent the uncertainty *i.e.* variance of predictions.-->

在下面的两张图中，我们估计网络预测值附近的置信区间。这些可视化结果是通过[Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb)中的代码生成的。红线代表着预测值，预测值周围的紫色阴影区间代表着不确定度，也就是预测值的方差。

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>图 10:</b> 使用ReLU激活的不确定度估计
</center>



<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>图 11:</b> 使用Tanh激活的不确定度估计
</center>



<!--As you can observe in the above images, these uncertainty estimations are not calibrated. They are different for different activation functions. Noticeably in the images, uncertainty around data points is low. Furthermore, the variance that we can observe is a differentiable function. So we can run gradient descent to minimise this variance. Thereby we can get more confident predictions.-->

正如你在上图中观察到的，这些不确定度的估计是未被校准的。对于不同的激活函数，它们都不同。在图片中我们可以注意到，数据点附近的不确定度较低。更进一步，我们可以发现这些方差是可微函数。所以我们可以通过推理梯度下降来最小化这些方差，从而我们可以获得更确信的预测结果。

#### 如果我们的EBM模型的总损失由多项构成，它们之间会如何影响？

<!--In EBM models, we can simply and conveniently sum the different terms to estimate the total loss.-->

在EBM模型中，我们可以简化并简单地将不同项加起来以估计总损失函数。

<!--**Digression**: A term that penalises the length of the latent variable can act as one of many loss terms in a model. The length of a vector is roughly proportional to the number  of dimensions it has. So if you decrease the number of dimensions, then the length of the vector decreases and as a result it encodes less information. In an auto-encoder setting, this makes sure that the model is retaining the most important information. So, one way to bottleneck information in latent spaces is to reduce the dimensionality of the latent space.-->

**题外话** 一个惩罚隐变量长度的项可以成为损失函数中的一项。一个向量的长度一般大致和它的维度成正比。所以如果你减少了维度，那么向量的长度也会减少，最终向量编码的信息也会减少。在自编码器的设定中，这能保证模型保留了最重要的信息。所以，限制隐空间中的信息量的一种方法是减少隐空间的维度。

#### 我们如何确定正则化的超参数？

<!--In practice, to determine the optimal hyper-parameter for regularisation *i.e.* regularisation strength we can use-->

从实践的角度，我们可以使用以下方法确定最优的超参数（比如正则化强度）

- <!-- Bayesian hyper-parameter Optimization -->贝叶斯超参数优化
- <!--Grid Search-->网格搜索
- <!-- Random Search-->随机搜索

<!--While doing these searches, the first few epochs are usually enough to give us a sense of how the regularization is working. So we need train the model extensively.-->

在采用这些搜索技术时，前几轮的结果就应该足够可以让我们理解正则化是如何运行的。所以我们需要花很多时间训练模型。

