---
lang-ref: ch.14-2
lang: zh
lecturer: Yann LeCun
title: 图能量模型
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
translator: Yang Zhou
translation-date: 31 Jan 2021

---



## [损失函数对比](https://www.youtube.com/watch?v=gYayCG6YyO8&t=3622s)

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
图 1: 网络结构
</center>

<!--In the figure above, incorrect paths have $-1$. -->
在上图中，错误的路径被标为 $-1$ 。

<!--Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.-->
在上图中的例子中，Transformer图模型使用了Perceptron误差。我们的目标是使得错误答案的能量尽量大，正确答案的目标尽量小。 

<!--In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.-->
从算法实现的角度，你会用向量表示图示中的弧线。相比较于对每个类别使用不同的弧线，单个向量就同时包含了所有类别和每个类别的分数。

<!--Q: How is the segmentor implemented in the model above?-->
提问：上述模型中的分割模型是如何实现的？

<!-- A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition. -->
回答：分割模型是人工启发式的。尽管有其他的方法可以实现端到端的训练，但该模型使用了一个人工的分割。这种人工方法在字母识别中被滑动窗口的方法所取代。



<!-- Overview of losses-->
## 损失函数概述

<center>
表 1: 不同的损失函数
</center>




| 损失函数      |                             公式                             | 边界 |
| :------------ | :----------------------------------------------------------: | ---: |
| Energy Loss   |         $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$         | None |
| Perceptron    | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ |    0 |
| Hinge         | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ |  $m$ |
| Log           | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ |   >0 |
| LVQ2          | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ |    0 |
| MCE           | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$ |   >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ |  $m$ |
| Square-Exp    | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ |   >0 |
| NNL/MMI       | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ |   >0 |
| MEE           | $1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ |   >0 |

<!-- The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.-->
Perceptron损失在上表中似乎没有边界，但也正因如此，这种损失存在数值爆炸的风险。

* <!--Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.--> Hinge损失是偏差最大的答案和正确答案的能量差值。从直观上可以理解为，对于边界 $m$，当正确答案的能量至少低于偏差最大的答案的能量 $m$ 时，Hinge损失只会是0。
* <!--MCE loss is used in speech recognition, and looks similar to a sigmoid.-->  MCE损失被用于语音识别，看上去和Sigmoid相近。
* <!--NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.--> NLL 损失的目标是使得正确答案的能量尽量小，并且使得公式中的对数部分尽量大。

<!--Q: How may hinge be better than NLL loss?-->
提问：为什么Hinge损失比NLL损失更好？

<!--A: Hinge is better than NLL because NLL will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m).-->
回答：Hinge损失比NLL损失更好的原因为：NLL鼓励正确答案和其他答案的能量差值趋于无穷，而Hingle损失只鼓励差值大于固定数值（边界 $m$ ）。

### 定义:

<!--A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.-->
一个解码器以一串向量作为输入，这串向量表示分数或单独的声音/图像的能量，然后解码器选择其中最有可能的输出作为结果。

<!--Q: What are some examples of problems that can use decoders?-->
提问：什么问题可以使用解码器？

<!--A: Language modelling, machine translation, and sequence tagging.-->
回答：语言模型，机器翻译或者序列标注。

## Transformer图模型中的前向算法

### 图构成（Graph Composition）

<!--Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.-->
我们可以通过图构成来结合两张图。在这个例子中，我们可以看到一个语言模型词典被表示为Trie图和一个用神经网络生成的识别图。

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>图 2</b>: 图构成（Graph Composition）
</center>



<!--The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.-->
识别图通过不同的能量数值（相对于每一条弧线）来标明一个字母在某个特别的步骤的可能性。

<!--Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?-->
现在，我们想问一个关于图构成操作的问题作为例子：哪条在识别图中的路径是符合我们的词典的最佳路径？

<!--The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values.-->

识别图和语法图从第一步到第二步的共同的Hop是字母 $c$ ，相关联的能量是 $0.4$。因此，我们的解释图在第一步和第二步之间只包含了一条对应于 $c$ 的弧线。相似的，识别图中可能位于第二步和第三步间的字母为 $x$, $u$ 和 $a$。在语法图中位于 $c$ 之后的分支包含了 $u$ 和 $a$。所以，图构成操作选择了 $u$ 和 $a$ 作为解释图中的弧线。它也关联了从识别图中复制而来的弧线和对应的能量值。

<!--If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.-->
如果语法图也包含了弧线上的能量值，图构成操作会添加这些能量值或把它们与其他的操作结合起来。

<!-- In a similar fashion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discussed above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node. -->
相似的，图构成也允许我们结合两个不同的用神经网络表达的知识。在上述示例中，一个预测下一字母的神经网络表达了语法。神经网络的Softmax输出向我们提供了从一个给定节点转移至下一节点的转移概率。

<!--As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.-->
另外，如果例子中的语言模型是一个神经网络，我们可以在整个结构中进行反向传播。这就成为了一个包含了循环，条件判断，递归等操作的可以反向传播的可微分程序。

### 来自九十年代中期的支票读取器

<!--The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph.-->
来自九十年代中期的支票读取器的整体结构是比较复杂的，但我们主要感兴趣的部分从产生识别图的字母识别环节开始。

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>图 3</b>: 支票读取器
</center>



<!--This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.-->
识别图经过了两个独立的构成操作，第一个利用正确的解释（或者说真实值），第二个利用语法创建了包含所有可能解释的图。

<!--The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.-->
整个系统通过Negative Log-Likelihood损失函数进行训练。Negative Log-likelihood表明解释图中的每条路径都是一种可能的解释，而这条路径上的能量和就是这个解释的能量。

<!--Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.-->
现在，相比较于Viterbi算法，我们选择使用前向算法。在下一个小节我们将讨论这两种方法的区别。

#### Viterbi 算法

<!--Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.-->
Viterbi算法是一种动态规划算法，它被用于找到指定图中最有可能的路径（拥有最小能量的路径）。它相对于隐变量 $z$ 优化能量使其最小，这里的 $z$ 代表图中的路径。

$$F (x, y) = \min_{z} \; E(x, y, z)$$

#### [前向算法](https://www.youtube.com/watch?v=gYayCG6YyO8&t=4518s)

<!--The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:-->
前向算法计算所有路径的负能量的指数之和的对数。这可以轻易地从以下的公式中看出：

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

<!--This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combining the cost of all possible paths in a soft-minimum way.-->
这个操作在边缘化隐变量 $z$， 它定义了解释图中的路径。这种方法计算了抵达特定节点的所有可能路径的指数之和的对数。这就像在以一种软性最小化的方式结合所有可能路径的代价。

<!--The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.-->
前向算法的实现十分节约资源并且不比Viterbi算法有更大的花费。而且，我们可以对图中所有前向算法节点进行反向传播。

<!--The working of the forward algorithm can be shown using the following example defined on an interpretation graph.-->
前向传播的成功可以通过下面这个定义在解释图上的例子来证明。

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>图 4</b>: 解释图
</center>

<!--The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.-->
从输入节点到红色阴影节点的代价是通过边缘化所有可能通向红色节点的路径。 在我们的例子中，指向红色的箭头定义了这些可能的路径。

<!--For the red node, the value of energy at the node is given by:-->
对于红色节点，该节点的能量值为：

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

#### 前向传播算法的神经网络类比

<!--The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term.-->
前向算法是置信度传播算法在图蜕化为链图时特殊形式。整个算法可以被看做是一个前向传播的神经网络，每个节点函数为一个指数和的对数与一个额外项。
<!--For each node in the interpretation graph, we maintain a variable $\alpha$.-->

我们对于解释图中每一个节点都维护一个变量 $\alpha$。

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

<!--where $e_{ki}$ is the energy of the link from node $k$ to node $i$.-->

其中的 $e_{ki}$ 是节点 $k$ 到节点 $i$ 的边的能量。

<!--$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.-->

$\alpha_i$ 组成了神经网络中节点  $i$ 的激活值，而 $e_{ki}$ 是连接节点 $k$ 和 节点 $i$ 的边的权重。这样的模型在代数上等同于一个神经在对数域上的加权和操作。

<!--We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of  $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.-->

我们可以对一个应用了前向算法的动态（对于不同的例子，图会改变）解释图进行反向传播。我们可以在图的末尾节点上对于定义在解释图的边上的边权重 $e_{ki}$ 计算梯度  $F(x, y)$。

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>图 5</b>: 支票读取器
</center>




<!--Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential formula. The difference between these energy values is the negative log-likelihood loss.-->

我们回到支票阅读器的例子，我们对两个图构成使用了前向算法并且通过使用指数和的对数的计算公式得到了末尾节点的能量值。这两个能量值的差值就是Negative log-likelihood 损失。

<!--The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations.-->

位于识别图和正确答案之间的在图构成上使用前向算法得到的的结果是正确答案的指数和的对数。相对的，位于识别图和语法图之间的图构成上最后一个节点的指数和的对数，是所有可能可行解释的边缘值。

## [反向传播的拉格朗日形式](https://www.youtube.com/watch?v=gYayCG6YyO8&t=5573s)

<!--For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.-->

对于输入 $x$ 和 目标输出 $y$， 我们可以用一系列函数建模一个网络。$f_k$ 作为权重，$w_k$ 用于网络输出 $z_k$ 之后的步骤 $z_{k+1} = f_k(z_k, w_k)$。在监督学习的设定中，网络的优化目标是最小化网络的第 $n$ 个结果相对于真值的代价：$C(z_n, y)$，这等价于相对于限制条件 $z_{k+1} = f_k(z_k, w_k)$ 和  $z_0 = x$，最小化 $C(z_n, y)$。

<!--The Lagrangian can be written:-->

拉格朗日项可以被写作：

$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
<!--where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).-->

其中 $\lambda$ 项表示拉格朗日乘子 （详见 [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) 作为复习材料）。

<!--To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.-->

为了最小化 $\mathcal{L}$， 我们需要将$\mathcal{L}$ 相对于每个输入的偏导数设为 $0$ 并求解。

- <!--For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.--> 对于 $\lambda$， 我们简单地将该限制条件还原：$\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$。
- <!--For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.--> 对于 $z_k$， $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$， 这一步只是标准的反向传播公式。

<!--This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.-->

这个方法由拉格朗日和汉密尔顿在经典力学的背景下提出，其中最小化的目标是整个系统的能量，而 $\lambda$ 项表示了系统的物理限制，例如：两个球被一个铁杆限制在固定距离内。

<!--In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes-->

在我们需要每步优化代价 $C$ 的情况下，拉格朗日项变为 $$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.

## 神经偏微分方程

<!--Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.-->

通过采用这种形式的反向传播，我们可以讨论一种新模型：神经偏微分方程（Neural ODEs）。这些网络大体上是一种循环神经网络，其中，$t$ 时刻的状态 $z$ 被定义为 $ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $。$W$ 代表一些固定的参数。这也可以用普通的微分方程（非偏微分方程）来表达：$\frac{\text{d}z}{\text{d}t} = f(z_t, W)$。

<!--Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).-->

通过采用朗格朗日公式来训练这样的网络是十分直接的。如果我们拥有目标 $y$ ，并且我们希望系统状态在时刻 $T$ 到达 $y$，我们可以简单将代价函数设为 $z_T$ 和 $y$ 的距离。网络的另一个目标可以是找到系统的稳定状态，*比如*，在某时刻后，系统不再改变。从数学上说，这等同于 $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$ 的设定。总体来说，使用这种方法找到一个方程的解  $y$ 比反向传播更容易，因为网络不需要记住相对于整个序列的梯度，并只需要优化 $f$ 或 $\lvert f \rvert^2$。对于更多训练神经偏微分方程来达到不动点的信息，可以参考 [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf)。 

## [能量角度的变分推断](https://www.youtube.com/watch?v=gYayCG6YyO8&t=6522s)

<!--For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute-->

对于一个基本的能量函数 $E(x,y,z)$， 如果我们想要针对一个变量 $z$ 边缘化以获得一个只包含 $x$ 和 $y$ 的损失 $L(x,y)$， 我们必须计算

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

<!--If we then multiply by $\frac{q(z)}{q(z)}$, we get-->

如果我们乘上 $\frac{q(z)}{q(z)}$， 我们会获得

$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!--If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.-->

如果我们假设 $q(z)$ 是 $z$ 的概率分布，我们可以把我们重写后的损失函数中的积分结果解释为一个相对于 $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$ 的分布的期待值。

<!--We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.-->

我们使用这种解释，琴生不等式和基于采样的估计，来间接地优化我们的损失函数。

## 琴生不等式

<!--Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:-->

琴生不等式是以下情况的一种几何观察：如果我们有一个凸函数，那么处于一定范围的函数的*期待值*是这个函数在范围两端的结果的平均值。从几何上展示这一点是十分直观的：

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>图 6:</b> 琴生不等式 (来源 [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>



<!--Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,-->

类似的，如果 $F$ 是凸的，那么对于一个固定的概率分布 $q$， 我们可以通过琴生不等式推得，在一定范围 $z$ 上，

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

<!--Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,-->

现在，回想起我们的边缘化后的乘上了 $\frac{q(z)}{q(z)}$ 的 $L(x,y)$

$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!--If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that-->

如果我们令 $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$，我们可以从琴生不等式 $(1)$ 得到

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

<!--Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$-->

我们再用一个具体的凸损失函数，$F(x) = -\log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

<!--Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.-->

很好！现在我们通过两个我们能够理解的项得到了我们的损失函数 $L(x,y)$ 的上界，第一项 $\int_z q(z)E(x,y,z)$ 是*平均* 能量，第二项 $\frac{1}{\beta}\int_z\log(q(z))$ 是分布 $q$ 的*熵* 乘上了一个标量（$-\frac{1}{\beta}$）。

## 要点

<!--We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!-->

我们现在通过一种方法表达了上界，这种方法避免了复杂的积分，而采用在一个我们选择的替代分布（ $q(z)$ ）上采样来简单估计这些值。

<!-- To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.-->

为了得到我们的上界公式的第一项，我们只需要在这个分布中采样，并计算采用了我们采样的 $z$ 的 $L$ 的平均值。

<!--The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.-->

第二项（熵的倍数）只是这种分布的一个特点，可以被相似地使用随机采样 $q$ 来估计。

<!--Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$.-->

最后，我们通过最小化 $L$ 的上界来相对于$L$ 的参数 （网络权重 $W$）最小化 $L$。我们通过更新两个变量来优化：（1）$q$ 的熵 （2）模型参数 $W$。

## 总结

<!--This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimise this upper bound, and in doing so minimize the function we actually care about.-->

本章节从能量角度看待变分推断（variantonal inference）。如果你需要计算指数之和的对数，你可以用你的损失函数的平均值加上一个熵项来替换。这样的替换提供了一个上界。接着我们最小化这个上界，从而最小化我们的损失函数。