---
lang-ref: ch.14-1
lang: zh
lecturer: Yann LeCun
title: 用于结构化预测的深度学习
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
translator: titusjgr
translation-date: 18 Sep 2020
---

<!-- ## Structured Prediction -->
## 结构化预测

<!-- It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values. -->
结构化预测这种问题是对给定的输入 x 预测变数 y，其中输出值彼此相关且带有限制，而是离散或实数的标量。并且输出的变数并非属于特定的类别，而是具有指数多个或者无穷多的可能值。
<!-- For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain. -->
例如：在语音识别、手写识别，或是自然语言翻译，输出必须符合语法，而且不能限制可能的输出的数量。模型的工作为捕捉在问题领域的循序、空间、或组合的结构。


<!-- ### Early works on structured prediction -->
### 结构化预测的早期工作

<!-- This vector is fed to a TDNN which gives a feature vector which in case of model systems can be compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used. -->
这个向量被喂给一个 TDNN（时延神经网络），它给出一个特征向量（等同代表类别的 softmax）。其中一个语音识别遇到的状况是，同一个词可能不同的人发音速度或方法不同。我们使用动态时间规整来解决这个问题。

<!-- The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates. -->
想法是为系统提供一组预先录制，对应到录下的某人的序列或者特征向量的模板。神经网络训练时同时使用这些模板，使得系统学会识别不同发音下的词汇。潜变量使我们得以将特征向量延时以配合模板的长度。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center>

<!-- This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance. -->
这可以视觉化为矩阵，藉由将来自 TDNN 的特征向量水平排列，词汇模板垂直排列。矩阵中的每个元素对应到特征向量间的距离。这可以视觉化为一个图的问题：目标是从左下角以最短路径抵达右上角。

<!-- To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every incorrect answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients. -->
为训练这个潜变数模型，我们得使正确答案的能量尽量小，错误答案的能量尽可能大。为此我们使用一个目标函数，它会接收错误词汇的模板并且将它们推离目前的特征序列，并且将梯度反向传播。


<!-- ## Energy based factor graphs -->
## 基于能量的因子图

<!-- The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The 
benefit of these models is that efficient inference algorithms can be employed. -->
基于能量的因子图的想法是要建立一个能量基础模型，其中的能量是各项部份的能量的和或者当几率是因子的积。这些模型的优点是可以利用高效的推断算法。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center>


<!-- ### Sequence Labeling -->
### 序列标记

<!-- The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term. -->
模型接受一个说话的声音讯号 X 并输出使得总能量最小化的标记 Y。
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center>

<!-- In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels. -->
此处，能量是蓝色方块代表的三个项，也就是为输入变数产生特征向量的神经网络。就语音识别而言，X 可以想作声音讯号，方块实作文法限制，而 Y 代表生成的输出标记。


<!-- ## Efficient Inference for Energy-Based Factor Graphs -->
## 基于能量的因子图的高效推断

<!-- A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006): -->
能量基础学习教程 (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006)：

<!-- Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks. -->
用能量基础模型进行学习与预测牵涉到最小化答案 $\mathcal{Y}$ 和潜变数 $\mathcal{Z}$ 的能量。当 $\mathcal{Y} \times \mathcal{Z}$ 的基数很大时，最小化的过程可能变得难以追踪。其中一种解法是善用能量函数的结构以有效最小化。一种能善用结构的例子是当能量能被表达为一些函数（称作因子）的和，而这些函数各自依赖于 Y 和 Z 中不同组变数的子集。这些依赖适合用因子图的方式来表示。因子图是一种概率图模型或信念网络的一般型。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center>

<!-- A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors: -->
Figure 19 展示了一个单纯的因子图。能量函数是四个因子的和：

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

<!-- where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding: -->
其中 $Y = [Y_1, Y_2]$ 是输出变数，$Z = [Z_1, Z_2]$ 是潜变数。每个因子可视为代表对输入变数的软性限制。推断的问题是要找：

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

<!-- Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations). -->
先假定 $Z_1$, $Z_2$, 和 $Y_1$ 是离散的二元变数，$Y_2$ 是三元变数。$X$ 的定义域的基数并不重要，因为 X 总是会被观测。给定 X 之下 $Z$ 和 $Y$ 可能的组合的数量有 $2 \times 2 \times 2 \times 3 = 24$。一个朴素的，经由穷举的最小化算法会计算能量函数 24 次（96 次的因子计算）。

<!-- However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence, -->
然而，我们注意到对给定的 $X$，$E_a$ 只有两种可能的输入组合：$Z_1 = 0$ 和 $Z_1 = 1$。相似地，$E_b$ 和 $E_c$ 只有 4 种可能的输入组合，而 $E_d$ 有 6 种。总共只需要 $2 + 4 + 4 + 6 = 16$ 单一的因子计算。

<!-- Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom). -->
因此，我们可以预先计算 16 个因子的数值，如 Figure 19（下方）将它们放在格子中的弧上。

<!-- The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general. -->
每一列的节点代表一个变数的可能值。每个边的权重是因子根据对应输入变数输出的能量。在这种表示之下，一个从开始节点到最终节点的路径代表一种可能的变数组合。路径权重的和代表该组合的能量。故推断的问题可以归约为寻找图中的**最短路径**，能够运用动态规划的方法例如 Viterbi 算法或者 A* 算法来解决。损失会与边的数量成比例（16），也就是指数小于总共的路径数量。

<!-- To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$. -->
要计算 $E(Y, X) = \min_{z\in Z} E(Y, z, X)$ 时，使用同样的程序，只是我们会将图限制到那些跟定下的 $Y$ 相容的弧的子集。


<!-- The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure. -->
以上的程序有时被称作 min-sum 算法，它是传统的图的 max-product 算法的对数域版本。这个过程很容易能推广到接受多于两个变数输入的因子图，和树状结构而非链状结构的因子图。


<!-- However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent algorithm such as simulated annealing could be used. -->
然而，它仅适用于二分树（无环）的因子图。当图里有环，min-sum 算法可能给出近似解，也可能完全不收敛。此时可以使用如模拟退火这种下降算法。


<!-- ## Simple Energy-Based Factor Graphs with “Shallow” Factors -->
## 单纯的，具有浅的因子的基于能量的因子图

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center>

<!-- The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about) -->
Figure 20 中是在对数域中线性结构模型的因子图（也就是我们所说单纯的，具有浅的因子的基于能量的因子图）。

<!-- Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation: -->
每个因子都是具有可训练参数的线性模型。它依赖于输入与一对的标记 $(Y_m, Y_n)$。总的来说，每个因子都可以依赖于超过两个标记，但我们会只讨论成对的因子来简化符号：

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

<!-- Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$ -->
这里 $\mathcal{F}$ 代表因子的集合（一对对有着直接互相依赖的关系的标记的集合），$W_{m n}$ 是因子 $(m, n)$ 的参数，而 $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ 是个（固定的）特征向量。全域的参数向量 $W$ 是串接所有 $W_{m n}$。


<!-- And then we can think about like what type of loss function. Here comes several different models. -->
接着我们可以想想要用何种损失函数，这里有几种模型。


<!-- ### Conditional Random Field -->
### 条件随机场

<!-- We can use the negative log-likelihood loss function to train a linear structured model. -->
我们可以用负对数似然损失函数来训练一个线性结构模型。

<!-- This is the Conditional Random Field -->
这是条件随机场。

<!-- The intuition is we want the energy of the correct answer to below and want the log of exponential for all the answers, including the good one, to be large. -->
直觉上来说，我们希望正确答案的能量要小，而所有答案（包含那些较好的）的指数取对数之后要大。

<!-- Below is the formal definition for the negative log-likelihood loss function: -->
底下是负对数似然损失的正式定义：

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$


<!-- ### Max Margin Markov Nets and Latent SVM -->
### 最大边界马可夫网络与潜支持向量机

<!-- We can also using the Hinge loss function for optimization. -->
我们也可以用合页损失做优化。

<!-- The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway. -->
想法是我们希望正确答案的能量可以很小，而在所有可能的错误答案中，找到有着最低能量的。接着我们要增加它的能量。其它答案就不用，因为它们已经有较高的能量。

<!-- This is the idea behind Max Margin Markov Nets and Latent SVM. -->
这就是最大边界马可夫网络和潜支持向量机的概念。


<!-- ### Structured Perceptron model -->
### 结构化感知器模型

<!-- We can train the linear structured model by using perceptron loss. -->
我们可以用感知器损失训练线性结构化模型。

<!-- Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP:-->
Collins [Collins, 2000, Collins, 2002] 提倡在 NLP 使用感知器损失：


$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

<!-- where $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ is the answer produced by the system. -->
其中 $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ 是系统找到的答案。


<!-- #### Early trails on discriminative training for speech/handwritten recognition. -->
#### 早期用于语音、手写识别的判别训练

<!-- Minimum Empirical Error Loss (Ljolje, and Rabiner 1990): -->
最小经验误差损失 (Ljolje, and Rabiner 1990)：

<!-- By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use neural networks, and have other ways in turning speech signals into sound categories. -->
在序列的层次进行训练，他们不告诉系统对应的声音或位置，而是给系统输入的语句和逐字稿，并且要系统藉延时自己找出来。他们并没有使用神经网络，而是使用其它方法把语音信号转为声音类别。


<!-- ## Graph Transformer Net -->
## 图变换网路

<!-- Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works. -->
这里的问题是我们有一个数字的序列作为输入但不知如何分段。我们可以建立一个图其中每个路径都是一种分段方法，接着找出最小能量的路径，基本上就是找最短路径。这里是一个具体的示例。

<!-- We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink. -->
我们有输入图像 34。将其输入分段器，得到多种分割方法。这些分段都是可以组合小区段的方式。每一道路径都对应到一种组合这些笔迹的方式。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center>

<!-- We run each through the same charecter recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird form of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies. -->
我们将每一种都输入相同的字元识别卷积网络，得到 10 个分数（这里写了 2 个但是应该有 10 个，对应 10 个分类）。举例来说，1 [0.1] 代表类别 1 的能量是 0.1。所以这里有一个图，或者想像成一个奇怪的张量。它其实是一个稀疏的张量。这张量标明每一种变数的组合的损失。其实它更像是张量的一个分部，或者是对数分布因为我们讨论的是能量。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center>

<!-- Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7. -->
拿到这个图之后我们要来计算正确答案的能量。我先说正确解答是 34。找到抵达 34 的路径，有两个，能量各自为 3.4 + 2.4 = 5.8 和 0.1 + 0.6 = 0.7。选择有最低能量的路径，这里就是 0.7。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center>

<!-- So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path. -->
所以寻找路径就像最小化潜变数，其中潜变数是我们选择的路径。概念上而言，它是一个以潜变数为路径的能量模型。

<!-- Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, neural net is regular and the Path Selector and Viterbi Transformer are basically swtiches that pick a particular edge or not. -->
我们已经算出正确路径的能量：0.7。我们现在所需要做的就是将梯度反向传播，以改变卷积网络中的权重，使总能量下降。虽然看起来很困难，但完全是办的到的。因为整个系统都是由我们已知的元素组成，神经网络是普通的，路径选择器和 Viterbi 转换器只是表达是否选择某个边的开关。

<!-- So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set  the gradeint for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and wil come back to this later. Then you can backpropagate gradient through the neural net. That will make the energy of the correct answer small. -->
那要如何反向传播呢？首先点 0.7 是 0.1 + 0.6。所以点 0.1 和 0.6 的梯度是 +1，如括弧内所写。接下来，Viterbi 转换器只是在两条路径中择一，所以只要把梯度复制到对应的边并将其他边设为 0，正如使用最大值池化或平均值池化时一样。路径选择器的情况也是一样，只是选择正确答案的系统。注意图中的 3 [0.1] (0) 在此刻应该是 3 [0.1] (1)，我们稍后会回到这里。接着你可以在网络中反向传播梯度，以减低正确答案的能量。

<!-- What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of neural net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the suitation where things like PyTorch are really important. -->
重要的是，这个结构是动态的，因为当我们收到一个新的输入，神经网络的数量会随着分段的数量而改变，导出的图也会不同。我们必须反向传播过这个动态结构。这就是 PyTorch 能派上用场的地方了。

<!-- This phase of backpropagation make the energy of correct answer small. And there's going to be a second phase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discriminative training for structure prediction that use perceptual loss. -->
这一阶段的反向传播使正确答案的能量变小。而在第二阶段我们要使错误答案的能量上升。此时，我们让系统任意选择它要的答案，进行一种简化的判别训练做结构化预测，并使用感知器损失。

<!-- The first stages of phase two are exactly the same with the first phase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether this path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phase one, since the energy get here is the smallest among all possible paths. -->
第二阶段的第一步和第一阶段完全相同。Viterbi 转换器选择有着最低能量的路径，我们不在乎到底是正确与否。此处得到的能量会小于等于第一阶段得到的，因为我们按照最小能量选择路径。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figure 10.
</center>

<!-- Putting phase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perceptron loss. -->
将两阶段放在一起，损失函数应该要是第一阶段能量减去第二阶段的能量。之前我们介绍了如何在左半边反向传播，我们现在要在整个结构中反向传播。在左边的路经会得到 +1，而右侧的路径会是 -1，所以 3 [0.1] 出现在两边，应该得到梯度 0。这样做最终系统会最小化正确答案和最佳答案之间的能量插。这里的损失函数是感知机损失。

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figure 11.
</center>


<!-- ## Comprehension Questions and Answers -->
## 理解问答


<!-- #### Question1: Why is inference easy in the case of energy-based factor graphs? -->
#### 问题 1：为何基于能量的因子图的推断很容易？

<!-- Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead. -->
在具有潜变数的能量基础模型中，推断需要使用穷举的方法例如梯度下降来最小化能量，然而在此的能量可以由各因子累加，能够用动态规划的技巧处理。
<!--  -->
<!--  -->
<!-- #### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm? -->
#### 问题 2：如果因子图中的潜变数是连续变数呢？我们还是能使用 min-sum 算法吗？
<!--  -->
<!-- We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference. -->
不能，因为这样无法寻找所有可能组合。然而，此时能量也给我们一个好处，因为我们可以做独立优化。像在 Figure 19 中 $Z_1$ 和 $Z_2$ 只影响 $E_b$。我们可以做独立的优化和动态规划来进行推断。

<!-- #### Question3: Are the NN boxes refering to seperate ConvNets? -->
#### 问题 3：NN 的箱子是指不同的卷积网络吗？

<!-- They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network. -->
他们是共用的。只是同一个字元识别网络的多个复制。
