---
lang: zh 
translator: Jonathan Sum(😊🍩📙)
translation-date: 16 Sep 2020
lang-ref: ch.13-2
title: 图形卷积网络 II
lecturer: Xavier Bresson
authors: Neil Menghani, Tejaishwarya Gagadam, Joshua Meisel and Jatin Khilnani
date: 27 Apr 2020
---

## [光谱图形卷积网络(Spectral Graph ConvNets , 英文简称GCNs)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=2670s)

在之前的部份，我們討論了圖形卷積網絡的理論，用兩個方法之一來決定用在圖形上的捲積，也我們現在能夠用來決定我們的光譜圖形卷積網絡。


### 基本型的光譜圖形卷積網絡(Vanilla Spectral GCN)

我們定義了一個圖形光譜層，比如我們叫它為$h^l$，這個下一層的激活值是這樣:

$$
h^{l+1}=\eta(w^l*h^l),
$$

<!-- where $\eta$ represents a nonlinear activation and $w^l$ is a spatial filter. The RHS of the equation is equivalent to $\eta(\hat{w}^l(\Delta)h^l)$ where $\hat{w}^l$ represents a spectral filter and $\Delta$ is the Laplacian. We can further decompose the RHS of the equation into $\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$, where $\boldsymbol{\phi}$ is the Fourier matrix and $\Lambda$ is the eigenvalues. This yields the final activation equation as below. -->
這裡的$\eta$代表一個非線性激活和$w^l$代表一個空間性的過濾器。這個方程的
右側是等於$\eta(\hat{w}^l(\Delta)h^l)$，這裡的$\hat{w}^l$代表一個光譜過濾器，而$\Delta$是拉普拉斯(Laplacian)。我們可以更進一步分解程式的右側為$\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$，而$\boldsymbol{\phi}$是就是傅立葉矩陣(Fourier matrix)和$\Lambda$是特徵值。這就生成下方最後的程式。

$$
h^{l+1}=\eta\Big(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l\Big)
$$

<!-- The objective is to learn the spectral filter $\hat{w}^l(\lambda)$ using backpropagation instead of hand crafting. -->
目標是為了用反向傳播，而不是人手外加的，去學到一個光譜過濾器 $\hat{w}^l(\lambda)$。

<!-- This technique was the first spectral technique used for ConvNets, but it has a few limitations:
* No guarantee of spatial localization of filters
* Need to learn $O(n)$ parameters per layer ($\hat{w}(\lambda_1)$ to $\hat{w}(\lambda_n)$)
* Learning rate is $O(n^2$) because $\boldsymbol{\phi}$ is a dense matrix -->
這個方法過去時第一個用在卷積網路上的光譜性技巧，但它有多個局限性:
* 無法保證有空間區域性的過濾器
* 要去學由($\hat{w}(\lambda_1)$ 到 $\hat{w}(\lambda_n)$)每一層的O(n)那麼多的參數
* 學習率是$O(n^2$)因為$\boldsymbol{\phi}$是緊密矩陣(dense matrix)


<!-- ### SplineGCNs -->
樣條式圖形卷積網絡(SplineGCNs)

<!-- SplineGCNs involve computing smooth spectral filters to get localized spatial filters. The connection between smoothness in frequency domain and localization in space is based on Parseval's Identity (also Heisenberg uncertainty principle): smaller derivative of spectral filter (smoother function) $\Leftrightarrow$ smaller variance of spatial filter (localization). -->
樣條式圖形卷積網絡涉及計算平穩的空間性過濾器來取得一些空間區域性的過濾器。這個在頻域和在空間區域性的關係是由帕塞瓦爾恆等式(Parseval's identity)和也包括海森堡不確定性原理(Heisenberg uncertainty principle)一起建立出來的，方式是這樣:光譜過濾器的導數中較細的數值(較平穩的函數)$\Leftrightarrow$空間性(區域)過濾器中較細的方差。

<!-- How do we get a smooth spectral filter? We decompose the spectral filter to be a linear combination of $K$ smooth kernels $\boldsymbol{B}$ (splines) so that $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. The activation equation the is as the following. -->
我們如何去取得一個平穩的光譜過濾器?我們分解光譜過濾器我們如何去取得一個平穩的光譜過濾器?我們把光譜過濾器分解為$K$平穩內核$\boldsymbol{B}$(樣條，英文:splines)的線性組合，所以$\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$，(diag: 對角矩陣)。這個激活方程式是如下方這樣。


$$
h^{l+1}=\eta\bigg(\boldsymbol{\phi} \Big(\text{diag}(\boldsymbol{B}w^l)\Big)\boldsymbol{\phi^\top} h^l\bigg)
$$
(diag: 對角矩陣)

<!-- Now, we only have $O(1)$ parameters (constant $K$) per layer to be learned through backpropagation. However, the learning complexity is still $O(n^2)$. -->
現在，我們只有$O(1)$個參數，參數為常數$K$，每層的參數是可以由反向傳播進行學習。相反，學習的複雜度還是$O(n^2)$。


<!-- ### LapGCNs -->
### 重疊式圖形卷積網絡(LapGCNs)

<!-- How do we learn in linear time $O(n)$ (w.r.t. graph size $n$)? The $O(n^2)$  complexity is a direct result of using Laplacian eigenvectors. We need to avoid eigen-decomposition, which can be achieved by directly learning a function of the Laplacian. The spectral function will be a monomial of the Laplacian as shown here. -->
我们如何在图形大小为$n$的，而只用一个线性的$O(n)$时间如何去学习?那使用拉普拉斯特征向量的直接带来的效果为$O(n^2)$复杂度。我们要避免「特征分解」，这一点可以由一个直接地学习一点个函数做到。这个光谱函数会是单项式的拉普拉斯，下方所示。

$$
w*h=\hat{w}(\Delta)h=\bigg(\sum^{K-1}_{k=0}w_k\Delta^k\bigg)h
$$

<!-- One nice feature is that filters are localized in exactly k-hop supports. -->
一个很好的功能就是过滤器是完全地被所有k-hop连接起来，看起来就如被k-hop支撑起来一样(这称为k-hop supports.)。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<!-- <b>Figure 1:</b> Demonstrates 1-hop and 2-hop neighbourhoods -->
<b>图1: </b>展示1-hop和2-hop邻域
</center>

<!-- We replace the expression $\Delta^kh$ with $X_k$, a recursive equation defined as, -->
我们替换表达式「$\Delta^k 」为「$X_k$」，一个递归方程式就如这样定义

$$
X_k=\Delta X_{k-1} \text{ and } X_0=h
$$

<!-- Complexity is now $O(E.K)=O(n)$ for sparse (real-world) graphs. We can reshape $X_k$ into $\bar{X}$ to form a linear operation. We now have the following activation equation. -->
那现在，稀疏（现实中）图形的复杂度现在为$O(E.K)=O(n)$。我们可以把$X_k$的大小转为$\bar{X}$来构成一个线性运算。我们现在就有下方这个激活方程。

$$
h^{l+1}=\eta\bigg(\sum^{K-1}_{k=0}w_kX_k\bigg)=\eta\Big((w^l)^\top \bar{X}\Big)
$$

<!-- Note: Since no Laplacian eigen-decomposition is used, all operations are in the  spatial (not spectral) domain, so calling them Spectral GCNs may be misguided. Further, another drawback of LapGCNs is that convolutional layers involve sparse linear operations, which GPU's are not fully optimized for. -->
注意: 因为没有用上拉普拉斯特征分解，所有运算都是在空间的域，而不是光谱性的域，所以叫它们为光谱式图形卷积网络是有点误导性的。更进一步的，重叠式图形卷积网络另一个缺陷就是卷积层是包含稀疏线性运算，也就是现在的GPU们不是在这方面有被完全优化过。

<!-- We now have resolved the 3 limitations of Vanilla GCNs through localized filters (in $K$-hop support), $O(1)$ parameters per layer and $O(n)$ learning complexity. However, the limitation of LapGCNs is that monomial basis ($\Delta^0,\Delta^1,\ldots$) used is unstable for optimization because it is not orthogonal (changing one coefficient changes the function approximation). -->
我们现在用这三个做法解决了三个基本版图形卷积网络的限制，第一是用位置性过滤器($K$-hop support)，第二是用每层为$O(1)$参数，第二是用$O(n)$学习复杂度。不过，重叠式图形卷积网络的限制是因为用了单项式基底($\Delta^0,\Delta^1,\ldots$)，这些基底是在优化中不稳定的，因为它不是正交的，也就是改变一个系数就改变函数的近似值。


<!-- ### ChebNets -->
### 切布网路(ChebNets)

<!-- To resolve the issue of unstable basis we can use any orthonormal basis, but it must have a recursive equation to ensure linear complexity. For ChebNets we use Chebyshev polynomials, and as in a LapGCN we represent the expression $T_k(\Delta)h$ (Chebyshev function applied to $h$) by $X_k$, a recursive equation defined as, -->
为了去解决这个不稳定基底问题，我们可以用任何正交基底，但它必须要有一个递归方程式来确保有一个线性复杂度。对于切布网路，我们用切比雪夫多项式，而在重疊式圖形卷積網絡中，我們用$X_k$,來代表這個表達式$T_k(\Delta)h$，也就是在$h$上用上了切比雪夫函數的表達式，這樣一個遞歸方程就如下方定義，

$$
X_k=2\tilde{\Delta} X_{k-1} - X_{k-2}, X_0=h, X_1=\tilde{\Delta}h  \text{ 和 } \tilde{\Delta} = 2\lambda_n^{-1}\Delta - \boldsymbol{I}
$$

<!-- Now we have stability under coefficient perturbation. -->
現在我們就在系数扰动(coefficient perturbation)下有穩定性。

<!--ChebNets are GCNs that can be used for any arbitrary graph domain, but the limitation is that they are isotropic. Standard ConvNets produce *anisotropic* filters because Euclidean grids have direction, while Spectral GCNs compute *isotropic* filters since graphs have no notion of direction (up, down, left, right). We can extend ChebNets to multiple graphs using a 2D spectral filter. This may be useful, for example, in recommender systems where we have movie graphs and user graphs. Multi-graph ChebNets have the activation equation as below. -->
切布网路們都是圖形卷積網絡，它能夠用在任何任意的圖形領域上，但限制是它們都是各向同性的。標準的卷積网生成各向異性的過濾器，那是因為歐幾里得格子(Euclidean grids)是有方向的，同時光譜圖形卷積網絡計算各向同性過濾器，這是因為國形沒有方向這個概念，比如上下左右。我們可以延伸切佈網路到多重使用一個2d光譜過濾器的圖形。這或許是有用的，比如，在推薦系統中，我們有影片圖形和用戶圖形。多重圖形切佈網路有激活方程，下方所示。

$$
h^{l+1}=\eta(\hat{w}(\Delta_1,\Delta_2)*h^l)
$$


<!-- ### CayleyNets -->
### 凱利網路(CayleyNets)

<!-- ChebNets are unstable to produce filters (localize) with frequency bands of interest (graph communities). In CayleyNets, we instead use as our orthonormal basis Cayley rationals. -->
凱利網路在其對應的頻段中生成局部性過濾器時，就生成得不穩定，而這是在眾多圖形中看得出來的。在凱利網路中，我們改為使用正交基底凱利有理化數(orthonormal basis Cayley rationals.)。

$$
\hat{w}(\Delta)=w_0+2\Re\left\{\sum^{K-1}_{k=0}w_k\frac{(z\Delta-i)^k}{(z\Delta+i)^k}\right\}
$$

<!-- CayleyNets have the same properties as ChebNets (are isotropic), but they are localized in frequency (with spectral zoom) and provide a richer class of filters (for the same order $K$). -->
凱利網路有與切佈網路那樣有同樣的屬性，它們都是各向同性，但它們以帶光譜放大來以頻率來分佈，而且在同樣的$K$順序下，它也提供一個能分更多類的過濾器。


<!-- ## [Spatial Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s) -->
## [光谱图形卷积网络](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s)


<!-- ### Template Matching -->
### 模板匹配

<!-- To understand Spatial Graph ConvNets, we go back to the Template Matching definition of ConvNets. -->
为了明白光谱图形卷积网络，我们回到卷积网的模组匹配(template matching)的定义。

<!-- The main issue when we perform Template Matching for graphs is the lack of node ordering or positioning for the template. All we have are the indices of nodes, which isn't enough to match information between them. How do we design template matching to be invariant to node re-parametrisation? That is, if we have a graph and one of the nodes had an arbitrary index, say 6, this index could've been 122 as well. So it's essential to be able to perform template matching independent to the index of the node. -->
当给图形进行模组匹配的主要问题是模组中的节点缺乏顺序性或缺乏位置顺序性。我们只有的是节点的索引值，也就是对匹配它们的信息来说是不足够的。那我们如何去设计模组匹配来令它对节点重新参数化是有不变性的?就是了，如果我们有一个图形和其中一个节点有任意的索引值，比如说是6，那这个索引值也可以是122，所以模组匹配必须是独立于节点的索引值。

<!-- The simplest way to do this is by having only one template vector $w^l$, instead of having $w_{j1}$,$w_{j2}$, $w_{j3}$ or so on. So we match this vector $w^l$ with all other features on our graph. Most Graph Neural Networks today use this property. -->
最简单的做法是只用一个模组向量$w^l$，而不是用$w_{j1}$或$w_{j2}$﹑ $w_{j3}$更多。所以我们匹配这个向量wl对其它在我们图形上的特征。今天的大部份的图形神经网络都是用这个属性。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<!-- <b>Figure 2:</b> Template Matching using a template vector -->
<b>图2:</b> 模组匹配(template matching)用一个模组向量
</center>

<!-- Mathematically, for one feature we have, -->
数学性来说，如果是一个特征的话，我们有，

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \langle w^l,h_{ij}^l \rangle \bigg)$$

<!-- where, $w^l$ is the template vector at layer $l$ of dimensions $d \times 1$ and $h_{ij}^l$ is the vector at node j with $d \times 1$ which will result in a scalr quantity $h_{i}^{l+1}$ at node $i$. -->
这里，$w^l$是在尺寸为$d \times 1$的$l$层的模组向量，而 $h_{ij}^l$是在节点j的向量，这个向量尺寸为 $d \times 1$，它会变成在节点$i$的一个标量$h_{i}^{l+1}$。

<!-- for more($d$) features, -->
如果是更多的($d$)特征，

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \boldsymbol{W}^l,h_{ij}^l\bigg)$$

<!-- where, $\boldsymbol{W}^l$ is of the dimensionality $d \times d$ and $h_{i}^{l+1}$ is $d \times 1$ -->
这里，$\boldsymbol{W}^l$尺寸为$d \times d$ ，而且每一个向量性特征，$h_{i}^{l+1}$ 是 $d \times 1$

对于向量表示，

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

<!-- where, $\boldsymbol{A}$ is the adjacency matrix of dimensions $n \times n$, $h^l$ is the activation function at the layer $l$ with dimensions $n \times d$. -->
这里，$\boldsymbol{A}$是一个尺寸为$n \times n$的邻接矩阵，而$h^l$是在$l$层的激活函数，它的尺寸为$n \times d$。

基于这个模组匹配的定义，我们可以定义两种空间性的图形卷积网络:各向同性图形卷积网络和各向异性图形卷积网络


<!-- ## Isotropic GCNs -->
## 各向同性图形卷积网络


<!-- ### Vanilla Spatial GCNs -->
### 基础型空间性图形卷积网络

<!-- It has the same definition as before, but we add the Diagonal matrix in the equation, in such a way that we find the mean value of the neighbourhood. -->
它的定义和之前一样，但我们在方程式上加上了一个对角矩阵，旁边的数值的平均值。

<!-- Matrix representation being, -->
矩阵表示为

$$h^{l+1} = \eta(\boldsymbol{D}^{-1}\boldsymbol{A}h^{l}\boldsymbol{W}^{l})$$

<!-- where, $\boldsymbol{A}$ has the dimensions $n \times n$, $h^{l}$ has dimensions $n \times d$ and $W^{l}$ has $d \times d$, which results in a $n \times d$ $h^{l+1}$ matrix. -->
这里， $\boldsymbol{A}$大小为$n \times n$, 而$h^{l}$大小为$n \times d$和$W^{l}$ 大小为$d \times d$，所有东西计算起来为一个大小为$n \times d$ 的$h^{l+1}$矩阵。

<!-- And the vectorial representation being, -->
而向量的表示是这样，

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{A}_{ij}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!-- where, $h_{i}^{l+1}$ has the dimensions of $d \times 1$ -->
这里，$h_{i}^{l+1}$的大小为$d \times 1$。

<!-- The vectorial representation is responsible for handling the absence of node ordering, which is invariant of node re-parametrisation. That is, adding on the previous example, if the node has an in 6 and is changed to 122, this won't change anything in the computation of the activation function of the next layer $h^{l+1}$. -->
而向量的表示是用来解决节点没有顺序的问题，也就是节点重新参数化的不变性。也就是这样，加一些之前的例子上去，如果节点的数字为6，然后改为122，这对在下一层$h^{l+1}$的激活函数的计算中是不会改变或影响到任何东西的。

<!-- We can also deal with neighbourhood of different sizes. That is we can have a neighbourhood of 4 nodes or 10 nodes, it wouldn't change anything. -->
我们也可以解决有不同大小的邻域。也就是我们可以有大小为4个节点或10个节点的邻域，这也不会改变或影响到任何东西

<!-- We are given the local reception field by design, that is, with Graph Neural Networks we only have to consider the neighbours. -->
先给我们一个设计上的接收视野(Receptive Field)，也就是，以图形神经网路，我们只要考虑那些邻域。

<!-- We have weight sharing, that is, we the same $\boldsymbol{W}^{l}$ matrix for all features no matter the position of the graph, which is a Convolution property. -->
我们有权重分享，也就是我们在所有的特征上都用同样的Wl矩阵，无论是在图形中的位置是什么，也就是卷积层属性。

<!-- This formulation is also independent of the graph size, since all operations are done locally. -->
这个方程式是独立于图形大小，那是因为所有的运算都是本地性运行。

<!-- Since it is an isotropic model, the neighbours will have the same $\boldsymbol{W}^{l}$ matrix. -->
因为这是各向同性模型，邻域会有同样$\boldsymbol{W}^{l}$ 矩阵。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<!-- <b>Figure 3:</b> Isotropic model -->
<b>图3:</b> 各向同性模型
</center>

$$h_{i}^{l+1} = f_\text{GCN}(h_{i}^{l}, \{h_{j}^l: j \rightarrow i\})$$

So, the activation of the next layer $h_{i}^{l+1}$ is a function of the activation of the previous layer $h_{i}^{l}$ at node $i$ and the neighbourhood of $i$. When we change the function, we get an entire family of graphs.
所以，下一层$h_{i}^{l+1}$的这个激活是...，就是在节点$i$和节点$i$的邻域的之前那一层$h_{i}^{l}$的激活的函数。当我们去改变这个函数时，我们就有整个图形的家族


<!-- ### ChebNets and Vanilla Spatial GCNs -->
### 切布网络(ChebNets)和基础式空间性图形卷积网络(Vanilla Spatial GCNs)

<!-- The above defined Vanilla Spatial GCN is a simplification of ChebNets. We can truncate the expansion of ChebNet by using the first two Chebyshev functions to end up with, -->
上方定义了基础型空间性图形卷积网络是一个简化了的切布网络。我们可以把切布网络的方程展开截断起来，方法是利用第一和第二切比雪夫函数来得到这个，

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{\hat{d_{i}}}\sum_{j \in N_{i}}\hat{\boldsymbol{A}_{ij}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$


<!-- ### GraphSage -->
### 图形取样和聚合框架 (Graph SAmple and aggregate, 简称GraphSAGE)

<!-- If the Adjacency matrix $\boldsymbol{A}_{ij} = 1$ for the edges in Vanilla Spatial GCNs, we get, -->
如果边条是在基础型空间性图形卷积网络，那这个邻接矩阵的$\boldsymbol{A}_{ij} = 1$，我们就有个:

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$
<!-- 
For this equation, we give the central/core vertex $i$ and it's neighbourhood the same template weight $\boldsymbol{W}^{l}$. We can differentiate this by giving the central node $\boldsymbol{W}\_{1}^{l}$, and having a different template node $\boldsymbol{W}_{2}^{l}$ for the one-hot neighbourhood. This will improve the performance of the GNNs by a substantial amount. This model is still considered to be Isotropic in nature, since the neighbours have the same weight. -->
以这个方程，我们有中央式或核心性的顶点$i$，和这个它的邻域有同样的模板权重(template weight)，为$\boldsymbol{W}^{l}$.。我们可以把它区分起来，方法是给它一个中央性的节点$\boldsymbol{W}\_{1}^{l}$，而且有一个不同的模板节点$\boldsymbol{W}_{2}^{l}$和用它在独热邻域中。这会大量提高GNN的效能。这个模型还是本质上被认为是各向同性，那是因为邻域都有同样的权重。

$$h_{i}^{l+1} = \eta\bigg(\boldsymbol{W}_{1}^{l} h_{i}^{l} + \frac{1}{d_{i}} \sum_{j \in N_{i}} \boldsymbol{W}_{2}^{l} h_{j}^{l}\bigg)$$

<!-- where, $\boldsymbol{W}\_{1}^{l}$ and $\boldsymbol{W}\_{2}^{l}$ are of dimension $d \times d$; $h_{i}^{l}$ and $h_{j}^{l}$ are of the dimension $d \times 1$. -->
这里，wl1和wl2的大小为dxd，而hli和hlj的大小为dx1。

<!-- In this equation, we can find the summation or maximum of $\boldsymbol{W}\_{2}^{l} h_{j}^{l}$ or the Long-Short Term Memory of $h_{j}^{l}$, instead of the mean. -->
在这个方程，我们可以找到$\boldsymbol{W}\_{2}^{l} h_{j}^{l}$的总和和最大数值，或$h_{j}^{l}$的长短期记忆，而不是平均值。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<!-- <b>Figure 4:</b> GraphSage -->
<b>图4: </b> 图形取样和聚合框架 (Graph SAmple and aggregate, 简称GraphSAGE)
</center>


<!-- ### Graph Isomorphism Networks (GIN) -->
### 图形同构网络(GIN)

<!-- An architecture that can differentiate graphs that are not isomorphic. *Isomorphism* is the measure of equivalence between graphs. In the figure below, the two graphs are considered isomorphic to each other. Isomorphic graphs will be treated in a similar way and non-isomorphic graphs will be treated differently. -->
一个架构可以区分不是同构的图形们。*同构*是图形们之间的相等度。在下方的图，两个图形是被认为同构的。同构图形们会被以相似的方式对待，而且不是同构的图形们会被以不相似的方式对待。

<!-- GIN is an isotropic GCN. -->
图形同构网络是一个图形同构图形卷积网络。

$$h_{i}^{l+1} = \texttt{ReLU}(\boldsymbol{W}_{2}^{l}\space \texttt{ReLU}(\texttt{BN}(\boldsymbol{W}_{1}^{l} \hat(h_{j}^{l+1})))$$

<!-- where, $\texttt{BN}$ stands for Batch Normalization. -->
这里，$\texttt{BN}$意思是批量归一化

$$h_{i}^{l+1} = (1 + \epsilon)h_{i}^{l} + \sum_{j \in N_{i}} h_{j}^{l}$$

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<!-- <b>Figure 5:</b> Examples of two isomorphic graphs -->
<b>图5:</b> 两个同构图形的例子


<!-- ## [Anisotropic GCNs](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s) -->
## [各向异性图形卷积网络](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s)

<!-- Standard CNNs have the ability to produce anisotropic filters — ones that favour certain directions. This is because the directional structure is based on up, down, left, and right. However, the GCNs described above have no notion of direction, and thus can only produce isotropic filters. Anisotropy can be introduced naturally, with edge features. For instance, molecules can have single, double, and triple bonds. Graphically, it is introduced weighting different neighbours differently. -->
标准的卷积网络有一个能力就是生成各向异性过滤器...也就是说它一个可以注意方向性的东西。这是因为方向性结构是基于上下左。相反，图形卷积网络上方被形容为没卜方向性，而所以这只可以生成各向同性过滤器。各向異性可以自然地以一些邊緣特徵來實作出來。比如，分子就有单键和双键﹑三键。图形地上来说，它是用边的信息来实作出来。


<!-- ### MoNets -->
### Mo网络(MoNets)

<!-- MoNets use the degree of the graph to learn the parameters of a Gaussian Mixture Model (GMM). -->
Mo网络用图形的度数来学习高斯混合模型(Gaussian Mixture Model，英文简称GMM)的参数

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<!-- <b>Figure 6:</b> MoNet -->
<b>图6：</b> Mo网络
</center>


<!-- ### Graph Attention Networks (GAT) -->
### 图形注意机制网络(Graph Attention Networks ，简称GAT)

<!-- GAT uses the attention mechanism to introduce anisotropy in the neighbourhood aggregation function. -->
图形注意机制网络使用注意机制来在邻域聚合函数(neighbourhood aggregation function)中实作各向异性。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<!-- <b>Figure 7:</b> GAT -->
<b>图7: </b>图形注意机制网络(Graph Attention Networks ，简称GAT)
</center>


<!-- ### Gated Graph ConvNets -->
### 门控式图形卷积网络

<!-- These use a simple edge gating mechanism, which can be seen as a softer attention process as the sparse attention mechanism used in GATs. -->
这些都用了一个简单的「边门控式机制」，也可以看得出一个较软的注意力机制过程是如一个在GAT中用上的稀疏注意力机制。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<!-- <b>Figure 8:</b> Gated Graph ConvNet -->
<b>图8: </b>门控式图形卷积网络
</center>


<!-- ### Graph Transformers -->
### 图形变压器(Graph Transformers)

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<!-- <b>Figure 9:</b> Graph Transformer -->
<b>图9: </b>图形变压器(Graph Transformers)
</center>

<!-- This is the graph version of the standard transformer, commonly used in NLP. If the graph is fully connected (every two nodes share an edge), we recover the definition of a standard transformer. -->
這個圖形版本是一個基本形變壓器，一般都被用在NLP。如果圖片是完全地連接起來，也就是每兩個節點們分享一條邊，我們會補充一點標準變壓器的定義。

<!-- Graphs obtain their structure from sparsity, so the fully connected graph has trivial structure and is essentially a set. Transformers then can be viewed as **Set** Neural Networks, and are in fact the best technique currently to analyse sets/bags of features. -->
圖形在稀疏性中取得它自身的結構，所以完全連結起來的圖形有一個不重要的的結構和本身是本質地上是一個**集**。變壓器之後是被看成一個「集」神經網絡，而且事實上現在最好的技術就是去分析這些集或一堆特徵。


<!-- ## Benchmarking GNNs -->
## 基準化分析法圖形神經網絡(Benchmarking GNNs)

<!-- Benchmarks are an essential part of progress in any field. The recently released benchmark [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) has six medium-scale datasets that can be used for four fundamental graph problems - graph classification, graph regression, node classification and edge classification. Though these datasets are mediumly sized, they are enough to statiscally separate trends in various GNNs. -->
基準化分析法是任何領域中的過程中，都是十分重要的部份。而最近發佈出的基準，也就是[基準化分析法圖形神經網絡](https://arxiv.org/pdf/2003.00982.pdf/)有6個中規模大小的數據集，這些數據集可以被用在4個基本的圖形問題:圖形分類和圖片回歸﹑節點分類丶邊分類。雖然這些數據集都是中規模大小，但已經足夠來用在不同的圖形神經網絡們。

<!-- As an example of a **Graph Regression task**, we would want to predict the molecular solubility. -->
就如一個**图形回归任務**的例子，我們會去預測出分子溶解度。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<!-- <b>Figure 10:</b> Graph Regression task - Quantum Chemistry -->
<b>图10: </b>图形回归任务 - 量子化学
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figure 11:</b> Performance of various GCNs on the regression task
<b>图11：</ b>各种GCN在回归任务上的表现
</center>

<!-- We notice that in most cases anisotropic GCNs perform better compared to isotropic GCNs because we use directional properties. -->
我们可以注意到大部例子中，各向异性的图形卷积网络效能比各向同性的图形卷积网络好，因为我们用了方向性属性。

<!-- For a **Graph Classification task**, a Computer Vision problem was chosen where we have super nodes of images and we want to classify the image. -->
在**图形分类任务**中，如果是决定在用在一个计算机视觉问题上，那是先决在我们在图片中有一些起节点，而我们也想去分类图片。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>图 12:</b> 图形分类任务
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>图 13:</b> 不同的圖形卷積神網絡在圖形分類上的效能
</center>

<!-- For an **Edge Classification task**, we have considered the Combinatorial Optimization problem of the Travelling Salesman Problem (TSP) - where we want to know if a particular edge belongs to the optimal solution. If it belongs to the solution it falls in class 1, else class 0. Here we need explicit edge features, and the only model that does a good job of this is GatedGCN. -->
**在「邊」分類任務**上，我們有考慮過旅行推銷員的組合優化問題(Combinatorial Optimization problem of the Travelling Salesman Problem ，簡稱TSP)，這裡我們想要知道的是，如果特定的邊是屬於最佳解決方案的話，我們想要知道。如果是屬於解決方案的話，它就屬於第1類，不是就屬於第0類。這裡我們要明確的「邊」的特徵，而且最得最好的只有門控式圖形卷積神網絡。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<!-- <b>Figure 14:</b> Edge Classification task. -->
<b>图14</b>:分类「边」的任务。
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<!-- <b>Figure 15:</b> Performance of various GCNs on Edge Classification task -->
<b>图15:</b> 不同的图形卷积网络的效能
</center>

<!-- We can use GCNs for self-supervised tasks as well, they are not limited to supervised learning models. According to Dr. Yann LeCun, almost all self-supervised learning tasks exploit some sort of graph structure. When we do a self-supervised learning task in text, where we take a sequence of words and we learn to predict missing words or new sentences. There is a graphs structure here, which is how many times a word appears some distance away from another word. Text would be a linear graph, and the neighbours chosen would be used to train a Transformer. In the case of contrastive training, where we have two samples that are similar, and two which are dissimilar - it is essentially a similarity graph, where two samples are linked when they are similar and if they are not linked they are considere dissimilar. -->
我们可以在自我监督的任务中用上图形卷积网络，它们不会被限于监督学习模型。根据杨立昆 (Yann LeCun)博士，大部份的自我监督学习任务都利用一些图形结构。当我们在文字数据上用上自我监督学习任务时，我们就是用一序列的文字去学预测出缺失了的文字或预测一些新句子。这里有一个图形结构，它就是一个字是在别的字上在一些距离上出现了多少次。文字会是一个线性图形，而邻旁选择到的东西就会被用来训练一个变压器。在这个对比式训练的个案，我们有两个相似的样本，而且也有两个不一样的，这本质上就是一个相似的图形，也就是两个相似的様本就是连结起来，不相似就不是连结起来。


<!-- ## Conclusion -->
## 结论

<!-- GCNs generalize CNNs to data on graphs. The convolution operator needed to be redesigned on graphs. Doing this for template matching gave rise to Spatial GCNs, and for spectral convolution lead to Spectral GCNs. -->
图形卷积网络广泛到由卷积网络到在图形上的数据。卷积网络运算虽要在图形上重新设计。对模板匹配做这些东西的话就会对空间性图形卷积网络带来提升，而且对光谱图形卷积网络来说就会把它转成空间性图形卷积网络。

<!-- There is linear complexity for sparse graphs, and GPU implementation, although the latter is not yet optimized for sparse matrix multiplication. The applications are abound as shown below. -->
虽然后者在稀疏矩阵乘法中还没被优化好，但这是对稀疏图形和GPU实作来说是一个线性复杂度。它所有的应用就在下方所示。

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<!-- <b>Figure 16:</b> Applications -->
<b>图16</b>：应用
</center>
