---
lang: zh
lang-ref: ch.12-1
title: 自然语言处理中的深度学习
lecturer: Matt Lewis
authors: Jiayu Qiu, Yuhong Zhu, Lyuang Fu, Ian Leefmans
date: 20 Apr 2020
translator: Eric Yuan
translation-date: 27 Jun 2020
---
<!-- 
## Overview
* Amazing progress in recent years:
  - Humans prefer machine translation to human translators for some languages
  - Super-human performance on many question answering datasets
  - Language models generate fluent paragraphs (e.g Radford et al. 2019)
*  Minimal specialist techniques needed per task, can achieve these things with fairly generic models -->

## 综述
* 近年来令人瞩目的成就:
  - 对于某些语言, 机器翻译比起人工翻译更受青睐
  - 在一些问答数据集上, 机器超过人类水平
  - 语言模型可以生成流利的段落 (比如, Radford et al. 2019)
*  用机器学习可以得到非常通用的模型, 从而对于每个不同的任务, 机器学习只需要少量与这个任务相关的知识

<!-- 
## Language Models
* Language models assign a probability to a text:
  $p(x_0,...x_n)$
* Many possible sentences so we can’t just train a classifier
* Most popular method is to factorize distribution using chain rule: -->

## 语言模型
* 语言模型给一段文字指定概率:
  $p(x_0,...x_n)$
* 一个句子可能由太多种词汇组合而成, 所以我们无法简单地训练一个分类器
* 这里最流行的方法是利用链式法则去分解概率分布:


$$p(x_0,...x_n) = p(x_0)*p(x_1|x_0)*...*p(x_n|x_{n-1})$$

<!-- ## Neural Language Models
Basically we input the text into a neural network, the neural network will map all this context onto a vector. 
This vector represents the next word and we have some big word embedding matrix. The word embedding matrix contains a vector for every possible word the model can output. 
We then compute similarity by dot product of the context vector and each of the word vectors. 
We'll get a likelihood of predicting the next word, then train this model by maximum likelihood. 
The key detail here is that we don't deal with words directly, but we deal with things called sub-words or characters. -->

## 神经语言模型
简单来讲, 我们把一段文字输入一个神经网络, 这个神经网络会首先把这些上下文信息映射到一个向量上.
这个向量表示了下一个词的信息. 
我们有一个巨大的词嵌入矩阵, 这个矩阵里的向量对应了这个模型所有可能输出的词.
接着, 我们通过计算之前那个上下文向量与这个词嵌入矩阵里所有向量的点积, 得到预测下一个词的概率.
我们通过优化极大似然的方法训练这个模型.
通常, 我们不直接进行词级别的预测, 而是对子词(sub-word)或者字母进行预测.


$$p(x_0|x_{0...n-1}) = softmax(E f(x_{0...n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <!-- <center>  Fig.1: Neural language model</center> -->
  <center>  图.1: 神经语言模型</center>
</figure>
<!-- 
### Convolutional Language Models
* The first neural language model
* Embed each word as a vector, which is a lookup table to the embedding matrix, so the word will get the same vector no matter what context it appears in
* Apply same feed forward network at each timestep
* Unfortunately, fixed length history means it can only condition on bounded context
* These models do have the upside of being very fast -->

### 卷积语言模型
* 这是最初的神经语言模型
* 把每个词嵌入成一个向量, 它对应了词嵌入矩阵的一个条目; 因此, 无论这个词处在什么样的上下文当中, 得到的都是同样的向量表示
* 在时间维(通常在处理序列输入的时候, 比如一句话由不同词的序列组成, 我们把不同词组成的这个维度称为时间维)的每一步, 我们用同一个前向网络进行计算
* 不足的是, 卷积语言模型只能处理固定长度的历史信息, 因此, 它只考虑有限的上下文信息
* 卷积语言模型的训练速度非常快



<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <!-- <center>  Fig.2: Convolutional language model</center> -->
  <center>  图.2: 卷积语言模型</center>
</figure>
<!-- 
### Recurrent Language Models
* The most popular approach until a couple years ago.
* Conceptually straightforward: every timestep we maintain some state (recieved from the previous timestep, which represents what we've read so far. This is combined with current word being read and used at later state. Then we repeat this process for as many timesteps as we need.
* Uses unbounded context: in principle the title of a book would affect the hidden states of last word of the book.
* Disadvantages:
  - The whole history of the document reading is compressed into fixed-size vector at each timestep, which is the bottleneck of this model
  - Gradients tend to vanish with long contexts
  - Not possible to parallelize over time-steps, so slow training -->

### 循环语言模型
* 直到近一两年前, 循环语言模型一直是最流行的方法.
* 概念上非常容易理解: 时间轴上每一步, 我们维护一个状态 (这个状态是从上一步传递过来的, 里面包含着我们之前读过的所有信息). 我们把在当前步新读到的信息融合到这个状态里, 再把它传递到下一步. 我们重复这个过程, 直到读完每一个词.
* 循环语言模型没有上下文长度的限制: 举个极端的例子, 利用循环语言模型, 一本书的标题甚至可以影响到这本书最后一个词的状态.
* 缺点:
  - 正在阅读的整个文档的历史信息都被压缩到一个固定大小的向量里了, 这个向量是循环语言模型的瓶颈
  - 当上下文信息很长的时候, 这个模型存在梯度消失(gradient vanishing)的问题
  - 因为之后步的状态计算依赖于之前步的状态, 所以无法并行化运算, 这个导致了训练速度相对较慢


<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <!-- <center>  Fig.3: Recurrent language model</center> -->
  <center>  图.3: 循环语言模型</center>
</figure>
<!-- 
### Transformer Language Models
* Most recent model used in NLP
* Revolutionized penalty
* Three main stages
    * Input stage
    * $n$ times transformer blocks (encoding layers) with different parameters
    * Output stage
* Example with 6 transformer modules (encoding layers) in the original transformer paper: -->


### Transformer语言模型
* 自然语言处理领域最新的模型
* Revolutionized penalty (eric: not sure what does this mean)
* 三个主要步骤
    * 输入
    * $n$ 层transformer (编码层), 每层的参数不共享
    * 输出
* Transformer论文中一个6层transformer编码器的示例::

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <!-- <center>  Fig.4:Transformer language model </center> -->
  <center>  图.4:Transformer语言模型 </center>
</figure>

<!-- Sub-layers are connected by the boxes labeled "Add&Norm". The "Add" part means it is a residual connection, which helps in stopping the gradient from vanishing. The norm here denotes layer normalization. -->

我们用"Add&Norm"来连接不同的子层(在transformer里, 我们通常用层来表示transformer模块堆叠的数量, 每个模块里存在一些子层). "Add"表示一个残差连接(详见He et al.的Deep Residual Learning for Image Recognition). 这些残差连接可以减轻梯度消失的影响. "Norm"代表层标准化(Layer Normalization).
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <!-- <center>  Fig.5: Encoder Layer </center> -->
  <center>  图.5: 编码层 </center>
</figure>

<!-- 
It should be noted that transformers share weights across time-steps. -->

注意, 对于时间轴上的不同步, transformer公用同一套参数.


<!-- # Multi-headed attention -->
# 多头注意力机制

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<!-- <center>  Fig.6: Multi-headed Attention </center> -->
<center>  图.6: 多头注意力机制 </center>
</figure>

<!-- 
For the words we are trying to predict, we compute values called **query(q)**. 
For all the previous words use to predict we call them **keys(k)**. 
Query is something that tells about the context, such as previous adjectives. 
Key is like a label containing information about the current word such as whether it's an adjective or not. 
Once q is computed, we can derive the distribution of previous words ($p_i$): -->

对于我们想要预测的词, 我们计算一个叫做**query(q)**的值. 
对于这个词值钱的所有词(我们用它们来预测这个词), 我们称他们为**keys(k)**. 
Query里记录了上下文信息,比如之前的形容词.
Key更像是一个标签, 它当中包含了当前词的信息, 比如它是否是一个形容词.
一旦计算了$q$, 我们可以用它去计算出之前词的分布 ($p_i$):

$$p_i = softmax(q,k_i)$$

<!-- Then we also compute quantities called **values(v)** for the previous words. Values represent the content of the words. -->
对于之前的词, 我们同时计算一个叫做**values(v)**的值, 它表示了这些词的内容信息.

<!-- Once we have the values, we compute the hidden states by maximizing the attention distribution: -->
计算这些数值之后, 我们计算$v$的加权和, 权重是注意力机制得到的概率分布, 用这些加权和作为我们输出的隐状态(hidden states):

 $$h_i = \Sigma_{i}{p_i v_i}$$
<!-- 
We compute the same thing with different queries, values, and keys multiple times in parallel. 
The reason for this is that we want to predict the next word using different things. 
For example, when we predict the word "unicorns" using three previous words "These" "horned" and "silver-white". 
We know it is a unicorn by "horned" "silver-white". 
However, we can know it is plural "unicorns" by "These". 
Therefore, we probably want to use all these three words to know what the next word should be. 
Multi-headed attention is a way of letting each word look at multiple previous words. -->

在同一时间, 我们并行运算好几组query, value和key, 这样我们就可以借助多种信息去预测下一个词.
举个例子, 当我们用"这些", "长角的", "银白色的"去预测"独角兽(复数, unicorns)".
通过"长角的"和"银白色的", 我们已经可以猜到独角兽了.
但是, 通过"这些", 我们可以知道我们要的是一个名词的复数形态.
从而, 用全部这三个词去预测, 我们可以得到更好的结果.
多头注意力机制就是一种让模型从之前的词中考虑多种因素的方法.

<!-- 

One big advantage about the multi-headed attention is that it is very parallelizable. 
Unlike RNNs, it computes all heads of the multi-head attention modules and all the time-steps at once. 
One problem of computing all time-steps at once is that it could look at futures words too, while we only want to condition on previous words. 
One solution to that is what is called **self-attention masking**. 
The mask is an upper triangular matrix that have zeros in the lower triangle and negative infinity in the upper triangle. 
The effect of adding this mask to the output of the attention module is that every word to the left has a much higher attention score than words to the right, so the model in practice only focuses on previous words. 
The application of the mask is crucial in language model because it makes it mathematically correct, however, in text encoders, bidirectional context can be helpful. -->

相比于其他方法(比如循环神经网络), 多头注意力机制的一个重要的优势在于它很强的并行性.
它可以在同时对所有时间点的所有头进行计算.
这种运算方法随之引入一个问题: 因为它可以同时计算所有时间点, 模型是可以看到当前预测的词之后的词的 (作弊了), 我们只想要模型考虑之前的词.
一个解决方案是引入**自注意力掩码(self-attention masking)**. 
这个掩码是一个上三角矩阵, 矩阵对角线左下方的系数全部为0, 矩阵对角线右上方的系数全部为负无穷. (译者注: 这个掩码是应用在对数上的, 如果对这个矩阵求指数, 它就变成一个下三角矩阵, 左下为1, 右上为0.)
将这个掩码使用在注意力机制的输出上, 可以让模型在预测一个词的时候, 只关注它之前的词.
这个掩码很重要, 因为它让这个语言模型在数学上是正确的. 
在实际操作中, 我们经常用双向的上下文信息. 
(注: 在双向的transformer语言模型里, 我们有两个transformer, 前向的transformer如同以上所述.
后向的transformer在实际操作中, 我们将文字序列倒序, 然后用另一个transformer去对这个倒序的的文字序列进行计算.
对于倒序的tranformer, 自注意力掩码也是必要的.
对于每一个transformer, 我们都要保证它不能"偷看"到当前预测的词之后的内容.)

<!-- 
One detail to make the transformer language model work is to add the positional embedding to the input. 
In language, some properties like the order are important to interpret. 
The technique used here is learning seperate embeddings at different time-steps and adding these to the input, so the input now is the summation of word vector and the positional vector. 
This gives the order information. -->

在transformer语言模型里, 我们通常会给模型额外提供一种嵌入, 表示每个词的位置信息.
在语言中, 有一些信息, 比如词序, 对于模型来说非常重要.
在这里我们的方法是, 用一个额外的嵌入去学习每个词的位置信息, 然后用它们作为transformer的额外输入, 去区分同样的词在不同位置出现的情况.
这时, transformer的输入就是用来表达词信息的向量与用来表达位置信息的向量的和(注: 或者把这两个向量连接起来).


<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<!-- <center>  Fig.7: Transformer Architecture </center> -->
<center>  图.7: Transformer结构 </center>
</figure>

<!-- 
**Why the model is so good:**

1. It gives direct connections between each pair of words. Each word can directly access the hidden states of the previous words, mitigating vanishing gradients. It learns very expensive function very easily
2. All time-steps are computed in parallel
3. Self-attention is quadratic (all time-steps can attend to all others), limiting max sequence length -->


**为啥这模型这么棒:**

1. 它提供词与词之间的直接连接, 计算每个词的时候都可以访问到之前所有词的隐状态, 这样有效减少了梯度消失. 通过这个方法, 我们可以非常简单地学到很复杂的函数.
2. 并行运算所有时间点.
3. 自注意力机制是平方时间复杂度的 (每个词可以访问到其他所有词)

<!-- 
## Some tricks (especially for multi-head attention and positional encoding) and decoding Language Models -->

## 一些使用技巧 (适用于多头注意力机制和位置信息嵌入) 以及如何从语言模型中解码
<!-- 
### Trick 1: Extensive use of layer normalization to stabilize training is really helpful

- Really important for transformers -->

### 技巧1: 利用层标准化来稳定训练

- 对于基于transformer的模型来说非常重要
<!-- 

### Trick 2: Warmup + Inverse-square root training schedule

- Make use of learning rate schedule: in order to make the transformers work well, you have to make your learning rate decay linearly from zero to thounsandth steps. -->

### 技巧2: 学习率预热(Warmup)和逆方差学习率调整

- 合理调整学习率: 通常我们让学习率在前一千步内线性地下降.

<!-- ### Trick 3: Careful initialization
- Really helpful for a task like machine translation -->

### 技巧3: 谨慎初始化参数
- 对于类似机器翻译的任务, 这点很重要.

<!-- 
### Trick 4: Label smoothing
- Really hepful for a task like machine translation -->

### 技巧4: 标签平滑化
- 对于类似机器翻译的任务, 这点同样很重要.


<!-- ### The following are the results from some methods mentioned above. In these tests, the metric on the right called ppl was preplexity. (the lower the ppl the better) -->

### 以下是我们之前讨论的方法的结果. 在右面列出的"ppl"代表困惑度(perplexity, 交叉熵的指数形式). ppl越低越好.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<!-- <center>  Fig.8: Model Performance Comparison </center> -->
<center>  图.8: 模型性能对比 </center>
</figure>

<!-- You could see that when transformers were introduced, the performance was greatly improved. -->
从图中可以看到, 当使用了transformer时, 模型性能有明显提升.

<!-- 
## Some important facts of Transformer Language Models

 - Minimal inductive bias
 - All words directly connected, which will mitigate vanishing gradients.
 - All time-steps computed in parallel. -->

## 关于transformer语言模型的重要知识点

 - 比较少的归纳偏置(Inductive Bias).
 - 所有词之间都直接连接, 一定程度上解决梯度消失问题.
 - 可以并行运算所有时间点.
<!-- 

### Self attention is quadratic (all time-steps can attend to all others), limiting max sequence length.

- As self attention is quadratic, its expense grows linearly in practice, which could cause a problem. -->

### 自注意力机制是平方时间复杂度的(任意词可以访问到其他所有词), 我们需要限制输入序列的最大长度.

- 因为自注意力机制是平方时间复杂度的, 计算开销随着序列长度线性增长, 这个会导致一些问题.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<!-- <center>  Fig.9: Transformers vs. RNNs </center> -->
<center>  图.9: 对比Transformers和RNNs </center>
</figure>
<!-- 
### Transformers scale up very well
1.Unlimited training data, even far more than you need
2.GPT2 used 2 billion parameters in 2019
3.Recent models use up to 17B parameters and in 2020 -->

### Transformer有很好的扩展性
1.无限的训练数据, 甚至超过你需要的规模
2.GPT2 (2019年一个基于transformer的模型) 包含20亿个可训练参数
3.最近(2020年), 一些模型甚至包含170亿个参数.
<!-- 
## Decoding Language Models

We can now train a probability distribution over text - now essentially we could get exponentially many possible outputs, so we can’t compute the max. Whatever choice you make for your first word could affect all the other decisions.
Thus, given that, the greedy decoding was introduced as follows. -->

## 从语言模型中解码

我们现在可以训练一个模型, 训练它学习一个文字上的概率分布.
因为存在指数级数量的可能输出, 我们无法轻易得到概率最高的那一个.
我们对于前面词的选择, 会影响之后所有的决策.
所以, 我们利用贪婪解码(greedy decoding)的方法.

<!-- 
### Greedy Decoding does not work
We take most likely word at each timestep. However, no guarantee this gives most likely sequence because if you have to make that step at some point, then you get no way of back-tracking your search to undo any previous sessions. -->

### 贪婪解码可能不灵
在每一步, 我们取概率最高的那个词.
但是, 这种做法无法保证最后得到整体概率最高的序列, 因为只要在某一步取了某个词, 之后都再无机会回溯到这一步重新选取了.

<!-- ### Exhaustive search also not possible
It requires computing all possible sequences and because of the complexity of $O(V^T)$, it will be too expensive -->

### 穷举搜索亦不现实
如果想要穷举所有可能的序列, 需要$O(V^T)$的时间复杂度, 费时费力.

<!-- 
## Comprehension Questions and Answers

1. What is the benefit of multi-headed attention as opposed to a single-headed attention model?

    * To predict the next word you need to observe multiple separate things, in other words attention can be placed on multiple previous words in trying to understand the context neccessary to predict the next word. -->

## 以上内容的理解问答

1. 相对于单头注意力机制(single-headed attention), 多头的好处都有啥?

    * 为了更好地预测下一个词, 模型需要观测和考虑多个因素. 
<!-- 
2. How do transformers solve the informational bottlenecks of CNNs and RNNs?

    * Attention models allow for direct connection between all words allowing for each word to be conditioned on all previous words, effectively removing this bottleneck. -->

2. Transformers是如何解决CNN或者RNN模型的信息瓶颈问题的?

    * 注意力机制允许每个词直接访问到它之前的所有词, 这种机制去除了信息瓶颈的问题.

3. 在GPU并行运算上, transformer如何区别于RNN的?

    * Transformer模型的多头注意力机制使得它可以被高度并行化, 这个在RNN中是无法做到的. 实际上, transformer用一次前向反馈就可以完成对所有时间点的计算..
