---
lang: zh
lang-ref: ch.10-3
title: The Truck Backer-Upper
lecturer: Alfredo Canziani
authors: Muyang Jin, Jianzhi Li, Jing Qian, Zeming Lin
date: 7 Apr 2020
translator: Elizabeth Zhao
translation-date: 01 Jul 2020
---

<div hidden>
    $$\gdef \tcab {\Theta_{\mathrm{cab}}}$$
    $$\gdef \xcab {x_{\mathrm{cab}}}$$
    $$\gdef \ycab {y_{\mathrm{cab}}}$$
    $$\gdef \ttrailer {\Theta_{\mathrm{trailer}}}$$
    $$\gdef \xtrailer {x_{\mathrm{trailer}}}$$
    $$\gdef \ytrailer {y_{\mathrm{trailer}}}$$
</div>


## [设定](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s)

<!--The goal of this task is to build a **self-learning controller** which controls the steering of the truck while it backs up to the loading dock from any arbitrary initial position.-->

任务的目标是建造一个**自主学习控制器（self-learning controller）**用以操控驾驶货车，并从任意起点倒库至装载码头。

<!--Note that **only backing up is allowed,** as shown below in Figure 1.-->

注意如图一所示，任务**只允许倒车**。

|![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>图1</b>: 货车、拖车，和装载码头</center>|

<!--The **state** of the truck is represented by six parameters:-->

货车的六个参数的**状态**：

 - $\tcab$: <!--Angle of the truck-->货车的角度
 - $\xcab, \ycab$: <!--The cartesian of the yoke (or front of the trailer).-->轭的直角坐标（拖车前部）
 - $\ttrailer$:  <!--Angle of the trailer -->拖车角度
 - $\xtrailer, \ytrailer$: <!--The cartesian of the (back of the) trailer.--> 拖车（背部）的直角坐标

 <!--The **goal** of the controller is to select an appropriate angle $\phi$ at each time $k$, where after the truck will back up in a fixed small distance. Success depends on two criteria:-->

控制器的**目标**是在货车倒行一小段固定距离后，在时刻$k$选择合适的角度$\phi$。目标实现依靠两点：

1. <!--The back of the trailer is parallel to the wall loading dock, e.g. $\ttrailer = 0$.--> 拖车背部与装载码头的墙面平行，如$\ttrailer = 0$。
2. <!--The back of the trailer ($\xtrailer, \ytrailer$) is as close as possible to the point ($x_{dock}, y_{dock}$) as shown above.-->拖车背部($\xtrailer, \ytrailer$)尽可能接近点($x_{dock}, y_{dock}$)，如上图所示。

## <!--More Parameters and Visualization-->

## 更多参数与图示

|![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>图 2</b>: 参数的图示</center>|

<!--In this section, we also consider a few more parameters shown in Figure 2.-->

在这一部分，我们还考虑到一些图二中的参数。

<!--Given car length $L$, $d_1$ the distance between car and trailer and $d_2$ the length of the trailer, etc, we can calculate the change of angle and positions:-->

假设货车车长是 $L$、货车与拖车的间距是$d_1$，拖车车长为$d_2$，等等。我们可以计算角度与位置的变化：
$$
\begin{aligned}
\dot{\theta_0} &= \frac{s}{L}\tan(\phi)\\
\dot{\theta_1} &= \frac{s}{d_1}\sin(\theta_1 - \theta_0)\\
\dot{x}        &= s\cos(\theta_0)\\
\dot{y}        &= s\sin(\theta_0)
\end{aligned}
$$

<!--Here, $s$ denotes the signed speed and $\phi$ the negative steering angle.
Now we can represent the state by only four parameters: $\xcab$, $\ycab$, $\theta_0$ and $\theta_1$.
This is because Length parameters are known and $\xtrailer, \ytrailer$ is determined by $\xcab, \ycab, d_1, \theta_1$.-->

此处$s$表示正负速度，$\phi$表示负的驾驶角度。

现在我们可以只用四个参数表示状态：$\xcab$、$\ycab$、$\theta_0$，和$\theta_1$。

这是因为长度参数已知，并且$\xtrailer, \ytrailer$由$\xcab, \ycab, d_1, \theta_1$决定。

<!--In the Jupyter Notebook from the Deep Learning repository, we have some sample environments shown in Figures 3.(1-4):-->

在深度学习文件库里的Jupyter Notebook中，我们有一些样本环境，如图3.(1-4)所示：

| <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **图 3.1**: Sample plot of the environment | **图 3.2**: Driving into itself (jackknifing) |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
| **图 3.3**: Going out of boundary |**图 3.4**: Reaching the dock|

<!--At each time step $k$, a steering signal which ranges from $-\frac{\pi}{4}$ to $\frac{\pi}{4}$ will be fed in and the truck will take back up using the corresponding angle.-->

在每时刻$k$，驾驶信号的值域是从$-\frac{\pi}{4}$到$\frac{\pi}{4}$，货车接收到信号后以相应的角度倒退。

<!--There are several situations where the sequence can end:-->

以下几种工作程序可以结束的情况：

 - <!--If the truck drives into itself (jackknifes, as in Figure 3.2)-->如果货车车头折叠，如图3.2所示
 - <!--If the truck goes out of boundary (shown in Figure 3.3)-->如果货车驶过边界，如图3.3所示
 - <!--If the truck reaches the dock (shown in Figure 3.4)-->如果货车到达码头，如图3.4所示


## [训练](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s)

<!--The training process involves two stages: (1)  training of a neural network to be an emulator of the truck and trailer kinematics and (2) training of a neural network controller to control the truck.-->

训练过程由两个阶段组成：（1）训练神经网络成为一个货车和拖车动力的模拟器；（2）训练神经网络控制器用以控制货车。

| ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>图 4</b>: 概览图 </center> |

<!--As shown above, in the abstract diagram, the two blocks are the two networks that will be trained. At each time step $k$, the "Trailer Truck Kinematics", or what we have been calling the emulator, takes in the 6-dimension state vector and the steering signal generated from the controller and generate a new 6-dimension state at time $k + 1$.-->

如上图所示，在抽象图中，两个方块为两个即将被训练的网络。在每一时刻$k$，"拖车货车动力"或称作模拟器，用六维状态向量和控制器生成的驾驶信号，并在时刻$k + 1$生成一个新的六维状态。

### <!--Emulator--> 

### 模拟器

<!--The emulator takes the current location ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) plus the steering direction $\phi^t$ as input and outputs the state at next timestep ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). It consists of a linear hidden layer, with ReLu activation function, and an linear output layer. We use MSE as the loss function and train the emulator via stochastic gradient descent.-->

模拟器用当前时刻的位置($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$)和驾驶方向$\phi^t$作为输入，并输出下一时刻的状态($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$)。它由一个带ReLu激活函数的线性隐藏层和一个线性输出层组成。我们用MSE作为损失函数并通过SGD训练模拟器。

|![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
|  <center><b>图 5</b>:训练神经网络控制器</center>|

 <!--In this setup, the the simulator can tell us the location of next step given the current location and steering angle. Therefore, we don’t really need a neural-net that emulates the simulator. However, in a more complex system, we may not have access to the underlying equations of the system, i.e. we do not have the laws of the universe in a nice computable form. We may only observe data that records sequences of steering signals and their corresponding paths. In this case, we want to train a neural-net to emulate the dynamic of this complex system.-->

在这个设定里，模拟程序可以用已知的当前时刻的位置和驾驶角度告诉我们下一步的位置。所以，我们不需要一个神经网络来效仿模拟程序。然而，在更复杂的系统中，我们可能无法接触到系统的底层公式，也就是说我们没有一个漂亮形式可以计算宇宙法则。我们可能无法观测记录驾驶信号和对应路径的序列的数据。这种情况下，我们想要训练一个神经网络来模仿这个复杂系统的动态。

<!--In order to train enumlator, there are two important function in `Class truck` we need to look into when we train the emulator.-->

为了训练模拟器，我们需要仔细研究`Class truck`中的两个重要的方程。

<!--First is the `step` function which gives the output state of the truck after computation.-->

第一个是`step`方程，在计算后它会给出货车的输出状态。

```python
def step(self, ϕ=0, dt=1):

    # Check for illegal conditions
    if self.is_jackknifed():
        print('The truck is jackknifed!')
        return

    if self.is_offscreen():
        print('The car or trailer is off screen')
        return

    self.ϕ = ϕ
    x, y, W, L, d, s, θ0, θ1, ϕ = self._get_atributes()

    # Perform state update
    self.x += s * cos(θ0) * dt
    self.y += s * sin(θ0) * dt
    self.θ0 += s / L * tan(ϕ) * dt
    self.θ1 += s / d * sin(θ0 - θ1) * dt
```

<!--Second is the `state` function which gives the current state of the truck.-->

第二个是`state`方程，它给出货车的当前状态。

```python
def state(self):
        return (self.x, self.y, self.θ0, *self._traler_xy(), self.θ1)
```

<!--We generate two lists first. We generate an input list by appending the randomly generated steering angle `ϕ` and the initial state which coming from the truck by running `truck.state()`. And we generate an output list that is appended by the output state of the truck which can be computed by `truck.step(ϕ)`.-->

我们首先生成两个list。我们通过加入随机生成的驾驶角度`ϕ`和运行`truck.state()`得到的货车的初始状态生成输入list。然后我们通过加入由`truck.step(ϕ)`计算得到的火车输出状态生成输出list。

<!--We now can train the emulator:-->

现在我们可以训练模拟器：

```python
cnt = 0
for i in torch.randperm(len(train_inputs)):
    ϕ_state = train_inputs[i]
    next_state_prediction = emulator(ϕ_state)

    next_state = train_outputs[i]
    loss = criterion(next_state_prediction, next_state)

    optimiser_e.zero_grad()
    loss.backward()
    optimiser_e.step()

    if cnt == 0 or (cnt + 1) % 1000 == 0:
        print(f'{cnt + 1:4d} / {len(train_inputs)}, {loss.item():.10f}')
    cnt += 1
```

<!--Notice that `torch.randperm(len(train_inputs))` gives us a random permutation of the indices within the range $0$ to length of training inputs minus $1$. After the permutation of indices, each time `ϕ_state` is chosen from the input list at the index `i`. We input `ϕ_state` through the emulator function that has a linear output layer and we get `next_state_prediction`. Notice that the emulator is a neural netork defined as below:-->

注意`torch.randperm(len(train_inputs))`给我们一个随机的索引排列，其值域从$0$到训练输入的长度减$1$。索引排列后，每次在索引`i`从输入list选出`ϕ_state` 。我们通过模仿方程，其包含一个线性输出层，输入`ϕ_state`，然后得到`next_state_prediction`。注意模拟器是一个神经网络，其定义如下所示：

```python
emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)
```

<!--Here we use MSE to calculate the loss between the true next state and the next state prediction, where the true next state is coming from the output list with index `i` that corresponding to the index of the `ϕ_state` from input list.-->

此处我们用MSE计算下一状态的真实值和下一状态的预测值之间的损失函数，下一状态的真实值来自索引`i`的输出list，对应来自输入list的`ϕ_state`的索引。

### <!--Controller-->

### 控制器

<!--Refer to Figure 5. Block $\matr{C}$ represents the controller. It takes in the current state and ouputs a steering angle. Then block $\matr{T}$ (emulator) takes both the state and angle to produce the next state.-->

根据图5，方块$\matr{C}$代表控制器。它输入进当前状态并输出驾驶角度。方块$\matr{T}$（模拟器）输送进状态和角度，产生下一状态。

|![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
| <center><b>Fig. 5</b>: 状态转换流图示</center>|

*注：状态穿过所有之前的$\matr{T}/\matr{C}$模块。本图只显示所有方块$\matr{C}$按比例更新到最终误差（意指MSE损失函数）。

<!--To train the controller, we start from a random initial state and repeat the procedure($\matr{C}$ and $\matr{T}$) until the trailer is parallel to the dock. The error is calculated by comparing the trailer location and dock location.
We then find the gradients using backpropagation and update parameters of the controller via SGD.-->

为了训练控制器，我们从任意初始状态开始并重复过程($\matr{C}$和$\matr{T}$)直到拖车与码头平行。误差由对比拖车位置与码头位置计算得出。然后我们用向后传播得到梯度并且用SGD更新控制器的参数。


### [详解模型结构](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s)

<!--This is a detailed graph of ($\matr{C}$, $\matr{T}$) process. We start with a state (6 dimension vector), multiply it with a tunable weights matrix and get 25 hidden units. Then we pass it through another tunable weights vector to get the output (steering signal). Similarly, we input the state and angle $\phi$ (7 dimension vector) through two layers to produce the state of next step.-->

下图为($\matr{C}$, $\matr{T}$)过程的详细图解。我们用一个状态（六维向量）乘以可调节的权重矩阵，得到25个隐藏单元。然后将它传送到另一颗可调节的权重矩阵以获得输出（驾驶信号）。相似的，我们通过两层输入状态和角度$\phi$（七维向量）来产生下一步的状态。

![]({{site.baseurl}}/images/week10/10-3/fig14.png)

<!--To see this more clearly, we show the exact implementation of the emulator:-->

为了更好地理解，我们展示了准确的模拟器的执行过程：

```python
state_size = 6
steering_size = 1
hidden_units_e = 45

emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)

optimiser_e = SGD(emulator.parameters(), lr=0.005)
criterion = nn.MSELoss()
```

### <!--Examples of Movement--> 

### 运动的例子

<!--Following are four examples of movement for different initial state. Notice that the number of time steps in each episode varies.-->

以下是四种不同初始状态的运动的例子。注意每种例子的时间步数是不一致的。

|![]({{site.baseurl}}/images/week10/10-3/fig16.png) | ![]({{site.baseurl}}/images/week10/10-3/fig17.png) |
|![]({{site.baseurl}}/images/week10/10-3/fig18.png) | ![]({{site.baseurl}}/images/week10/10-3/fig19.png) |


### <!--Additional Resources:-->补充资料：

<!--A full working demo can be found at: [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Please check out the code as well, which can be found at [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper).-->

完整的工作demo可以查看：[https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/)。

也请查看完整代码：[https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper)。

