---
lang-ref: ch.06-3
title: 循环神经网络与LSTM模型的架构
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
lang: zh
translation-date: 11 Jun 2020
translator: Elizabeth Zhao
---

## <!-- [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s) -->

## [概述](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

<!--RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is just temporal inputs of X. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions. -->

循环神经网络（Recurrent Neural Networks, RNN）是一种可以用来处理数据序列的架构。在之前的CNN课程中，我们学到了信号可以是一维、二维、或者三维。其中维度取决于它的定义域（domain）。定义域是函数自变量的取值范围。因为序列数据的定义域是时间轴（temporal axis），所以处理序列数据是个1维的操作。不过，你也可以用RNN来处理双向的二维数据。


### Vanilla vs. Recurrent NN

<!--Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input. -->

图1是一个三层的**Vanilla神经网络图 （Vanilla NN)**（注：“Vanilla"意指平淡的、普通的）。图中粉色泡泡代表的是输入向量x，中间绿色的是隐藏层，蓝色的是输出。以右侧的数字电路为例，它类似于**组合逻辑电路 （combinational logic)**，其每一时刻的输出仅仅取决于该时刻的输入变量的值。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图1:</b> Vanilla基本网络架构
</center>

<!--In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.-->

相对于Vanilla NN，**RNN**在每一时刻的输出不仅取决于该时刻的输入，还依赖于系统状态（如图2所示）。RNN好比是数字电路中的**时序逻辑电路（sequential logic)**，其输出还依赖于触发器（flip-flop）（注：数字电路中的基本记忆单元）。所以这两种神经网络的主要区别是RNN比Vanilla多依赖了整个场景的状态。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图2:</b> RNN基本架构
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图3:</b> 基本神经网络架构
</center>

<!--Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.-->

Yann在图示的网络神经之间添加了一些特殊图形，用来表示从一个张量到另一个张量的映射。如图3所示，输入向量x通过一个特殊图形映射到隐藏层h。这个特殊图形是一个仿射变换（affine transformation），包括旋转加畸变（rotation and distortion）。经过另一个变换后，我们从隐藏层得到了最终输出。同理，在RNN图里的网络神经之间亦可添加同样的小图形。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图4:</b> Yann的RNN基本网络架构
</center>



### <!--Four types of RNN Architectures and Examples -->

### RNN的4种架构与实例

<!--The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.-->

- **向量至序列（vector to sequence)**。输入是一个向量，然后转化为系统内部的状态（如图中绿色泡泡所示）。当系统转化时，在每一个时刻都会有一个具体的输出。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图5:</b> Vec to Seq
</center>
<!--An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.-->

例如，输入为一个图像（向量），输出是一组描述输入图的英文单词序列（一串符号的序列）。如图6所示，每个蓝色泡泡表示一个英文词典里的索引。比如输出为：“This is a yellow school bus”，你得到的是“This”的索引，然后是“is”的索引，以此类推。下图展示了部分由这个神经网络运算的结果。第一列最底部的图像的描述是：“A herd of elephants walking across a dry grass field（一群大象经过干旱的草场）”。这个结果是非常准确的。第二列第一张图的描述为：“Two dogs play in the grass（两只狗在草坪上玩耍）”。然而图中却有三只狗。最后一列都是错误较多的例子，比如“A yellow school bus parked in a parking lot (一辆黄色校车停在了停车场里）”。总之，这些结果显示了这个神经网络时而准确时而错误百出。这种网络结构称之为**自回归网络(Autoregressive Network)**。自回归网络是一种将之前的输出引入此刻的输入从而得到新的输出的一种网络。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图6:</b> vec2seq Example: Image to Text
</center>

<!--The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.-->

- **序列至向量（sequence to vector)**。这种网络不断在末尾引入一串符号的序列最终得到结果。应用之一是用这种网络阐释Python语言。比如，这里的输入是每一行的Python代码。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图7:</b> Seq to Vec
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图8:</b> Input lines of Python Codes
</center>
<!--Then the network will be able to output the correct solution of this program. Another more complicated program like this:-->

然后，神经网络会输出程序的正确结果。

另一个更复杂的程序如下所示：



<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图9:</b> Input lines of Python Codes in a more Completed Case
</center>

<!--Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.-->

得到的输出应为12184。通过这两个例子，我得知可以训练一个神经网络来实现这样的操作。我们只需要引入一串符号的序列并且强制最终输出为一个具体的值。

<!--The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).-->

- **序列至向量至序列（sequence to vector to sequence）**。如图10所示。这个架构曾是一个标准的机器翻译方法。输入为一个符号序列（如下图粉色泡泡所示）。然后压缩至隐藏层h，代表一个概念。比如我们可以用一句话表示输入，然后把它暂时挤压到一个向量中。这个向量表示句子的意思和发送的信息。得到意思后，神经网络把它展开到另一种语言。比如，“Today I'm very happy”是一个英文单词的序列，可以翻译成意大利语或中文。总之，神经网络将某种转码（encoding）的输入转换成一个密集的表示。我们最近见过这种网络，比如Transformers，它的表现甚至超过了这个机器翻译方法。我们在下节课会细讲。这种架构在两年前（2018年）堪称一绝。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图10:</b> Seq to Vec to Seq
</center>

<!--If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.-->

如果你在潜空间（latent space）上使用主成分分析（PCA），你会得到一堆由语义组成的单词（如下图所示）。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图11:</b> PCA训练后由语意分组的词汇
</center>

<!--If we zoom in, we will see that the in the same location there are all the months, like January and November.-->

放大后我们看到在同一位置有不同的月份，比如January（一月）和November（十一月）。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图12:</b> 词组的局部放大图
</center>

<!--If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.-->

如果你关注到不同的区域，你会得到“a few days ago（一天前）”、“the next few months（之后几个月）”之类的词组。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图13:</b> 另一个区域的词组
</center>


<!--From these examples, we see that different locations will have some specific common meanings.-->

由这些例子可得，在不同的位置会有一些相同的含义

<!--Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transofmation going from one word to another or from country to capital.-->

图14展示了训练这类网络会挑拣一些语义特征。比如你看到有一个连接man和woman的向量，和一个连接king与queen的向量。这表示woman减去man等于queen减去king。在这类male-female的例子中，你会得到同样的距离。另一个例子是walking到walked，和swimming到swam。你始终可以应用这种由一个单词到另一个单词或一个国家到一个首都的线性变换。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图14:</b> 训练时挑出的语义特征
</center>

<!--The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.-->

- **序列至序列（sequence to sequence）**。在你引入输入的同时，网络就开始生成输出。例如，文字预测技术（T9）。如果你使用过诺基亚手机，每次打字的时候都会有文字建议。另一个例子是语音转文字。还有一个很酷的例子是这个RNN写字机。当你打了“the rings of Saturn glittered while（土星之环闪闪之时）”后，它会建议“two men looked at each other（两个男人面面相觑）”。这个网络是用几部科幻小说训练的，便于你用它来帮你写一本小说。再有一个例子如图16所示，你输入上面部分的简述，然后网络就会完成余下的部分。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图15:</b> Seq to Seq
</center>
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图16:</b> Seq to Seq模型的文字自动完成的实例
</center>




## [基于时间的反向传播算法（Back Propagation through time）](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)

### <!--Model architecture-->

### 模型架构

<!--In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.-->

在训练RNN的时候，必须用到基于时间的反向传播算法（BPTT）。RNN的架构如图17所示。图左是未展开的循环表示，图右是将循环按照时间序列展开。同时中间的权值跨时共享，这点和CNN中的参数共享很相似。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图17:</b> Back Propagation through time
</center>

<!--Hidden representations are stated as-->

隐藏层表达式为：

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

<!--The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as-->

$h[t]$是一个非线性函数，将堆叠形式的输入进行旋转操作，其中加入了前一步的隐藏层。$h[0]$初始值设为1。$W_h$可简化为两个不同的矩阵$\left[ W_{hx}\ W_{hh}\right]$，变换后的公式可以写成

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

<!--which corresponds to the stack representation of the input.-->

与堆叠形式的输入同理。

<!--$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step.-->

$y[t]$由最后一步的旋转计算得出，之后我们可以用链式法则来反向传递前一步的残差。


### 语言建模中的分批处理（Batch-Ification in Language Modeling ）

<!--When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.-->

在处理符号序列时，我们可以将文字分批成不同的大小。比如，在处理图18中的序列时，先将它分批处理（Batch-Ification），它的时间定义域是垂直向。这个例子中的Batch的大小为4。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图18:</b> Batch-Ification
</center>

<!--If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as-->

如果将BPTT的周期$T$设为3， 那么第一组RNN的输入$x[1:T]$和输出$y[1:T]$为：

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

<!--When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.-->

在运行RNN的第一组样本时，我们首先引入 $x[1] = [a\ g\ m\ s]$并强制输出为$y[1] = [b\ h\ n\ t]$。隐藏层表达式$h[1]$向前传递到下一步，帮助RNN从$x[2]$预测$y[2]$。当传递$h[T-1]$至最后一组$x[T]$和$y[T]$后，我们停止$h[T]$和$h[0]$的梯度传递步骤，使得梯度不会无限地传递（.detach() in Pytorch）。整个过程如图19所示。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图19:</b> Batch-Ification
</center>



## 梯度消失与梯度爆炸（Vanishing and Exploding Gradient）

### <!--Problem-->

### 问题

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图20:</b> 梯度消失问题
</center>

<!--The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.-->

图20展示了一个经典RNN架构。我们用矩阵对RNN里的前一步进行旋转操作，在这个模型中用水平箭头表示。假设我们选择的行列式大于1，因为矩阵可以改变输出的大小，梯度会随时间增大并造成梯度爆炸。相对而言，如果我们选择的特征值小于0，则传播过程会收缩梯度并导致梯度消失。

<!--In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.-->

在经典RNN中，梯度会通过所有可能的箭头来传播。这有很大的几率会使梯度爆炸或者消失。例如，梯度在时刻1的时候非常大（图中白色圆点）。当进行一个旋转后，梯度在时刻3收缩，即消失。

### <!--Solution-->

### 解决办法

<!--An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.-->

理想的预防梯度爆炸或梯度消失的办法是跳过连接。我们可以通过相乘网络来实现。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图21:</b> 跳过连接
</center>

<!--In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.-->

在图21的例子中，我们把原来的网络分成了4个网络。以第一个网络为例，从时刻1输入一个值，然后输出到第一个隐藏层的中间状态。这个状态有其他三个网络，$\circ$s可以使梯度通过，$-$则会阻止梯度传播。这种方法称为**门控循环网络（Gated Recurrent Network)**。

<!--LSTM is one prevalent gated RNN and is introduced in detail in the following sections.-->

长期记忆网络（LSTM）是一个很普遍的门控循环神经网络，我们随即作它的详细介绍。


## [LSTM模型](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)

### <!--Model Architecture -->

### 模型架构

<!--Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.-->

图22为LSTM的表达式。黄色方框中的是输入门，它是一个仿射变换。将这个输入变换乘以$c[t]$，我们得到候选门。



<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图22:</b> LSTM架构
</center>

<!--Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.-->

遗忘门与前一步的细胞记忆值$c[t-1]$相乘。总细胞值$c[t]$是遗忘门加输入门。最终隐藏表达式为输出门元素$o[t]$和双曲正切形式的细胞$c[t]$之间对应相乘，它们是有界的。候选门$\tilde{c}[t]$ 是一个循环网。我们用$o[t]$来调整输出，用$f[t]$调整遗忘门，并且用$i[t]$调整输入门。这些记忆和门之间都是相互相乘。$i[t]$、$f[t]$，和$o[t]$都是0和1之间的Sigmoid函数。因此，当乘以0时，我们得到一个关闭门。当乘以1时，我们得到一个开放门。

<!--How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.-->

我们如何关闭输出？假设我们有一个紫色的内部表达式$th$，并且在输出门放置0。输出就会被乘以0，结果得0。如果在输出门放置1，我们会得到和紫色表达式同样的值。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图23:</b> LSTM架构——输出打开
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图24:</b> LSTM架构——输出关闭
</center>

<!--Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.-->

同样的道理，我们可以控制记忆。比如，我们可以把$f[t]$和$i[t]$重设为0。在相乘和相加之后，记忆里包含0。或者为了保留记忆，我们可以将内部表达式$th$清零，但在$f[t]$里保留1。因此，总和得到$c[t-1]$并且一直将它输送出去。最后，我们在输入门得到了1，相乘得到紫色表达式，然后在遗忘门里设置0，这样它就真的会“遗忘”。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图25:</b> 记忆细胞的可视化
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图26:</b> LSTM架构——重设记忆
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图27:</b> LSTM架构——保留记忆
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图28:</b> LSTM架构——编写记忆
</center>



## <!--Notebook Examples-->

## 笔记里的示例


### 序列的分类（Sequence Classification）

<!--The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.-->

我们的目标是给序列分类。元素和目标是局部的表现形式（只有一个非零比特的输入向量）。序列开头是`B`，结尾是`E`（触发符号）。其他的位置是由从`{a, b, c, d}`集里随机抽取的符号组成，除了在$t_1$和$t_2$位置只能由 `X`  或`Y`组成。在`DifficultyLevel.HARD`的例子中，序列长度是在100到110之间随机抽取、$t_1$是在10到20之间随机抽取，且$t_2$是在50到60之间随机抽取。一共有四个序列门类：`Q`、 `R`、 `S`，和 `U`，它们都依赖`X`和`Y`的时间顺序。其规则是：`X, X -> Q`；`X, Y -> R`； `Y, X -> S`； `Y, Y -> U`。

1). <!--Dataset Exploration-->探索数据集

<!--The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.-->

数据生成器返回的数据类型时一个长度为2的Tuple。Tuple里的第一项是序列的Batch，其形状为$(32, 9, 8)$。这个数据会被输送进神经网络。每行里有8个不同的符号：(`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`)。每一行是一个One-hot向量。一个行的序列代表一个符号的序列。第一个全零行叫做Padding。当序列长度小于Batch里的最大长度的时候，我们使用Padding。Tuple里的第二项是门类标签的对应Batch，其形状是$(32, 4)$。我们有四个门类：(`Q`, `R`, `S`, `U`)。第一个序列是`BbXcXcbE`，它解码后的门类标签是$[1, 0, 0, 0]$，表示`Q`。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>图29:</b> 输入向量示例
</center>



2). <!--Defining the Model and Training--> 定义并训练模型

<!--Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:-->

让我们建立一个简单的RNN，一个LSTM，并且训练10次。在训练环节，我们应当始终寻找一下五点：

 * <!--Perform the forward pass of the model--> 完成模型的向前传递
 * <!--Compute the loss--> 计算损失
 * <!--Zero the gradient cache--> 梯度缓存清零
 * <!--Backpropagate to compute the partial derivative of loss with regard to parameters--> 向后传播，计算损失函数的关于系数的偏分
 * <!--Step in the opposite direction of the gradient--> 进入梯度的相反方向

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图30:</b> 简单RNN vs LSTM - 10 Epochs
</center>

<!--With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.-->

在简单模式下，训练了10次后的RNN有50%的准确率，而LSTM有100%的准确率。但是LSTM有比RNN大4倍的权重，而且有两个隐藏层。所以这样比较不是很公平。训练了100次后，RNN才有了100%的准确率，比LSTM花了更长的训练时间。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图31:</b> 简单RNN vs LSTM - 100 Epochs
</center>

<!--If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.-->

如果我们增加训练的难度（使用更长的序列），我们会看到RNN失败，而LSTM继续工作。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>图32:</b> 隐藏状态值的可视化
</center>

<!--The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence.-->

图23展示的是随时间变化的LSTM的隐藏状态。我们将输入送进一个双曲正切函数。这样当输入值小于$-2.5$时，会被映射到$-1$；当它大于$2.5$时，会被映射到$1$。这种情况下，隐藏层挑中`X`（图中第五行），然后变成红色，直到另一个`X`出现。所以第五个细胞的隐藏单元因观测到 `X`而被触发，然后在遇到另一个 `X` 后渐渐平息。这个过程让我们能辨认出序列的门类。


### 信号反射 (Signal Echoing)

 <!--Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.-->

反射信号是一个同步多对多形式（many-to-many）的例子。比如，第一个输入序列是`"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`， 第一个目标序列是`"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`。这种情况下，输出延迟了3步。所以我们需要短期工作记忆来保留之前的信息。然而在语言模型中，它要根据提示说出之前没说过的信息。这就是两者之间的区别。

<!--Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past.-->

在我们往神经网络里输送整个序列并迫使目标为某个值之前，我们需要将长序列切分成几个小块。当输送一个新的小块时，我们需要跟踪隐藏状态，并在加入下一小块时把它输入到内部状态。在LSTM中，只要你有足够的储存空间，保留多久的记忆都可以。在RNN中，达到了一定长度后，网络会忘记过去发生的事。
