---
lang: zh
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: 线性代数与卷积
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
translation-date: 15 Apr 2020
translator: jiqihumanR
---


## [线性代数回顾](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

这部分将在神经网络的背景下对基础线性代数进行一个简单回顾。我们首先介绍一个简单的隐层$\boldsymbol{h}$：
$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

其输出为一个非线性函数$f$作用到一个向量$z$上。这里$z$是一个仿射变换$\boldsymbol{A} \in\mathbb{R^{m\times n}}$作用到输入向量$\boldsymbol{x} \in\mathbb{R^n}$上的输出：

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

考虑到简洁性，偏置在这里被忽略。线性方程可扩展为：

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

其中$\boldsymbol{a}^{(i)}$是矩阵$\boldsymbol{A}$的第$i$行。

为了理解这个变换的含义，让我们分析一下$\boldsymbol{z}$的一个分量，比如$a^{(1)}\boldsymbol{x}$。假设$n=2$，那么$\boldsymbol{a} = (a_1,a_2)$ 并且 $\boldsymbol{x}  = (x_1,x_2)$。


$\boldsymbol{a}$ 和 $\boldsymbol{x}$在二维坐标轴上可以被画成向量。现在，如果$\boldsymbol{a}$ 和 $\hat{\boldsymbol{\imath}}$之间的角度是$\alpha$，$\boldsymbol{x}$ 和 $\hat{\boldsymbol{\imath}}$之间的角度是$\xi$，那么利用三角公式，$a^\top\boldsymbol{x}$可以被展开为：


$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$

这个输出度量了输入对矩阵$\boldsymbol{A}$的特定行的对齐情况。这可以通过观察两个向量$\xi-\alpha$之间的角度来理解。当$\xi = \alpha$时，这两个向量完美对齐，输出达到最大。如果$\xi - \alpha = \pi$，那么$\boldsymbol{a}^\top\boldsymbol{x}$达到最小并且两个向量指向相反方向。本质上来看，线性变换允许我们将一个输入对于各个方向的投影看作定义的$A$。这个直觉的想法同样可以扩展到高维情况。

另一个理解线性变换的方式是理解到$\boldsymbol{z}$也可以被扩展为：

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix} +
$$

而输出则是矩阵$\boldsymbol{A}$的列的权重和。因此，信号就只是输入的组合而已。


## [扩展线性代数至卷积](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

现在，我们通过音频数据分析的例子，将线性代数扩展至卷积。首先，我们将一个全连接层表达为矩阵乘法的形式：

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

在这里例子中，权重矩阵的大小是$4 \times 3$，输入向量的大小是$3 \times 1$，输出向量的大小是$4 \times 1$。

但是对于音频数据，数据会变得更长（不再是3个样本的长度）。音频数据中的样本数量等于音频持续长度（比如3秒钟）乘以采样率（比如22.05 kHz）。如下所示，输入向量$\boldsymbol{x}$将会非常长。相应的，权重矩阵将变得很“宽”。

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

上面的式子将会非常难以训练。幸运的是，有很多方法可以进行简化。



### 性质：局部性

根据数据的局部性（即：我们不考虑较远的数据点），当$k$相对较大的时候，来自权重矩阵的$w_{1k}$可以被填充为0。因此，矩阵的第一行就成为了一个大小为3的卷积核。让我们将这个大小为3的卷积核表示为$\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$。

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


### 性质：平稳性

自然数据信号具有平稳性（即：某些模式会不停重复）的性质。这可以帮助我们复用之前定义的卷积核$\mathbf{a}^{(1)}$。我们在使用这个卷积核的时候，每次移动一步（即步长为1），结果如下：

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

由于局部性，矩阵的右上角和左下角均被置0，这就导致了稀疏性。不断复用某个卷积核，就称作权重共享。


### Toeplitz matrix的多层结构

经过这些改变，剩下的参数数量为3（即：$a_1,a_2,a_3$）。与之前有着12个参数（即：$w_{11},w_{12},\cdots,w_{43}$）的权重矩阵进行比较，现在的参数数量过于受限，我们希望进行扩展。

前面的矩阵可以被认为是带着卷积核$\boldsymbol{a}^{(1)}$的一层（即一个卷积层）。那么我们可以使用不同的卷积核$\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, 等进行多层构建，从而增加参数数量。

每层都有一个包含着一个多次重复的卷积核的矩阵。这类矩阵被称之为Toeplitz矩阵。在每一个Toeplitz矩阵中，每个从左至右的降对角线是常数。而且这里使用的Toeplitz矩阵也是稀疏矩阵。

给定第一个卷积核$\boldsymbol{a}^{(1)}$和输入向量$\boldsymbol{x}$，该层给出的输出的第一项是：$a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$。因此整个输出向量如下：


$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

同样的矩阵相乘方法可以被用于后续带有其它卷积核（比如$\boldsymbol{a}^{(2)}$ 和 $\boldsymbol{a}^{(3)}$）的卷积层并得到类似的结果。


## [听见卷积 - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)


对应的Jupyter Notebook可以在[这里](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb)获得。

在这个notebook中，我们将卷积看做“运行的标量积”的形式对它进行探索。

`librosa`库让我们能够加载音频片段$\boldsymbol{x}$及它的采样率。在这个例子中，我们有70641个样本，采样率为22.05kHz，片段总长度为3.2秒。导入的音频信号是波动的（见图1），并且我们能够通过$y$轴的振幅猜测它大概是听上去是怎么样的。这个音频信号$x(t)$其实就是Windows系统的关机音（见图2）。

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>图1</b>: 音频信号的可视化<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>图2</b>: 上图音频信号的对应音符.<br>
</center>


我们需要从波形分离出音符。为了实现这件事情，如果我们使用傅里叶变换，所有的音符会一起出现，那么找出每个音高的精确时间和位置就变得非常困难。因此，我们需要使用局部傅里叶变换（也被称作声谱图）。正如在声谱图（图三）中观察到的那样，不同的音高在不同频率下的达到峰值（比如第一音高的峰值是1600）。在各自的频率下连接四个音高，我们就获得了原信号的音高版本。

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>图3</b>: 音频信号和它的声谱图<br>
</center>

输入信号和所有音高（比如钢琴上的所有键）的卷积能够帮助提取输入片段中的所有音符（即：当音频匹配特定卷积核的时候的激发）。原信号的声谱图和连接的音高的信号如图4所示。原信号的频率和四个音高的图像如图5所示。输入信号（原信号）和四个卷积核的卷积如图6所示。图6中卷积的音频片段证明了卷积对于提取音符的有效性。


<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>图4</b>: 原信号的声谱图（左图）和音高连接的声谱图（右图）<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>图5</b>: 旋律的第一个音符<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>图6</b>: 四个卷积核的卷积<br>
</center>


## 不同数据集的维度

最后一个部分，我们将额外讨论一下维度的不同表示以及这个问题的一些例子。我们假设输入集$X$由定义域$\Omega$映射到通道$c$的函数组成。


### 举例

* 音频数据：定义域是1维、时间索引的离散信号；通道数量$c$可以是1 (单声道), 2 (立体声do), 5+1 (杜比 5.1), 等。
* 图像数据：定义域是2维（像素）；$c$可以是1(灰阶图片), 3(彩色图片), 20(高光谱), 等。
* 狭义相对论：定义域是$\mathbb{R^4} \times \mathbb{R^4}$（时空 $\times$ 四维动量），当$c = 1$时，这就是哈密顿量。


<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>图7</b>: 不同种类信号的不同维度<br>
</center>
