---
lang: zh
lang-ref: ch.03-2
lecturer: Yann LeCun
title: 卷积网络的演变，架构，实现细节和优势。
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translator: Mingyang Zhao
translation-date: 14 Mar 2020
---


## [原始 CNN 和向现代 CNN 的演变](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


### 小数据集上的原始卷积神经网络

受福岛视觉皮层模型的启发，Yann LeCun 教授于 1988-1989 年在多伦多大学使用简单/复杂的细胞层次结构并结合监督训练和反向传播，开发了第一个CNN。实验使用320个用鼠标写成数字的小型数据集比较了以下架构的性能：

1. 单FC（全连接）层
2. 两层FC
3. 没有共享权重的本地连接层
4. 带有共享权重和本地连接的受限网络
5. 带有共享权重和本地连接的受限网络的改版（更多功能图）

性能最好的架构（具有共享权重的受限网络）具有最强的泛化能力，成为现代 CNN 的基础。 然而单独的 FC 层则有过拟合的倾向。


### 贝尔实验室：第一个“真正的”卷积网络

转到贝尔实验室后，LeCunn 的研究转向使用美国邮政服务的手写邮政编码来训练更大的 CNN：

* 256 (16$\times$16) 输入层
* 12 5$\times$5 步幅为 2 的卷积核 (每步前进 2 个像素): 下一层分辨率下降
* **没有**单独的汇合层


### 有汇合层的卷积网络架构

第二年的改进是引入了单独的汇合层，暨通过对输入求均值，添加偏差并传递给非线性函数（双曲正切函数）来完成。2$\times$2 汇合的步幅为2，因此分辨率降低一半。

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>图 1</b> 卷积网络架构
</center>

单个卷积层的示例如下：
1. 输入大小为 *32$\times$32*
2. 输入图像以 1 的步幅输入 5$\times$5 卷积层内核，输出 *28$\times$28* 的特征图。
3. 将特征图输入非线性函数：尺寸 *28$\times$28*
4. 再以 2 的步幅输入 2$\times$2 汇合层，尺寸 *14$\times$14*
5. 对 4 个内核重复 1-4 步

第一层简单卷积/汇合层的组合通常会检测简单特征，例如定向边缘检测。 在第一个卷积/汇合层之后，目标是检测来自先前层的特征组合。为此，第 2-4 步会在上一层特征图上由多个内核重复进行，并求和成为新的特征图。

1. 将新的 5$\times$5 内核扫描所有之前的特征图，并对其结果求和。（注意：在 LeCun 教授于1989年的实验中，连接未完全出于计算目的。现在的设置通常会强制使用完全连接）：尺寸 *10$\times$10*
2. 将卷积的输出传递给非线性函数：尺寸 *10$\times$10*
3. 对 16 个内核重复前两步。
4. 将结果传递到 2$\times$2、步幅为 2 的汇合层：每个特征图的尺寸 *5$\times$5*

最后是为了输出设置的卷积层 （虽然看起来像全连接层， 但确实是卷积层）。

1. 最后的卷积层以 5$\times$5 内核扫描所有之前的特征图，并对其结果求和：尺寸 *1$\times$1*
2. （将卷积的输出）传递给非线性函数：尺寸 *1$\times$1*
3. 为一个类别生成单独输出。
4. 对所有10个类别（同时）重复先前步骤。

关于卷积如何改变下一层特征图的尺寸，请参见Andrej Karpathy网站上的[动画](http://cs231n.github.io/convolutional-networks/)。 全文见[这里](https://papers.nips.cc/paper/293-handwriting-digit-recognition-with-a-back-propagation-network.pdf)。


### 位移等变性

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>图 2</b> 位移等变性
</center>

如幻灯片上的动画所示（这是另一个示例），对输入图像的变换会对特征图产生相同的变换。 但是，特征图中的更改是通过卷积/汇合操作缩放的。例如步幅为 2 的 2$\times$2 汇合将输入层的 1 像素偏移在其特征图上减少到 0.5 像素。然后将空间分辨率交换为更多的特征类型，即使表示形式更加抽象，并且对位移和变形的敏感性降低。


### 通用架构分解

通用 CNN 架构可分为几种基本的层：

* **归一化层**
   *调整白化（可选）
   *减轻：例如平均去除、高通滤波
   *分离：局部对比归一化，方差归一化

* **滤波器层**
   *增加维度
   *过完备基向量投影
   *边缘检测

* **非线性层**
   *稀疏
   *典型的整流线性单位（ReLU）：$\text{ReLU}(x) = \max(x, 0)$

* **汇合层**
   *特征图汇总
   *最大值汇合：$\text{MAX}= \text{Max}_i(X_i)$

   * LP范数汇合：$$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

   *对数概率汇合：$\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$


## [LeNet5 和数字识别](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)


### 在 PyTorch 中实现 LeNet5

LeNet5 由以下几层组成（第 1 层是最顶层）：

1. Log-softmax
2. 全连接层， 尺寸：500$\times$10
3. ReLu
4. 全连接层， 尺寸：(4$\times$4$\times$50)$\times$500
5. 最大值汇合层，尺寸 2$\times$2， 步幅 2
6. ReLu
7. 卷积层，20个输出通道，内核 5$\times$5，步幅 1
8. 最大值汇合层，尺寸 2$\times$2， 步幅 2
9. ReLu
10. 卷积层，20个输出通道，内核 5$\times$5，步幅 1

输入层是一个 32$\times$32 灰度图像（1 个输入通道）。

LeNet5可以使用以下代码在PyTorch中实现：

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

尽管 `fc1` 和 `fc2` 是全连接层，但可视为卷积层，其内核覆盖整个输入。全连接层用于提高效率。

`nn.Sequential` 可以实现相的代码，但已经过时。


## CNN的优势

在全卷积网络中，无需指定输入的大小。但更改输入的大小也会更改输出的大小。

在潦草手写识别系统中，我们不必将输入图像分成多个部分。我们可以将 CNN 应用于整个图像：内核将覆盖整个图像的所有位置，并记录相同的输出无论特征位于何处。 在整个图像上应用 CNN 比在多个位置分别应用 CNN 需要的计算量小得多。无需事先分割减少了工作量，因为分割图像的任务类似于识别图像。


### 示例：MNIST

LeNet5在大小 32$\times$32 的 MNIST 图像集上进行训练，以对图像中心的各个数字进行分类，并通过平移、缩放，侧面数字来进行数据扩增。它也进行第 11 类的训练，暨不代表任何上述类别。 此类的图像通过空白图像或在侧面而非中心放置数字来生成。

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>图 3</b> 滑动窗口卷积网络
</center>


上图显示了 32$\times$32 图像训练的 LeNet5 网络可以应用于 32$\times$64 图像，以在多个位置识别数字。


## [特征捆绑问题](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)


### 什么是特征捆绑问题？

视觉神经科学家和计算机视觉专家有如何将对象定义为对象的问题。对象是功能的集合，但是如何绑定所有功能以形成该对象呢？


### 如何解决？

我们可以使用非常简单的 CNN 来解决此特征绑定问题：只要我们有足够的非线性度和数据来训练 CNN，我们只需使用两层带有汇合层的的卷积层加上另外两层全连接层，而无需任何特定机制。

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>图 4</b> 卷积网络表现特征捆绑
</center>

上面的动画展示了 CNN 通过移动单个笔画来识别不同数字的能力，展示了其解决特征绑定问题的能力，即以层次、合成的方式识别特征的能力。


### 示例：动态输入长度

我们可以构建一个具有2个卷积层（步幅为1）和2个汇合层（步幅为2）的 CNN，使总步幅为4。因此，如果要获得新的输出，我们需要将输入窗口移动 4。 我们在下图（绿色单元）可以看到更明确的的表示。 首先，我们有一个尺寸为 10 的输入，并执行尺寸为 3 的卷积以获得 8 个单元。 之后，我们执行大小为 2 的汇合以得到 4 个单元。 同样，我们重复卷积并再次汇合，最终得到 1 个输出。

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>图 5</b> 可变输入尺寸绑定的卷积网络结构
</center>

假设我们在输入层添加 4 个单元（上面的粉色单元），这样我们在第一个卷积层之后可以再获得 4 个单元，在第一个汇合层之后再获得 2 个单元，在第二个卷积层之后又获得 2 个单元以及多 1 个输出。 因此，新生成输出的窗口大小为 4（2步距 $\times$2）<！-我们从输入到输出的总体子采样为4（2x2）->。 此外，这证明了以下事实：如果我们增加输入的尺寸，我们将增加每层的尺寸，从而证明 CNN 能够处理动态长度输入。


## CNN 的优势

CNN 非常适合以多维数组形式出现的信号。这些信号具有三个主要特征。
1. **局部性**：第一个是各个值之间存在很强的局部相关性。如果我们观察天然图像上两个临近像素，则这些像素很可能具有相同的颜色。随着两个像素之间的距离越来越远，它们之间的相似性将降低。本地相关性可以帮助我们检测局部特征，暨 CNN 的作用。如果我们向 CNN 提供置换后的像素，则它在识别输入图像时效果不佳，而 FC 不会受到影响。局部相关性证明了局部连接的合理性。
2. **平稳性**：第二个是特征作为基础可以出现在图像上任何地方，证明了权值共享和汇合的合理性。此外，统计信号是均匀分布的，这意味着我们需要对输入图像上的每个位置重复进行特征检测。
3. **结构性**：第三个是自然图像有结构，暨特征以层级方式构成图像。这证明了使用多层神经元的合理性，这也与 Hubel 和 Weisel 对简单和复杂细胞的研究紧密相关。

此外，人们在视频、图像、文本和语音识别中大量使用了 CNN。
