---
lang: zh
lang-ref: ch.01-2
lecturer: Yann LeCun
title: 卷积神经网络(CNN)的演化及其用途，为何出现深度学习？
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
---


## [卷积神经网络(CNN)的演化](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

在动物的大脑中，神经元对特定方向的边缘信息有所反应。对同一方向起反应的神经元群将复制遍整个视野。

Fukushima (1982)基于两个概念构建了一个与大脑工作方式相同的神经网络(NN)。第一，神经元将跨越视野进行复制。 第二，复杂细胞可以将来自简单细胞(方向选择性单元)的信息进行汇合。
这造成的结果就是，图片的移动将改变单个细胞的激活，但是并不影响复杂细胞的集成激活(卷积汇合操作)。


LeCun (1990)使用反向传播算法训练CNN，进行手写数字的识别。在1992年的一个演示中，展示了该算法可以识别任意样式的数字。在那时，使用通过端到端训练的模型进行字符/模式识别非常新颖。在这之前，大家的方案通常是利用
特征提取器再加上一个监督模型。


这些新颖的CNN系统能够同时在图片上识别多个字符。为了实现识别，人们在CNN中使用一个小型的输入窗，并将其滑过整个图像。如果它被激活，那就意味着存在某个特定的字符。


之后，这个想法被应用于面部/人物检测和语义分割(逐像素分类)。包括像Hadsell (2009)和Farabet (2012)这样
的例子。最终，CNN在工业界变得非常普遍，在如车道跟踪这样的自动驾驶应用中也被使用。


在20世纪80年代，用来训练CNN的特殊硬件是一个非常热门的主题。接着，人们对此的兴趣衰退。而如今这个主题则再次变得炙手可热。


深度学习(虽然在那时大家还没有使用这个词)的革命始于2010-2013年。研究人员致力于创造那些可以帮助大型CNN训练变得更加快速的算法。
Krizhevsky (2012)在2012年提出AlexNet。这是一个比以往大得多的卷积神经网络，使用GPU在
ImageNet(130多万张图片)上进行训练。在经过几周的训练之后，AlexNet大幅度超越当时的最佳性能 -- 将top-5错误率从25.8%降到16.4%。


在看到AlexNet的成功之后，计算机视觉社区开始确信CNN的有效。虽然2011-2012涉及CNN的论文都被拒稿，
但是自2016以来，大多数被接收的CV论文都使用了CNN。


多年以来，CNN中的层的数量在不断增加：LeNet -- 7层，AlexNet -- 12层，VGG -- 19层，ResNet -- 50层。尽管如此，在计算输出的所需操作数、模型的大小和它的准确率之间始终存在着一种权衡。因此当前一个非常热门的主题就是如何压缩网络，使得计算更加快速。



## [深度学习和特征提取](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

多层网络之所以成功，是因为它发掘了天然数据的复合结构。在复合的层级结构中，层级中某一层的目标的组合形成
下一层中的目标。如果我们将这个层级结构看做一个多层结构的网络，并且让网络学习特征的合适的组合，那么
我们就得到了所谓的深度学习架构。因此，深度学习网络本质上就是层次化的。


深度学习架构使计算机视觉任务取得了难以置信的发展。从识别并生成围绕目标的准确遮罩(mask)到识别
目标的空间性质。Mask-RCNN和RetinaNet架构对这类改善作出了主要贡献。

Mask RCNN在分割独立目标中被广泛使用。即为图像中的每一个目标建立遮罩。在这个任务中，输入和输出都是图像。该架构还可以被用来执行实例分割任务，即，在一张图像中识别同一类型的不同目标。由Facebook AI 研究院 (FAIR)开发的软件系统：Detectron，实现了所有这些SOTA(state-of-the-art)的目标检测算法并且将其开源。

一些CNN的实际应用还包括赋能自动驾驶和分析医学影像。

虽然人们对深度学习背后的科学和数学已经有了不错的理解，但是仍有一些有趣的问题需要更深入的研究。
这些问题包括：已知我们可以使用两层结构近似任意函数，为什么多层架构会表现的更好？为何CNN在
语音、图像、文本这样的天然数据上效果很好？我们如何对非凸函数较好地优化？为什么过度参数化的结构也会有效？

特征提取由扩展表征维度组成，比如扩展的特征更有可能线性可分；由于可能的分离平面数量的增加，使得高维空间
的数据点更有可能线性可分。


早前的机器学习从业者依靠高质量、手工提取、针对特定任务的特征来构建人工智能模型，但是随着深度学习的出现，
模型能够自动提取通用特征。在特征提取算法中的一些常见方法如下：

- 空间贴片
- 随机投影
- 多项式分类器(特征向量积)
- 径向基函数
- 核机

由于数据的复合性质，学到的特征随着抽象层次的增加具有层级化的表征。比如：

-  图像 - 在最细的粒度级别，图像可以被认为是像素。像素的组合构成边缘，边缘的组合构成纹理基元(多边缘形状)，纹理基元构成图案，图案构成部分图像。将这些部分图像组合，构成最终的图像。


-  文本 - 类似地，在文本数据中也存在固有的层级。字符形成词，而词形成词组，然后是子句，再然后，将
子句合并，我们得到句子。而最终句子会告诉我们故事表达了什么。

-  语音 - 在语音里，样本组成波段，波段组成声音，声音组成元音，继而组成音素，接着是整个词，然后是句子，
这里也同样展现出了清晰的层级化表征。





## [学习表征](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

有一种驳斥深度学习的说法：如果我们能够使用2层结构近似任意函数，为何还要更多层？

举个例子：支持向量机(SVM)“从数据中”找到一个分类超平面，这意味着预测是基于训练数据的比较。SVM本质上是一个极简的2层
神经网络，其中第一层定义了一个“模板”，第二层则是一个线性分类器。而2层说法的谬误在于，复杂度和中间层
的大小是N的指数级(为了完成一个困难的任务，我们需要大量的模板)。但是如果你扩展层的数量到log(N)，
那么层的复杂度将成为N的线性级别。这里就存在时间和空间的权衡。


这里再举一个类比：设计一个电路，使用不多于两层的逻辑门来计算一个布尔函数 - 用这种方法，我们其实可以计算**任意布尔函数**！但是，对于复杂函数而言，第一层(逻辑门的数量)的复杂度和资源将会很快变得无法实现。

什么是“深度”？

- SVM不是深度的，因为它仅仅有两层
- 分类树也不是深度的，因为它的每一层分析了同样的(原始)特征
- 深度网络具有很多层，并且被用来构建一个**复杂性递增的特征的层级结构**

模型如何学习表征(好的特征)?

流形假设：天然的数据存在于一个低维流形上。可能的图像的集合本质上是无限的，而“天然”的图像的集合是其中
一个小子集。比如：对于一个人物的图像，可能的图像的集合规模大约在能移动的面部肌肉的数量(自由度)这个量级 ~ 50。一个理想的(同时不切实际的)特征提取器需要表达所有这些变化的因素(每个肌肉、光照、等等等等)。

讲稿最后的Q&A：

- 对于人脸的那个例子，能不能用一些其他的维度约化技术(比如主成分分析(PCA))来抽取这些特征？
  - 回答：只有当流形表面为超平面时可行，但显然这里不是
