---
lang: zh
lang-ref: ch.01-1
lecturer: Yann LeCun
title: 深度学习的动机及其历史和启示
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 24 Feb 2020
translator: lejinghu, Mingyang Zhao
---

## [课程纲要](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

- 监督学习，神经网络，和深度学习基础
- 反向传播算法和架构组成
- 卷积神经网络和应用
- 更多深度学习架构
- 正则化技巧/优化技巧/理解深度学习如何工作
- 基于能量的模型 （Energy-based models）
- 自监督学习与更多


## 深度学习的灵感和历史

深度学习的概念受到了大脑的启发，但并非大脑的每个细节都重要。类比而言，飞行器的构想受到鸟的启发。它们飞行的原理相同，细节上却截然不同。

深度学习的历史可以追溯到今天我们称为控制论(cybernetics)的学科。20世纪40年代，McCulloch和Pitts萌生出一种想法：神经元是可以开关的阈值单元，可以将神经元联结构成布尔电路并用它进行逻辑推理。因为神经元是二元的，大脑实际上就是个逻辑推理机器。神经元计算出输入的加权和，并与阈值比较。如果结果超出阈值就开启，反之关闭。这便是神经网络工作方式的简单描述。几十年来，相关领域一直采用这个模型。

1947年，Donald Hebb想到大脑中的神经元通过修改彼此间连接的强度来学习。这叫Hebb学习：当两个神经元一起激发时，它们之间的连接变强；当它们不一起激发时，它们之间的连接变弱。

此后在1948年，Norbert Wiener提出控制论，即通过传感器(sensor)和执行器(actuator)，可以构造反馈回路和自调整系统。举例来说，汽车（转向控制）中反馈机制的相关规则和稳定性都源自控制论。

1957年，Frank Rosenblatt提出了感知器。这种算法能修改简单神经网络的权重来学习。

总而言之，通过模拟大量神经元来制造智能机器的想法诞生于20世纪40年代，流行于50年代，而没落于60年代。它没落的根源在于：

- 研究者们使用的神经元都是二元的。然而只有连续的激活函数才能让反向传播算法发挥作用。当时的研究者们没想到可以用连续的神经元。他们也没想到可以用梯度来训练，因为二元神经元无法微分。
- 即使有连续的神经元，需要将它的输入与权重相乘才能得到其对权重和的贡献。1980年前，对两个数字，特别是浮点数，进行乘法的过程十分缓慢。这也使得研究者们不愿使用连续神经元。

深度学习于1985年随着反向传播算法的出现再度流行。1995年，该方向再次没落，机器学习社区也舍弃了神经网络的思路。2010年初，人们将神经网络用于语音识别并取得了巨大进展，并将之大量商用。2013年，机器视觉转向使用神经网路。2016年，自然语言处理亦然。不久，我们将在机器人学、控制学和其它学科中也看到类似的革命。


### 监督学习

$90\%$的深度学习应用使用监督学习。监督学习中，你需要收集一组对应的输入与输出数据，之后将输入交给机器，令其学习正确的输出。当输出正确时，你不需做任何事情。若输出错误，你修改机器的参数以使输出更接近想要的正确结果。这里的微妙之处是想明白该往哪个方向调整参数以及调整多少。而这就要用到梯度计算和反向传播算法。

监督学习可以回溯到感知机和自适应线型单元(Adaline, Adaptive Linear Element)。Adaline与感知机基于相同的架构，对输入进行加权求和。加权之和高于阈值时开启，低于阈值时关闭。感知机是一种两层神经网络，第二层可训练而第一层固定。大多数情况下，第一层的权重是随机决定的，被称为联想层。


## [模式识别的历史和梯度下降简介](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

前述部分构成了深度学习出现之前模式识别的基础。模式识别的基本模型包括特征提取器和可训练分类器。特征提取器从输入数据经中获得有用的特征，比如人脸识别中的任务中检测出眼睛。然后，可训练分类器计算出代表特征的向量的加权和，并与阈值比较。可训练分类器可以是感知机或者一个神经网络。问题是，特征提取器必须由人工设计。因此，模式识别/机器视觉的侧重点变成了为具体问题设计特征提取器，而非可训练分类器。

随着深度学习的出现与发展，这个二阶过程转变为一系列模块。每个模块都包含可微调的参数与非线性单元。我们将它们层层叠起。因此称之为“深度学习”。我们之所以使用非线性单元而不是线性，是因为两层线型单元的组成仍为线性，因此相当于一层线型单元。

最简单的含可调参数与非线性单元的多层结构是：用向量表现的输入，比如图像或语音。该输入和权重矩阵相乘，矩阵的系数是可调参数。接着，相乘结果的每个部分都通过一个非线性单元，比如ReLU。重复这个过程便得到一个基本的神经网络。它之所以被称为神经网络，是因为这个结构将输入的每个组成部分与矩阵对应的行相乘，获得一个加权和。

回到监督学习的概念上，我们将输出结果与目标输出比较，并优化一个目标函数。这个目标函数，或者说损失，计算结果与目标间的距离/惩罚/差异，并取它在训练集上的平均数。这就是我们要减少的目标。换言之，我们想找到能减少这个平均数的参数值。

我们通过计算梯度的方式来寻找它。举个例子，一个大雾弥漫的夜晚，我们在一座光滑的山上迷路了。我们想下到山谷的村庄里。这时我们可以转身寻找最陡的方向并迈一小步。这个方向就是梯度的反方向。只要假设山谷是凸的，那我们这样重复下去必定能达到山底。

随机梯度下降是一种更高效的方法。既然我们想减少整个训练集的平均损失，那每次取一个样本或一小组样本，计算它们的误差并使用梯度下降。接下来取一个新样本并得到一个新的误差，然后算出一个新的梯度。使用随机梯度下降的两个原因：一是经验上当数据集非常大时SGD收敛得更快，二是能取得更好的泛化能力，在其它的数据集上预测时能得到相近的性能。


### [通过反向传播计算梯度](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

通过反向传播计算梯度是链式法则的实际应用。 状态梯度的反向传播（计算）如下：

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

权重梯度的反向传播（计算）如下：

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

需要注意的是，输入时需要矢量而非标量，而且通常是多维矢量。反向传播使得我们可以计算真实值与实际输出（目标函数）之差对于网络中任何值的导数。最后，反向传播之所以如此重要是因为它会被应用于多层之上。

考虑如何处理输入十分重要。比如256$$\times$$256大小的图像需要有 200,000 个值的矩阵。 这些巨型矩阵之后会交给神经网络层来处理，而利用这样的矩阵是不切实际的。因此，对矩阵的结构进行假设十分重要。


## 视觉皮层的层次结构

福岛邦彦的实验使我们对大脑如何处理视觉有所了解。总的来说，我们发现视网膜前面的神经元压缩了输入（又称对比度归一化），之后视觉信号从我们的眼睛传播到我们的大脑。此后视觉信号被分阶段处理，特定类别的特定神经元被激活。因此，视觉皮层以分层方式进行模式识别。

研究人员在视觉皮层的特定区域（特别是V1区域）的电极实验使他们意识到，某些神经元会对出现在视野中的小区域的图案产生反应，并且临近的神经元对相邻区域也有类似的表现。另外，对同一视野做出反应的神经元会以有组织的方式对不同类型的边缘（垂直或水平边缘）做出反应。
还有一种值得关注的观点是是视觉过程本质上是前馈过程，因此可以在无反复连接的情况下完成快速识别。
