---
lang-ref: ch.01-3
title: Vấn đề về động lực, Đại số tuyến tính và trực quan hóa
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translator: Huynh Nguyen
lang: vi
translator-date: 22 Oct 2020
---

## Tài nguyên

Vui lòng theo dõi Alfredo Canziani [trên Twitter @alfcnz](https://twitter.com/alfcnz).
Bạn có thể tìm thấy video và học liệu chi tiết liên quan về đại số tuyến tính và SVD (singular value decomposition)
bằng cách tìm kiếm trên Twitter của  Alfredo, chẳng hạn như nhập *linear algebra (from:alfcnz)* vào ô tìm kiếm.

## Sự chuyển đổi và động lực

Như một ví dụ thúc đẩy, chúng ta hãy xem xét về phân loại hình ảnh. Giả sử chúng ta chụp ảnh bằng máy ảnh 1 Megapixel.
Hình ảnh này sẽ có khoảng 1.000 pixel theo chiều dọc và 1.000 pixel theo chiều ngang. Và mỗi pixel sẽ có 03 kênh màu cho đỏ, xanh lục và xanh lam (còn gọi là xanh dương) (RGB).
Mỗi hình ảnh cụ thể sau đó có thể được coi là một điểm trong không gian 3 triệu chiều.
Với kích thước khổng lồ như vậy, nhiều hình ảnh thú vị mà chúng ta có thể muốn phân loại,
chẳng hạn như là một con chó và một con mèo - về cơ bản nằm trong cùng một vùng không gian.

Để tách những hình ảnh này một cách hiệu quả, chúng tôi xem xét các cách chuyển đổi (biến đổi) dữ liệu để di chuyển các điểm.
Nhớ lại rằng trong không gian 2D, một phép biến đổi tuyến tính cũng giống như phép nhân ma trận. Ví dụ, sau đây là các phép biến đổi tuyến tính:

- Phép quay (khi ma trận là trục chuẩn)
- Chia tỷ lệ (khi ma trận là đường chéo)
- Phản xạ (khi định thức là âm)
- Cắt xén

Lưu ý rằng một mình phép tịnh tuyến không phải là tuyến tính vì 0 sẽ không phải lúc nào cũng được ánh xạ thành 0, nhưng nó là một phép biến đổi affine.
Quay trở lại hình ảnh ví dụ của chúng tôi, chúng tôi có thể biến đổi các điểm dữ liệu bằng cách dịch chuyển sao cho các điểm được nhóm xung quanh không và chia tỷ lệ với ma trận
đường chéo để chúng tôi "phóng to" vùng đó. Cuối cùng, chúng ta có thể phân loại bằng cách tìm các đường ngang qua không gian để phân loại các điểm khác nhau thành các lớp tương ứng của chúng. Nói cách khác, ý tưởng là sử dụng các phép biến đổi tuyến tính và phi tuyến tính để ánh xạ các điểm vào một không gian sao cho chúng có thể phân tách tuyến tính. Ý tưởng này sẽ được thực hiện cụ thể hơn trong các phần sau.

## Trực quan hóa dữ liệu - tách các điểm theo màu bằng mạng

Trong hình dung của chúng ta, chúng ta có 05 nhánh của một hình xoắn ốc, với mỗi nhánh tương ứng với một màu khác nhau. Các điểm trong cùng một mặt phẳng 02 chiều và có thể được biểu diễn dưới một bộ dữ liệu; màu sắc đại diện cho chiều thứ 03 có thể được coi là các lớp khác nhau cho mỗi điểm. Sau đó, chúng tôi sử dụng mạng để phân tách từng điểm theo màu sắc.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Điểm đầu vào, trước mạng             |            (b) Điểm đầu ra, sau mạng             |

Hình 1: Hình xoắn ốc năm màu mạng \"kéo dài\" dải không gian để tách từng điểm thành các không gian con khác nhau. Tại sự hội tụ, mạng phân tách từng màu thành các không gian con khác nhau của đa tạp cuối cùng. Nói cách khác, mỗi màu trong không gian mới này sẽ được phân tách tuyến tính bằng cách sử dụng hồi quy một *so với* tất cả. Các véc-tơ trong sơ đồ có thể được biểu diễn bằng ma trận năm x hai; ma trận này có thể được nhân lên từng điểm để trả về điểm cho từng màu trong số năm màu. Mỗi điểm sau đó có thể được phân loại theo màu sắc bằng cách sử dụng điểm tương ứng của chúng. Ở đây, kích thước đầu ra là năm, một cho mỗi màu và kích thước đầu vào là hai, một cho tọa độ *x và y* của mỗi điểm.

### Kiến trúc mạng

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Hình 2: Kiến trúc mạng
</center>

Ma trận đầu tiên ánh xạ đầu vào hai chiều vào một lớp ẩn trung gian 100 chiều. Sau đó, chúng ta có một lớp phi tuyến tính, ReLU hoặc Đơn vị tuyến tính đã chỉnh lưu, chỉ đơn giản là phần dương `$ (\ cdot) ^ + $` (hàm). Tiếp theo, để hiển thị hình ảnh của chúng tôi dưới dạng biểu diễn đồ họa, chúng tôi bao gồm một lớp nhúng ánh xạ đầu vào của lớp ẩn 100 chiều với đầu ra hai chiều. Cuối cùng, lớp nhúng được chiếu tới lớp năm chiều cuối cùng của mạng, biểu thị điểm cho mỗi màu.

## Phép chiếu ngẫu nhiên - Jupyter Notebook

Bạn có thể tìm thấy Jupyter Notebook [tại đây](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). Để chạy Notebook, hãy đảm bảo rằng bạn đã cài đặt môi trường `pDL` như chỉ định trong [README.md](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

### Pytorch

Pytorch có thể chạy trên cả CPU và GPU của máy tính. CPU sẽ hữu ích cho các tác vụ trình tự, trong khi GPU hữu ích cho các tác vụ song song. Trước khi thực hiện trên thiết bị mong muốn, trước tiên chúng ta phải đảm bảo rằng các tensor và mô hình của chúng ta đã được chuyển đổi bộ nhớ của thiết bị. Điều này có thể được thực hiện với 02 dòng mã sau:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```
Dòng đầu tiên tạo một biến gọi là `device`, được gán cho GPU (nếu có), nếu không nó mặc định là CPU. Trong dòng tiếp theo, một tensor được tạo và gửi đến bộ nhớ của thiết bị  bằng cách gọi `.to(device)`.

### Mẹo sử dụng Jupyter Notebook

Để xem tài liệu cho một chức năng trong Notebook, hãy sử dụng `Shift + Tab`.

### Hình dung các phép biến đổi tuyến tính

Nhớ lại rằng, một phép biến đổi tuyến tính có thể được biểu diễn dưới dạng một ma trận. Sử dụng phân rã giá trị đơn lẻ, chúng ta có thể phân ra ma trận này thành 03 ma trận thành phần, mỗi ma trận biểu diễn một phép biến đổi tuyến tính khác nhau.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top eq. (1)
$$

Trong eq. (1), các ma trận `$U$` và `$V^\top$` là trực giao và biểu diễn các phép biến đổi quay và phạn xạ. Ma trận giữa là đường chéo và đại diện cho một phép biến đổi tỷ lệ.

Chúng ta hình dung các phép biến đổi tuyến tính của một số ma trận ngẫu nhiên trong Hình 3. Lưu ý ảnh hưởng của các giá trị bất thường đối với kết quả của các phép biến đổi. Các ma trận đang sử dụng được tạo bằng `Numpy`. Tuy nhiên, chúng cũng có thể sử dụng lớp 'nn.Linear' của Pytorch với `bias = False` để tạo ra các phép biến đổi tuyến tính.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Các điểm gốc       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Hình 3: Các phép biến đổi tuyến tính từ ma trận ngẫu nhiên </center>

### Các phép biến đổi phi tuyến tính

Tiếp theo, chúng ta hình dung sự chuyển đổi sau:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Nhớ lại, đồ thị của $\tanh(\cdot)$ trong Hình 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Hình 4: Tiếp tuyến hyperbolic không tuyến tính
</center>

Ảnh hưởng của sự không tuyến tính này là giới hạn giữa các điểm `$-1$` và `$+1$`, tạo ra một hình vuông. Là giá trị của `$s$` trong eq. (2) càng tăng thì càng có nhiều điểm bị đẩy ra cạnh hình vuông. Điều này được thể hiện trong Hình 5. Bằng cách buộc nhiêu điểm hơn vào cạnh, chúng tôi trải chúng ra nhiều hơn và sau đó cố gắng phân loại chúng.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Phi tuyến tính với $s=1$                 |                 (b) Phi tuyến tính với $s=5$                  |

<center> Hình 5: Biến đổi phi tuyến tính </center>

### Mạng thần kinh ngẫu nhiên

Cuối cùng, chúng tôi hình dung sự chuyển đổi được thực hiện bởi một mạng thần kinh đơn giản, chưa qua đào tạo. Mạng bao gồm một lớp tuyến tính, thực hiện phép biến đổi affine, tiếp theo là một lớp phi tuyến tính tiếp tuyến hypebol, và cuối cùng là một lớp tuyến tính khác. Xem xét phép biến đổi trong Hình 6, chúng ta thấy rằng nó không giống như các phép biến đổi tuyến tính và phi tuyến tính đã thấy trước đó. Trong tương lai, chúng ta sẽ xem cách làm cho các phép biến đổi này được thực hiện bởi mạng thần kinh hữu ích cho mục tiêu cuối cùng là phân loại của chúng ta.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Hình 6:  Chuyển đổi từ mạng thần kinh chưa được đào tạo
</center>
